/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.agent;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.server.agentreq.ProbeDefResp;
import org.eclipse.aperi.TStorm.server.agentreq.ScanDefReq;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TFoundFilesystem;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDevice;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResFabric;
import org.eclipse.aperi.repository.table.TResLdapTree;
import org.eclipse.aperi.repository.table.TResLibraries;
import org.eclipse.aperi.repository.table.TResPwd;
import org.eclipse.aperi.repository.table.TSnmpCommunity;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.repository.table.TStormSettings;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.svp.AgentSvp;

public class ProbeDefHndlr
implements RequestHandler,
ThreadSafe {
    private static HashMap probeScheduleMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeDefHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (!RequestChecker.isDesiredType(ScanDefReq.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        ScanDefReq probingAgent = (ScanDefReq)request.requestData;
        int scheduleID = probingAgent.scheduleID;
        int computerID = probingAgent.computerID.computerID;
        Connection dbc = Server.getConnection();
        if (dbc == null) {
            Server.setResponseError(response, "GEN0050E");
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        ProbeDefResp probeDef = new ProbeDefResp();
        probeDef.pdProbeLocal = true;
        probeDef.pdAbbreviatedProbe = AgentSvp.abbreviatedProbe;
        response.responseData = probeDef;
        try {
            HashMap agentMap;
            TStormSettings accessor = new TStormSettings(dbc);
            Settings settings = accessor.getSettings();
            probeDef.pdDesiredAWRE = settings.seDiskDesiredAWRE;
            probeDef.pdDesiredARRE = settings.seDiskDesiredARRE;
            probeDef.pdDesiredNoErrRcvry = settings.seDiskDesiredNoErrRcvry;
            TResDevice devAccessor = new TResDevice(dbc);
            probeDef.pdDiskList = (Disk)devAccessor.getDevByCmp(computerID, (short)0);
            devAccessor = null;
            TResComputer cmpAccessor = new TResComputer(dbc);
            probeDef.agentIP = cmpAccessor.getIPAddress(computerID);
            cmpAccessor = null;
            MutableInteger key = new MutableInteger(scheduleID);
            HashMap hashMap = probeScheduleMap;
            synchronized (hashMap) {
                agentMap = (HashMap)probeScheduleMap.get(key);
            }
            if (agentMap != null) {
                key.value = computerID;
                ProbeDefHndlr.addNasFilers(dbc, probeDef, agentMap, key, response);
            }
            probeDef.pack();
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ProbeDefHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
        }
        Server.returnConnection(dbc);
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response getEssProbeDef(ScanDefReq probingAgent, Connection dbc) {
        HashMap agentMap;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeDefHndlr.class.getName(), (String)"getEssProbeDef", (String)"probingAgent, dbc");
        }
        int scheduleID = probingAgent.scheduleID;
        Response response = Response.getResponse((short)0, null);
        ProbeDefResp probeDef = new ProbeDefResp();
        probeDef.pdProbeLocal = false;
        probeDef.pdAbbreviatedProbe = AgentSvp.abbreviatedProbe;
        response.responseData = probeDef;
        MutableInteger key = new MutableInteger(scheduleID);
        HashMap hashMap = probeScheduleMap;
        synchronized (hashMap) {
            agentMap = (HashMap)probeScheduleMap.get(key);
        }
        try {
            if (agentMap != null) {
                key.value = -999999999;
                ProbeDefHndlr.addNasFilers(dbc, probeDef, agentMap, key, response);
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ProbeDefHndlr.class.getName(), (String)"getEssProbeDef", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"getEssProbeDef", (Object)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response getStorageSubsystemProbeDef(ScanDefReq probingAgent, Connection dbc) {
        HashMap agentMap;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeDefHndlr.class.getName(), (String)"getStorageSubsystemProbeDef", (String)"probingAgent, dbc");
        }
        int scheduleID = probingAgent.scheduleID;
        Response response = Response.getResponse((short)0, null);
        ProbeDefResp probeDef = new ProbeDefResp();
        probeDef.pdProbeLocal = false;
        probeDef.pdAbbreviatedProbe = AgentSvp.abbreviatedProbe;
        response.responseData = probeDef;
        MutableInteger key = new MutableInteger(scheduleID);
        HashMap hashMap = probeScheduleMap;
        synchronized (hashMap) {
            agentMap = (HashMap)probeScheduleMap.get(key);
        }
        try {
            if (agentMap != null) {
                key.value = -999999999;
                ProbeDefHndlr.addNasFilers(dbc, probeDef, agentMap, key, response);
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ProbeDefHndlr.class.getName(), (String)"getStorageSubsystemProbeDef", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"getStorageSubsystemProbeDef", (Object)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Response getTapeLibraryProbeDef(ScanDefReq probingAgent, Connection dbc) {
        HashMap agentMap;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeDefHndlr.class.getName(), (String)"getTapeLibraryProbeDef", (String)"probingAgent, dbc");
        }
        int scheduleID = probingAgent.scheduleID;
        Response response = Response.getResponse((short)0, null);
        ProbeDefResp probeDef = new ProbeDefResp();
        probeDef.pdProbeLocal = false;
        probeDef.pdAbbreviatedProbe = AgentSvp.abbreviatedProbe;
        response.responseData = probeDef;
        MutableInteger key = new MutableInteger(scheduleID);
        HashMap hashMap = probeScheduleMap;
        synchronized (hashMap) {
            agentMap = (HashMap)probeScheduleMap.get(key);
        }
        try {
            if (agentMap != null) {
                key.value = -999999997;
                ProbeDefHndlr.addNasFilers(dbc, probeDef, agentMap, key, response);
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ProbeDefHndlr.class.getName(), (String)"getTapeLibraryProbeDef", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"getTapeLibraryProbeDef", (Object)traceResult);
        }
        return traceResult;
    }

    public static void addNasFilers(Connection dbc, ProbeDefResp probeDef, HashMap agentMap, MutableInteger key, Response response) throws GeneralException {
        int[] filerArray;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeDefHndlr.class.getName(), (String)"addNasFilers", (String)"dbc, probeDef, agentMap, key, response");
        }
        if ((filerArray = (int[])agentMap.get(key)) == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"addNasFilers");
            }
            return;
        }
        probeDef.pdProbeLocal = false;
        int computerID = key.value;
        TResComputer compAccessor = new TResComputer(dbc);
        boolean includeNas = false;
        ArrayList<NasFiler> filerList = new ArrayList<NasFiler>();
        for (int i = 0; i < filerArray.length; ++i) {
            if (key.value == filerArray[i]) {
                probeDef.pdProbeLocal = true;
                continue;
            }
            NasFiler filer = null;
            if (compAccessor.isStorageSubsystem(filerArray[i])) {
                compAccessor.prepGetSS();
                filer = compAccessor.getSS(filerArray[i]);
            } else if (compAccessor.isTapeLibrary(filerArray[i])) {
                compAccessor.prepGetTape();
                filer = compAccessor.getTape(filerArray[i]);
            } else {
                compAccessor.prepGetNasFiler();
                filer = compAccessor.getNasFiler(filerArray[i]);
            }
            if (filer == null) continue;
            if (!Constants.isDiskArray((short)filer.nfOSType) && filer.nfOSType != 8) {
                includeNas = true;
            }
            filerList.add(filer);
        }
        compAccessor.closeSelect();
        compAccessor = null;
        if (computerID > -1) {
            boolean windowsAgent;
            AgentManager.AgentAddress agent = Server.agentMgr.get(computerID);
            boolean bl = windowsAgent = agent != null && Constants.isWindows((short)agent.osType);
            if (windowsAgent) {
                TResPwd pwdAccessor = new TResPwd(dbc);
                pwdAccessor.getFilerLogins(filerList.iterator());
                pwdAccessor = null;
            }
        }
        TSnmpCommunity snmpAccessor = new TSnmpCommunity(dbc);
        NameList snmpCommunityList = snmpAccessor.getCommunities();
        snmpAccessor = null;
        boolean genericNAS = false;
        boolean specificNAS = false;
        for (NasFiler filer : filerList) {
            if (!includeNas && filer.nfOSType != 8 && !Constants.isDiskArray((short)filer.nfOSType)) continue;
            filer.nfNext = probeDef.pdNasFiler;
            probeDef.pdNasFiler = filer;
            if (Constants.isDiskArray((short)filer.nfOSType)) continue;
            if (!Constants.supportsFullProbe((short)filer.nfOSType)) {
                genericNAS = true;
            } else if (filer.nfOSType != 8) {
                specificNAS = true;
            }
            if (filer.nfOSType == 8) continue;
            filer.nfSnmpCommunity = snmpCommunityList;
        }
        if (genericNAS || specificNAS) {
            TFoundFilesystem fsAccessor = new TFoundFilesystem(dbc);
            if (genericNAS) {
                fsAccessor.getFilerProbeFS(probeDef.pdNasFiler, computerID);
            }
            if (specificNAS) {
                fsAccessor.getFakeFilesystems(probeDef.pdNasFiler);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"addNasFilers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getProbeComputers(Connection dbc, int scheduleID, int[] probeComputers) throws GeneralException {
        Object agent2;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeDefHndlr.class.getName(), (String)"getProbeComputers", (String)"dbc, scheduleID, probeComputers");
        }
        TStatComputer cmpAccessor = new TStatComputer(dbc);
        NameList compList = cmpAccessor.computersTiedTo(scheduleID, false);
        cmpAccessor = null;
        HashMap agentMap = new HashMap();
        ProbeDefHndlr.mapNetwareAgents(dbc, compList, agentMap);
        ProbeDefHndlr.mapNasAgents(dbc, compList, agentMap);
        TResDiskArray daAccessor = new TResDiskArray(dbc);
        NameList daList = daAccessor.computersTiedTo(scheduleID);
        daAccessor = null;
        ProbeDefHndlr.mapDiskArrayAgents(daList, agentMap);
        daList = null;
        TResLibraries tapeAccessor = new TResLibraries();
        NameList tapeList = tapeAccessor.getLibrariesTiedTo(scheduleID);
        ProbeDefHndlr.mapTapeLibraries(tapeList, agentMap);
        tapeAccessor = null;
        TResFabric fabricAccessor = new TResFabric();
        NameList fabricList = fabricAccessor.getFabricTiedTo(scheduleID);
        ProbeDefHndlr.mapFabric(fabricList, agentMap);
        fabricList = null;
        MutableInteger key = new MutableInteger();
        int computerIndex = 0;
        NameList node = compList;
        while (node != null) {
            if (!Constants.isNasBox((short)node.nlInfo) && !Constants.isVirtualServer((int)node.nlInfo)) {
                key.value = node.nlID;
                List filerList = (List)agentMap.get(key);
                if (filerList == null) {
                    probeComputers[computerIndex++] = node.nlID;
                } else {
                    filerList.add(new MutableInteger(key.value));
                }
            }
            node = node.nlNext;
        }
        for (Object agent2 : agentMap.keySet()) {
            probeComputers[computerIndex++] = agent2.value;
        }
        ProbeDefHndlr.makeArrays(agentMap);
        key.value = scheduleID;
        agent2 = probeScheduleMap;
        synchronized (agent2) {
            if (agentMap.isEmpty()) {
                probeScheduleMap.remove(key);
            } else {
                probeScheduleMap.put(key, agentMap);
            }
        }
        int traceResult = computerIndex;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"getProbeComputers", (int)traceResult);
        }
        return traceResult;
    }

    private static void mapNetwareAgents(Connection dbc, NameList compList, HashMap agentMap) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeDefHndlr.class.getName(), (String)"mapNetwareAgents", (String)"dbc, compList, agentMap");
        }
        TResLdapTree treeAccessor = new TResLdapTree(dbc);
        treeAccessor.prepGetProbeAgent();
        MutableInteger key = new MutableInteger();
        NameList node = compList;
        while (node != null) {
            if (node.nlInfo == 8) {
                key.value = treeAccessor.getProbeAgent(node.nlID);
                if (key.value > 0) {
                    ProbeDefHndlr.addMap(key, new MutableInteger(node.nlID), agentMap);
                }
            }
            node = node.nlNext;
        }
        treeAccessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"mapNetwareAgents");
        }
    }

    private static void mapNasAgents(Connection dbc, NameList compList, HashMap agentMap) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeDefHndlr.class.getName(), (String)"mapNasAgents", (String)"dbc, compList, agentMap");
        }
        TFoundFilesystem fsAccessor = new TFoundFilesystem(dbc);
        fsAccessor.prepGetScanningAgent();
        MutableInteger key = new MutableInteger();
        NameList node = compList;
        while (node != null) {
            if (node.nlInfo != 8 && Constants.isNasBox((short)node.nlInfo)) {
                boolean supportsFullProbe = Constants.supportsFullProbe((short)node.nlInfo);
                fsAccessor.execQueryByID(node.nlID);
                MutableInteger filer = new MutableInteger(node.nlID);
                while (fsAccessor.getScanningAgent(key)) {
                    ProbeDefHndlr.addMap(key, filer, agentMap);
                    if (!supportsFullProbe) continue;
                    fsAccessor.closeResultSet();
                    break;
                }
            }
            node = node.nlNext;
        }
        fsAccessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"mapNasAgents");
        }
    }

    private static void mapDiskArrayAgents(NameList daList, Map agentMap) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeDefHndlr.class.getName(), (String)"mapDiskArrayAgents", (String)"daList, agentMap");
        }
        MutableInteger agentID = new MutableInteger();
        while (daList != null) {
            if (daList.nlID2 >= 0) {
                if (daList.nlID2 == 0) {
                    daList.nlID2 = -999999999;
                }
                agentID.value = daList.nlID2;
                ProbeDefHndlr.addMap(agentID, new MutableInteger(daList.nlID), agentMap);
            }
            daList = daList.nlNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"mapDiskArrayAgents");
        }
    }

    private static void mapTapeLibraries(NameList tapeList, Map agentMap) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeDefHndlr.class.getName(), (String)"mapTapeLibraries", (String)"tapeList, agentMap");
        }
        MutableInteger agentID = new MutableInteger();
        while (tapeList != null) {
            if (tapeList.nlID2 >= 0) {
                if (tapeList.nlID2 == 0) {
                    tapeList.nlID2 = -999999997;
                }
                agentID.value = tapeList.nlID2;
                ProbeDefHndlr.addMap(agentID, new MutableInteger(tapeList.nlID), agentMap);
            }
            tapeList = tapeList.nlNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"mapTapeLibraries");
        }
    }

    private static void mapFabric(NameList fabricList, Map agentMap) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeDefHndlr.class.getName(), (String)"mapFabric", (String)"daList, agentMap");
        }
        MutableInteger agentID = new MutableInteger();
        while (fabricList != null) {
            if (fabricList.nlID2 >= 0) {
                if (fabricList.nlID2 == 0) {
                    fabricList.nlID2 = -999999998;
                }
                agentID.value = fabricList.nlID2;
                ProbeDefHndlr.addMap(agentID, new MutableInteger(fabricList.nlID), agentMap);
            }
            fabricList = fabricList.nlNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"mapFabric");
        }
    }

    public static void addMap(MutableInteger agentID, MutableInteger filerID, Map agentMap) {
        ArrayList<MutableInteger> filerList;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeDefHndlr.class.getName(), (String)"addMap", (String)"agentID, filerID, agentMap");
        }
        if ((filerList = (ArrayList<MutableInteger>)agentMap.get(agentID)) == null) {
            filerList = new ArrayList<MutableInteger>();
            agentMap.put(new MutableInteger(agentID.value), filerList);
        }
        filerList.add(filerID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"addMap");
        }
    }

    public static void makeArrays(HashMap agentMap) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeDefHndlr.class.getName(), (String)"makeArrays", (String)"agentMap");
        }
        for (Map.Entry entry : agentMap.entrySet()) {
            ArrayList filerList = (ArrayList)entry.getValue();
            int filerCount = filerList.size();
            int[] filerArray = new int[filerCount];
            while (filerCount > 0) {
                MutableInteger filerID = (MutableInteger)filerList.get(--filerCount);
                filerArray[filerCount] = filerID.value;
            }
            entry.setValue(filerArray);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeDefHndlr.class.getName(), (String)"makeArrays");
        }
    }
}

