/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.agent;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.common.CompHist;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.CuStatDef;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.EntityWWPN;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.common.ExtAccess;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.LunWWN;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.TStorm.common.SSummaryHist;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.EnclosureAccessor;
import org.eclipse.aperi.repository.FilerSaver;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TComputer;
import org.eclipse.aperi.repository.table.TFoundFilesystem;
import org.eclipse.aperi.repository.table.TGroup2Res;
import org.eclipse.aperi.repository.table.TResChunk;
import org.eclipse.aperi.repository.table.TResChunkCollection;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResController;
import org.eclipse.aperi.repository.table.TResDevAccess;
import org.eclipse.aperi.repository.table.TResDevice;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResEntityWWPN;
import org.eclipse.aperi.repository.table.TResExport;
import org.eclipse.aperi.repository.table.TResExtCtrlr;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.repository.table.TResLdapTree;
import org.eclipse.aperi.repository.table.TResLogicalDisk;
import org.eclipse.aperi.repository.table.TResLunWWN;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.repository.table.TResStorExtent;
import org.eclipse.aperi.repository.table.TResVolGroup;
import org.eclipse.aperi.repository.table.TStatCompHist;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.repository.table.TStatDisk;
import org.eclipse.aperi.repository.table.TStatDiskHist;
import org.eclipse.aperi.repository.table.TStatSpaceHist;
import org.eclipse.aperi.repository.table.TStormSettings;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.alert.ProbeAlerter;
import org.eclipse.aperi.server.handler.gui.GroupDefHndlr;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ProbeResultsHndlr
implements RequestHandler {
    private Response warningResponse;
    private Connection dbc;
    private Settings settings;
    private Computer computer;
    private Computer oldComputer;
    private TStatComputer cmpAccessor;
    private EnclosureAccessor encAccessor;
    private TResDevice devAccessor;
    private TResChunk chkAccessor;
    private TResChunkCollection colAccessor;
    private TResLogicalDisk ldAccessor;
    private TResFS fsAccessor;
    private TResShare shAccessor;
    private TResCluster clAccessor;
    private TComputer tCmpAccessor;
    private TResComputer tResCmpAccessor;
    private TGroup2Res tGrp2ResAccessor;
    private Share shareBuffer = new Share();
    private LogicalDisk lDiskBuffer = new LogicalDisk();
    private Filesystem fsBuffer = new Filesystem();
    private long probeTime;
    private Share missingDeviceList;
    private Share missingFSList;
    private Share removeFSList;
    private int[] lockedDeviceTable;
    private boolean updateScheduler;
    private boolean runDiscovery;
    private boolean isDelete;
    private boolean isDiskArray;
    private boolean isVirtualServer;
    private static final long MILLIS_PER_DAY = 86400000L;
    private int previousClusterID = 0;
    private boolean isStorageSubsystem = false;

    public ProbeResultsHndlr() {
    }

    public ProbeResultsHndlr(Connection dbc) {
        this.dbc = dbc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        ViewReportTablesUpdater reportTablesUpdater;
        Computer c;
        Response response;
        block21: {
            Response phase1Response;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
            }
            if (!transceiver.transmitResponse(request, phase1Response = Response.getResponse((short)0, null, (byte)0))) {
                phase1Response.returnResponse();
                Response traceResult = null;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"handle", traceResult);
                }
                return traceResult;
            }
            response = Response.getResponse((short)0, null);
            phase1Response.returnResponse();
            request.requestData = (Serializable)transceiver.receiveData(request);
            if (!RequestChecker.isDesiredType(Computer.class, (Request)request, (Response)response)) {
                Response traceResult = response;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"handle", (Object)traceResult);
                }
                return traceResult;
            }
            this.dbc = Server.getConnection();
            if (this.dbc == null) {
                Server.setResponseError(response, "GEN0050E");
                Response traceResult = response;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"handle", (Object)traceResult);
                }
                return traceResult;
            }
            this.warningResponse = response;
            c = (Computer)request.requestData;
            c.unpack();
            try {
                TStatComputer tStatComp;
                NameList agents;
                NasFiler filer = c.cmpNasFiler;
                while (filer != null) {
                    filer.nfParentComputerID = c.cmpID;
                    filer.nfComputer.cmpParentID = c.cmpID;
                    filer = filer.nfNext;
                }
                if (c.cmpOSVersion != null) {
                    this.saveResults(c);
                } else {
                    this.initializeFlags();
                    if (c.cmpDomain != null) {
                        TResDomain domAccessor = new TResDomain(this.dbc);
                        domAccessor.getIDs(c.cmpDomain);
                        c.cmpDomainID = c.cmpDomain.domID;
                    }
                }
                long filerProbeTime = 86400000L;
                FilerSaver filerSaver = null;
                if (c.cmpNasFiler != null) {
                    int nasShareID = c.cmpDomainID > 0 ? c.cmpDomainID : c.cmpID;
                    filerSaver = new FilerSaver(this.dbc, nasShareID);
                    filerSaver.saveProbeData(c);
                }
                if (c.cmpCluster != null) {
                    this.expireVSs(this.dbc, c, filerSaver);
                }
                if (this.previousClusterID == 0 || (agents = (tStatComp = new TStatComputer(this.dbc)).selectAgentsInCluster(this.previousClusterID)) != null) break block21;
                filerSaver = new FilerSaver(this.dbc, this.previousClusterID);
                TResShare shareAccessor = new TResShare(this.dbc);
                Share s = shareAccessor.getRemovedResources(this.previousClusterID, (short)99, filerSaver.getProbeTime());
                filerSaver.removeFilers(s, false);
                this.clAccessor = new TResCluster(this.dbc);
                this.clAccessor.cleanupCluster(this.previousClusterID);
            }
            catch (StorageException e) {
                try {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ProbeResultsHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                catch (Throwable throwable) {
                    ViewReportTablesUpdater reportTablesUpdater2 = new ViewReportTablesUpdater();
                    reportTablesUpdater2.updateViewTables(new int[]{c.cmpID}, (short)1);
                    throw throwable;
                }
                reportTablesUpdater = new ViewReportTablesUpdater();
                reportTablesUpdater.updateViewTables(new int[]{c.cmpID}, (short)1);
            }
        }
        reportTablesUpdater = new ViewReportTablesUpdater();
        reportTablesUpdater.updateViewTables(new int[]{c.cmpID}, (short)1);
        Server.returnConnection(this.dbc);
        this.dbc = null;
        if (this.updateScheduler) {
            ScheduleQueue.routine.rebuild();
        }
        if (this.runDiscovery) {
            response.responseData = "DISCOVERY";
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveResults(Computer computer) throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveResults", (String)"computer");
        }
        this.computer = computer;
        this.isDelete = false;
        this.initialize();
        boolean processed = false;
        try {
            if (ProbeResultsHndlr.lockComputer(computer, this.warningResponse)) {
                processed = true;
                this.getSettings();
                this.clusterProcessing();
                if (this.isDiskArray) {
                    this.updateSVCDiskIdentity();
                    this.updateSSLUNIdentity();
                }
                this.saveComputerStats();
                this.saveVolgroups();
                this.saveVolGroupStats();
                this.saveDevices();
                this.getMissingDevices();
                this.saveStorExtents();
                this.saveCtlrDevAccess();
                this.lockDevices();
                this.saveLogicalDisks();
                if (!this.isDiskArray) {
                    this.saveFilesystems();
                    this.saveFSHist();
                    this.saveExports();
                    this.saveLdapTrees();
                    this.removeObsoleteLdapTrees();
                    this.gatherObsoleteFilesystems();
                } else {
                    this.saveLunWWNs();
                    this.saveEntityWWPNs();
                }
                this.removeObsoleteLogicalDisks();
                this.removeObsoleteDevices();
                this.saveComputerHist();
                this.analyzeAlerts();
                if (!this.isDiskArray) {
                    this.removeObsoleteFilesystems();
                }
                this.cleanClusterMembership();
                computer.cmpProbeStatus = (byte)2;
            }
        }
        finally {
            this.doCleanup(processed, computer);
        }
        boolean traceResult = this.updateScheduler;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveResults", (boolean)traceResult);
        }
        return traceResult;
    }

    private void doCleanup(boolean processed, Computer computer) {
        block6: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"doCleanup", (String)"processed, computer, svcCleanup");
            }
            if (processed) {
                this.unLockDevices();
            }
            ProbeResultsHndlr.unLockComputer(computer);
            if (processed) {
                try {
                    this.encAccessor.update(computer);
                }
                catch (GeneralException e) {
                    if (!TraceLogger.enableTrace) break block6;
                    TraceLogger.exception((String)ProbeResultsHndlr.class.getName(), (String)"doCleanup", (Throwable)e);
                }
            }
        }
        this.cleanup();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"doCleanup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNasProbeResults(Computer computer) throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveNasProbeResults", (String)"computer");
        }
        this.computer = computer;
        this.isDelete = false;
        this.initialize();
        boolean processed = false;
        try {
            if (ProbeResultsHndlr.lockComputer(computer, this.warningResponse)) {
                processed = true;
                this.saveComputerStats();
                this.updateFilesystemStats();
                this.saveNewFilesystems();
                this.analyzeAlerts();
                computer.cmpProbeStatus = (byte)2;
            }
        }
        finally {
            block12: {
                ProbeResultsHndlr.unLockComputer(computer);
                if (processed) {
                    try {
                        this.encAccessor.update(computer);
                    }
                    catch (GeneralException e) {
                        if (!TraceLogger.enableTrace) break block12;
                        TraceLogger.exception((String)ProbeResultsHndlr.class.getName(), (String)"saveNasProbeResults", (Throwable)e);
                    }
                }
            }
            this.cleanup();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveNasProbeResults");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteComputer(int computerID, int productCode) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"deleteComputer", (String)"computerID, productCode");
        }
        boolean ok = false;
        MutableBoolean beenProbed = new MutableBoolean(false);
        boolean removeAll = true;
        if (productCode == -1) {
            removeAll = false;
        }
        this.dbc = Server.getConnection();
        if (this.dbc != null) {
            this.computer = new Computer();
            this.computer.cmpID = computerID;
            this.computer.cmpOSType = productCode == 0 || productCode == 1 ? (short)1 : (short)11;
            this.isDelete = true;
            this.initialize();
            try {
                if (this.encAccessor.getComputerStats(this.computer, beenProbed)) {
                    this.getSettings();
                    this.getMissingDevices();
                    this.removeStorExtents();
                    this.removeVolGroups();
                    if (removeAll) {
                        this.lockDevices();
                    }
                    this.removeObsoleteLdapTrees();
                    this.gatherObsoleteFilesystems();
                    if (removeAll) {
                        this.removeObsoleteLogicalDisks();
                        this.removeObsoleteDevices();
                    }
                    if (removeAll) {
                        this.removeObsoleteFilesystems();
                    } else {
                        this.deleteFilesystemStats();
                    }
                    this.removeNasFilers(removeAll);
                    this.deleteOtherStuff(removeAll);
                }
                ok = true;
            }
            catch (GeneralException ignored) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ProbeResultsHndlr.class.getName(), (String)"deleteComputer", (Throwable)ignored);
                }
            }
            finally {
                if (removeAll) {
                    this.unLockDevices();
                }
            }
            Server.returnConnection(this.dbc);
        }
        boolean traceResult = ok;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"deleteComputer", (boolean)traceResult);
        }
        return traceResult;
    }

    public boolean deleteRelationships(int computerID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"deleteRelationships", (String)"computerID");
        }
        boolean ok = false;
        try {
            this.computer = new Computer();
            this.computer.cmpID = computerID;
            this.isDelete = true;
            this.initialize();
            this.getSettings();
            this.removeNasFilers(true);
            StorageRepositoryAccessor deleteAccessor = new StorageRepositoryAccessor(this.dbc);
            deleteAccessor.deleteByComputer("t_alert_log", computerID);
            ok = true;
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ProbeResultsHndlr.class.getName(), (String)"deleteRelationships", (Throwable)e);
            }
            MessageLog.logException((StorageException)((Object)e));
        }
        boolean traceResult = ok;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"deleteRelationships", (boolean)traceResult);
        }
        return traceResult;
    }

    private void deleteFilesystemStats() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"deleteFilesystemStats", (String)"");
        }
        Filesystem fsList = null;
        Share sh = this.removeFSList;
        while (sh != null) {
            if (sh.shResource != null) {
                Filesystem fs = (Filesystem)sh.shResource;
                fs.fsNext = fsList;
                fsList = fs;
            }
            sh = sh.shNext;
        }
        if (fsList != null) {
            this.fsAccessor.deleteFS(fsList, false);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"deleteFilesystemStats");
        }
    }

    private void initialize() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"initialize", (String)"");
        }
        this.initializeFlags();
        try {
            this.probeTime = SQLUtil.getTimestamp(this.dbc).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ProbeResultsHndlr.class.getName(), (String)"initialize", (Throwable)e);
            }
            return;
        }
        this.isDiskArray = Constants.isDiskArray((short)this.computer.cmpOSType);
        this.isVirtualServer = Constants.isVirtualServer((int)this.computer.cmpOSType);
        if (this.isDiskArray) {
            this.cmpAccessor = null;
            this.encAccessor = new TResDiskArray(this.dbc);
        } else {
            this.cmpAccessor = new TStatComputer(this.dbc);
            this.encAccessor = this.cmpAccessor;
        }
        this.chkAccessor = new TResChunk(this.dbc);
        this.colAccessor = new TResChunkCollection(this.dbc);
        this.ldAccessor = new TResLogicalDisk(this.dbc);
        this.shAccessor = new TResShare(this.dbc);
        this.fsAccessor = new TResFS(this.dbc);
        this.devAccessor = new TResDevice(this.dbc);
        this.clAccessor = new TResCluster(this.dbc);
        this.tResCmpAccessor = new TResComputer(this.dbc);
        this.tGrp2ResAccessor = new TGroup2Res(this.dbc);
        this.previousClusterID = 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"initialize");
        }
    }

    private void initializeFlags() {
        this.updateScheduler = false;
        this.runDiscovery = false;
    }

    public static boolean lockComputer(Computer computer, Response msgResponse) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"lockComputer", (String)"computer, msgResponse");
        }
        byte lockLevel = Constants.isNasBox((short)computer.cmpOSType) ? (byte)1 : 2;
        LockManager.lock((short)2, (String)"Computer", (String)Integer.toString(computer.cmpID), (byte)lockLevel, (boolean)true);
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"lockComputer", (boolean)traceResult);
        }
        return traceResult;
    }

    public static void unLockComputer(Computer computer) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"unLockComputer", (String)"computer");
        }
        LockManager.unLock((short)2, (String)"Computer", (String)Integer.toString(computer.cmpID));
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"unLockComputer");
        }
    }

    private void getSettings() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"getSettings", (String)"");
        }
        TStormSettings accessor = new TStormSettings(this.dbc);
        this.settings = accessor.getSettings();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getSettings");
        }
    }

    private void saveComputerStats() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveComputerStats", (String)"");
        }
        MutableBoolean beenProbed = new MutableBoolean(false);
        if (this.computer.cmpDomain != null) {
            TResDomain domAccessor = new TResDomain(this.dbc);
            this.runDiscovery = domAccessor.getIDs(this.computer.cmpDomain);
        }
        this.computer.cmpProbeStatus = 0;
        this.computer.cmpLastProbeTime = this.probeTime;
        this.oldComputer = new Computer();
        this.oldComputer.cmpID = this.computer.cmpID;
        if (!this.encAccessor.getComputerStats(this.oldComputer, beenProbed)) {
            this.oldComputer = null;
            this.computer.cmpGroupID = this.isDiskArray ? 8 : 4;
            this.encAccessor.insert(this.computer);
            this.updateScheduler = true;
        } else {
            if (!beenProbed.value) {
                this.oldComputer = null;
            }
            if (Constants.isNasBox((short)this.computer.cmpOSType) && !Constants.supportsFullProbe((short)this.computer.cmpOSType)) {
                Filesystem fsList;
                HashMap fsMap = new HashMap();
                LogicalDisk lDisk = this.computer.cmpLogicalDisk;
                while (lDisk != null) {
                    fsMap.put(lDisk.ldFilesystem.fsMountPoint, null);
                    lDisk = lDisk.ldNext;
                }
                Filesystem fs = fsList = this.fsAccessor.getByComputerID(this.computer.cmpID);
                while (fs != null) {
                    if (!fsMap.containsKey(fs.fsMountPoint)) {
                        this.computer.cmpFilesystemFreeSpace += fs.fsFreeSpace;
                    }
                    fs = fs.fsNext;
                }
            }
            if (Constants.licensedAsNAS((short)this.computer.cmpOSType) && this.computer.cmpDomainID <= 0 && this.oldComputer.cmpDomainID > 0) {
                this.computer.cmpDomain = new Domain();
                this.computer.cmpDomain.domID = this.oldComputer.cmpDomainID;
            }
            this.encAccessor.update(this.computer);
        }
        this.computer.cmpProbeStatus = 1;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveComputerStats");
        }
    }

    private void saveVolGroupStats() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveVolGroupStats", (String)"");
        }
        VolGroup vg = null;
        TStatSpaceHist histAccessor = new TStatSpaceHist(this.dbc);
        SSummaryHist hist = new SSummaryHist();
        CuStatDef stat = new CuStatDef();
        stat.sdDailyRetention = this.settings.seDiskDailyHist;
        stat.sdWeeklyRetention = this.settings.seDiskWeeklyHist;
        stat.sdMonthlyRetention = this.settings.seDiskMonthlyHist;
        histAccessor.prepFSHistSave();
        vg = this.computer.cmpVolGroup;
        while (vg != null) {
            hist.sumFilesystemID = vg.vgID;
            hist.sumFreeSpace = vg.vgFreeSpace;
            hist.sumUsedSpace = vg.vgTotalSpace - vg.vgFreeSpace;
            hist.sumTotalSize = vg.vgTotalSpace;
            hist.sumFileCount = vg.vgDisks;
            hist.sumScanTime = this.probeTime;
            histAccessor.saveHist(stat, hist);
            vg = vg.vgNext;
        }
        histAccessor.closeHistSave();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveVolGroupStats");
        }
    }

    private void saveStorExtents() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveStorExtents", (String)"");
        }
        Rank rank = null;
        Rank rankRep = null;
        Rank rankDelList = null;
        Rank rankWork = null;
        TResStorExtent rankAccessor = new TResStorExtent(this.dbc);
        int insCount = 0;
        int updCount = 0;
        boolean found = false;
        rankRep = rankAccessor.getStorExtentByComputer(this.computer.cmpID);
        if (this.computer.cmpRank == null) {
            if (rankRep != null) {
                rankAccessor.deleteStorExtents(rankRep);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveStorExtents");
            }
            return;
        }
        while (rankRep != null) {
            found = false;
            rank = this.computer.cmpRank;
            while (rank != null) {
                rank.rankProbeTime = this.probeTime;
                if (rank.rankComputerID == rankRep.rankComputerID && rank.rankName.equalsIgnoreCase(rankRep.rankName)) {
                    rank.rankID = rankRep.rankID;
                    found = true;
                    if (!rank.equals((Object)rankRep)) {
                        rank.rankFlag = (short)2;
                        ++updCount;
                        break;
                    }
                    rank.rankFlag = 0;
                    break;
                }
                rank = rank.rankNext;
            }
            if (!found) {
                rankWork = rankRep.rankNext;
                rankRep.rankNext = rankDelList;
                rankDelList = rankRep;
            } else {
                rankWork = rankRep.rankNext;
            }
            rankRep = rankWork;
        }
        rank = this.computer.cmpRank;
        while (rank != null) {
            if (rank.rankID == -1) {
                ++insCount;
            }
            rank = rank.rankNext;
        }
        if (insCount > 0 || updCount > 0) {
            rankAccessor.saveStorExtents(this.computer.cmpRank, insCount);
        }
        if (rankDelList != null) {
            rankAccessor.deleteStorExtents(rankDelList);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveStorExtents");
        }
    }

    private void saveVolgroups() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveVolgroups", (String)"");
        }
        VolGroup vg = null;
        VolGroup vgRep = null;
        VolGroup vgDelList = null;
        VolGroup vgWork = null;
        TResVolGroup vgAccessor = new TResVolGroup(this.dbc);
        int insCount = 0;
        int updCount = 0;
        boolean found = false;
        vgRep = vgAccessor.getVolGroupByCmp(this.computer.cmpID);
        if (this.computer.cmpVolGroup == null) {
            if (vgRep != null) {
                vgAccessor.deleteVolGroups(vgRep);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveVolgroups");
            }
            return;
        }
        while (vgRep != null) {
            found = false;
            vg = this.computer.cmpVolGroup;
            while (vg != null) {
                vg.vgProbeTime = this.probeTime;
                if (vg.vgComputerID == vgRep.vgComputerID && vg.vgName.equalsIgnoreCase(vgRep.vgName)) {
                    vg.vgID = vgRep.vgID;
                    found = true;
                    if (!vg.equals((Object)vgRep)) {
                        vg.vgFlag = (short)2;
                        ++updCount;
                        break;
                    }
                    vg.vgFlag = 0;
                    break;
                }
                vg = vg.vgNext;
            }
            if (!found) {
                vgWork = vgRep.vgNext;
                vgRep.vgNext = vgDelList;
                vgDelList = vgRep;
            } else {
                vgWork = vgRep.vgNext;
            }
            vgRep = vgWork;
        }
        vg = this.computer.cmpVolGroup;
        while (vg != null) {
            if (vg.vgID == -1) {
                ++insCount;
                vg.vgDiscoveredTime = this.probeTime;
            }
            vg = vg.vgNext;
        }
        if (insCount > 0 || updCount > 0) {
            vgAccessor.saveVolGroups(this.computer.cmpVolGroup, insCount);
        }
        this.propagateVolGroupIDS();
        if (vgDelList != null) {
            vgAccessor.deleteVolGroups(vgDelList);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveVolgroups");
        }
    }

    private void propagateVolGroupIDS() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"propagateVolGroupIDS", (String)"");
        }
        VolGroup vg = null;
        Disk disk = null;
        vg = this.computer.cmpVolGroup;
        while (vg != null) {
            if (vg.vgDevices != null) {
                for (int i = 0; i < vg.vgDevices.length; ++i) {
                    Device dev = vg.vgDevices[i];
                    if (!(dev instanceof Disk)) continue;
                    disk = (Disk)this.computer.cmpDevice;
                    while (disk != null) {
                        if (dev.devSerialNumber.equals(disk.devSerialNumber)) {
                            disk.dskVolgroupID = vg.vgID;
                        }
                        disk = (Disk)disk.devNext;
                    }
                }
            }
            if (this.computer.cmpRank != null) {
                Rank rank = this.computer.cmpRank;
                while (rank != null) {
                    if (rank.rankVolGroupID == Integer.valueOf(vg.vgName.substring(2))) {
                        rank.rankVolGroupID = vg.vgID;
                    }
                    rank = rank.rankNext;
                }
            }
            vg = vg.vgNext;
        }
        if (this.computer.cmpLogicalDisk != null) {
            LogicalDisk lDisk = this.computer.cmpLogicalDisk;
            while (lDisk != null) {
                if (lDisk.ldVgroup != null) {
                    lDisk.ldVolgroupID = lDisk.ldVgroup.vgID;
                }
                LogicalDisk mDisk = lDisk.ldNextMirror;
                while (mDisk != null) {
                    if (mDisk.ldVgroup != null) {
                        mDisk.ldVolgroupID = mDisk.ldVgroup.vgID;
                    }
                    mDisk = mDisk.ldNextMirror;
                }
                lDisk = lDisk.ldNext;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"propagateVolGroupIDS");
        }
    }

    private void removeVolGroups() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"removeVolGroups", (String)"");
        }
        TResVolGroup accessor = new TResVolGroup(this.dbc);
        accessor.deleteVGByComputer(this.computer.cmpID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeVolGroups");
        }
    }

    private void removeStorExtents() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"removeStorExtents", (String)"");
        }
        TResExtCtrlr accessor = new TResExtCtrlr(this.dbc);
        TResStorExtent accessor2 = new TResStorExtent(this.dbc);
        Rank rankList = accessor2.getStorExtentByComputer(this.computer.cmpID);
        accessor.deleteExtCtrlr(rankList);
        accessor2.deleteStorExtents(this.computer.cmpID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeStorExtents");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDevices() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveDevices", (String)"");
        }
        if (this.computer.cmpOSType == 10) {
            this.devAccessor.saveNetAppDevices(this.computer.cmpDevice, this.computer.cmpSerialNumber);
        } else {
            this.devAccessor.saveDevices(this.computer.cmpDevice);
        }
        TResShare shareAccessor = new TResShare(this.dbc);
        try {
            shareAccessor.prepSave();
            this.devAccessor.prepBumpUseCount();
            this.shareBuffer.shResourceType = (short)10;
            this.shareBuffer.shComputerID = this.computer.cmpID;
            this.shareBuffer.shScanTime = this.probeTime;
            this.shareBuffer.shRemovedTime = 0L;
            this.shareBuffer.shPath = " ";
            Device dev = this.computer.cmpDevice;
            while (dev != null) {
                boolean newDevice;
                this.shareBuffer.shResource = dev;
                this.shareBuffer.shResourceID = dev.devID;
                boolean bl = newDevice = (dev.devFlags & 4) != 0;
                if (shareAccessor.saveShare(this.shareBuffer, newDevice)) {
                    dev.devFlags = (short)(dev.devFlags | 4);
                    this.devAccessor.bumpUseCount(dev, 1);
                }
                shareAccessor.commit();
                dev = dev.devNext;
            }
        }
        finally {
            shareAccessor.closeSave();
            this.devAccessor.closeUpdate();
        }
        TStatDiskHist dhAccessor = new TStatDiskHist(this.dbc);
        dhAccessor.saveDailyHist(this.settings, this.computer.cmpDevice, this.probeTime);
        this.propagateDeviceIDs();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveDevices");
        }
    }

    private void getMissingDevices() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"getMissingDevices", (String)"");
        }
        TStatDisk accessor = new TStatDisk(this.dbc);
        this.missingDeviceList = this.shAccessor.getRemovedResources(this.computer.cmpID, (short)10, this.probeTime);
        if (this.missingDeviceList != null) {
            accessor.prepUpdateVolGroupID();
            this.devAccessor.prepGetDevByID(false);
            Share sh = this.missingDeviceList;
            while (sh != null) {
                sh.shResource = this.devAccessor.getDevByID(sh.shResourceID);
                accessor.updateVolGroupID(sh.shResourceID, -1);
                sh = sh.shNext;
            }
            this.devAccessor.closeSelect();
            accessor.closeUpdate();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getMissingDevices");
        }
    }

    private void propagateDeviceIDs() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"propagateDeviceIDs", (String)"");
        }
        Device dev = this.computer.cmpDevice;
        while (dev != null) {
            if (dev.isFixedDisk()) {
                Disk dsk = (Disk)dev;
                Chunk chk = dsk.dskChunk;
                while (chk != null) {
                    chk.chkDiskID = dsk.devID;
                    chk = chk.chkNextOnDisk;
                }
            }
            dev = dev.devNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"propagateDeviceIDs");
        }
    }

    private void removeObsoleteDevices() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"removeObsoleteDevices", (String)"");
        }
        if (this.missingDeviceList == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeObsoleteDevices");
            }
            return;
        }
        long removeMillis = (long)this.settings.seKeepRemovedDev * 86400000L;
        long removeTime = this.probeTime - removeMillis;
        Share removeShList = null;
        Share flagShList = null;
        Share shList = null;
        while (this.missingDeviceList != null) {
            Share sh = this.missingDeviceList;
            this.missingDeviceList = sh.shNext;
            if (sh.shRemovedTime <= 86400000L) {
                sh.shRemovedTime = this.probeTime;
            }
            if (sh.shResource == null || sh.shRemovedTime < removeTime || this.isDelete) {
                sh.shNext = removeShList;
                removeShList = sh;
                continue;
            }
            if (sh.shRemovedTime == this.probeTime) {
                sh.shNext = flagShList;
                flagShList = sh;
                continue;
            }
            sh.shNext = shList;
            shList = sh;
        }
        if (flagShList != null) {
            this.flagMissingResources(flagShList);
        }
        if (removeShList != null) {
            this.removeDevices(removeShList);
        }
        this.missingDeviceList = flagShList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeObsoleteDevices");
        }
    }

    private Share concatLists(Share a, Share b) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (String)"a, b");
        }
        if (a == null) {
            Share traceResult = b;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
            }
            return traceResult;
        }
        if (b == null) {
            Share traceResult = a;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
            }
            return traceResult;
        }
        Share tail = a;
        while (tail.shNext != null) {
            tail = tail.shNext;
        }
        tail.shNext = b;
        Share traceResult = a;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
        }
        return traceResult;
    }

    private void flagMissingResources(Share shList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"flagMissingResources", (String)"shList");
        }
        this.shAccessor.prepUpdate();
        Share sh = shList;
        while (sh != null) {
            this.shAccessor.updateShare(sh);
            sh = sh.shNext;
        }
        this.shAccessor.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"flagMissingResources");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDevices(Share shList) throws GeneralException {
        Device dev;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"removeDevices", (String)"shList");
        }
        Device removeList = null;
        Share sh = shList;
        while (sh != null) {
            if (sh.shResource != null) {
                dev = (Device)sh.shResource;
                if (dev.devUseCount <= 1) {
                    dev.devNext = removeList;
                    removeList = dev;
                }
            }
            sh = sh.shNext;
        }
        if (removeList != null) {
            this.devAccessor.deleteDevices(removeList);
        }
        try {
            this.shAccessor.prepDelete();
            this.devAccessor.prepBumpUseCount();
            sh = shList;
            while (sh != null) {
                if (sh.shResource != null) {
                    dev = (Device)sh.shResource;
                    if (dev.devUseCount > 1) {
                        this.devAccessor.bumpUseCount(dev, -1);
                    }
                }
                this.shAccessor.deleteShare(sh);
                sh = sh.shNext;
            }
        }
        finally {
            this.shAccessor.closeDelete();
            this.devAccessor.closeUpdate();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeDevices");
        }
    }

    private void saveCtlrDevAccess() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveCtlrDevAccess", (String)"");
        }
        Controller addedCtlrList = null;
        Controller removedCtlrList = null;
        Controller updatedCtlrList = null;
        Controller staticCtlrList = null;
        DevAccess addedDAList = null;
        DevAccess removedDAList = null;
        DevAccess updatedDAList = null;
        ExtAccess addedEAList = null;
        ExtAccess removedEAList = null;
        TResDevAccess daAccessor = new TResDevAccess(this.dbc);
        TResExtCtrlr eaAccessor = new TResExtCtrlr(this.dbc);
        TResController ctlrAccessor = new TResController(this.dbc);
        TResEntityWWPN wwpnAccessor = new TResEntityWWPN(this.dbc);
        Controller oldCtlrList = ctlrAccessor.getControllers(this.computer.cmpID);
        Controller ctlr = this.computer.cmpController;
        Controller oldCtlr = oldCtlrList;
        while (ctlr != null && oldCtlr != null) {
            Controller nextCtlr;
            int cmp = ctlr.compareKeys(oldCtlr);
            if (cmp < 0) {
                nextCtlr = ctlr.ctlrNext;
                addedCtlrList = this.addToList(ctlr, addedCtlrList);
                ctlr = nextCtlr;
                continue;
            }
            if (cmp > 0) {
                nextCtlr = oldCtlr.ctlrNext;
                removedCtlrList = this.addToList(oldCtlr, removedCtlrList);
                oldCtlr = nextCtlr;
                continue;
            }
            ctlr.ctlrID = oldCtlr.ctlrID;
            nextCtlr = ctlr.ctlrNext;
            if (ctlr.equals((Object)oldCtlr)) {
                staticCtlrList = this.addToList(ctlr, staticCtlrList);
            } else {
                updatedCtlrList = this.addToList(ctlr, updatedCtlrList);
            }
            ctlr = nextCtlr;
            oldCtlr = oldCtlr.ctlrNext;
        }
        addedCtlrList = this.concatLists(ctlr, addedCtlrList);
        removedCtlrList = this.concatLists(oldCtlr, removedCtlrList);
        if (addedCtlrList != null) {
            ctlrAccessor.insertControllers(this.computer.cmpID, addedCtlrList);
        }
        if (updatedCtlrList != null) {
            ctlrAccessor.updateControllers(this.computer.cmpID, updatedCtlrList);
        }
        if (removedCtlrList != null) {
            daAccessor.deleteDevAccess(removedCtlrList);
            eaAccessor.deleteExtCtrlr(removedCtlrList);
            ctlr = removedCtlrList;
            while (ctlr != null) {
                wwpnAccessor.deleteByEntity_ID(ctlr.ctlrID);
                ctlr = ctlr.ctlrNext;
            }
            wwpnAccessor.closeDelete();
            ctlrAccessor.deleteControllers(this.computer.cmpID, removedCtlrList);
        }
        updatedCtlrList = this.concatLists(staticCtlrList, updatedCtlrList);
        EntityWWPN oldWwpnList = null;
        EntityWWPN removedWwpnList = null;
        boolean found = false;
        String sWwpn = null;
        String oldsWwpn = null;
        if (updatedCtlrList != null) {
            ctlr = updatedCtlrList;
            while (ctlr != null) {
                EntityWWPN wwpn;
                oldWwpnList = wwpnAccessor.getEntityWWPNs(ctlr.ctlrID);
                EntityWWPN wwpnHead = ctlr.ctlrWWPNs;
                EntityWWPN oldWwpn = oldWwpnList;
                while (oldWwpn != null) {
                    found = false;
                    oldsWwpn = oldWwpn.sWWPN;
                    EntityWWPN wwpnPrevious = wwpnHead;
                    wwpn = wwpnHead;
                    while (wwpn != null) {
                        sWwpn = wwpn.sWWPN;
                        if (oldsWwpn != null && sWwpn != null && oldsWwpn.equals(sWwpn)) {
                            found = true;
                            if (wwpn.equals(wwpnHead)) {
                                wwpnHead = wwpnHead.entityWWPNNext;
                                break;
                            }
                            wwpnPrevious.entityWWPNNext = wwpn.entityWWPNNext;
                            break;
                        }
                        wwpnPrevious = wwpn;
                        wwpn = wwpn.entityWWPNNext;
                    }
                    if (!found) {
                        oldWwpn.entityWWPNNext = removedWwpnList;
                        removedWwpnList = oldWwpn;
                    }
                    oldWwpn = oldWwpn.entityWWPNNext;
                }
                wwpn = removedWwpnList;
                while (wwpn != null) {
                    wwpnAccessor.deleteByEntity_ID(ctlr.ctlrID);
                    wwpn = wwpn.entityWWPNNext;
                }
                wwpn = wwpnHead;
                while (wwpn != null) {
                    if (this.computer.cmpOSType == 21) {
                        wwpnAccessor.insert(ctlr.ctlrID, (byte)3, wwpn.sWWPN);
                    } else {
                        wwpnAccessor.insert(ctlr.ctlrID, (byte)1, wwpn.sWWPN);
                    }
                    wwpn = wwpn.entityWWPNNext;
                }
                ctlr = ctlr.ctlrNext;
            }
            wwpnAccessor.closeDelete();
            wwpnAccessor.closeInsert();
            wwpnAccessor.closeSelect();
        }
        if (updatedCtlrList != null) {
            daAccessor.prepSelectByCtlr();
            ctlr = updatedCtlrList;
            while (ctlr != null) {
                this.setDevAccessIDs(ctlr);
                DevAccess oldDAList = daAccessor.getDevAccess(ctlr.ctlrID);
                DevAccess da = ctlr.ctlrDevices;
                DevAccess oldDA = oldDAList;
                while (da != null && oldDA != null) {
                    DevAccess nextDA;
                    if (da.daTarget < oldDA.daTarget || da.daTarget == oldDA.daTarget && da.daLUN < oldDA.daLUN) {
                        nextDA = da.daNextDevice;
                        addedDAList = this.addToList(da, addedDAList);
                        da = nextDA;
                        continue;
                    }
                    if (da.daTarget > oldDA.daTarget || da.daTarget == oldDA.daTarget && da.daLUN > oldDA.daLUN) {
                        nextDA = oldDA.daNextDevice;
                        removedDAList = this.addToList(oldDA, removedDAList);
                        oldDA = nextDA;
                        continue;
                    }
                    nextDA = da.daNextDevice;
                    if (!da.equals((Object)oldDA)) {
                        updatedDAList = this.addToList(da, updatedDAList);
                    }
                    da = nextDA;
                    oldDA = oldDA.daNextDevice;
                }
                addedDAList = this.concatLists(da, addedDAList);
                removedDAList = this.concatLists(oldDA, removedDAList);
                ctlr = ctlr.ctlrNext;
            }
            daAccessor.closeSelect();
        }
        ctlr = addedCtlrList;
        while (ctlr != null) {
            this.setDevAccessIDs(ctlr);
            addedDAList = this.concatLists(ctlr.ctlrDevices, addedDAList);
            EntityWWPN wwpn = ctlr.ctlrWWPNs;
            while (wwpn != null) {
                if (this.computer.cmpOSType == 21) {
                    wwpnAccessor.insert(ctlr.ctlrID, (byte)3, wwpn.sWWPN);
                } else {
                    wwpnAccessor.insert(ctlr.ctlrID, (byte)1, wwpn.sWWPN);
                }
                wwpn = wwpn.entityWWPNNext;
            }
            ctlr = ctlr.ctlrNext;
        }
        wwpnAccessor.closeInsert();
        if (addedDAList != null) {
            daAccessor.insertDevAccess(addedDAList);
        }
        if (updatedDAList != null) {
            daAccessor.updateDevAccess(updatedDAList);
        }
        if (removedDAList != null) {
            daAccessor.deleteDevAccess(removedDAList);
        }
        if (updatedCtlrList != null) {
            eaAccessor.prepSelectByCtlr();
            ctlr = updatedCtlrList;
            while (ctlr != null) {
                boolean isfound;
                this.setExtAccessIDs(ctlr);
                ExtAccess oldEAList = eaAccessor.getExtAccess(ctlr.ctlrID);
                ExtAccess ea = ctlr.ctlrExtents;
                ExtAccess oldEA = oldEAList;
                while (ea != null) {
                    isfound = false;
                    while (oldEA != null && !isfound) {
                        if (ea.eaRankID == oldEA.eaRankID) {
                            isfound = true;
                            continue;
                        }
                        oldEA = oldEA.eaNextExtent;
                    }
                    ExtAccess nextEA = ea.eaNextExtent;
                    if (!isfound) {
                        addedEAList = this.addToList(ea, addedEAList);
                    }
                    ea = nextEA;
                }
                oldEAList = eaAccessor.getExtAccess(ctlr.ctlrID);
                ea = ctlr.ctlrExtents;
                oldEA = oldEAList;
                while (oldEA != null) {
                    isfound = false;
                    while (ea != null && !isfound) {
                        if (oldEA.eaRankID == ea.eaRankID) {
                            isfound = true;
                            continue;
                        }
                        ea = ea.eaNextExtent;
                    }
                    if (!isfound) {
                        removedEAList = this.addToList(oldEA, removedEAList);
                    }
                    oldEA = oldEA.eaNextExtent;
                }
                ctlr = ctlr.ctlrNext;
            }
            eaAccessor.closeSelect();
        }
        ctlr = addedCtlrList;
        while (ctlr != null) {
            this.setExtAccessIDs(ctlr);
            addedEAList = this.concatLists(ctlr.ctlrExtents, addedEAList);
            ctlr = ctlr.ctlrNext;
        }
        if (addedEAList != null) {
            eaAccessor.insertExtCtrlr(addedEAList);
        }
        if (removedEAList != null) {
            eaAccessor.deleteExtAccess(removedEAList);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveCtlrDevAccess");
        }
    }

    private Controller addToList(Controller ctlr, Controller ctlrList) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"addToList", (String)"ctlr, ctlrList");
        }
        ctlr.ctlrNext = ctlrList;
        Controller traceResult = ctlrList = ctlr;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"addToList", (Object)traceResult);
        }
        return traceResult;
    }

    private Controller concatLists(Controller a, Controller b) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (String)"a, b");
        }
        if (a == null) {
            Controller traceResult = b;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
            }
            return traceResult;
        }
        if (b == null) {
            Controller traceResult = a;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
            }
            return traceResult;
        }
        Controller tail = a;
        while (tail.ctlrNext != null) {
            tail = tail.ctlrNext;
        }
        tail.ctlrNext = b;
        Controller traceResult = a;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
        }
        return traceResult;
    }

    private DevAccess addToList(DevAccess da, DevAccess daList) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"addToList", (String)"da, daList");
        }
        da.daNextDevice = daList;
        DevAccess traceResult = daList = da;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"addToList", (Object)traceResult);
        }
        return traceResult;
    }

    private ExtAccess addToList(ExtAccess ea, ExtAccess eaList) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"addToList", (String)"ea, eaList");
        }
        ea.eaNextExtent = eaList;
        ExtAccess traceResult = eaList = ea;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"addToList", (Object)traceResult);
        }
        return traceResult;
    }

    private DevAccess concatLists(DevAccess a, DevAccess b) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (String)"a, b");
        }
        if (a == null) {
            DevAccess traceResult = b;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
            }
            return traceResult;
        }
        if (b == null) {
            DevAccess traceResult = a;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
            }
            return traceResult;
        }
        DevAccess tail = a;
        while (tail.daNextDevice != null) {
            tail = tail.daNextDevice;
        }
        tail.daNextDevice = b;
        DevAccess traceResult = a;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
        }
        return traceResult;
    }

    private ExtAccess concatLists(ExtAccess ea_a, ExtAccess ea_b) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (String)"ea_a, ea_b");
        }
        if (ea_a == null) {
            ExtAccess traceResult = ea_b;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
            }
            return traceResult;
        }
        if (ea_b == null) {
            ExtAccess traceResult = ea_a;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
            }
            return traceResult;
        }
        ExtAccess tail = ea_a;
        while (tail.eaNextExtent != null) {
            tail = tail.eaNextExtent;
        }
        tail.eaNextExtent = ea_b;
        ExtAccess traceResult = ea_a;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
        }
        return traceResult;
    }

    private void setDevAccessIDs(Controller ctlr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"setDevAccessIDs", (String)"ctlr");
        }
        DevAccess da = ctlr.ctlrDevices;
        while (da != null) {
            da.daControllerID = ctlr.ctlrID;
            da.daDeviceID = da.daDevice.devID;
            da = da.daNextDevice;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"setDevAccessIDs");
        }
    }

    private void setExtAccessIDs(Controller ctlr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"setExtAccessIDs", (String)"ctlr");
        }
        ExtAccess ea = ctlr.ctlrExtents;
        while (ea != null) {
            ea.eaControllerID = ctlr.ctlrID;
            ea.eaRankID = ea.eaRank.rankID;
            ea = ea.eaNextExtent;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"setExtAccessIDs");
        }
    }

    private void lockDevices() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"lockDevices", (String)"");
        }
        int arraySize = 0;
        Device dev = this.computer.cmpDevice;
        while (dev != null) {
            if (dev.isFixedDisk()) {
                ++arraySize;
            }
            dev = dev.devNext;
        }
        Share sh = this.missingDeviceList;
        while (sh != null) {
            if (sh.shResource != null && (dev = (Device)sh.shResource).isFixedDisk()) {
                ++arraySize;
            }
            sh = sh.shNext;
        }
        this.lockedDeviceTable = new int[arraySize];
        int i = 0;
        dev = this.computer.cmpDevice;
        while (dev != null) {
            if (dev.isFixedDisk()) {
                this.lockedDeviceTable[i++] = dev.devID;
            }
            dev = dev.devNext;
        }
        Share sh2 = this.missingDeviceList;
        while (sh2 != null) {
            if (sh2.shResource != null && (dev = (Device)sh2.shResource).isFixedDisk()) {
                this.lockedDeviceTable[i++] = dev.devID;
            }
            sh2 = sh2.shNext;
        }
        Arrays.sort(this.lockedDeviceTable);
        LockManager.lock((short)0, (String)"History", (String)"DiskHist", (byte)2, (boolean)true);
        for (i = 0; i < arraySize; ++i) {
            int devID = this.lockedDeviceTable[i];
            LockManager.lock((short)0, (String)"Device", (String)String.valueOf(devID), (byte)1, (boolean)true);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"lockDevices");
        }
    }

    private void saveLogicalDisks() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveLogicalDisks", (String)"");
        }
        this.getPhysicalSpaceIDs();
        this.assignLogicalDiskIDs();
        this.saveLogicalDiskShares();
        this.saveNewLogicalDisks();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveLogicalDisks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLunWWNs() throws GeneralException {
        TResLunWWN lwAccessor = new TResLunWWN(this.dbc);
        try {
            lwAccessor.deleteByComputer(this.computer.cmpID);
            lwAccessor.prepInsert();
            LogicalDisk lDisk = this.computer.cmpLogicalDisk;
            while (lDisk != null) {
                lwAccessor.insert(this.computer.cmpID, lDisk);
                lDisk = lDisk.ldNext;
            }
        }
        finally {
            lwAccessor.closeDelete();
            lwAccessor.closeInsert();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveEntityWWPNs() throws GeneralException {
        TResEntityWWPN wwpnAccessor = new TResEntityWWPN(this.dbc);
        EntityWWPN removedWwpnList = null;
        String sWwpn = null;
        String oldsWwpn = null;
        boolean found = false;
        try {
            EntityWWPN wwpn;
            EntityWWPN oldWwpnList = wwpnAccessor.getEntityWWPNs(this.computer.cmpID);
            EntityWWPN wwpnHead = this.computer.cmpEntityWWPN;
            EntityWWPN oldWwpn = oldWwpnList;
            while (oldWwpn != null) {
                found = false;
                oldsWwpn = oldWwpn.sWWPN;
                EntityWWPN wwpnPrevious = wwpnHead;
                wwpn = wwpnHead;
                while (wwpn != null) {
                    sWwpn = wwpn.sWWPN;
                    if (oldsWwpn != null && sWwpn != null && oldsWwpn.equals(sWwpn)) {
                        found = true;
                        if (wwpn.equals(wwpnHead)) {
                            wwpn = wwpnHead = wwpnHead.entityWWPNNext;
                            wwpnPrevious = wwpnHead;
                            break;
                        }
                        wwpnPrevious.entityWWPNNext = wwpn.entityWWPNNext;
                        break;
                    }
                    wwpnPrevious = wwpn;
                    wwpn = wwpn.entityWWPNNext;
                }
                if (!found) {
                    oldWwpn.entityWWPNNext = removedWwpnList;
                    removedWwpnList = oldWwpn;
                }
                oldWwpn = oldWwpn.entityWWPNNext;
            }
            wwpn = removedWwpnList;
            while (wwpn != null) {
                wwpnAccessor.deleteByEntity_ID(this.computer.cmpID);
                wwpn = wwpn.entityWWPNNext;
            }
            wwpn = wwpnHead;
            while (wwpn != null) {
                if (this.computer.cmpOSType == 21) {
                    wwpnAccessor.insert(this.computer.cmpID, (byte)2, wwpn.sWWPN);
                } else {
                    wwpnAccessor.insert(this.computer.cmpID, (byte)1, wwpn.sWWPN);
                }
                wwpn = wwpn.entityWWPNNext;
            }
        }
        finally {
            wwpnAccessor.closeDelete();
            wwpnAccessor.closeInsert();
            wwpnAccessor.closeSelect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPhysicalSpaceIDs() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"getPhysicalSpaceIDs", (String)"");
        }
        try {
            this.chkAccessor.prepSelectByLocation();
            this.colAccessor.prepSelectByLogicalDisk();
            if (this.isDiskArray) {
                this.ldAccessor.prepSelectBySVID();
            } else {
                this.ldAccessor.prepSelectByID();
            }
            this.fsAccessor.prepSelectByMountPoint();
            LogicalDisk lDisk = this.computer.cmpLogicalDisk;
            while (lDisk != null) {
                if (lDisk.ldType != 7 && lDisk.ldType != 4) {
                    if (lDisk.ldNextMirror == null) {
                        if (!this.getLogicalDiskSpace(lDisk)) {
                            lDisk.ldNewLogicalDisk = true;
                        }
                    } else {
                        LogicalDisk mDisk = lDisk.ldNextMirror;
                        while (mDisk != null) {
                            if (!this.getLogicalDiskSpace(mDisk)) {
                                lDisk.ldNewLogicalDisk = true;
                                break;
                            }
                            mDisk = mDisk.ldNextMirror;
                        }
                    }
                    if (!lDisk.ldNewLogicalDisk && !this.getLogicalDisk(lDisk)) {
                        lDisk.ldNewLogicalDisk = true;
                    }
                }
                lDisk = lDisk.ldNext;
            }
        }
        finally {
            this.chkAccessor.closeSelect();
            this.colAccessor.closeSelect();
            this.ldAccessor.closeSelect();
            this.fsAccessor.closeSelect();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getPhysicalSpaceIDs");
        }
    }

    private boolean getLogicalDiskSpace(LogicalDisk lDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"getLogicalDiskSpace", (String)"lDisk");
        }
        lDisk.ldID = -1;
        if (lDisk.ldCollectionList == null) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getLogicalDiskSpace", (boolean)traceResult);
            }
            return traceResult;
        }
        ChunkCollection probeCollection = lDisk.ldCollectionList;
        while (probeCollection != null) {
            Chunk probeChunk = probeCollection.ccChunkList;
            Chunk repoChunk = this.chkAccessor.getChunksByLocation(probeChunk);
            while (probeChunk != null && repoChunk != null) {
                if (!probeChunk.equals((Object)repoChunk)) {
                    boolean traceResult = false;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getLogicalDiskSpace", (boolean)traceResult);
                    }
                    return traceResult;
                }
                probeChunk.chkCollectionID = repoChunk.chkCollectionID;
                probeChunk.chkLogicalDiskID = repoChunk.chkLogicalDiskID;
                probeChunk = probeChunk.chkNextInCollection;
                repoChunk = repoChunk.chkNextInCollection;
            }
            if (probeChunk != null || repoChunk != null) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getLogicalDiskSpace", (boolean)traceResult);
                }
                return traceResult;
            }
            probeChunk = probeCollection.ccChunkList;
            if (lDisk.ldID == -1) {
                lDisk.ldID = probeChunk.chkLogicalDiskID;
            } else if (lDisk.ldID != probeChunk.chkLogicalDiskID) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getLogicalDiskSpace", (boolean)traceResult);
                }
                return traceResult;
            }
            probeCollection.ccID = probeChunk.chkCollectionID;
            probeCollection.ccLogicalDiskID = probeChunk.chkLogicalDiskID;
            probeCollection = probeCollection.ccNext;
        }
        ChunkCollection repoCollection = this.colAccessor.getCollections(lDisk);
        if (repoCollection == null) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getLogicalDiskSpace", (boolean)traceResult);
            }
            return traceResult;
        }
        while (repoCollection != null) {
            int repoCcID = repoCollection.ccID;
            probeCollection = lDisk.ldCollectionList;
            while (probeCollection != null && probeCollection.ccID != repoCcID) {
                probeCollection = probeCollection.ccNext;
            }
            if (probeCollection == null) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getLogicalDiskSpace", (boolean)traceResult);
                }
                return traceResult;
            }
            if (probeCollection.ccType != repoCollection.ccType || probeCollection.ccStripingSize != repoCollection.ccStripingSize) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getLogicalDiskSpace", (boolean)traceResult);
                }
                return traceResult;
            }
            repoCollection = repoCollection.ccNext;
        }
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getLogicalDiskSpace", (boolean)traceResult);
        }
        return traceResult;
    }

    private boolean getLogicalDisk(LogicalDisk primaryLDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"getLogicalDisk", (String)"primaryLDisk");
        }
        boolean firstMirror = true;
        LogicalDisk probeLDisk = primaryLDisk.ldNextMirror;
        while (probeLDisk != null) {
            if (!this.cmpLDiskToRepository(probeLDisk)) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getLogicalDisk", (boolean)traceResult);
                }
                return traceResult;
            }
            if (firstMirror) {
                firstMirror = false;
                primaryLDisk.ldID = this.lDiskBuffer.ldParentLogicalDiskID;
            } else if (primaryLDisk.ldID != this.lDiskBuffer.ldParentLogicalDiskID) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getLogicalDisk", (boolean)traceResult);
                }
                return traceResult;
            }
            probeLDisk = probeLDisk.ldNextMirror;
        }
        boolean traceResult = this.cmpLDiskToRepository(primaryLDisk);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getLogicalDisk", (boolean)traceResult);
        }
        return traceResult;
    }

    private boolean cmpLDiskToRepository(LogicalDisk probeLDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"cmpLDiskToRepository", (String)"probeLDisk");
        }
        this.lDiskBuffer.ldID = probeLDisk.ldID;
        if (this.ldAccessor.getLogicalDisk(this.lDiskBuffer, false) && probeLDisk.equals((Object)this.lDiskBuffer)) {
            probeLDisk.ldUseCount = this.lDiskBuffer.ldUseCount;
            probeLDisk.ldSnapSourceID = this.lDiskBuffer.ldSnapSourceID;
            probeLDisk.ldOldFlags = this.lDiskBuffer.getFlags();
            probeLDisk.ldOldVolgroupID = this.lDiskBuffer.ldVolgroupID;
            boolean traceResult = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"cmpLDiskToRepository", (boolean)traceResult);
            }
            return traceResult;
        }
        boolean traceResult = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"cmpLDiskToRepository", (boolean)traceResult);
        }
        return traceResult;
    }

    private void assignLogicalDiskIDs() throws GeneralException {
        LogicalDisk mDisk;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"assignLogicalDiskIDs", (String)"");
        }
        int identifier = 0;
        LogicalDisk lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null) {
            if (lDisk.ldNewLogicalDisk) {
                identifier += this.countResources(lDisk);
                mDisk = lDisk.ldNextMirror;
                while (mDisk != null) {
                    identifier += this.countResources(mDisk);
                    mDisk = mDisk.ldNextMirror;
                }
            }
            lDisk = lDisk.ldNext;
        }
        if (identifier > 0) {
            identifier = TResLogicalDisk.getIdentifier(1, identifier, this.dbc);
            lDisk = this.computer.cmpLogicalDisk;
            while (lDisk != null) {
                if (lDisk.ldNewLogicalDisk) {
                    identifier = this.setIDs(lDisk, identifier);
                    mDisk = lDisk.ldNextMirror;
                    while (mDisk != null) {
                        identifier = this.setIDs(mDisk, identifier);
                        mDisk.ldParentLogicalDiskID = lDisk.ldID;
                        mDisk = mDisk.ldNextMirror;
                    }
                }
                lDisk = lDisk.ldNext;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"assignLogicalDiskIDs");
        }
    }

    private int countResources(LogicalDisk lDisk) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"countResources", (String)"lDisk");
        }
        int resourceCount = 1;
        ChunkCollection collection = lDisk.ldCollectionList;
        while (collection != null) {
            ++resourceCount;
            collection = collection.ccNext;
        }
        int traceResult = resourceCount;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"countResources", (int)traceResult);
        }
        return traceResult;
    }

    private int setIDs(LogicalDisk lDisk, int identifier) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"setIDs", (String)"lDisk, identifier");
        }
        lDisk.ldID = identifier++;
        lDisk.ldParentLogicalDiskID = -1;
        ChunkCollection collection = lDisk.ldCollectionList;
        while (collection != null) {
            collection.ccLogicalDiskID = lDisk.ldType == 12 ? -1 : lDisk.ldID;
            collection.ccID = identifier++;
            Chunk chunk = collection.ccChunkList;
            while (chunk != null) {
                chunk.chkLogicalDiskID = lDisk.ldType == 12 ? -1 : lDisk.ldID;
                chunk.chkCollectionID = collection.ccID;
                chunk = chunk.chkNextInCollection;
            }
            collection = collection.ccNext;
        }
        int traceResult = identifier;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"setIDs", (int)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLogicalDiskShares() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveLogicalDiskShares", (String)"");
        }
        this.shareBuffer.shResourceType = (short)11;
        this.shareBuffer.shComputerID = this.computer.cmpID;
        this.shareBuffer.shScanTime = this.probeTime;
        this.shareBuffer.shRemovedTime = 0L;
        MutableBoolean prepared = new MutableBoolean(false);
        try {
            this.shAccessor.prepSave();
            LogicalDisk lDisk = this.computer.cmpLogicalDisk;
            while (lDisk != null) {
                if (lDisk.ldType != 7 && lDisk.ldType != 4) {
                    this.saveLogicalDiskShare(lDisk, prepared);
                    LogicalDisk mDisk = lDisk.ldNextMirror;
                    while (mDisk != null) {
                        this.saveLogicalDiskShare(mDisk, prepared);
                        mDisk = mDisk.ldNextMirror;
                    }
                }
                lDisk = lDisk.ldNext;
            }
        }
        finally {
            this.shAccessor.closeSave();
            if (prepared.value) {
                this.ldAccessor.closeUpdate();
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveLogicalDiskShares");
        }
    }

    private void saveLogicalDiskShare(LogicalDisk lDisk, MutableBoolean prepared) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveLogicalDiskShare", (String)"lDisk, prepared");
        }
        this.shareBuffer.shResourceID = lDisk.ldID;
        this.shareBuffer.shPath = lDisk.ldPath;
        this.shareBuffer.shName = lDisk.ldName;
        boolean shareAdded = this.shAccessor.saveShare(this.shareBuffer, lDisk.ldNewLogicalDisk);
        if (lDisk.ldNewLogicalDisk) {
            lDisk.setSnapSourceID();
        } else {
            boolean doUpdate;
            int oldSnapSourceID = lDisk.ldSnapSourceID;
            lDisk.setSnapSourceID();
            if (shareAdded) {
                lDisk.ldUseCount = (short)(lDisk.ldUseCount + 1);
                doUpdate = true;
            } else {
                boolean bl = doUpdate = lDisk.getFlags() != lDisk.ldOldFlags || lDisk.ldSnapSourceID != oldSnapSourceID || lDisk.ldVolgroupID != lDisk.ldOldVolgroupID;
            }
            if (doUpdate) {
                if (!prepared.value) {
                    if (this.isDiskArray) {
                        this.ldAccessor.prepUpdateSVAttributes();
                    } else {
                        this.ldAccessor.prepUpdateAttributes();
                    }
                    prepared.value = true;
                }
                this.ldAccessor.updateAttributes(lDisk);
            }
        }
        this.shAccessor.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveLogicalDiskShare");
        }
    }

    private void saveNewLogicalDisks() throws GeneralException {
        LogicalDisk mDisk;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveNewLogicalDisks", (String)"");
        }
        HashSet<ChunkCollection> lastCC = new HashSet<ChunkCollection>();
        if (this.isDiskArray) {
            this.ldAccessor.prepInsertSV();
        } else {
            this.ldAccessor.prepInsert();
        }
        LogicalDisk lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null) {
            if (lDisk.ldNewLogicalDisk) {
                lDisk.ldUseCount = 1;
                this.ldAccessor.insertLogicalDisks(lDisk);
            }
            lDisk = lDisk.ldNext;
        }
        this.ldAccessor.closeInsert();
        this.colAccessor.prepInsert();
        lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null) {
            if (lDisk.ldNewLogicalDisk) {
                if (lDisk.ldCollectionList != null) {
                    if (!lastCC.contains(lDisk.ldCollectionList)) {
                        this.colAccessor.insertCollections(lDisk.ldCollectionList);
                        lastCC.add(lDisk.ldCollectionList);
                    }
                    if (lDisk.ldType == 12) {
                        this.colAccessor.insertAggregates(lDisk.ldID, lDisk.ldCollectionList.ccID);
                    }
                }
                mDisk = lDisk.ldNextMirror;
                while (mDisk != null) {
                    this.colAccessor.insertCollections(mDisk.ldCollectionList);
                    mDisk = mDisk.ldNextMirror;
                }
            }
            lDisk = lDisk.ldNext;
        }
        this.colAccessor.closeInsert();
        this.chkAccessor.prepSave();
        lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null) {
            if (lDisk.ldNewLogicalDisk) {
                this.saveChunks(lDisk.ldCollectionList);
                mDisk = lDisk.ldNextMirror;
                while (mDisk != null) {
                    this.saveChunks(mDisk.ldCollectionList);
                    mDisk = mDisk.ldNextMirror;
                }
            }
            lDisk = lDisk.ldNext;
        }
        this.chkAccessor.closeSave();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveNewLogicalDisks");
        }
    }

    private void saveChunks(ChunkCollection collection) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveChunks", (String)"collection");
        }
        while (collection != null) {
            this.chkAccessor.saveChunks(collection.ccChunkList, true, true);
            collection = collection.ccNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveChunks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeObsoleteLogicalDisks() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"removeObsoleteLogicalDisks", (String)"");
        }
        if (this.isDiskArray) {
            this.updateTStatDisk();
        }
        LogicalDisk lDisk = null;
        Share shList = this.shAccessor.getRemovedResources(this.computer.cmpID, (short)11, this.probeTime);
        if (shList == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeObsoleteLogicalDisks");
            }
            return;
        }
        if (this.isDiskArray) {
            this.ldAccessor.prepSelectBySVID();
        } else {
            this.ldAccessor.prepSelectByID();
        }
        Share sh = shList;
        while (sh != null) {
            if (lDisk == null) {
                lDisk = new LogicalDisk();
            }
            lDisk.ldID = sh.shResourceID;
            if (this.ldAccessor.getLogicalDisk(lDisk, false)) {
                // empty if block
            }
            sh.shResource = lDisk;
            lDisk = null;
            sh = sh.shNext;
        }
        this.ldAccessor.closeSelect();
        this.chkAccessor.prepDeleteByLogicalDisk();
        this.deleteLogicalDiskDependents(this.chkAccessor, shList);
        this.chkAccessor.closeDelete();
        this.colAccessor.prepDeleteByLogicalDisk();
        this.deleteLogicalDiskDependents(this.colAccessor, shList);
        this.colAccessor.closeDelete();
        if (this.isDiskArray) {
            this.ldAccessor.prepDeleteSV();
        } else {
            this.ldAccessor.prepDeleteLogicalDisk();
        }
        sh = shList;
        while (sh != null) {
            if (sh.shResource != null) {
                lDisk = (LogicalDisk)sh.shResource;
                if (lDisk.ldUseCount <= 1 && lDisk.ldParentLogicalDiskID == -1) {
                    this.ldAccessor.deleteLogicalDisk(lDisk);
                }
            }
            sh = sh.shNext;
        }
        this.ldAccessor.closeDelete();
        try {
            if (this.isDiskArray) {
                this.ldAccessor.prepUpdateSVUseCount();
            } else {
                this.ldAccessor.prepUpdateUseCount();
            }
            this.shAccessor.prepDelete();
            sh = shList;
            while (sh != null) {
                if (sh.shResource != null) {
                    lDisk = (LogicalDisk)sh.shResource;
                    if (lDisk.ldUseCount > 1) {
                        lDisk.ldUseCount = (short)(lDisk.ldUseCount - 1);
                        this.ldAccessor.updateUseCount(lDisk);
                    }
                }
                this.shAccessor.deleteShare(sh);
                sh = sh.shNext;
            }
        }
        finally {
            this.ldAccessor.closeUpdate();
            this.shAccessor.closeDelete();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeObsoleteLogicalDisks");
        }
    }

    private void deleteLogicalDiskDependents(StorageRepositoryAccessor repoAccessor, Share shList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"deleteLogicalDiskDependents", (String)"repoAccessor, shList");
        }
        Share sh = shList;
        while (sh != null) {
            if (sh.shResource != null) {
                LogicalDisk lDisk = (LogicalDisk)sh.shResource;
                if (lDisk.ldUseCount <= 1) {
                    if (lDisk.ldNextMirror == null) {
                        repoAccessor.deleteByLogicalDisk(lDisk);
                    } else {
                        LogicalDisk mDisk = lDisk.ldNextMirror;
                        while (mDisk != null) {
                            repoAccessor.deleteByLogicalDisk(lDisk);
                            mDisk = mDisk.ldNextMirror;
                        }
                    }
                }
            }
            sh = sh.shNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"deleteLogicalDiskDependents");
        }
    }

    private void updateTStatDisk() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"updateTStatDisk", (String)"");
        }
        HashMap<String, LogicalDisk> currentMap = new HashMap<String, LogicalDisk>();
        LogicalDisk ld = this.computer.cmpLogicalDisk;
        while (ld != null) {
            String lunName = ld.ldPath;
            if (this.computer.cmpOSType == 21) {
                int i = ld.ldPath.indexOf(":");
                if (i > 0) {
                    lunName = ld.ldPath.substring(i + 1);
                }
            } else if (this.computer.cmpOSType == 15) {
                lunName = ld.ldPath.substring(8);
            } else if (this.computer.cmpOSType == 14) {
                lunName = ld.ldTruePath;
            }
            currentMap.put(lunName, ld);
            ld = ld.ldNext;
        }
        TStatDisk accessor = new TStatDisk(this.dbc);
        NameList hostLUNs = accessor.selectHostLUNs(this.computer);
        accessor = null;
        while (hostLUNs != null) {
            ld = (LogicalDisk)currentMap.get(hostLUNs.nlName);
            int shouldBe = ld != null ? ld.ldID : -1;
            if (hostLUNs.nlID2 != shouldBe) {
                if (accessor == null) {
                    accessor = new TStatDisk(this.dbc);
                    accessor.prepUpdateLogicalDiskID();
                }
                accessor.updateLogicalDiskID(hostLUNs.nlID, shouldBe, true);
            }
            hostLUNs = hostLUNs.nlNext;
        }
        if (accessor != null) {
            accessor.closeUpdate();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"updateTStatDisk");
        }
    }

    private void saveFilesystems() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveFilesystems", (String)"");
        }
        this.getRepoFilesystems();
        this.relocateFilesystems();
        if (this.isVirtualServer) {
            this.resetScanComputer(this.computer.cmpLogicalDisk, this.computer.cmpID, this.computer.cmpNodeHostedID);
        }
        this.assignFilesystemIDs();
        this.updateFilesystemStats();
        this.saveNewFilesystems();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveFilesystems");
        }
    }

    private void getRepoFilesystems() throws GeneralException {
        Filesystem fs;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"getRepoFilesystems", (String)"");
        }
        this.fsAccessor.prepSelectByLogicalDisk();
        LogicalDisk lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null) {
            if (lDisk.ldFilesystem != null) {
                fs = lDisk.ldFilesystem;
                fs.fsID = -1;
                fs.fsLogDiskID = fs.fsLogDisk != null ? fs.fsLogDisk.ldID : -1;
                if (!lDisk.ldNewLogicalDisk && lDisk.ldRepoFilesystem == null && lDisk.ldID != 0) {
                    lDisk.ldRepoFilesystem = this.fsAccessor.getByLogicalDisk(lDisk.ldID);
                }
            }
            lDisk = lDisk.ldNext;
        }
        this.fsAccessor.closeSelect();
        this.fsAccessor.prepSelectByMountPoint();
        lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null) {
            if (lDisk.ldFilesystem != null) {
                fs = lDisk.ldFilesystem;
                Filesystem repoFS = lDisk.ldRepoFilesystem;
                if (repoFS == null || !repoFS.fsMountPoint.equals(fs.fsMountPoint) && repoFS.fsUseCount <= 1 && repoFS.fsComputerID == this.computer.cmpID) {
                    long savedFSCapacity = fs.fsCapacity;
                    fs.fsComputerID = this.computer.cmpID;
                    this.fsAccessor.getByMountPoint(fs);
                    fs.fsCapacity = savedFSCapacity;
                } else {
                    fs.fsID = repoFS.fsID;
                    fs.fsLogicalDiskID = lDisk.ldID;
                    fs.fsComputerID = repoFS.fsComputerID;
                    fs.fsUseCount = repoFS.fsUseCount;
                }
            }
            lDisk = lDisk.ldNext;
        }
        this.fsAccessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"getRepoFilesystems");
        }
    }

    private void relocateFilesystems() throws GeneralException {
        Filesystem fs;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"relocateFilesystems", (String)"");
        }
        boolean updatePrepared = false;
        LogicalDisk lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null) {
            if (lDisk.ldRepoFilesystem != null) {
                fs = lDisk.ldFilesystem;
                Filesystem repoFS = lDisk.ldRepoFilesystem;
                if (repoFS.fsUseCount <= 1 && repoFS.fsComputerID == this.computer.cmpID && !fs.fsMountPoint.equals(repoFS.fsMountPoint)) {
                    if (!updatePrepared) {
                        this.fsAccessor.prepUpdateLogicalDisk();
                        updatePrepared = true;
                    }
                    repoFS.fsLogicalDiskID = -1;
                    this.fsAccessor.updateLogicalDisk(repoFS);
                }
            }
            lDisk = lDisk.ldNext;
        }
        lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null) {
            if (lDisk.ldFilesystem != null && lDisk.ldFilesystem.fsID != -1) {
                fs = lDisk.ldFilesystem;
                if (fs.fsLogicalDiskID != lDisk.ldID) {
                    if (fs.fsUseCount <= 1 && fs.fsComputerID == this.computer.cmpID) {
                        if (!updatePrepared) {
                            this.fsAccessor.prepUpdateLogicalDisk();
                            updatePrepared = true;
                        }
                        fs.fsLogicalDiskID = lDisk.ldID;
                        this.fsAccessor.updateLogicalDisk(fs);
                    } else {
                        fs.fsID = -1;
                    }
                }
            }
            lDisk = lDisk.ldNext;
        }
        if (updatePrepared) {
            this.fsAccessor.closeUpdate();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"relocateFilesystems");
        }
    }

    private void assignFilesystemIDs() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"assignFilesystemIDs", (String)"");
        }
        int identifier = 0;
        LogicalDisk lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null) {
            if (lDisk.ldFilesystem != null && lDisk.ldFilesystem.fsID == -1) {
                lDisk.ldFilesystem.fsNewFilesystem = true;
                ++identifier;
            }
            lDisk = lDisk.ldNext;
        }
        if (identifier > 0) {
            if (Constants.isNasBox((short)this.computer.cmpOSType)) {
                TFoundFilesystem foundFsAccessor = new TFoundFilesystem(this.dbc);
                if (foundFsAccessor.getIDsForProbe(this.computer)) {
                    this.updateScheduler = true;
                }
            } else {
                identifier = TResFS.getIdentifier(1, identifier, this.dbc);
                lDisk = this.computer.cmpLogicalDisk;
                while (lDisk != null) {
                    if (lDisk.ldFilesystem != null && lDisk.ldFilesystem.fsID == -1) {
                        lDisk.ldFilesystem.fsID = identifier++;
                    }
                    lDisk = lDisk.ldNext;
                }
                this.updateScheduler = true;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"assignFilesystemIDs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilesystemStats() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"updateFilesystemStats", (String)"");
        }
        this.shareBuffer.shScanTime = this.probeTime;
        this.shareBuffer.shRemovedTime = 0L;
        boolean setExportName = false;
        LogicalDisk lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null) {
            if (lDisk.ldFilesystem != null) {
                setExportName = lDisk.ldFilesystem.fsExportName != null;
                break;
            }
            lDisk = lDisk.ldNext;
        }
        try {
            this.fsAccessor.prepProbeUpdate(setExportName);
            this.fsAccessor.prepUpdateUseCount();
            this.shAccessor.prepSave();
            this.shareBuffer.shComputerID = this.computer.cmpID;
            this.shareBuffer.shResourceType = (short)3;
            this.shareBuffer.shPath = " ";
            lDisk = this.computer.cmpLogicalDisk;
            while (lDisk != null) {
                if (lDisk.ldFilesystem != null) {
                    Filesystem fs = lDisk.ldFilesystem;
                    this.shareBuffer.shResourceID = fs.fsID;
                    boolean shareAdded = this.shAccessor.saveShare(this.shareBuffer, fs.fsNewFilesystem);
                    if (!fs.fsNewFilesystem) {
                        if (shareAdded && !Constants.isNasBox((short)this.computer.cmpOSType)) {
                            fs.fsUseCount = (short)(fs.fsUseCount + 1);
                            this.fsAccessor.updateUseCount(fs);
                        }
                        if (!this.fsAccessor.probeUpdate(fs)) {
                            fs.fsNewFilesystem = true;
                        }
                    }
                    this.shAccessor.commit();
                }
                lDisk = lDisk.ldNext;
            }
        }
        finally {
            this.fsAccessor.closeUpdate();
            this.shAccessor.closeSave();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"updateFilesystemStats");
        }
    }

    private void saveNewFilesystems() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveNewFilesystems", (String)"");
        }
        this.fsAccessor.prepInsert();
        LogicalDisk lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null) {
            if (lDisk.ldFilesystem != null && lDisk.ldFilesystem.fsNewFilesystem) {
                Filesystem fs = lDisk.ldFilesystem;
                fs.fsLogicalDiskID = lDisk.ldID;
                fs.fsComputerID = this.computer.cmpID;
                if (!Constants.isNasBox((short)this.computer.cmpOSType) && !Constants.isVirtualServer((int)this.computer.cmpOSType)) {
                    fs.fsScanningCompID = this.computer.cmpID;
                }
                fs.fsGroupID = 3;
                fs.fsUseCount = 1;
                fs.fsScanTime = 0L;
                this.fsAccessor.insert(fs);
            }
            lDisk = lDisk.ldNext;
        }
        this.fsAccessor.closeInsert();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveNewFilesystems");
        }
    }

    private void saveFSHist() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveFSHist", (String)"");
        }
        LogicalDisk lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null && lDisk.ldFilesystem == null) {
            lDisk = lDisk.ldNext;
        }
        if (lDisk == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveFSHist");
            }
            return;
        }
        TStatSpaceHist histAccessor = new TStatSpaceHist(this.dbc);
        long lastHistoryTime = histAccessor.getMaxFsHistTime(lDisk.ldFilesystem.fsID, (byte)0);
        long timeSinceLastHistory = this.probeTime - lastHistoryTime;
        if (timeSinceLastHistory >= 86400000L) {
            CuStatDef statDef = new CuStatDef();
            statDef.sdDailyRetention = this.settings.seFSDailyHist;
            statDef.sdWeeklyRetention = this.settings.seFSWeeklyHist;
            statDef.sdMonthlyRetention = this.settings.seFSMonthlyHist;
            SSummaryHist hist = new SSummaryHist();
            hist.sumStatisticID = 1;
            hist.sumFileCount = -1L;
            histAccessor.prepFSHistSave();
            lDisk = this.computer.cmpLogicalDisk;
            while (lDisk != null) {
                Filesystem fs = lDisk.ldFilesystem;
                if (fs != null) {
                    hist.sumFilesystemID = fs.fsID;
                    hist.sumScanTime = this.probeTime;
                    hist.sumTotalSize = fs.fsCapacity;
                    hist.sumFreeSpace = fs.fsFreeSpace;
                    hist.sumUsedSpace = fs.fsUsedSpace;
                    histAccessor.saveHist(statDef, hist);
                }
                lDisk = lDisk.ldNext;
            }
            histAccessor.closeHistSave();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveFSHist");
        }
    }

    private void gatherObsoleteFilesystems() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"gatherObsoleteFilesystems", (String)"");
        }
        long removeMillis = (long)this.settings.seKeepRemovedFS * 86400000L;
        long removeTime = this.probeTime - removeMillis;
        this.removeFSList = null;
        Share flagShList = null;
        Share shList = this.shAccessor.getRemovedResources(this.computer.cmpID, (short)3, this.probeTime);
        if (shList == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"gatherObsoleteFilesystems");
            }
            return;
        }
        this.fsAccessor.prepSelectByID();
        Share sh = shList;
        while (sh != null) {
            sh.shResource = this.fsAccessor.getByID(sh.shResourceID);
            sh = sh.shNext;
        }
        this.fsAccessor.closeSelect();
        while (shList != null) {
            sh = shList;
            shList = sh.shNext;
            if (sh.shRemovedTime <= 86400000L) {
                sh.shRemovedTime = this.probeTime;
            }
            if (sh.shResource == null || sh.shRemovedTime < removeTime || this.fsWasRelocated((Filesystem)sh.shResource) || this.isDelete) {
                sh.shNext = this.removeFSList;
                this.removeFSList = sh;
                continue;
            }
            if (sh.shRemovedTime == this.probeTime) {
                sh.shNext = flagShList;
                flagShList = sh;
                continue;
            }
            sh.shNext = this.missingFSList;
            this.missingFSList = sh;
        }
        if (flagShList != null) {
            this.flagMissingFilesystems(flagShList);
        }
        this.missingFSList = flagShList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"gatherObsoleteFilesystems");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flagMissingFilesystems(Share flagShList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"flagMissingFilesystems", (String)"flagShList");
        }
        try {
            this.shAccessor.prepUpdate();
            this.fsAccessor.prepUpdateLogicalDisk();
            Share sh = flagShList;
            while (sh != null) {
                this.shAccessor.updateShare(sh);
                if (sh.shResource != null) {
                    Filesystem fs = (Filesystem)sh.shResource;
                    int useCount = this.ldAccessor.getUseCount(fs.fsLogicalDiskID);
                    if (useCount <= 1 && fs.fsComputerID == this.computer.cmpID) {
                        fs.fsLogicalDiskID = -1;
                        this.fsAccessor.updateLogicalDisk(fs);
                    }
                }
                sh = sh.shNext;
            }
        }
        finally {
            this.shAccessor.cleanup();
            this.fsAccessor.closeUpdate();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"flagMissingFilesystems");
        }
    }

    private void removeObsoleteFilesystems() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"removeObsoleteFilesystems", (String)"");
        }
        if (this.removeFSList == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeObsoleteFilesystems");
            }
            return;
        }
        this.resetScanComputer(this.removeFSList);
        this.removeFilesystems(this.removeFSList);
        this.updateScheduler = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeObsoleteFilesystems");
        }
    }

    private void analyzeAlerts() throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"analyzeAlerts", (String)"");
        }
        ProbeAlerter alerter = new ProbeAlerter(this.dbc, this.oldComputer, this.computer, this.missingDeviceList, this.missingFSList);
        alerter.alert();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"analyzeAlerts");
        }
    }

    private boolean fsWasRelocated(Filesystem fs) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"fsWasRelocated", (String)"fs");
        }
        LogicalDisk lDisk = this.computer.cmpLogicalDisk;
        while (lDisk != null) {
            if (lDisk.ldFilesystem != null && fs.fsMountPoint.equals(lDisk.ldFilesystem.fsMountPoint)) {
                boolean traceResult = true;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"fsWasRelocated", (boolean)traceResult);
                }
                return traceResult;
            }
            lDisk = lDisk.ldNext;
        }
        boolean traceResult = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"fsWasRelocated", (boolean)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetScanComputer(LogicalDisk pLD, int hostComputer, int newScanningCID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"resetScanComputer", (String)"pLD, hostComputer, newScanningCID");
        }
        this.fsAccessor.prepSelectScanningCompID();
        this.fsAccessor.prepUpdateScanComputer();
        try {
            LogicalDisk ld = pLD;
            while (ld != null) {
                int currFSID = ld.ldFilesystem.fsID;
                int repoScanningCID = this.fsAccessor.selectScanningCompID(currFSID);
                if (newScanningCID != repoScanningCID) {
                    this.fsAccessor.updateScanComputer(hostComputer, newScanningCID, currFSID);
                    this.updateScheduler = true;
                }
                ld = ld.ldNext;
            }
        }
        catch (LocalizableException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ProbeResultsHndlr.class.getName(), (String)"resetScanComputer", (Throwable)e);
            }
            e.print();
        }
        finally {
            this.fsAccessor.closeUpdate();
            this.fsAccessor.closeSelect();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"resetScanComputer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetScanComputer(Share shList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"resetScanComputer", (String)"shList");
        }
        boolean transferPrepared = false;
        try {
            Share sh = shList;
            while (sh != null) {
                if (sh.shResource != null) {
                    Filesystem fs = (Filesystem)sh.shResource;
                    if (fs.fsUseCount > 1 && fs.fsComputerID == this.computer.cmpID) {
                        Share shComputer;
                        if (!transferPrepared) {
                            transferPrepared = true;
                            this.shAccessor.prepGetAnotherComputer();
                            this.fsAccessor.prepUpdateScanComputer();
                        }
                        if ((shComputer = this.shAccessor.getAnotherComputer(fs.fsID, (short)3, fs.fsComputerID)) != null) {
                            fs.fsComputerID = shComputer.shComputerID;
                            this.fsAccessor.updateScanComputer(fs);
                            this.updateScheduler = true;
                        } else {
                            fs.fsUseCount = 1;
                        }
                    }
                }
                sh = sh.shNext;
            }
        }
        finally {
            if (transferPrepared) {
                this.shAccessor.closeSelect();
                this.fsAccessor.closeUpdate();
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"resetScanComputer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFilesystems(Share shList) throws GeneralException {
        Filesystem fs;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"removeFilesystems", (String)"shList");
        }
        Filesystem fsRemoveList = null;
        Object defaultFS = null;
        Object deleteList = null;
        Share sh = shList;
        while (sh != null) {
            if (sh.shResource != null) {
                fs = (Filesystem)sh.shResource;
                if (fs.fsUseCount <= 1) {
                    fs.fsNext = fsRemoveList;
                    fsRemoveList = fs;
                }
            }
            sh = sh.shNext;
        }
        this.shAccessor.closeSelect();
        try {
            this.shAccessor.prepDelete();
            if (fsRemoveList != null) {
                this.fsAccessor.deleteFS(fsRemoveList, true);
            }
            this.fsAccessor.prepUpdateUseCount();
            sh = shList;
            while (sh != null) {
                if (sh.shResource != null) {
                    fs = (Filesystem)sh.shResource;
                    if (fs.fsUseCount > 1) {
                        fs.fsUseCount = (short)(fs.fsUseCount - 1);
                        this.fsAccessor.updateUseCount(fs);
                    }
                }
                this.shAccessor.deleteShare(sh);
                sh = sh.shNext;
            }
        }
        finally {
            this.shAccessor.closeDelete();
            this.fsAccessor.closeUpdate();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeFilesystems");
        }
    }

    private void saveExports() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveExports", (String)"");
        }
        Export deleteExportList = null;
        Export insertExportList = null;
        Export updateExportList = null;
        TResExport expAccessor = new TResExport(this.dbc);
        byte protocol = -1;
        if (Constants.isNasBox((short)this.computer.cmpOSType) && this.computer.cmpExport != null) {
            protocol = this.computer.cmpExport.xpProtocol;
        }
        Export repoExportList = expAccessor.selectByComputer(this.computer.cmpID, protocol);
        while (repoExportList != null && this.computer.cmpExport != null) {
            Export repoExport = repoExportList;
            Export probeExport = this.computer.cmpExport;
            int cmp = probeExport.xpExportName.compareTo(repoExport.xpExportName);
            if (cmp < 0) {
                this.computer.cmpExport = probeExport.xpNext;
                insertExportList = this.addToList(probeExport, insertExportList);
                continue;
            }
            if (cmp > 0) {
                repoExportList = repoExport.xpNext;
                deleteExportList = this.addToList(repoExport, deleteExportList);
                continue;
            }
            this.computer.cmpExport = probeExport.xpNext;
            repoExportList = repoExport.xpNext;
            if (probeExport.xpProtocol == repoExport.xpProtocol && probeExport.xpPath.equals(repoExport.xpPath)) continue;
            probeExport.xpExportID = repoExport.xpExportID;
            updateExportList = this.addToList(probeExport, updateExportList);
        }
        insertExportList = this.concatLists(this.computer.cmpExport, insertExportList);
        deleteExportList = this.concatLists(repoExportList, deleteExportList);
        if (Constants.isVirtualServer((int)this.computer.cmpOSType)) {
            Export exp = insertExportList;
            while (exp != null) {
                exp.xpComputerID = this.computer.cmpID;
                exp = exp.xpNext;
            }
            exp = updateExportList;
            while (exp != null) {
                exp.xpComputerID = this.computer.cmpID;
                exp = exp.xpNext;
            }
        }
        expAccessor.delete(deleteExportList);
        expAccessor.update(updateExportList);
        expAccessor.insert(insertExportList);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveExports");
        }
    }

    private Export addToList(Export export, Export exportList) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"addToList", (String)"export, exportList");
        }
        export.xpNext = exportList;
        Export traceResult = exportList = export;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"addToList", (Object)traceResult);
        }
        return traceResult;
    }

    private Export concatLists(Export a, Export b) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (String)"a, b");
        }
        if (a == null) {
            Export traceResult = b;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
            }
            return traceResult;
        }
        if (b == null) {
            Export traceResult = a;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
            }
            return traceResult;
        }
        Export tail = a;
        while (tail.xpNext != null) {
            tail = tail.xpNext;
        }
        tail.xpNext = b;
        Export traceResult = a;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"concatLists", (Object)traceResult);
        }
        return traceResult;
    }

    private void saveLdapTrees() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveLdapTrees", (String)"");
        }
        if (this.computer.cmpLdapTree != null) {
            TResLdapTree ltAccessor = new TResLdapTree(this.dbc);
            ltAccessor.save(this.computer.cmpLdapTree);
            ltAccessor = null;
            this.shareBuffer.shResourceType = (short)66;
            this.shareBuffer.shComputerID = this.computer.cmpID;
            this.shareBuffer.shScanTime = this.probeTime;
            this.shareBuffer.shRemovedTime = 0L;
            this.shareBuffer.shPath = " ";
            this.shAccessor = new TResShare(this.dbc);
            this.shAccessor.prepSave();
            LdapTree tree = this.computer.cmpLdapTree;
            while (tree != null) {
                this.shareBuffer.shResource = tree;
                this.shareBuffer.shResourceID = tree.ltTreeID;
                this.shAccessor.saveShare(this.shareBuffer, false);
                this.shAccessor.commit();
                tree = tree.ltNext;
            }
            this.shAccessor.closeSave();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveLdapTrees");
        }
    }

    private void removeObsoleteLdapTrees() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"removeObsoleteLdapTrees", (String)"");
        }
        Share missingTrees = null;
        Share removeList = null;
        missingTrees = this.shAccessor.getRemovedResources(this.computer.cmpID, (short)66, this.probeTime);
        if (missingTrees != null) {
            removeList = this.isDelete ? missingTrees : this.shAccessor.setRemovedTime(missingTrees, this.probeTime, this.settings.seKeepRemovedFS);
        }
        if (removeList != null) {
            this.removeTreeShares(removeList);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeObsoleteLdapTrees");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTreeShares(Share removeList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"removeTreeShares", (String)"removeList");
        }
        this.shAccessor.prepDelete();
        this.shAccessor.prepGetAnotherComputer();
        try {
            Share sh = removeList;
            while (sh != null) {
                try {
                    LockManager.lock((short)0, (String)"LdapTree", (String)Integer.toString(sh.shResourceID), (byte)1, (boolean)true);
                    Share other = this.shAccessor.getAnotherComputer(sh.shResourceID, (short)66, this.computer.cmpID);
                    if (other != null) {
                        this.setComputerForTree(sh.shResourceID, other.shComputerID);
                    } else {
                        this.removeTree(sh.shResourceID);
                    }
                    this.shAccessor.deleteShare(sh);
                }
                finally {
                    LockManager.unLock((short)0, (String)"LdapTree", (String)Integer.toString(sh.shResourceID));
                }
                sh = sh.shNext;
            }
        }
        finally {
            this.shAccessor.closeSelect();
            this.shAccessor.closeDelete();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeTreeShares");
        }
    }

    private void setComputerForTree(int treeID, int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"setComputerForTree", (String)"treeID, computerID");
        }
        TResLdapTree accessor = new TResLdapTree(this.dbc);
        accessor.updateComputerID(treeID, computerID, this.computer.cmpID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"setComputerForTree");
        }
    }

    private void removeTree(int treeID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"removeTree", (String)"treeID");
        }
        TResShare shareAccessor = new TResShare(this.dbc);
        Share treeComputers = shareAccessor.getRemovedResources(treeID, (short)1, 0L);
        shareAccessor = null;
        FilerSaver filerSaver = new FilerSaver(this.dbc, -1);
        filerSaver.removeFilers(treeComputers, true);
        filerSaver = null;
        StorageRepositoryAccessor accessor = new StorageRepositoryAccessor(this.dbc);
        accessor.deleteByIdColumn("t_res_domain", "tree_id", treeID);
        accessor.deleteByIdColumn("t_res_ldap_tree", "tree_id", treeID);
        accessor.deleteByIdColumn("t_res_share", "computer_id", treeID);
        this.updateScheduler = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeTree");
        }
    }

    private void removeNasFilers(boolean removeAll) throws GeneralException {
        int shareID;
        Share sanfsFilerList;
        Share DAVSList;
        TStatComputer tStatComp;
        NameList agents;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"removeNasFilers", (String)"removeAll");
        }
        if (Constants.isNasBox((short)this.computer.cmpOSType) || Constants.isDiskArray((short)this.computer.cmpOSType) || Constants.isVirtualServer((int)this.computer.cmpOSType)) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeNasFilers");
            }
            return;
        }
        Share diskArrayList = this.shAccessor.getRemovedResources(this.computer.cmpID, (short)78, this.probeTime);
        Share VSList = null;
        if (this.computer.cmpClusterID != 0 && (agents = (tStatComp = new TStatComputer(this.dbc)).selectAgentsInCluster(this.computer.cmpClusterID)) != null && agents.nlNext == null) {
            int[] type = new int[]{99};
            VSList = this.shAccessor.getByCompAndResType(this.computer.cmpClusterID, type);
        }
        if ((DAVSList = this.concatLists(diskArrayList, VSList)) != null) {
            FilerSaver filerSaver = new FilerSaver(this.dbc, this.computer.cmpID);
            filerSaver.removeFilers(DAVSList, false);
        }
        if (Constants.isWindows((short)this.computer.cmpOSType) && (sanfsFilerList = this.shAccessor.getRemovedResources(shareID = this.computer.cmpID, (short)1, this.probeTime)) != null) {
            FilerSaver sanfsFilerSaver = new FilerSaver(this.dbc, shareID);
            sanfsFilerSaver.removeFilers(sanfsFilerList, false);
            this.shAccessor.deleteByCompAndResType(shareID, new int[]{1, 68});
        }
        if (!Constants.isWindows((short)this.computer.cmpOSType)) {
            shareID = this.computer.cmpID;
        } else {
            if (this.cmpAccessor.domainHasOtherOSAgents(this.computer.cmpDomainID, this.computer.cmpID)) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeNasFilers");
                }
                return;
            }
            shareID = this.computer.cmpDomainID;
        }
        Share filerList = this.shAccessor.getRemovedResources(shareID, (short)1, this.probeTime);
        if (filerList != null) {
            FilerSaver filerSaver = new FilerSaver(this.dbc, shareID);
            filerSaver.removeFilers(filerList, false);
            this.shAccessor.deleteByCompAndResType(shareID, new int[]{1, 68});
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeNasFilers");
        }
    }

    private void removeVirtualServers(Computer cmp, FilerSaver filerSaver) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"removeVirtualServers", (String)"cmp, filerSaver");
        }
        int clusterID = this.cmpAccessor.getClusterID(cmp);
        Share VSList = this.shAccessor.getRemovedResources(clusterID, (short)99, this.probeTime);
        filerSaver.removeFilers(VSList, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"removeVirtualServers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveComputerHist() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"saveComputerHist", (String)"");
        }
        if (this.computer.cmpHistory != null) {
            try {
                CompHist compHist = this.computer.cmpHistory;
                while (compHist != null) {
                    compHist.chComputerID = this.computer.cmpID;
                    compHist = compHist.chNext;
                }
                LockManager.lock((short)0, (String)"History", (String)"CompHist", (byte)2, (boolean)true);
                TStatCompHist chAccessor = new TStatCompHist(this.dbc);
                chAccessor.save(this.computer.cmpHistory);
            }
            finally {
                LockManager.unLock((short)0, (String)"History", (String)"CompHist");
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"saveComputerHist");
        }
    }

    private void deleteOtherStuff(boolean removeAll) throws GeneralException {
        TResDiskArray daAccessor;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"deleteOtherStuff", (String)"removeAll");
        }
        if (removeAll) {
            TResDevAccess daAccessor2 = new TResDevAccess(this.dbc);
            daAccessor2.deleteByComputer(this.computer.cmpID);
        }
        StorageRepositoryAccessor deleteAccessor = new StorageRepositoryAccessor(this.dbc);
        if (removeAll) {
            if (this.isDiskArray) {
                TResEntityWWPN wwpnAccessor = new TResEntityWWPN(this.dbc);
                if (this.computer.cmpOSType == 21) {
                    if (this.computer.cmpEntityWWPN == null) {
                        EntityWWPN wwpnList;
                        this.computer.cmpEntityWWPN = wwpnList = wwpnAccessor.getEntityWWPNs(this.computer.cmpID);
                    }
                    this.updateExistingStorageSystemLUNs((byte)0);
                    Controller ctlrList = null;
                    TResController ctlrAccessor = new TResController(this.dbc);
                    Controller ctlr = ctlrList = ctlrAccessor.getControllers(this.computer.cmpID);
                    while (ctlr != null) {
                        deleteAccessor.deleteByIdColumn("t_res_entity_wwpn", "entity_id", ctlr.ctlrID);
                        ctlr = ctlr.ctlrNext;
                    }
                } else {
                    EntityWWPN wwpnList = wwpnAccessor.getEntityWWPNs(this.computer.cmpID);
                    boolean found = false;
                    int entityID = -1;
                    EntityWWPN wwpn = wwpnList;
                    while (wwpn != null) {
                        entityID = wwpnAccessor.getEntityIdByWWPN((byte)3, wwpn.sWWPN);
                        if (entityID != -1) {
                            found = true;
                            break;
                        }
                        wwpn = wwpn.entityWWPNNext;
                    }
                    if (found) {
                        this.updateSavedSVCDiskIdentity(entityID, (byte)2);
                    }
                }
                deleteAccessor.deleteByComputer("t_res_entity_wwpn", this.computer.cmpID);
                deleteAccessor.deleteByComputer("t_res_disk_group", this.computer.cmpID);
            } else {
                deleteAccessor.deleteByComputer("t_res_export", this.computer.cmpID);
                deleteAccessor.deleteByComputer("t_stat_ping_hist", this.computer.cmpID);
                deleteAccessor.deleteByComputer("t_stat_comp_hist", this.computer.cmpID);
                deleteAccessor.deleteByComputer("t_res_comp_user", this.computer.cmpID);
                deleteAccessor.deleteByComputer("t_res_user_group", this.computer.cmpID);
                deleteAccessor.deleteByComputer("t_res_directory", this.computer.cmpID);
            }
            deleteAccessor.deleteByComputer("t_res_controller", this.computer.cmpID);
        }
        if (removeAll) {
            deleteAccessor.deleteByFilesystem("t_stat_fs_hist", this.computer.cmpID);
        }
        deleteAccessor.deleteByFilesystem("t_stat_group_hist", this.computer.cmpID);
        deleteAccessor.deleteByFilesystem("t_stat_space_hist", this.computer.cmpID);
        deleteAccessor.deleteByFilesystem("t_stat_time_hist", this.computer.cmpID);
        deleteAccessor.deleteByFilesystem("t_stat_user_hist", this.computer.cmpID);
        deleteAccessor.deleteByFilesystem("t_stat_ftype_hist", this.computer.cmpID);
        deleteAccessor.deleteByFilesystem("t_stat_user", this.computer.cmpID);
        deleteAccessor.deleteByFilesystem("t_stat_group", this.computer.cmpID);
        if (removeAll) {
            deleteAccessor.deleteByDisk("t_stat_disk_hist", this.computer.cmpID);
        }
        if (Constants.isNasBox((short)this.computer.cmpOSType)) {
            this.fsAccessor.resetNasScanComputer(this.computer.cmpID);
        } else if (Constants.isDiskArray((short)this.computer.cmpOSType)) {
            daAccessor = new TResDiskArray(this.dbc);
            daAccessor.resetProbingComputer(this.computer.cmpID);
        } else {
            this.fsAccessor.resetScanComputer(this.computer.cmpID);
            daAccessor = new TResDiskArray(this.dbc);
            daAccessor.resetAllProbingComputers(this.computer.cmpID);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"deleteOtherStuff");
        }
    }

    private void unLockDevices() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"unLockDevices", (String)"");
        }
        LockManager.unLock((short)0, (String)"History", (String)"DiskHist");
        if (this.lockedDeviceTable != null) {
            for (int i = 0; i < this.lockedDeviceTable.length; ++i) {
                LockManager.unLock((short)0, (String)"Device", (String)String.valueOf(this.lockedDeviceTable[i]));
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"unLockDevices");
        }
    }

    private void cleanup() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"cleanup", (String)"");
        }
        this.warningResponse = null;
        this.settings = null;
        this.computer = null;
        this.oldComputer = null;
        this.shareBuffer.shResource = null;
        this.shareBuffer.shPath = null;
        this.cmpAccessor = null;
        this.devAccessor = null;
        this.chkAccessor = null;
        this.colAccessor = null;
        this.ldAccessor = null;
        this.fsAccessor = null;
        this.shAccessor = null;
        this.clAccessor = null;
        this.tResCmpAccessor = null;
        this.tGrp2ResAccessor = null;
        this.missingDeviceList = null;
        this.missingFSList = null;
        this.removeFSList = null;
        this.lockedDeviceTable = null;
        this.isVirtualServer = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"cleanup");
        }
    }

    private void clusterProcessing() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"clusterProcessing", (String)"");
        }
        if (this.computer.cmpCluster == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"clusterProcessing");
            }
            return;
        }
        Cluster cluster = this.computer.cmpCluster;
        Cluster repoCluster = null;
        Object tComp = null;
        boolean DoesRepoShowComputerInCluster = false;
        boolean DoesRepoKnowClusterExsists = false;
        boolean DoesRepoShowComputerInDifferentCluster = false;
        try {
            NameList currComp = new NameList();
            currComp.nlID = this.computer.cmpID;
            currComp.nlInfo = 1;
            cluster.clusterID = this.cmpAccessor.getClusterID(this.computer);
            repoCluster = this.clAccessor.getClusterByName(cluster.clusterName, cluster.domain_name);
            DoesRepoKnowClusterExsists = repoCluster != null;
            DoesRepoShowComputerInCluster = DoesRepoKnowClusterExsists && cluster.clusterID == repoCluster.clusterID;
            boolean bl = DoesRepoShowComputerInDifferentCluster = DoesRepoKnowClusterExsists && cluster.clusterID > 0 && cluster.clusterID != repoCluster.clusterID;
            if (DoesRepoShowComputerInDifferentCluster) {
                this.tGrp2ResAccessor.addRemoveResources(repoCluster.clusterID, (short)99, null, currComp, false);
            }
            if (DoesRepoShowComputerInCluster) {
                this.clAccessor.update(cluster, false);
            } else {
                if (DoesRepoKnowClusterExsists) {
                    cluster.clusterID = repoCluster.clusterID;
                    this.clAccessor.update(cluster, false);
                    try {
                        this.tGrp2ResAccessor.addRemoveResources(repoCluster.clusterID, (short)99, currComp, null, false);
                    }
                    catch (StorageException se) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)ProbeResultsHndlr.class.getName(), (String)"clusterProcessing", (Throwable)se);
                        }
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"clusterProcessing");
                        }
                        throw se;
                    }
                }
                try {
                    cluster = this.clAccessor.insert(cluster);
                    GroupDefinition def = new GroupDefinition();
                    def.creator = "Default";
                    def.groupType = (short)99;
                    def.ID = cluster.clusterID;
                    def.members = currComp;
                    def.setName(cluster.clusterName + "-" + cluster.domain_name);
                    GroupDefHndlr grp = new GroupDefHndlr();
                    grp.createGroupWithMembers(def, "Cluster Reporting Group");
                }
                catch (GeneralException se) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ProbeResultsHndlr.class.getName(), (String)"clusterProcessing", (Throwable)se);
                    }
                    this.clAccessor.cleanupCluster(cluster.clusterID);
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"clusterProcessing");
                    }
                    throw se;
                }
            }
            this.computer.cmpClusterID = cluster.clusterID;
        }
        catch (StorageException se) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ProbeResultsHndlr.class.getName(), (String)"clusterProcessing", (Throwable)se);
            }
            MessageLog.logException((StorageException)se);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"clusterProcessing");
        }
    }

    private void cleanClusterMembership() throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"cleanClusterMembership", (String)"");
        }
        if (this.oldComputer == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"cleanClusterMembership");
            }
            return;
        }
        if (this.computer.cmpCluster == null && this.oldComputer.cmpClusterID > 0) {
            NameList currComp = new NameList();
            currComp.nlID = this.computer.cmpID;
            currComp.nlInfo = 1;
            this.tGrp2ResAccessor.addRemoveResources(this.oldComputer.cmpClusterID, (short)99, null, currComp, false);
            this.cmpAccessor.updateClusterMembership(this.computer);
        }
        if (this.oldComputer.cmpClusterID != this.computer.cmpClusterID && !Constants.isVirtualServer((int)this.computer.cmpOSType)) {
            this.previousClusterID = this.oldComputer.cmpClusterID;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"cleanClusterMembership");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVSScanTime(Connection dbc, Computer c, long filerProbeTime) throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"updateVSScanTime", (String)"dbc, c, filerProbeTime");
        }
        RepositoryAccessor shareAccessor = null;
        try {
            if (c.cmpCluster != null) {
                shareAccessor = new TResShare(dbc);
                ((TResShare)shareAccessor).prepUpdate();
                Share shareBuffer = new Share();
                shareBuffer.shScanTime = filerProbeTime;
                shareBuffer.shResourceType = (short)99;
                shareBuffer.shComputerID = c.cmpCluster.clusterID;
                TResComputer tResCompAccessor = new TResComputer(dbc);
                Iterator itr = c.cmpCluster.virtualServers.iterator();
                while (itr.hasNext()) {
                    try {
                        int cmpID;
                        shareBuffer.shResourceID = cmpID = tResCompAccessor.selectCID((String)itr.next());
                        ((TResShare)shareAccessor).updateShare(shareBuffer);
                    }
                    catch (GeneralException e) {
                        if (!TraceLogger.enableTrace) continue;
                        TraceLogger.exception((String)ProbeResultsHndlr.class.getName(), (String)"updateVSScanTime", (Throwable)e);
                    }
                }
                shareAccessor.commit();
            }
        }
        finally {
            shareAccessor.closeUpdate();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"updateVSScanTime");
        }
    }

    private void expireVSs(Connection dbc, Computer c, FilerSaver filerSaver) throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"expireVSs", (String)"dbc, c, filerSaver");
        }
        if (filerSaver == null) {
            filerSaver = new FilerSaver(dbc, c.cmpDomainID);
            filerSaver.setProbeTime(this.probeTime);
        }
        filerSaver.updateVSProbeTime(c.cmpCluster);
        filerSaver.handleMissingVSs(c.cmpCluster.clusterID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"expireVSs");
        }
    }

    public int updateSSLUNIdentity() {
        int updatedLUNs = 0;
        updatedLUNs = this.computer.cmpOSType == 21 ? this.updateExistingStorageSystemLUNs((byte)1) : this.updateNewStorageSystemLUNs();
        return updatedLUNs;
    }

    public int updateExistingStorageSystemLUNs(byte lunIdentity) {
        int updatedRows;
        block14: {
            boolean identityChanged = false;
            updatedRows = 0;
            Object svcClusterWWPNList = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"updateExistingStorageSystemLUNs", null);
            }
            try {
                TResDiskArray daAccessor = new TResDiskArray(this.dbc);
                NameList filerList = daAccessor.getStorageSystems();
                this.ldAccessor.prepUpdateLUNIdentity();
                NameList element = filerList;
                while (element != null) {
                    LunWWN lunWWNList;
                    TResLunWWN accessor = new TResLunWWN(this.dbc);
                    LunWWN lun = lunWWNList = accessor.SelectByComputerId(element.nlID);
                    while (lun != null) {
                        EntityWWPN svcWWPN = this.computer.cmpEntityWWPN;
                        while (svcWWPN != null) {
                            block13: {
                                if (lun.lwWWN.compareToIgnoreCase(svcWWPN.sWWPN) == 0) {
                                    try {
                                        updatedRows = this.ldAccessor.updateLUNIdentity(lun.lwLunID, lunIdentity);
                                        break;
                                    }
                                    catch (GeneralException e) {
                                        updatedRows = -1;
                                        if (!this.isDelete) {
                                            MessageLog.logMessage((String)"SRV0198E", (Object)this.computer.cmpNasFiler.nfAlias);
                                        }
                                        if (!TraceLogger.enableTrace) break block13;
                                        TraceLogger.exception((String)ProbeResultsHndlr.class.getName(), (String)"updateExistingStorageSystemLUNs", (Throwable)e);
                                    }
                                }
                            }
                            svcWWPN = svcWWPN.entityWWPNNext;
                        }
                        lun = lun.lwNext;
                    }
                    accessor.closeSelect();
                    element = element.nlNext;
                }
                this.ldAccessor.closeUpdate();
                daAccessor.closeSelect();
                if (!this.isDelete && updatedRows > 0) {
                    MessageLog.logMessage((String)"SRV0197I", (Object)this.computer.cmpNasFiler.nfAlias);
                }
            }
            catch (GeneralException e) {
                if (!this.isDelete) {
                    MessageLog.logMessage((String)"SRV0198E", (Object)this.computer.cmpNasFiler.nfAlias);
                }
                if (!TraceLogger.enableTrace) break block14;
                TraceLogger.exception((String)ProbeResultsHndlr.class.getName(), (String)"updateExistingStorageSystemLUNs", (Throwable)e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"updateExistingStorageSystemLUNs");
        }
        return updatedRows;
    }

    public int updateNewStorageSystemLUNs() {
        int updatedRows;
        block14: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"updateNewStorageSystemLUNs", null);
            }
            boolean lunIdentityChanged = false;
            LogicalDisk lDisk = null;
            updatedRows = 0;
            int entityID = -1;
            String svcName = null;
            HashMap svcMap = new HashMap();
            try {
                TResDiskArray daAccessor = new TResDiskArray(this.dbc);
                EntityWWPN svcWWPNList = daAccessor.getSVCNodeWWPNs();
                TResEntityWWPN wwpnAccessor = new TResEntityWWPN(this.dbc);
                TResComputer computerAccessor = new TResComputer(this.dbc);
                if (svcWWPNList == null) {
                    return updatedRows;
                }
                lDisk = this.computer.cmpLogicalDisk;
                while (lDisk != null) {
                    lunIdentityChanged = false;
                    LunWWN lun = null;
                    lun = lDisk.ldLunWWNs;
                    while (lun != null) {
                        EntityWWPN svcWWPN = svcWWPNList;
                        while (svcWWPN != null) {
                            if (lun.lwWWN.compareToIgnoreCase(svcWWPN.sWWPN) == 0) {
                                lDisk.lun_identity = 1;
                                lunIdentityChanged = true;
                                ++updatedRows;
                                entityID = wwpnAccessor.getEntityIdByWWPN((byte)2, svcWWPN.sWWPN);
                                computerAccessor.prepSelectLocalHostname();
                                svcName = computerAccessor.fetchName(entityID);
                                if (svcMap.containsKey(svcName)) break;
                                svcMap.put(svcName, null);
                                break;
                            }
                            svcWWPN = svcWWPN.entityWWPNNext;
                        }
                        if (lunIdentityChanged) break;
                        lun = lun.lwNext;
                    }
                    lDisk = lDisk.ldNext;
                }
                if (updatedRows > 0) {
                    Set set = svcMap.keySet();
                    Iterator it = set.iterator();
                    String s = "";
                    int num = set.size();
                    if (num > 1) {
                        int pos = 1;
                        while (it.hasNext()) {
                            s = s + (String)it.next();
                            if (++pos >= num) continue;
                            s = s + ", ";
                        }
                    } else if (num == 1) {
                        s = s + (String)it.next();
                    }
                    MessageLog.logMessage((String)"SRV0197I", (Object)s);
                }
                daAccessor.closeSelect();
                wwpnAccessor.closeSelect();
                computerAccessor.closeSelect();
            }
            catch (GeneralException ge) {
                MessageLog.logMessage((String)"SRV0198E", (Object)svcMap.toString());
                if (!TraceLogger.enableTrace) break block14;
                TraceLogger.exception((String)ProbeResultsHndlr.class.getName(), (String)"updateNewStorageSystemLUNs", (Throwable)ge);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"updateNewStorageSystemLUNs");
        }
        return updatedRows;
    }

    private void updateSavedSVCDiskIdentity(int entityID, byte diskIdentity) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"updateSavedSVCDiskIdentity", null);
        }
        TStatDisk diskAccessor = new TStatDisk(this.dbc);
        diskAccessor.updateSVCDiskIdentity(entityID, diskIdentity);
        diskAccessor.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"updateSavedSVCDiskIdentity", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSVCDiskIdentity() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ProbeResultsHndlr.class.getName(), (String)"updateSVCDiskIdentity", null);
        }
        byte entityType = -1;
        int entityID = -1;
        TResEntityWWPN wwpnAccessor = new TResEntityWWPN(this.dbc);
        try {
            if (this.computer.cmpOSType == 21) {
                entityType = 1;
                Controller ctlr = this.computer.cmpController;
                while (ctlr != null) {
                    EntityWWPN ctlrWWPN = ctlr.ctlrWWPNs;
                    while (ctlrWWPN != null) {
                        entityID = wwpnAccessor.getEntityIdByWWPN(entityType, ctlrWWPN.sWWPN);
                        if (entityID != -1) {
                            for (Disk disk : ctlr.ctlrDisks) {
                                disk.dskIdentity = 1;
                            }
                        }
                        ctlrWWPN = ctlrWWPN.entityWWPNNext;
                    }
                    ctlr = ctlr.ctlrNext;
                }
            } else {
                entityType = 3;
                EntityWWPN ctlrWWPN = this.computer.cmpEntityWWPN;
                while (ctlrWWPN != null) {
                    entityID = wwpnAccessor.getEntityIdByWWPN(entityType, ctlrWWPN.sWWPN);
                    if (entityID != -1) {
                        this.updateSavedSVCDiskIdentity(entityID, (byte)1);
                    }
                    ctlrWWPN = ctlrWWPN.entityWWPNNext;
                }
            }
        }
        finally {
            wwpnAccessor.closeSelect();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ProbeResultsHndlr.class.getName(), (String)"updateSVCDiskIdentity", null);
        }
    }
}

