/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListSaver;
import org.eclipse.aperi.repository.RaceConditionChecker;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.server.handler.gui.AlertDefChangeDetectThread;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertDefHndlr
implements RequestHandler,
ThrowAway {
    private AlertHeader alertHeader;
    private Response response;
    private Connection dbc;
    private short attributeType;
    private static final String RESOURCE_TYPE = "ALERT";
    private static final String OBJECT_TYPE_LABEL = MessageLog.getMessageNoID((String)"STS0109L");
    private static String USER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        USER = request.userName;
        this.response = Response.getResponse((short)0, null);
        if (!RequestChecker.isDesiredType(AlertHeader.class, (Request)request, (Response)this.response)) {
            Response traceResult = this.response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        this.alertHeader = (AlertHeader)request.requestData;
        this.dbc = Server.getConnection();
        if (this.dbc == null) {
            Server.setResponseError(this.response, "GEN0050E");
            Response traceResult = this.response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        boolean fetch = this.alertHeader.alert == null && this.alertHeader.alertElements == null && this.alertHeader.alertGroups == null && this.alertHeader.alertGroups2 == null && this.alertHeader.alertElements2 == null && this.alertHeader.alertGroups3 == null && this.alertHeader.alertElements3 == null && this.alertHeader.alertClusters == null && !this.alertHeader.allObjects && !this.alertHeader.allElements1 && !this.alertHeader.allElements2 && this.alertHeader.paDevicesInAlertDef == null;
        String resourceName = null;
        if (this.alertHeader.ID > 0) {
            resourceName = Integer.toString(this.alertHeader.ID);
            byte lockType = fetch ? (byte)2 : 1;
            LockManager.lock((short)0, (String)RESOURCE_TYPE, (String)resourceName, (byte)lockType, (boolean)true);
        }
        try {
            if (fetch) {
                this.retrieve();
            } else {
                this.save();
            }
            this.response.responseData = this.alertHeader;
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AlertDefHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            if (this.response.status <= 4) {
                this.response.status = (short)12;
            }
            this.response.errorMessage = e.getMessage();
        }
        finally {
            if (resourceName != null) {
                LockManager.unLock((short)0, (String)RESOURCE_TYPE, (String)resourceName);
            }
            Server.returnConnection(this.dbc);
        }
        Response traceResult = this.response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private void retrieve() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"retrieve", (String)"");
        }
        TAlertDefinition alertAccessor = new TAlertDefinition(this.dbc);
        alertAccessor.getByID(this.alertHeader);
        AlertDefinition alert = this.alertHeader.alert;
        this.setAttributeType(alert);
        short groupType = 0;
        TResAttr raAccessor = new TResAttr(this.dbc);
        if (alert.aldType == 7) {
            groupType = 2;
            TResFS accessor = new TResFS(this.dbc);
            this.alertHeader.alertElements = accessor.queryDependents(this.alertHeader.ID);
            this.alertHeader.alertElements2 = this.getDependentComputers();
            this.alertHeader.alertGroups2 = raAccessor.queryDependents("t_group", "group_id", this.alertHeader.ID, (short)0);
            this.alertHeader.alertClusters = raAccessor.queryDependents("t_group", "group_id", this.alertHeader.ID, (short)99);
        } else if (alert.aldType == 6) {
            groupType = 0;
            this.alertHeader.alertElements = this.getDependentComputers();
            this.alertHeader.alertClusters = raAccessor.queryDependents("t_group", "group_id", this.alertHeader.ID, (short)99);
        } else if (alert.aldType == 20) {
            groupType = 77;
            TResDiskArray accessor = new TResDiskArray(this.dbc);
            this.alertHeader.alertElements = accessor.queryDependents(this.alertHeader.ID);
        } else if (alert.aldType == 30) {
            this.alertHeader.alertElements = FabricDbAccess.getFabricsForAlert((int)this.alertHeader.ID);
            this.alertHeader.alertElements2 = FabricDbAccess.getZonesForAlert((int)this.alertHeader.ID);
            this.alertHeader.alertElements3 = FabricDbAccess.getZoneSetsForAlert((int)this.alertHeader.ID);
            this.alertHeader.allObjects = FabricDbAccess.verifyAllResourcesSelected((int)this.alertHeader.ID, (short)114);
            this.alertHeader.allElements1 = FabricDbAccess.verifyAllResourcesSelected((int)this.alertHeader.ID, (short)127);
            this.alertHeader.allElements2 = FabricDbAccess.verifyAllResourcesSelected((int)this.alertHeader.ID, (short)126);
        } else if (alert.aldType == 31) {
            this.alertHeader.alertElements = FabricDbAccess.getSwitchesForAlert((int)this.alertHeader.ID);
            this.alertHeader.alertGroups = FabricDbAccess.getFabricsForAlert((int)this.alertHeader.ID);
            this.alertHeader.allObjects = FabricDbAccess.verifyAllResourcesSelected((int)this.alertHeader.ID, (short)121);
        } else if (alert.aldType == 32) {
            this.alertHeader.alertElements = this.getEndpoints(this.alertHeader.ID);
            this.alertHeader.alertGroups = FabricDbAccess.getFabricsForAlert((int)this.alertHeader.ID);
            this.alertHeader.allObjects = FabricDbAccess.verifyAllResourcesSelected((int)this.alertHeader.ID, (short)129);
        }
        if (alert.aldType != 30 && alert.aldType != 31 && alert.aldType != 32) {
            this.alertHeader.alertGroups = raAccessor.queryDependents("t_group", "group_id", this.alertHeader.ID, groupType);
            this.alertHeader.allObjects = NameListSaver.allObjectsSelected(raAccessor, this.alertHeader.ID, this.attributeType);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"retrieve");
        }
    }

    private NameList getEndpoints(int id) {
        NameList tempList;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"getEndpoints", (String)"alert");
        }
        NameList mergedHead = null;
        NameList mergedTail = null;
        NameList peHead = null;
        NameList peTail = null;
        NameList portHead = null;
        NameList portTail = null;
        NameList nodeHead = null;
        NameList nodeTail = null;
        peHead = FabricDbAccess.getPeripheralEntitiesForAlert((int)id);
        if (peHead != null) {
            tempList = peHead;
            peTail = peHead;
            while (tempList.nlNext != null) {
                tempList = tempList.nlNext;
                if (tempList == null) continue;
                peTail = tempList;
            }
        }
        if (peHead != null) {
            mergedHead = peHead;
            mergedTail = peTail;
        }
        if ((portHead = FabricDbAccess.getPortsForAlert((int)id)) != null) {
            tempList = portHead;
            portTail = portHead;
            while (tempList.nlNext != null) {
                tempList = tempList.nlNext;
                if (tempList == null) continue;
                portTail = tempList;
            }
        }
        if ((nodeHead = FabricDbAccess.getNodesForAlert((int)id)) != null) {
            tempList = nodeHead;
            nodeTail = nodeHead;
            while (tempList.nlNext != null) {
                tempList = tempList.nlNext;
                if (tempList == null) continue;
                nodeTail = tempList;
            }
        }
        if (portHead != null) {
            if (mergedTail != null) {
                mergedTail.nlNext = portHead;
            } else {
                mergedHead = portHead;
            }
            mergedTail = portTail;
        }
        if (nodeHead != null) {
            if (mergedTail != null) {
                mergedTail.nlNext = nodeHead;
            } else {
                mergedHead = nodeHead;
            }
            mergedTail = nodeTail;
        }
        return mergedHead;
    }

    private void setAttributeType(AlertDefinition alert) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"setAttributeType", (String)"alert");
        }
        switch (alert.aldType) {
            case 7: {
                if (alert.aldCondition == 12) {
                    this.attributeType = (short)29;
                    break;
                }
                this.attributeType = (short)27;
                break;
            }
            case 6: {
                this.attributeType = (short)26;
                break;
            }
            case 20: {
                if (alert.aldCondition == 65) {
                    this.attributeType = (short)82;
                    break;
                }
                this.attributeType = (short)81;
                break;
            }
            case 31: {
                this.attributeType = (short)121;
                break;
            }
            case 30: {
                this.attributeType = (short)114;
                break;
            }
            case 32: {
                this.attributeType = (short)129;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"setAttributeType");
        }
    }

    private NameList getDependentComputers() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"getDependentComputers", (String)"");
        }
        TResComputer accessor = new TResComputer(this.dbc);
        NameList traceResult = accessor.queryDependents(this.alertHeader.ID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"getDependentComputers", (Object)traceResult);
        }
        return traceResult;
    }

    private void save() throws GeneralException {
        boolean rowExists;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"save", (String)"");
        }
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)AlertDefHndlr.class.getName(), (String)"save", (String)USER);
        }
        String checkerWarning = null;
        AlertHeader currentDefinition = new AlertHeader();
        NameListSaver nlSaver = new NameListSaver(this.dbc, this.response);
        this.setAttributeType(this.alertHeader.alert);
        if (this.alertHeader.ID <= 0) {
            this.alertHeader.ID = StorageRepositoryAccessor.getIdentifier(1, 1, this.dbc);
            rowExists = false;
        } else {
            RaceConditionChecker checker = new RaceConditionChecker(this.dbc, "t_alert_definition", "alert_id", (CreateHeader)this.alertHeader, OBJECT_TYPE_LABEL);
            checker.check();
            checkerWarning = checker.message;
            rowExists = !checker.wasDeleted;
            checker = null;
            if (rowExists) {
                TResAttr accessor = new TResAttr(this.dbc);
                accessor.prepQueryByAttr();
                ResourceAttribute resAttr = new ResourceAttribute();
                resAttr.raAttributeID = this.alertHeader.ID;
                resAttr.raAttributeType = this.attributeType;
                AlertDefinition alert = this.alertHeader.alert;
                if (alert.aldType == 7) {
                    this.getFSAlertRes(accessor, resAttr, alert, currentDefinition);
                } else if (alert.aldType == 6) {
                    this.getCompAlertRes(accessor, resAttr, alert, currentDefinition);
                } else if (alert.aldType == 20) {
                    this.getArrayAlertRes(accessor, resAttr, alert, currentDefinition);
                } else if (alert.aldType == 31) {
                    nlSaver.deleteObject(this.alertHeader.ID, this.attributeType, (short)121, -1);
                    this.getSwitchAlertRes(accessor, resAttr, alert, currentDefinition);
                } else if (alert.aldType == 30) {
                    nlSaver.deleteObject(this.alertHeader.ID, this.attributeType, (short)114, -1);
                    nlSaver.deleteObject(this.alertHeader.ID, this.attributeType, (short)127, -1);
                    nlSaver.deleteObject(this.alertHeader.ID, this.attributeType, (short)126, -1);
                    this.getFabricAlertRes(accessor, resAttr, alert, currentDefinition);
                } else if (alert.aldType == 32) {
                    nlSaver.deleteObject(this.alertHeader.ID, this.attributeType, (short)129, -1);
                    this.getEndpointAlertRes(accessor, resAttr, alert, currentDefinition);
                }
                currentDefinition.allObjects = NameListSaver.allObjectsSelected(accessor, this.alertHeader.ID, this.attributeType);
                accessor.closeSelect();
            }
        }
        TAlertDefinition alertAccessor = new TAlertDefinition(this.dbc);
        if (rowExists) {
            alertAccessor.deleteByID(this.alertHeader.ID);
        }
        alertAccessor.insert((CreateHeader)this.alertHeader, this.alertHeader.alert);
        if (this.alertHeader.alert.aldType == 30) {
            if (this.alertHeader.allObjects) {
                nlSaver.saveAllObjectsSelected(this.alertHeader.allObjects, this.alertHeader.ID, this.attributeType, (short)114, true);
            }
            if (this.alertHeader.allElements1) {
                nlSaver.saveAllObjectsSelected(this.alertHeader.allElements1, this.alertHeader.ID, this.attributeType, (short)127, true);
            }
            if (this.alertHeader.allElements2) {
                nlSaver.saveAllObjectsSelected(this.alertHeader.allElements2, this.alertHeader.ID, this.attributeType, (short)126, true);
            }
        } else if (this.alertHeader.alert.aldType == 31) {
            if (this.alertHeader.allObjects) {
                nlSaver.saveAllObjectsSelected(this.alertHeader.allObjects, this.alertHeader.ID, this.attributeType, (short)121, true);
            }
        } else if (this.alertHeader.alert.aldType == 32) {
            if (this.alertHeader.allObjects) {
                nlSaver.saveAllObjectsSelected(this.alertHeader.allObjects, this.alertHeader.ID, this.attributeType, (short)129, true);
            }
        } else {
            nlSaver.saveAllObjectsSelected(this.alertHeader.allObjects, this.alertHeader.ID, this.attributeType);
        }
        NameList[] newDef = new NameList[6];
        if (this.alertHeader.alert.aldType != 30) {
            newDef[0] = this.alertHeader.alertElements;
            newDef[1] = this.alertHeader.alertElements2;
            newDef[2] = this.alertHeader.alertElements3;
            newDef[3] = this.alertHeader.alertGroups;
            newDef[4] = this.alertHeader.alertGroups2;
            newDef[5] = this.alertHeader.alertClusters;
        } else {
            newDef[0] = this.alertHeader.alertElements;
            this.removeFabricInfo(this.alertHeader.alertElements2);
            newDef[1] = this.alertHeader.alertElements2;
            this.removeFabricInfo(this.alertHeader.alertElements3);
            newDef[2] = this.alertHeader.alertElements3;
            newDef[3] = this.alertHeader.alertGroups;
            newDef[4] = this.alertHeader.alertGroups2;
            newDef[5] = this.alertHeader.alertClusters;
        }
        NameList[] oldDef = new NameList[]{currentDefinition.alertElements, currentDefinition.alertElements2, currentDefinition.alertElements3, currentDefinition.alertGroups, currentDefinition.alertGroups2, currentDefinition.alertClusters};
        nlSaver.save((CreateHeader)this.alertHeader, OBJECT_TYPE_LABEL, this.attributeType, this.alertHeader.ID, newDef, oldDef, this.createTablesMap(), rowExists);
        AlertDefChangeDetectThread cdThread = new AlertDefChangeDetectThread();
        Thread actionThread = new Thread((Runnable)cdThread, this.getClass().getName());
        actionThread.start();
        if (checkerWarning != null) {
            this.response.status = (short)4;
            this.response.errorMessage = checkerWarning;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"save");
        }
    }

    private NameList removeFabricInfo(NameList records) {
        NameList tempRecord = records;
        NameList topRecord = new NameList();
        NameList previousRecord = new NameList();
        boolean firstPass = true;
        while (tempRecord != null) {
            NameList currentRecord = new NameList();
            currentRecord.nlID = tempRecord.nlID;
            currentRecord.nlInfo = tempRecord.nlInfo;
            currentRecord.nlName = tempRecord.nlName.substring(0, tempRecord.nlName.lastIndexOf(40));
            if (firstPass) {
                topRecord = currentRecord;
            } else {
                previousRecord.nlNext = currentRecord;
            }
            previousRecord = currentRecord;
            tempRecord = tempRecord.nlNext;
            firstPass = false;
        }
        return topRecord;
    }

    private void getFSAlertRes(TResAttr accessor, ResourceAttribute resAttr, AlertDefinition alert, AlertHeader currentDefinition) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"getFSAlertRes", (String)"accessor, resAttr, alert, currentDefinition");
        }
        resAttr.raResourceType = (short)3;
        currentDefinition.alertElements = accessor.getResAttr(resAttr);
        resAttr.raResourceType = (short)2;
        currentDefinition.alertGroups = accessor.getResAttr(resAttr);
        resAttr.raResourceType = 1;
        currentDefinition.alertElements2 = accessor.getResAttr(resAttr);
        resAttr.raResourceType = 0;
        currentDefinition.alertGroups2 = accessor.getResAttr(resAttr);
        resAttr.raResourceType = (short)99;
        currentDefinition.alertClusters = accessor.getResAttr(resAttr);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"getFSAlertRes");
        }
    }

    private void getCompAlertRes(TResAttr accessor, ResourceAttribute resAttr, AlertDefinition alert, AlertHeader currentDefinition) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"getCompAlertRes", (String)"accessor, resAttr, alert, currentDefinition");
        }
        resAttr.raResourceType = 1;
        currentDefinition.alertElements = accessor.getResAttr(resAttr);
        resAttr.raResourceType = 0;
        currentDefinition.alertGroups = accessor.getResAttr(resAttr);
        resAttr.raResourceType = (short)99;
        currentDefinition.alertClusters = accessor.getResAttr(resAttr);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"getCompAlertRes");
        }
    }

    private void getArrayAlertRes(TResAttr accessor, ResourceAttribute resAttr, AlertDefinition alert, AlertHeader currentDefinition) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"getArrayAlertRes", (String)"accessor, resAttr, alert, currentDefinition");
        }
        resAttr.raResourceType = (short)78;
        currentDefinition.alertElements = accessor.getResAttr(resAttr);
        resAttr.raResourceType = (short)77;
        currentDefinition.alertGroups = accessor.getResAttr(resAttr);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"getArrayAlertRes");
        }
    }

    private void getSwitchAlertRes(TResAttr accessor, ResourceAttribute resAttr, AlertDefinition alert, AlertHeader currentDefinition) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"getCompAlertRes", (String)"accessor, resAttr, alert, currentDefinition");
        }
        resAttr.raResourceType = (short)121;
        currentDefinition.alertElements = accessor.getResAttr(resAttr);
        resAttr.raResourceType = (short)114;
        currentDefinition.alertGroups = accessor.getResAttr(resAttr);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"getSwitchAlertRes");
        }
    }

    private void getFabricAlertRes(TResAttr accessor, ResourceAttribute resAttr, AlertDefinition alert, AlertHeader currentDefinition) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"getFabricAlertRes", (String)"accessor, resAttr, alert, currentDefinition");
        }
        resAttr.raResourceType = (short)114;
        currentDefinition.alertElements = accessor.getResAttr(resAttr);
        resAttr.raResourceType = (short)127;
        currentDefinition.alertElements2 = accessor.getResAttr(resAttr);
        resAttr.raResourceType = (short)126;
        currentDefinition.alertElements3 = accessor.getResAttr(resAttr);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"getFabricAlertRes");
        }
    }

    private void getEndpointAlertRes(TResAttr accessor, ResourceAttribute resAttr, AlertDefinition alert, AlertHeader currentDefinition) throws GeneralException {
        NameList tail;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"getEndpointAlertRes", (String)"accessor, resAttr, alert, currentDefinition");
        }
        resAttr.raResourceType = (short)139;
        currentDefinition.alertElements = accessor.getResAttr(resAttr);
        if (currentDefinition.alertElements != null) {
            resAttr.raResourceType = (short)137;
            tail = this.getTail(currentDefinition.alertElements);
            tail.nlNext = accessor.getResAttr(resAttr);
        } else {
            currentDefinition.alertElements = accessor.getResAttr(resAttr);
        }
        resAttr.raResourceType = (short)138;
        if (currentDefinition.alertElements != null) {
            tail = this.getTail(currentDefinition.alertElements);
            tail.nlNext = accessor.getResAttr(resAttr);
        } else {
            currentDefinition.alertElements = accessor.getResAttr(resAttr);
        }
        resAttr.raResourceType = (short)114;
        currentDefinition.alertGroups = accessor.getResAttr(resAttr);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"getEndpointAlertRes");
        }
    }

    private NameList getTail(NameList first) {
        NameList last = null;
        NameList temp = first;
        while (temp.nlNext != null) {
            temp = last = temp.nlNext;
        }
        if (last != null) {
            return last;
        }
        return first;
    }

    private Map createTablesMap() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"createTablesMap", (String)"");
        }
        HashMap map = new HashMap();
        AlertDefinition alert = this.alertHeader.alert;
        if (alert.aldType == 7) {
            this.addCompToMap(map);
            this.addToMap(map, (short)2, "t_group", "group_id");
            this.addToMap(map, (short)3, "t_res_filesystem", "filesystem_id");
            this.addToMap(map, (short)99, "t_group", "group_id");
        } else if (alert.aldType == 6) {
            this.addCompToMap(map);
            this.addToMap(map, (short)99, "t_group", "group_id");
        } else if (alert.aldType == 20) {
            this.addToMap(map, (short)77, "t_group", "group_id");
            this.addToMap(map, (short)78, "t_res_storage_subsystem", "subsystem_id");
        } else if (alert.aldType == 31) {
            this.addToMap(map, (short)121, "t_res_switch", "SWITCH_ID");
            this.addToMap(map, (short)114, "t_res_fabric", "FABRIC_ID");
        } else if (alert.aldType == 30) {
            this.addToMap(map, (short)114, "t_res_fabric", "FABRIC_ID");
            this.addToMap(map, (short)127, "t_res_zone", "ZONE_ID");
            this.addToMap(map, (short)126, "t_res_zset", "ZSET_ID");
        } else if (alert.aldType == 32) {
            this.addToMap(map, (short)139, "t_res_phy_pe", "PHY_PE_ID");
            this.addToMap(map, (short)137, "t_res_port", "PORT_ID");
            this.addToMap(map, (short)138, "t_res_node", "NODE_ID");
            this.addToMap(map, (short)114, "t_res_fabric", "FABRIC_ID");
        }
        HashMap traceResult = map;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"createTablesMap", traceResult);
        }
        return traceResult;
    }

    private void addCompToMap(Map map) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"addCompToMap", (String)"map");
        }
        this.addToMap(map, (short)0, "t_group", "group_id");
        this.addToMap(map, (short)1, "t_stat_computer", "computer_id");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"addCompToMap");
        }
    }

    private void addToMap(Map map, short resourceType, String tableName, String idColumnName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AlertDefHndlr.class.getName(), (String)"addToMap", (String)"map, resourceType, tableName, idColumnName");
        }
        MutableInteger key = new MutableInteger((int)resourceType);
        String[] value = new String[]{tableName, idColumnName};
        map.put(key, value);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AlertDefHndlr.class.getName(), (String)"addToMap");
        }
    }
}

