/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TChartSettings;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;

public class ChartSettingsHndlr
implements RequestHandler {
    private Response response;
    private Connection dbc;
    private TChartSettings accessor;
    private GuiChartSettingsReq csr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ChartSettingsHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.response = Response.getResponse((short)0, null);
        if (!RequestChecker.isDesiredType(GuiChartSettingsReq.class, (Request)request, (Response)this.response)) {
            Response traceResult = this.response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ChartSettingsHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        this.csr = (GuiChartSettingsReq)request.requestData;
        this.dbc = Server.getConnection();
        if (this.dbc == null) {
            Server.setResponseError(this.response, "GEN0050E");
            Response traceResult = this.response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ChartSettingsHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        this.accessor = new TChartSettings(this.dbc);
        try {
            if (this.csr.reqType == 3) {
                this.delete();
                this.response.responseData = this.csr;
            } else if (this.csr.reqType == 4) {
                this.retrieve();
                this.response.responseData = this.csr;
            } else if (this.csr.reqType == 1) {
                this.insert();
                this.response.responseData = this.csr;
            } else if (this.csr.reqType == 2) {
                this.update();
                this.response.responseData = this.csr;
            } else if (this.csr.reqType == 5) {
                this.response.responseData = this.retrieveArrayByCreator();
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ChartSettingsHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            if (this.response.status <= 4) {
                this.response.status = (short)12;
            }
            this.response.errorMessage = e.getMessage();
        }
        finally {
            Server.returnConnection(this.dbc);
        }
        Response traceResult = this.response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ChartSettingsHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private Serializable retrieveArrayByCreator() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ChartSettingsHndlr.class.getName(), (String)"retrieve_array_by_creator", (String)"");
        }
        this.accessor = new TChartSettings(this.dbc);
        ArrayList al = this.accessor.select_all_by_creator(this.csr.creator);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ChartSettingsHndlr.class.getName(), (String)"retrieve_array_by_creator");
        }
        return al;
    }

    private void retrieve() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ChartSettingsHndlr.class.getName(), (String)"retrieve", (String)"");
        }
        this.accessor = new TChartSettings(this.dbc);
        this.csr.options = this.accessor.select(this.csr.reportId, this.csr.reportSubtype, this.csr.chartId, this.csr.chartSubtype, this.csr.creator, this.csr.batchId);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ChartSettingsHndlr.class.getName(), (String)"retrieve");
        }
    }

    private void insert() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ChartSettingsHndlr.class.getName(), (String)"insert", (String)"");
        }
        this.accessor.insert(this.csr.options, this.csr.reportId, this.csr.reportSubtype, this.csr.chartId, this.csr.chartSubtype, this.csr.creator, this.csr.batchId);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ChartSettingsHndlr.class.getName(), (String)"insert");
        }
    }

    private void update() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ChartSettingsHndlr.class.getName(), (String)"update", (String)"");
        }
        this.accessor.updateAll(this.csr.options, this.csr.reportId, this.csr.reportSubtype, this.csr.chartId, this.csr.chartSubtype, this.csr.creator, this.csr.batchId);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ChartSettingsHndlr.class.getName(), (String)"update");
        }
    }

    private void delete() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ChartSettingsHndlr.class.getName(), (String)"delete", (String)"");
        }
        this.accessor.delete(this.csr.reportId, this.csr.reportSubtype, this.csr.chartId, this.csr.chartSubtype, this.csr.creator, this.csr.batchId);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ChartSettingsHndlr.class.getName(), (String)"delete");
        }
    }
}

