/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.Report;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RaceConditionChecker;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TBatchReport;
import org.eclipse.aperi.repository.table.TSchedule;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiBatchReportHndlr
implements RequestHandler,
ThrowAway {
    private Report report;
    private Response response;
    private Connection dbc;
    static final String JOB_TYPE = "REPORT";
    static final String JOB_TYPE_LABEL = MessageLog.getMessageNoID((String)"STS0155L");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiBatchReportHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.response = Response.getResponse((short)0, null);
        if (RequestChecker.isDesiredType(Report.class, (Request)request, (Response)this.response)) {
            this.report = (Report)request.requestData;
            this.dbc = Server.getConnection();
            if (this.dbc == null) {
                this.response.errorMessage = MessageLog.getMessageNoID((String)"GEN0050E");
                this.response.status = (short)12;
            } else {
                String resourceName;
                boolean forRetrieve = this.report.isEmpty();
                if (this.report.ID <= 0) {
                    resourceName = null;
                } else {
                    resourceName = Integer.toString(this.report.ID);
                    byte lockType = forRetrieve ? (byte)2 : 1;
                    LockManager.lock((short)0, (String)JOB_TYPE, (String)resourceName, (byte)lockType, (boolean)true);
                }
                try {
                    if (forRetrieve) {
                        this.retrieve();
                    } else {
                        this.save();
                    }
                    this.response.responseData = this.report;
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiBatchReportHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    if (this.response.status <= 4) {
                        this.response.status = (short)12;
                    }
                    this.response.errorMessage = e.getMessage();
                }
                finally {
                    if (resourceName != null) {
                        LockManager.unLock((short)0, (String)JOB_TYPE, (String)resourceName);
                    }
                }
                Server.returnConnection(this.dbc);
            }
        }
        Response traceResult = this.response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiBatchReportHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private void retrieve() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiBatchReportHndlr.class.getName(), (String)"retrieve", (String)"");
        }
        TSchedule scheduleAccessor = new TSchedule(this.dbc);
        scheduleAccessor.retrieve((ScheduleHeader)this.report, JOB_TYPE);
        TBatchReport reportAccessor = new TBatchReport(this.dbc);
        this.report.batchReport = reportAccessor.selectByID(this.report.ID);
        TAlertDefinition alertAccessor = new TAlertDefinition(this.dbc);
        alertAccessor.prepSelectByID(false, false);
        this.report.alert = alertAccessor.getByID(this.report.ID);
        alertAccessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiBatchReportHndlr.class.getName(), (String)"retrieve");
        }
    }

    private void save() throws GeneralException {
        boolean rowExists;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiBatchReportHndlr.class.getName(), (String)"save", (String)"");
        }
        String checkerWarning = null;
        if (this.report.ID <= 0) {
            this.report.ID = StorageRepositoryAccessor.getIdentifier(1, 1, this.dbc);
            rowExists = false;
        } else {
            RaceConditionChecker checker = new RaceConditionChecker(this.dbc, "t_schedule", TSchedule.ID_COLUMN_NAME, (CreateHeader)this.report, JOB_TYPE_LABEL);
            checker.check();
            checkerWarning = checker.message;
            rowExists = !checker.wasDeleted;
            checker = null;
        }
        this.report.alertID = this.report.ID;
        TAlertDefinition alertAccessor = new TAlertDefinition(this.dbc);
        if (rowExists) {
            alertAccessor.deleteByID(this.report.alertID);
        }
        alertAccessor.insert((CreateHeader)this.report, this.report.alert);
        alertAccessor = null;
        this.report.batchReport.reportID = this.report.ID;
        TBatchReport reportAccessor = new TBatchReport(this.dbc);
        if (rowExists) {
            reportAccessor.delete(this.report.ID, false);
        }
        reportAccessor.insert(this.report.batchReport);
        reportAccessor = null;
        TSchedule scheduleAccessor = new TSchedule(this.dbc);
        if (rowExists) {
            scheduleAccessor.deleteByID(this.report.ID, JOB_TYPE_LABEL);
        }
        ScheduleQueue.routine.getHighRunNumber((ScheduleHeader)this.report);
        scheduleAccessor.insert((ScheduleHeader)this.report, JOB_TYPE_LABEL);
        scheduleAccessor.commitInsert();
        if (rowExists) {
            ScheduleQueue.routine.addEdit((ScheduleHeader)this.report);
        } else {
            ScheduleQueue.routine.addCreate((ScheduleHeader)this.report);
        }
        if (checkerWarning != null) {
            this.response.status = (short)4;
            this.response.errorMessage = checkerWarning;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiBatchReportHndlr.class.getName(), (String)"save");
        }
    }
}

