/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.aperi.TStorm.common.ProbePing;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListSaver;
import org.eclipse.aperi.repository.RaceConditionChecker;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResFabric;
import org.eclipse.aperi.repository.table.TResLibraries;
import org.eclipse.aperi.repository.table.TSchedule;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiProbeHndlr
implements RequestHandler,
ThrowAway {
    private String jobType;
    private String jobTypeLabel;
    private short resourceAttribute;
    public static final String PROBE_JOB_TYPE = "PROBE";
    public static final String PING_JOB_TYPE = "PING";
    public static final String NAQ_JOB_TYPE = "NETAPPQUOTA";
    public static final String PROBE_JOB_TYPE_LABEL = MessageLog.getMessageNoID((String)"STS0106L");
    public static final String PING_JOB_TYPE_LABEL = MessageLog.getMessageNoID((String)"STS0107L");
    public static final String NAQ_JOB_TYPE_LABEL = MessageLog.getMessageNoID((String)"NAS0007L");
    private ProbePing requestData;
    private Response response;
    private Connection dbc;

    private void retrieve() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiProbeHndlr.class.getName(), (String)"retrieve", (String)"");
        }
        TSchedule parentAccessor = new TSchedule(this.dbc);
        parentAccessor.retrieve((ScheduleHeader)this.requestData, this.jobTypeLabel);
        parentAccessor = null;
        int ID = this.requestData.ID;
        TStatComputer compAccessor = new TStatComputer(this.dbc);
        this.requestData.pbComputers = compAccessor.queryDependents(ID);
        compAccessor = null;
        TResDiskArray diskAccessor = new TResDiskArray(this.dbc);
        this.requestData.pbDiskArrays = diskAccessor.queryDependents(ID);
        diskAccessor = null;
        TResFabric fabricAccessor = new TResFabric();
        this.requestData.pbFabrics = fabricAccessor.queryDependents(ID);
        fabricAccessor = null;
        TResLibraries librariesAccessor = new TResLibraries();
        this.requestData.pbLibraries = librariesAccessor.queryDependents(ID);
        librariesAccessor = null;
        TResAttr accessor = new TResAttr(this.dbc);
        this.requestData.pbAllComputers = NameListSaver.allObjectsSelected(accessor, ID, this.resourceAttribute);
        this.requestData.pbComputerGroups = accessor.queryDependents("t_group", "group_id", ID, (short)0);
        this.requestData.pbClusters = accessor.queryDependents("t_group", "group_id", ID, (short)99);
        this.requestData.pbAllDiskArrays = NameListSaver.allObjectsSelected(accessor, ID, this.resourceAttribute, (short)54);
        this.requestData.pbDiskArrayGroups = accessor.queryDependents("t_group", "group_id", ID, (short)77);
        this.requestData.pbAllFabrics = NameListSaver.allObjectsSelected(accessor, ID, this.resourceAttribute, (short)115);
        this.requestData.pbFabricGroups = accessor.queryDependents("t_group", "group_id", ID, (short)113);
        this.requestData.pbAllLibraries = NameListSaver.allObjectsSelected(accessor, ID, this.resourceAttribute, (short)135);
        this.requestData.pbLibrariesGroups = accessor.queryDependents("t_group", "group_id", ID, (short)133);
        accessor = null;
        TAlertDefinition alertAccessor = new TAlertDefinition(this.dbc);
        alertAccessor.prepSelectByID(false, false);
        this.requestData.pbAlert = alertAccessor.getByID(this.requestData.ID);
        alertAccessor.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiProbeHndlr.class.getName(), (String)"retrieve");
        }
    }

    private void fillMap(Map map, short resourceType, String tableName, String idColumnName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiProbeHndlr.class.getName(), (String)"fillMap", (String)"map, resourceType, tableName, idColumnName");
        }
        MutableInteger key = new MutableInteger((int)resourceType);
        String[] value = new String[]{tableName, idColumnName};
        map.put(key, value);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiProbeHndlr.class.getName(), (String)"fillMap");
        }
    }

    private Map createTablesMap() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiProbeHndlr.class.getName(), (String)"createTablesMap", (String)"");
        }
        HashMap map = new HashMap();
        this.fillMap(map, (short)1, "t_stat_computer", "computer_id");
        this.fillMap(map, (short)0, "t_group", "group_id");
        this.fillMap(map, (short)78, "t_res_storage_subsystem", "subsystem_id");
        this.fillMap(map, (short)77, "t_group", "group_id");
        this.fillMap(map, (short)99, "t_group", "group_id");
        this.fillMap(map, (short)113, "t_group", "group_id");
        this.fillMap(map, (short)133, "t_group", "group_id");
        this.fillMap(map, (short)134, "t_res_tape_library", "tape_library_id");
        this.fillMap(map, (short)114, "t_res_fabric", "fabric_id");
        HashMap traceResult = map;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiProbeHndlr.class.getName(), (String)"createTablesMap", traceResult);
        }
        return traceResult;
    }

    private void save() throws GeneralException {
        boolean rowExists;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiProbeHndlr.class.getName(), (String)"save", (String)"");
        }
        String checkerWarning = null;
        ProbePing currentDefinition = new ProbePing(16);
        if (this.requestData.ID <= 0) {
            this.requestData.ID = StorageRepositoryAccessor.getIdentifier(1, 1, this.dbc);
            rowExists = false;
        } else {
            RaceConditionChecker checker = new RaceConditionChecker(this.dbc, "t_schedule", TSchedule.ID_COLUMN_NAME, (CreateHeader)this.requestData, this.jobTypeLabel);
            checker.check();
            checkerWarning = checker.message;
            rowExists = !checker.wasDeleted;
            checker = null;
            if (rowExists) {
                TResAttr accessor = new TResAttr(this.dbc);
                accessor.prepQueryByAttr();
                ResourceAttribute attr = new ResourceAttribute();
                attr.raAttributeID = this.requestData.ID;
                attr.raAttributeType = this.resourceAttribute;
                attr.raResourceType = 1;
                currentDefinition.pbComputers = accessor.getResAttr(attr);
                attr.raResourceType = 0;
                currentDefinition.pbComputerGroups = accessor.getResAttr(attr);
                attr.raResourceType = (short)13;
                currentDefinition.pbAllComputers = accessor.getResAttr(attr) != null;
                attr.raResourceType = (short)78;
                currentDefinition.pbDiskArrays = accessor.getResAttr(attr);
                attr.raResourceType = (short)77;
                currentDefinition.pbDiskArrayGroups = accessor.getResAttr(attr);
                attr.raResourceType = (short)54;
                currentDefinition.pbAllDiskArrays = accessor.getResAttr(attr) != null;
                attr.raResourceType = (short)99;
                currentDefinition.pbClusters = accessor.getResAttr(attr);
                attr.raResourceType = (short)114;
                currentDefinition.pbFabrics = accessor.getResAttr(attr);
                attr.raResourceType = (short)113;
                currentDefinition.pbFabricGroups = accessor.getResAttr(attr);
                attr.raResourceType = (short)115;
                currentDefinition.pbAllFabrics = accessor.getResAttr(attr) != null;
                attr.raResourceType = (short)134;
                currentDefinition.pbLibraries = accessor.getResAttr(attr);
                attr.raResourceType = (short)133;
                currentDefinition.pbLibrariesGroups = accessor.getResAttr(attr);
                attr.raResourceType = (short)135;
                currentDefinition.pbAllLibraries = accessor.getResAttr(attr) != null;
                accessor.closeSelect();
            }
        }
        this.requestData.alertID = this.requestData.ID;
        TAlertDefinition alertAccessor = new TAlertDefinition(this.dbc);
        if (rowExists) {
            alertAccessor.deleteByID(this.requestData.ID);
        }
        alertAccessor.insert((CreateHeader)this.requestData, this.requestData.pbAlert);
        alertAccessor = null;
        TSchedule parentAccessor = new TSchedule(this.dbc);
        if (rowExists) {
            parentAccessor.deleteByID(this.requestData.ID, this.jobTypeLabel);
        }
        ScheduleQueue.routine.getHighRunNumber((ScheduleHeader)this.requestData);
        parentAccessor.insert((ScheduleHeader)this.requestData, this.jobTypeLabel);
        parentAccessor = null;
        NameList[] newDef = new NameList[]{this.requestData.pbComputers, this.requestData.pbComputerGroups, this.requestData.pbDiskArrays, this.requestData.pbDiskArrayGroups, this.requestData.pbClusters, this.requestData.pbFabrics, this.requestData.pbFabricGroups, this.requestData.pbLibraries, this.requestData.pbLibrariesGroups};
        NameList[] oldDef = new NameList[]{currentDefinition.pbComputers, currentDefinition.pbComputerGroups, currentDefinition.pbDiskArrays, currentDefinition.pbDiskArrayGroups, currentDefinition.pbClusters, currentDefinition.pbFabrics, currentDefinition.pbFabricGroups, currentDefinition.pbLibraries, currentDefinition.pbLibrariesGroups};
        NameListSaver nlSaver = new NameListSaver(this.dbc, this.response);
        nlSaver.saveAllObjectsSelected(this.requestData.pbAllComputers, this.requestData.ID, this.resourceAttribute);
        nlSaver.saveAllObjectsSelected(this.requestData.pbAllDiskArrays, this.requestData.ID, this.resourceAttribute, (short)54);
        nlSaver.saveAllObjectsSelected(this.requestData.pbAllFabrics, this.requestData.ID, this.resourceAttribute, (short)115);
        nlSaver.saveAllObjectsSelected(this.requestData.pbAllLibraries, this.requestData.ID, this.resourceAttribute, (short)135);
        nlSaver.save((CreateHeader)this.requestData, this.jobTypeLabel, this.resourceAttribute, this.requestData.ID, newDef, oldDef, this.createTablesMap(), rowExists);
        if (rowExists) {
            ScheduleQueue.routine.addEdit((ScheduleHeader)this.requestData);
        } else {
            ScheduleQueue.routine.addCreate((ScheduleHeader)this.requestData);
        }
        if (TraceLogger.enableAudit) {
            String action = rowExists ? "Modify" : "Create";
            TraceLogger.auditMessage((String)GuiProbeHndlr.class.getName(), (String)"save()", (String)("\n Username=" + this.requestData.creator + " " + action + ". Definition type=" + this.jobType + ".  Name='" + this.requestData.getName() + "'"));
        }
        if (checkerWarning != null) {
            this.response.status = (short)4;
            this.response.errorMessage = checkerWarning;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiProbeHndlr.class.getName(), (String)"save");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        String resourceName;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiProbeHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.response = Response.getResponse((short)0, null);
        if (!RequestChecker.isDesiredType(ProbePing.class, (Request)request, (Response)this.response)) {
            Response traceResult = this.response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GuiProbeHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        this.requestData = (ProbePing)request.requestData;
        boolean forRetrieve = this.requestData.isEmpty();
        this.dbc = Server.getConnection();
        this.resourceAttribute = this.requestData.jobType;
        switch (this.resourceAttribute) {
            case 16: {
                this.jobType = PROBE_JOB_TYPE;
                this.jobTypeLabel = PROBE_JOB_TYPE_LABEL;
                break;
            }
            case 17: {
                this.jobType = PING_JOB_TYPE;
                this.jobTypeLabel = PING_JOB_TYPE_LABEL;
            }
        }
        if (this.requestData.ID <= 0) {
            resourceName = null;
        } else {
            resourceName = Integer.toString(this.requestData.ID);
            byte lockType = forRetrieve ? (byte)2 : 1;
            LockManager.lock((short)0, (String)this.jobType, (String)resourceName, (byte)lockType, (boolean)true);
        }
        try {
            if (forRetrieve) {
                this.retrieve();
            } else {
                this.save();
            }
            this.response.responseData = this.requestData;
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiProbeHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            if (this.response.status <= 4) {
                this.response.status = (short)12;
            }
            this.response.errorMessage = e.getMessage();
        }
        finally {
            if (resourceName != null) {
                LockManager.unLock((short)0, (String)this.jobType, (String)resourceName);
            }
            Server.returnConnection(this.dbc);
        }
        Response traceResult = this.response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiProbeHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }
}

