/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.table.TResDevAccess;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.PartitionedReport;
import org.eclipse.aperi.server.handler.PartitionedDataProvider;
import org.eclipse.aperi.server.handler.StormReportHndlr;
import org.eclipse.aperi.server.svp.AgentSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiReportHndlr
implements RequestHandler,
ThrowAway,
StormReportHndlr {
    Transceiver transceiver;
    Request request;
    Response response;

    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiReportHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.transceiver = transceiver;
        this.request = request;
        this.response = Response.getResponse((short)0, null);
        if (!RequestChecker.isDesiredType(GuiReportReq.class, (Request)request, (Response)this.response)) {
            Response traceResult = this.response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GuiReportHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        GuiReportReq grr = (GuiReportReq)request.requestData;
        Connection dbc = Server.getConnection();
        if (dbc == null) {
            Server.setResponseError(this.response, "GEN0050E");
            Response traceResult = this.response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GuiReportHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        if (grr.idSubtype > 0) {
            GuiListReq glr = new GuiListReq();
            glr.listRequested = 10000;
            NameListQueryable accessor = null;
            switch (grr.idSubtype) {
                case 14: {
                    ++glr.listRequested;
                    glr.groupID = -1;
                    glr.qualifierID = grr.grrID1;
                    accessor = new TStatComputer(dbc);
                    break;
                }
                case 13: 
                case 82: {
                    glr.listRequested = 0;
                    glr.groupID = grr.grrID1;
                    glr.includeUnmanaged = true;
                    accessor = new TStatComputer(dbc);
                    break;
                }
                case 12: {
                    if (grr.reportSubtype == 10) {
                        glr.listRequested += 3;
                        glr.computerID = grr.grrID1;
                        glr.groupID = -1;
                        accessor = new TResFS(dbc);
                        break;
                    }
                    if (grr.reportSubtype == 28) {
                        grr.selectedResources = new int[1];
                        grr.selectedResources[0] = grr.grrID1;
                        break;
                    }
                    glr.listRequested += 10;
                    glr.computerID = grr.grrID1;
                    glr.controllerID = -1;
                    accessor = new TResDevAccess(dbc);
                }
            }
            if (accessor != null) {
                NameList nameList = null;
                try {
                    nameList = accessor.selectNames(glr);
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiReportHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(this.response, (Exception)((Object)e));
                    Server.returnConnection(dbc);
                    Response traceResult = this.response;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)GuiReportHndlr.class.getName(), (String)"handle", (Object)traceResult);
                    }
                    return traceResult;
                }
                if (nameList == null) {
                    grr.selectedResources = new int[1];
                    grr.selectedResources[0] = Integer.MAX_VALUE;
                } else {
                    int i = 0;
                    NameList nl = nameList;
                    while (nl != null) {
                        ++i;
                        nl = nl.nlNext;
                    }
                    grr.selectedResources = new int[i];
                    nl = nameList;
                    while (nl != null) {
                        grr.selectedResources[--i] = nl.nlID;
                        nl = nl.nlNext;
                    }
                }
            }
        }
        GuiDataProvider dataProvider = null;
        PartitionedDataProvider pDataProvider = null;
        try {
            Class<?> rClass = Class.forName(GuiReportReq.guiClasses[grr.reportType][1]);
            Class[] argdef = new Class[]{Connection.class};
            Constructor<?> constr = rClass.getConstructor(argdef);
            Object[] args = new Object[]{dbc};
            if (PartitionedDataProvider.class.isAssignableFrom(rClass)) {
                pDataProvider = (PartitionedDataProvider)constr.newInstance(args);
            } else {
                dataProvider = (GuiDataProvider)constr.newInstance(args);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiReportHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            Object[] args = new Object[]{new Integer(grr.reportType), new Integer(grr.reportSubtype)};
            Server.setResponseError(this.response, "GEN0125E", args);
        }
        catch (Exception e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiReportHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            System.err.println(e);
            e.printStackTrace();
            Server.setResponseError(this.response, e);
        }
        try {
            if (dataProvider != null) {
                this.response.responseData = dataProvider.getReportData(grr);
            } else if (pDataProvider != null) {
                pDataProvider.getReportData(grr, this);
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiReportHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            if (this.response == null) {
                String title = GuiReportReq.guiClasses[grr.reportType][2];
                MessageLog.logException((String)"STG4158E", (Exception)((Object)e), (Object)title);
            }
            Server.setResponseError(this.response, (Exception)((Object)e));
        }
        Server.returnConnection(dbc);
        Response traceResult = this.response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiReportHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    public void transmitReportData(PartitionedReport pr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiReportHndlr.class.getName(), (String)"transmitReportData", (String)"pr");
        }
        this.response.responseData = pr;
        if (!pr.prLastPart) {
            this.response.status = (short)4;
            Object[] args = new Object[]{Integer.toString(AgentSvp.reportRowLimit)};
            this.response.errorMessage = MessageLog.getMessage((String)"STS0156W", (Object[])args);
        }
        this.transceiver.transmitResponse(this.request, this.response);
        this.response.returnResponse();
        this.response = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiReportHndlr.class.getName(), (String)"transmitReportData");
        }
    }
}

