/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import org.eclipse.aperi.TStorm.server.guireq.GuiUpdateReq;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TStatDisk;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;

public class GuiUpdateHndlr
implements RequestHandler,
ThreadSafe {
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiUpdateHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (!RequestChecker.isDesiredType(GuiUpdateReq.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GuiUpdateHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        GuiUpdateReq gur = (GuiUpdateReq)request.requestData;
        Connection dbc = Server.getConnection();
        if (dbc == null) {
            Server.setResponseError(response, "GEN0050E");
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GuiUpdateHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        if (gur.gurType == 1) {
            try {
                new TStatDisk(dbc).updateDiskDesiredSettings(gur.gurDisk);
            }
            catch (GeneralException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)GuiUpdateHndlr.class.getName(), (String)"handle", (Throwable)e);
                }
                Server.setResponseError(response, (Exception)((Object)e));
            }
        }
        Server.returnConnection(dbc);
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiUpdateHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }
}

