/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import org.eclipse.aperi.TStorm.server.guireq.GuiSavedReportReq;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TSavedReport;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;

public class SavedReportHndlr
implements RequestHandler,
ThrowAway {
    private GuiSavedReportReq savedReport;
    private NameList deleteReport;
    private Response response;
    private Connection dbc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SavedReportHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.response = Response.getResponse((short)0, null);
        if (request.requestData instanceof GuiSavedReportReq) {
            this.savedReport = (GuiSavedReportReq)request.requestData;
        } else if (request.requestData instanceof NameList) {
            this.deleteReport = (NameList)request.requestData;
        } else {
            RequestChecker.isDesiredType(GuiSavedReportReq.class, (Request)request, (Response)this.response);
            Response traceResult = this.response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)SavedReportHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        this.dbc = Server.getConnection();
        try {
            if (this.deleteReport != null) {
                this.delete();
            } else if (this.savedReport.grr == null) {
                this.retrieve();
                this.response.responseData = this.savedReport;
            } else {
                this.save();
                this.response.responseData = this.savedReport;
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)SavedReportHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            if (this.response.status <= 4) {
                this.response.status = (short)12;
            }
            this.response.errorMessage = e.getMessage();
        }
        finally {
            Server.returnConnection(this.dbc);
        }
        Response traceResult = this.response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SavedReportHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private void retrieve() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SavedReportHndlr.class.getName(), (String)"retrieve", (String)"");
        }
        TSavedReport accessor = new TSavedReport(this.dbc);
        this.savedReport = accessor.selectByID(this.savedReport.ID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SavedReportHndlr.class.getName(), (String)"retrieve");
        }
    }

    private void save() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SavedReportHndlr.class.getName(), (String)"save", (String)"");
        }
        TSavedReport accessor = new TSavedReport(this.dbc);
        if (this.savedReport.ID <= 0) {
            this.savedReport.ID = StorageRepositoryAccessor.getIdentifier(1, 1, this.dbc);
        } else {
            accessor.delete(this.savedReport.ID, false);
        }
        accessor.insert(this.savedReport);
        accessor.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SavedReportHndlr.class.getName(), (String)"save");
        }
    }

    private void delete() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)SavedReportHndlr.class.getName(), (String)"delete", (String)"");
        }
        TSavedReport accessor = new TSavedReport(this.dbc);
        accessor.delete(this.deleteReport.nlID, true);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)SavedReportHndlr.class.getName(), (String)"delete");
        }
    }
}

