/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.aperi.agent.req.AgentStatusReq;
import org.eclipse.aperi.agent.req.AgtStatusResp;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.SchHistoryRequestNode;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.VMTransceiver;
import org.eclipse.aperi.server.handler.scheduler.JobHndlr;
import org.eclipse.aperi.server.handler.scheduler.ScheduleGuiHandler;
import org.eclipse.aperi.xmsg.MessageLog;

public class UpdateJobStatusHndlr
implements RequestHandler,
ThrowAway {
    int schedID;
    Connection connection;
    ResultSet results;
    Statement statement;
    String errorMessage;
    int numberSubmitted;
    ArrayList agtList = new ArrayList(20);

    public Response handle(Request request, Transceiver transceiver) {
        HashMap confirmedJobs;
        AgentData ag;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UpdateJobStatusHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        Response response = Response.getResponse((short)0, null);
        SchHistoryRequestNode reqNode = (SchHistoryRequestNode)request.requestData;
        this.schedID = reqNode.queryID;
        this.connection = Server.getConnection();
        if (this.connection == null) {
            Server.setResponseError(response, "GEN0050E");
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UpdateJobStatusHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        try {
            this.getAgents(reqNode, this.agtList);
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)UpdateJobStatusHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            if (this.connection != null) {
                Server.returnConnection(this.connection);
                this.connection = null;
            }
            response.status = (short)12;
            response.errorMessage = e.getMessage();
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UpdateJobStatusHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        Request agtRequest = new Request();
        agtRequest.typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
        agtRequest.serviceName = RequestTypeManager.getInternalName((String)request.typeCode);
        agtRequest.subType = "org.eclipse.aperi.agent.handler.status.StatusHandler";
        agtRequest.requestData = new AgentStatusReq(true);
        AgentManager agtMgr = Server.getAgentManager();
        for (int i = 0; i < this.agtList.size(); ++i) {
            ag = (AgentData)this.agtList.get(i);
            int agentID = ag.agtId;
            if (agentID > 0) {
                Response agtResponse = agtMgr.transmitToAgent(agtRequest, null, agentID, false);
                if (agtResponse != null) {
                    if (agtResponse.status == 0) {
                        AgtStatusResp agtResp;
                        ag.agtResponse = agtResp = (AgtStatusResp)agtResponse.responseData;
                        continue;
                    }
                    response.errorMessage = agtResponse.errorMessage;
                    response.status = (short)4;
                    continue;
                }
                response.errorMessage = MessageLog.getMessage((String)"JSS0052L");
                response.status = (short)4;
                continue;
            }
            Iterator iter = ag.agtRunJobs.values().iterator();
            while (iter.hasNext()) {
                AgentRunJobs ar = (AgentRunJobs)iter.next();
                Integer k = new Integer(ar.jobRunNumber);
                if (!JobHndlr.runningOrNot(k)) continue;
                iter.remove();
            }
        }
        for (int j = 0; j < this.agtList.size(); ++j) {
            ag = (AgentData)this.agtList.get(j);
            AgtStatusResp agentResp = ag.agtResponse;
            if (ag.agtId <= 0 || agentResp == null || agentResp.jobs == null) continue;
            Set jobSet = agentResp.jobs;
            for (StartedJob job : jobSet) {
                Integer jrn = new Integer(job.getRunNumber());
                ag.agtRunJobs.remove(jrn);
            }
        }
        try {
            confirmedJobs = this.confirmJobs(reqNode);
        }
        catch (GeneralException e) {
            if (this.connection != null) {
                Server.returnConnection(this.connection);
                this.connection = null;
            }
            response.status = (short)12;
            response.errorMessage = e.getMessage();
            return response;
        }
        if (confirmedJobs != null && confirmedJobs.size() != 0) {
            for (int k = 0; k < this.agtList.size(); ++k) {
                AgentData agd = (AgentData)this.agtList.get(k);
                if (agd.agtResponse == null && agd.agtId >= 0) continue;
                for (AgentRunJobs ar : agd.agtRunJobs.values()) {
                    if (!confirmedJobs.containsKey(new Integer(ar.jobRunNumber))) continue;
                    JobRun jr = new JobRun();
                    jr.setRunNumber(ar.jobRunNumber);
                    jr.setSchedRunNumber(ar.schedRunNumber);
                    StartedJob sj = new StartedJob(jr);
                    sj.setExitCode(40);
                    sj.setJobStatus((byte)67);
                    sj.setPid(-1);
                    sj.setStarted(-1L);
                    Date now = new Date();
                    sj.setFinished(now.getTime());
                    sj.setLogFileName(ar.logFileName);
                    Request schedReq = new Request();
                    schedReq.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
                    schedReq.subType = "org.eclipse.aperi.server.handler.scheduler.ScheduleHandler";
                    schedReq.serviceName = RequestTypeManager.getInternalName((String)schedReq.typeCode);
                    schedReq.userName = null;
                    schedReq.requestData = sj;
                    schedReq.flags = (byte)2;
                    VMTransceiver schedTransceiver = new VMTransceiver();
                    Response schedResponse = schedTransceiver.transmitRequest(schedReq, sj);
                    if (schedResponse != null && schedResponse.status == 12) {
                        this.errorMessage = schedResponse.errorMessage;
                    }
                    schedTransceiver.close();
                }
            }
        }
        try {
            this.clearOldRuns(reqNode);
        }
        catch (GeneralException e) {
            if (this.connection != null) {
                Server.returnConnection(this.connection);
                this.connection = null;
            }
            response.status = (short)12;
            response.errorMessage = e.getMessage();
            return response;
        }
        response.responseData = this.refreshNodes(reqNode);
        if (this.connection != null) {
            Server.returnConnection(this.connection);
            this.connection = null;
        }
        if (this.errorMessage != null) {
            response.status = (short)12;
            response.errorMessage = this.errorMessage;
            this.errorMessage = null;
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UpdateJobStatusHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private NameList refreshNodes(SchHistoryRequestNode schedNode) {
        NameList nlNodes;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UpdateJobStatusHndlr.class.getName(), (String)"refreshNodes", (String)"schedNode");
        }
        ScheduleGuiHandler schGuihndlr = new ScheduleGuiHandler();
        NameList traceResult = nlNodes = schGuihndlr.getNodes(this.connection, schedNode);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UpdateJobStatusHndlr.class.getName(), (String)"refreshNodes", (Object)traceResult);
        }
        return traceResult;
    }

    private void getAgents(SchHistoryRequestNode queryNode, ArrayList aList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UpdateJobStatusHndlr.class.getName(), (String)"getAgents", (String)"queryNode, aList");
        }
        try {
            String stmt = "select t.computer_id, t.job_run_number, r.run_number, t.log_file_name from      t_runs    r ,                  t_run_jobs    t      where     r.schedule_id   =    " + Integer.toString(queryNode.queryID) + "      and r.status   = '" + Integer.toString(2) + "' " + "      and r.schedule_id = t.schedule_id " + "      and r.run_number = t.sid_run_number " + "      and t.submit_status  =  " + Integer.toString(-1) + " order by  t.computer_id ";
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(stmt);
            int prev_agt = 0;
            AgentData ad = null;
            while (this.results.next()) {
                int cur_agt = this.results.getInt(1);
                if (prev_agt != cur_agt) {
                    ad = new AgentData();
                    aList.add(ad);
                }
                ad.agtId = cur_agt;
                AgentRunJobs arj = new AgentRunJobs();
                arj.jobRunNumber = this.results.getInt(2);
                arj.schedRunNumber = this.results.getInt(3);
                arj.logFileName = this.results.getString(4);
                Integer i = new Integer(arj.jobRunNumber);
                ad.agtRunJobs.put(i, arj);
                prev_agt = cur_agt;
            }
            if (this.statement != null) {
                this.statement.close();
                this.statement = null;
            }
        }
        catch (SQLException e1) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)UpdateJobStatusHndlr.class.getName(), (String)"getAgents", (Throwable)e1);
            }
            try {
                if (this.statement != null) {
                    this.statement.close();
                    this.statement = null;
                }
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            Object[] args = new Object[]{"t_run_jobs"};
            this.errorMessage = SQLUtil.getSQLExceptionMsg("SRV0082E", e1, args);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UpdateJobStatusHndlr.class.getName(), (String)"getAgents");
            }
            throw new GeneralException(this.errorMessage);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UpdateJobStatusHndlr.class.getName(), (String)"getAgents");
        }
    }

    private HashMap confirmJobs(SchHistoryRequestNode queryNode) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UpdateJobStatusHndlr.class.getName(), (String)"confirmJobs", (String)"queryNode");
        }
        HashMap<Integer, Integer> jobNumbers = new HashMap<Integer, Integer>();
        try {
            String stmt = "select t.job_run_number from      t_runs    r ,                  t_run_jobs    t      where     r.schedule_id   =    " + Integer.toString(queryNode.queryID) + "      and r.status   = '" + Integer.toString(2) + "' " + "      and r.schedule_id = t.schedule_id " + "      and r.run_number = t.sid_run_number " + "      and t.submit_status  =  " + Integer.toString(-1);
            this.statement = this.connection.createStatement();
            this.results = this.statement.executeQuery(stmt);
            while (this.results.next()) {
                int jobRunNo = this.results.getInt(1);
                Integer i = new Integer(jobRunNo);
                jobNumbers.put(i, i);
            }
            if (this.statement != null) {
                this.statement.close();
                this.statement = null;
            }
        }
        catch (SQLException e1) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)UpdateJobStatusHndlr.class.getName(), (String)"confirmJobs", (Throwable)e1);
            }
            try {
                if (this.statement != null) {
                    this.statement.close();
                    this.statement = null;
                }
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            Object[] args = new Object[]{"t_run_jobs"};
            this.errorMessage = SQLUtil.getSQLExceptionMsg("SRV0082E", e1, args);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UpdateJobStatusHndlr.class.getName(), (String)"confirmJobs");
            }
            throw new GeneralException(this.errorMessage);
        }
        HashMap<Integer, Integer> traceResult = jobNumbers;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UpdateJobStatusHndlr.class.getName(), (String)"confirmJobs", traceResult);
        }
        return traceResult;
    }

    private void clearOldRuns(SchHistoryRequestNode queryNode) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)UpdateJobStatusHndlr.class.getName(), (String)"clearOldRuns", (String)"queryNode");
        }
        long schedulerStartTime = SchCommon.startMillis;
        long finishTime = 0L;
        try {
            finishTime = SQLUtil.getTimestamp(this.connection).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)AgentRunJobs.class.getName(), (String)"clearOldRuns", (Throwable)e);
            }
            return;
        }
        try {
            String stmt = " update t_runs  set status = '" + Integer.toString(0) + "' " + " , finish_time = " + finishTime + "  where t_runs.schedule_id = " + Integer.toString(queryNode.queryID) + "  and t_runs.status = '" + Integer.toString(2) + "' " + "  and t_runs.time_stamp < " + schedulerStartTime + "  and t_runs.number_jobs >  (select count(*) from t_run_jobs j " + "                where j.schedule_id = t_runs.schedule_id " + "                and j.sid_run_number = t_runs.run_number )" + "  and not exists (select 1 from t_run_jobs j " + "      where  j.schedule_id = t_runs.schedule_id " + "      and j.sid_run_number = t_runs.run_number " + "      and j.submit_status = " + Integer.toString(-1) + " ) ";
            this.statement = this.connection.createStatement();
            this.statement.executeUpdate(stmt);
            this.connection.commit();
            if (this.statement != null) {
                this.statement.close();
                this.statement = null;
            }
        }
        catch (SQLException e1) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)UpdateJobStatusHndlr.class.getName(), (String)"clearOldRuns", (Throwable)e1);
            }
            try {
                if (this.statement != null) {
                    this.statement.close();
                    this.statement = null;
                }
            }
            catch (SQLException ignored) {
                // empty catch block
            }
            Object[] args = new Object[]{"update", "t_runs", "UpdateJobStatusHndlr.clearOldRuns"};
            String errorMessage = SQLUtil.getSQLExceptionMsg("JSS0009E", e1, args);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)UpdateJobStatusHndlr.class.getName(), (String)"clearOldRuns");
            }
            throw new GeneralException(errorMessage);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)UpdateJobStatusHndlr.class.getName(), (String)"clearOldRuns");
        }
    }

    private static class AgentData {
        public int agtId;
        public HashMap agtRunJobs = new HashMap();
        public AgtStatusResp agtResponse;

        private AgentData() {
        }
    }

    private static class AgentRunJobs {
        public int jobRunNumber;
        public int schedRunNumber;
        public String logFileName;

        private AgentRunJobs() {
        }
    }
}

