/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.fabric;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.common.dbaccess.HostAgentPingDbAccess;
import org.eclipse.aperi.common.dbaccess.ViewReportTablesUpdater;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.guireq.InbandFabricAgentInfo;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.jobs.Ping;
import org.eclipse.aperi.xmsg.MessageLog;

public class InBandFabricAgentHandler
implements RequestHandler,
ThreadSafe {
    public static final String INBAND_FABRIC_AGENT_LOG_NAME = "msgAperiDeviceAgent.log";

    private void log(String logmessage) {
        if (TraceLogger.enableTrace) {
            TraceLogger.traceMessage((int)3, (String)"InBandFabricAgentHandler", (String)"log", (String)logmessage);
        }
    }

    private void setResponseError(Response response, String logmessage, String localizedMessage) {
        this.log(logmessage);
        response.responseData = null;
        response.status = (short)12;
        response.errorMessage = logmessage;
        if (localizedMessage != null) {
            response.errorMessage = localizedMessage;
        }
        if (response.errorMessage == null) {
            response.errorMessage = "";
        }
    }

    private String getExceptionMessage(Exception e) {
        String message = "NO MESSAGE";
        if (e instanceof SRMRuntimeException) {
            message = ((SRMRuntimeException)e).getLocalizedMessage();
        } else if (e.getMessage() == null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                message = "[" + sw.toString() + "]";
            }
            catch (Exception exception) {
                // empty catch block
            }
            message = "exception thrown " + e.getClass().getName() + " " + message;
        } else {
            message = e.getMessage();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getHBATable(InbandFabricAgentInfo ifai) {
        String query = FabricDbAccess.GET_HBA_TABLE_INFO_STRING + ifai.hostId;
        Connection con = Server.getConnection();
        if (con != null) {
            try {
                PreparedStatement selectStmt = con.prepareStatement(query.toString());
                ResultSet resultSet = selectStmt.executeQuery();
                while (resultSet.next()) {
                    ifai.addHBA(resultSet.getString(1), new Integer(resultSet.getInt(2)).toString(), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getString(6));
                }
            }
            catch (SQLException e) {
                this.log("getHBATable hba query failed:" + query + " " + this.getExceptionMessage(e));
            }
            finally {
                Server.returnConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)InBandFabricAgentHandler.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (!RequestChecker.isDesiredType(InbandFabricAgentInfo.class, (Request)request, (Response)(response = Response.getResponse((short)12, null)))) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)InBandFabricAgentHandler.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        InbandFabricAgentInfo ibai = (InbandFabricAgentInfo)request.requestData;
        if (ibai.request_type == 1) {
            response.responseData = ibai;
            int hostId = ibai.hostId;
            String buf = "SELECT T_RES_DEVICE_AGENT.DEVICE_AGENT_ID, T_RES_DEVICE_AGENT.STATUS, T_RES_HOST.IP_ADDRESS, T_RES_HOST.HOST_NAME, T_RES_HOST.OS_TYPE, T_STAT_COMPUTER.OS_VERSION FROM T_RES_DEVICE_AGENT AS T_RES_DEVICE_AGENT, T_RES_HOST AS T_RES_HOST LEFT OUTER JOIN T_STAT_COMPUTER AS T_STAT_COMPUTER ON ( T_STAT_COMPUTER.COMPUTER_ID = T_RES_HOST.COMPUTER_ID ) WHERE T_RES_DEVICE_AGENT.HOST_ID = T_RES_HOST.COMPUTER_ID AND T_RES_DEVICE_AGENT.DEVICE_AGENT_ID=" + hostId;
            Connection con = Server.getConnection();
            if (con != null) {
                try {
                    PreparedStatement selectStmt = con.prepareStatement(buf.toString());
                    ResultSet resultSet = selectStmt.executeQuery();
                    int nres = 0;
                    while (resultSet.next()) {
                        ibai.hostId = resultSet.getInt(1);
                        ibai.status = FabricDbAccess.agentStateToByte((String)resultSet.getString(2));
                        ibai.ipaddress = resultSet.getString(3);
                        ibai.hostname = resultSet.getString(4);
                        int ostype = resultSet.getInt(5);
                        String osversion = resultSet.getString(6);
                        if (osversion == null) {
                            osversion = "";
                        }
                        ibai.OperatingSystemAndVersion = MessageLog.getMessageNoID((String)Constants.OSTYPES[ostype]) + " " + osversion;
                        this.getHBATable(ibai);
                        ++nres;
                    }
                    response.status = 0;
                }
                catch (SQLException e) {
                    this.setResponseError(response, "REQUEST_GET_INFO sql error:" + e.getMessage() + " statement: " + buf, this.getExceptionMessage(e));
                    Response traceResult = response;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)InBandFabricAgentHandler.class.getName(), (String)"handle", (Object)traceResult);
                    }
                    Response nres = response;
                    return nres;
                }
                finally {
                    Server.returnConnection(con);
                }
            }
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)InBandFabricAgentHandler.class.getName(), (String)"handle", (Object)traceResult);
            }
            return response;
        }
        if (ibai.request_type == 2) {
            response.responseData = ibai;
            Response traceResult = response;
            Connection connection = Server.getConnection();
            Statement statement = null;
            ResultSet resultSet = null;
            int id = ibai.hostId;
            String buf = "select host_id from t_res_device_agent where device_agent_id = " + id;
            try {
                int computerID;
                int rc;
                statement = connection.createStatement();
                resultSet = statement.executeQuery(buf.toString());
                if (resultSet.next() && (rc = statement.executeUpdate((buf = FabricDbAccess.getRemoveHostString((int)(computerID = resultSet.getInt(1)))).toString())) > 0) {
                    new ViewReportTablesUpdater().deleteDependentViews("host", String.valueOf(computerID));
                }
                buf = "delete from t_res_device_agent where device_agent_id = " + id;
                statement.executeUpdate(buf.toString());
                connection.commit();
                response.status = 0;
            }
            catch (SQLException e) {
                this.setResponseError(response, "REQUEST_REMOVE_AGENT sql error:" + e.getMessage() + " statement: " + statement, this.getExceptionMessage(e));
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException ignored) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException ignored) {}
                }
                Server.returnConnection(connection);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)InBandFabricAgentHandler.class.getName(), (String)"handle", (Object)traceResult);
            }
            return response;
        }
        if (ibai.request_type == 3) {
            int id = ibai.hostId;
            int nres = 0;
            int host_id = 0;
            String buf = "SELECT T_RES_DEVICE_AGENT.STATUS, T_RES_HOST.COMPUTER_ID FROM T_RES_DEVICE_AGENT AS T_RES_DEVICE_AGENT, T_RES_HOST AS T_RES_HOST WHERE T_RES_DEVICE_AGENT.HOST_ID = T_RES_HOST.COMPUTER_ID AND T_RES_DEVICE_AGENT.DEVICE_AGENT_ID = " + id;
            Connection con = Server.getConnection();
            if (con != null) {
                try {
                    PreparedStatement selectStmt = con.prepareStatement(buf.toString());
                    ResultSet resultSet = selectStmt.executeQuery();
                    while (resultSet.next()) {
                        ibai.status = FabricDbAccess.agentStateToByte((String)resultSet.getString(1));
                        host_id = resultSet.getInt(2);
                        ++nres;
                    }
                    if (nres == 0) {
                        this.setResponseError(response, "REQUEST_CHECK_AGENT query [" + buf + "] failed hostId=" + id + " returned no matching values. The agent has not been found. ", null);
                        ibai.message_status = 2;
                    } else {
                        response.status = 0;
                    }
                }
                catch (SQLException e) {
                    this.setResponseError(response, "REQUEST_CHECK_AGENT query [" + buf + "] failed hostId=" + id + " nres = " + nres + " exception:" + e, this.getExceptionMessage(e));
                    Response traceResult = response;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)InBandFabricAgentHandler.class.getName(), (String)"handle", (Object)traceResult);
                    }
                    Response response2 = response;
                    return response2;
                }
                finally {
                    Server.returnConnection(con);
                }
            }
            int pingStatus = 0;
            int status = Ping.pingHostByName(ibai.hostname);
            switch (status) {
                case 0: {
                    pingStatus = 1;
                    break;
                }
                default: {
                    pingStatus = 0;
                }
            }
            HostAgentPingDbAccess.updateHostStatus((int)host_id, (int)pingStatus);
            response.responseData = ibai;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)InBandFabricAgentHandler.class.getName(), (String)"handle", (int)0);
            }
            return response;
        }
        if (ibai.request_type == 4) {
            response.responseData = ibai;
            Response traceResult = response;
            ibai.agentData.name = INBAND_FABRIC_AGENT_LOG_NAME;
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            ReadLogResponse logResponse = new ReadLogResponse();
            IJobMgmtService iService = (IJobMgmtService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IJobMgmtService.class, (String)"FabricManagerService");
            if (iService == null) {
                this.setResponseError(response, "REQUEST_VIEW_AGENT_LOG Bind to IFabricManagerService on device server failed on host: " + dr.deviceServerHost + " port: " + dr.deviceServerPort + " ", null);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)InBandFabricAgentHandler.class.getName(), (String)"handle", (int)0);
                }
                return response;
            }
            try {
                logResponse = iService.getLog(ibai.hostId, ibai.agentData.name, ibai.agentData.direction, ibai.agentData.position, ibai.agentData.linesDesired);
                response.status = 0;
                response.responseData = logResponse;
            }
            catch (Exception e) {
                this.setResponseError(response, "GEN7061E " + e.getMessage(), this.getExceptionMessage(e));
            }
            finally {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)InBandFabricAgentHandler.class.getName(), (String)"handle", (Object)traceResult);
                }
            }
            return response;
        }
        ibai.status = 1;
        response.responseData = ibai;
        Response traceResult = response;
        Server.setResponseError(response, "unknown request type " + ibai.request_type);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)InBandFabricAgentHandler.class.getName(), (String)"handle", (Object)traceResult);
        }
        return response;
    }
}

