/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.fabric;

import java.sql.SQLException;
import java.util.HashMap;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.fabric.interfaces.IFabricInternalService;
import org.eclipse.aperi.fabric.interfaces.InvalidTokenException;
import org.eclipse.aperi.fabric.interfaces.ResourceLockedException;
import org.eclipse.aperi.fabric.interfaces.ResourceNotAvailableException;
import org.eclipse.aperi.gui.fabric.zone.GuiZoneConstants;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;

public class ZoneRequestHandler
implements RequestHandler,
ThrowAway {
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        String methodName;
        block31: {
            methodName = "handle";
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)"request, transceiver");
            }
            HashMap reqData = (HashMap)request.requestData;
            response = Response.getResponse((short)0, null);
            try {
                if (reqData.containsKey(GuiZoneConstants.GET_SANS)) {
                    HashMap<String, HashMap[]> hashMap = new HashMap<String, HashMap[]>();
                    hashMap.put(GuiZoneConstants.GET_SANS, this.getSans());
                    response.responseData = hashMap;
                } else if (reqData.containsKey(GuiZoneConstants.POPULATE_ACTIVEZONEDEF)) {
                    String sanWWN = (String)reqData.get(GuiZoneConstants.POPULATE_ACTIVEZONEDEF);
                    HashMap<String, ZoneDefinition> hashMap = new HashMap<String, ZoneDefinition>();
                    hashMap.put(GuiZoneConstants.POPULATE_ACTIVEZONEDEF, this.getZoneDefinition(sanWWN, true));
                    response.responseData = hashMap;
                } else if (reqData.containsKey(GuiZoneConstants.POPULATE_ZONEDEF)) {
                    String sanWWN = (String)reqData.get(GuiZoneConstants.POPULATE_ZONEDEF);
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    ZoneDefinition zDef = this.getZoneDefinition(sanWWN, false);
                    hashMap.put(GuiZoneConstants.POPULATE_ZONEDEF, zDef);
                    hashMap.put(GuiZoneConstants.NONSTD_ZONES, this.getNonStdZones(sanWWN, zDef));
                    response.responseData = hashMap;
                } else if (reqData.containsKey("pingZoneAgent")) {
                    String sanWWN = (String)reqData.get("pingZoneAgent");
                    HashMap hashMap = this.ping(sanWWN);
                    response.responseData = hashMap;
                } else if (reqData.containsKey(GuiZoneConstants.ZM_SWITCHES)) {
                    String sanWWN = (String)reqData.get(GuiZoneConstants.ZM_SWITCHES);
                    HashMap<String, HashMap[]> hashMap = new HashMap<String, HashMap[]>();
                    hashMap.put(GuiZoneConstants.ZM_SWITCHES, this.getSwitchMembers(sanWWN));
                    response.responseData = hashMap;
                } else if (reqData.containsKey(GuiZoneConstants.ZM_DEVICE)) {
                    String sanWWN = (String)reqData.get(GuiZoneConstants.ZM_DEVICE);
                    HashMap<String, HashMap[]> hashMap = new HashMap<String, HashMap[]>();
                    hashMap.put(GuiZoneConstants.ZM_DEVICE, this.getDeviceMembers(sanWWN));
                    response.responseData = hashMap;
                } else if (reqData.containsKey(GuiZoneConstants.ZM_DEVICESP)) {
                    String sanWWN = (String)reqData.get(GuiZoneConstants.ZM_DEVICESP);
                    HashMap<String, HashMap[]> hashMap = new HashMap<String, HashMap[]>();
                    hashMap.put(GuiZoneConstants.ZM_DEVICESP, this.getDeviceSPMembers(sanWWN));
                    response.responseData = hashMap;
                } else if (reqData.containsKey(GuiZoneConstants.ZM_NODE)) {
                    String sanWWN = (String)reqData.get(GuiZoneConstants.ZM_NODE);
                    HashMap<String, HashMap[]> hashMap = new HashMap<String, HashMap[]>();
                    hashMap.put(GuiZoneConstants.ZM_NODE, this.getNodeMembers(sanWWN));
                    response.responseData = hashMap;
                } else if (reqData.containsKey(GuiZoneConstants.ZM_PORT)) {
                    String sanWWN = (String)reqData.get(GuiZoneConstants.ZM_PORT);
                    HashMap<String, HashMap[]> hashMap = new HashMap<String, HashMap[]>();
                    hashMap.put(GuiZoneConstants.ZM_PORT, this.getPortMembers(sanWWN));
                    response.responseData = hashMap;
                } else if (reqData.containsKey(GuiZoneConstants.SAVE_ZONEDEF)) {
                    String sanWWN = (String)reqData.get(GuiZoneConstants.SAVE_ZONEDEF);
                    Integer flag = (Integer)reqData.get(GuiZoneConstants.FLAG);
                    ZoneDefinition zDef = (ZoneDefinition)reqData.get(GuiZoneConstants.ZONE_DEFINITION);
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    hashMap.put(GuiZoneConstants.SAVE_RESPONSE, this.saveZoneDef(sanWWN, flag, zDef));
                    response.responseData = hashMap;
                } else if (reqData.containsKey(GuiZoneConstants.SAVE_ZONE_DESCRIPTIONS)) {
                    ZoneDefinition zDef = (ZoneDefinition)reqData.get(GuiZoneConstants.SAVE_ZONE_DESCRIPTIONS);
                    String sanWWN = (String)reqData.get(GuiZoneConstants.SAN_WWN);
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    this.saveZoneDescriptions(zDef, sanWWN);
                    hashMap.put(GuiZoneConstants.SAVE_ZONE_DESCRIPTIONS, "");
                    response.responseData = hashMap;
                } else if (reqData.containsKey(GuiZoneConstants.RESERVE_TOKEN)) {
                    String sanWWN = (String)reqData.get(GuiZoneConstants.RESERVE_TOKEN);
                    response.responseData = this.reserveToken(sanWWN);
                } else if (reqData.containsKey(GuiZoneConstants.RELEASE_TOKEN)) {
                    Token token = (Token)reqData.get(GuiZoneConstants.TOKEN);
                    String sanWWN = (String)reqData.get(GuiZoneConstants.RELEASE_TOKEN);
                    response.responseData = this.releaseToken(sanWWN, token);
                } else if (reqData.containsKey(GuiZoneConstants.ROLLBACK_TOKEN)) {
                    Token token = (Token)reqData.get(GuiZoneConstants.TOKEN);
                    String sanWWN = (String)reqData.get(GuiZoneConstants.ROLLBACK_TOKEN);
                    response.responseData = this.rollbackToken(sanWWN, token);
                }
            }
            catch (Exception e) {
                Server.setResponseError(response, e);
                if (!TraceLogger.enableTrace) break block31;
                TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, (Object)response);
        }
        return response;
    }

    private HashMap[] getDeviceMembers(String sanWWN) {
        String methodName = "getDeviceMembers";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)sanWWN);
        }
        HashMap[] returnMap = null;
        try {
            return FabricDbAccess.getPeripheralEntitiesForSan((String)sanWWN);
        }
        catch (Exception ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, returnMap);
            }
            return returnMap;
        }
    }

    private HashMap[] getDeviceSPMembers(String sanWWN) {
        String methodName = "getDeviceSPMembers";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)sanWWN);
        }
        HashMap[] returnMap = null;
        try {
            return FabricDbAccess.getComputersForSan((String)sanWWN);
        }
        catch (Exception ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, returnMap);
            }
            return returnMap;
        }
    }

    private HashMap[] getNodeMembers(String sanWWN) {
        String methodName = "getNodeMembers";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)sanWWN);
        }
        HashMap[] returnMap = null;
        try {
            return FabricDbAccess.getDeadEndNodesForSan((String)sanWWN);
        }
        catch (Exception ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, returnMap);
            }
            return returnMap;
        }
    }

    private HashMap[] getPortMembers(String sanWWN) {
        String methodName = "getPortMembers";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)sanWWN);
        }
        HashMap[] returnMap = null;
        try {
            return FabricDbAccess.getDeadEndPortsForSan((String)sanWWN);
        }
        catch (Exception ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, returnMap);
            }
            return returnMap;
        }
    }

    private HashMap[] getSwitchMembers(String sanWWN) {
        String methodName = "getSwitchMembers";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)sanWWN);
        }
        HashMap[] returnMap = null;
        try {
            return FabricDbAccess.getSwitchConnections((String)sanWWN);
        }
        catch (Exception ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, returnMap);
            }
            return returnMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap reserveToken(String sanWWN) {
        String methodName = "reserveToken";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)sanWWN);
        }
        Integer zoneError = new Integer(2);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        DeviceRequest dr = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(dr);
        IFabricInternalService iAMS = (IFabricInternalService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IFabricInternalService.class, (String)"FabricManagerService");
        Token token = null;
        if (iAMS != null) {
            try {
                token = iAMS.reserve(sanWWN, "ZoneGUI:" + sanWWN);
                returnMap.put(GuiZoneConstants.TOKEN, token);
            }
            catch (ResourceLockedException le) {
                zoneError = new Integer(3);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)le);
                }
            }
            catch (ResourceNotAvailableException nae) {
                zoneError = new Integer(5);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)nae);
                }
            }
            catch (Exception ex) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
                }
                try {
                    zoneError = new Integer(1);
                }
                catch (Exception e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)e);
                    }
                }
                finally {
                    if (token != null) {
                        iAMS.release(token);
                    }
                }
            }
        }
        returnMap.put(GuiZoneConstants.SAVE_RESPONSE, zoneError);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, returnMap);
        }
        return returnMap;
    }

    private HashMap releaseToken(String sanWWN, Token token) {
        HashMap<String, Integer> returnMap;
        String methodName;
        block8: {
            methodName = "releaseToken";
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)sanWWN);
            }
            returnMap = new HashMap<String, Integer>();
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            IFabricInternalService iAMS = (IFabricInternalService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IFabricInternalService.class, (String)"FabricManagerService");
            if (iAMS != null) {
                try {
                    iAMS.release(token);
                    returnMap.put("pingError", new Integer(2));
                }
                catch (Exception ex) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
                    }
                    try {
                        returnMap.put("pingError", new Integer(1));
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block8;
                        TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)e);
                    }
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, returnMap);
        }
        return returnMap;
    }

    private HashMap rollbackToken(String sanWWN, Token token) {
        HashMap<String, Integer> returnMap;
        String methodName;
        block8: {
            methodName = "rollbackToken";
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)sanWWN);
            }
            returnMap = new HashMap<String, Integer>();
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            IFabricInternalService iAMS = (IFabricInternalService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IFabricInternalService.class, (String)"FabricManagerService");
            if (iAMS != null) {
                try {
                    iAMS.rollbackTransaction(sanWWN);
                    returnMap.put("pingError", new Integer(2));
                }
                catch (Exception ex) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
                    }
                    try {
                        returnMap.put("pingError", new Integer(1));
                    }
                    catch (Exception e) {
                        if (!TraceLogger.enableTrace) break block8;
                        TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)e);
                    }
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, returnMap);
        }
        return returnMap;
    }

    private HashMap ping(String sanWWN) {
        ZoneCapabilities zoneCap;
        HashMap<String, Integer> returnMap;
        block6: {
            String methodName = "ping";
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)sanWWN);
            }
            returnMap = new HashMap<String, Integer>();
            zoneCap = null;
            try {
                zoneCap = FabricDbAccess.getZoneControlCapabilities((String)sanWWN);
                if (zoneCap != null) {
                    returnMap.put("pingError", new Integer(2));
                } else {
                    returnMap.put("pingError", new Integer(4));
                }
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, returnMap);
                }
            }
            catch (Exception ex) {
                returnMap.put("pingError", new Integer(4));
                if (!TraceLogger.enableTrace) break block6;
                TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
            }
        }
        returnMap.put("pingZoneAgent", (Integer)zoneCap);
        return returnMap;
    }

    private void saveZoneDescriptions(ZoneDefinition zDef, String sanWWN) {
        String methodName = "saveZoneDescriptions";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)"zoneDefintion");
        }
        this.saveZoneDescriptions(zDef.getZones(), sanWWN);
        this.saveZoneSetDescriptions(zDef.getZoneSets(), sanWWN);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, (Object)"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer saveZoneDef(String sanWWN, Integer flag, ZoneDefinition zDef) {
        methodName = "saveZoneDef";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)sanWWN);
        }
        zoneError = new Integer(2);
        dr = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(dr);
        iAMS = (IFabricInternalService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IFabricInternalService.class, (String)"FabricManagerService");
        if (iAMS != null) {
            token = null;
            try {
                token = iAMS.reserve(sanWWN, "ZoneGUI:" + sanWWN);
                result = iAMS.setZoneInfo(token, zDef, flag.intValue());
                result = iAMS.waitForJobToComplete(result.getJobId());
                results = result.getResults();
                iAMS.release(token);
                token = null;
                this.saveZoneDescriptions(zDef.getZones(), sanWWN);
                this.saveZoneSetDescriptions(zDef.getZoneSets(), sanWWN);
                ** if (token == null) goto lbl-1000
            }
            catch (ResourceLockedException le) {
                zoneError = new Integer(3);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)le);
                }
                ** if (token == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    iAMS.release(token);
                }
lbl-1000:
                // 2 sources

                {
                }
                catch (ResourceNotAvailableException nae) {
                    zoneError = new Integer(5);
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)nae);
                    }
                    ** if (token == null) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        iAMS.release(token);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    catch (InvalidTokenException ite) {
                        zoneError = new Integer(4);
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ite);
                        }
                        ** if (token == null) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            iAMS.release(token);
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                        catch (OutOfMemoryError ome) {
                            zoneError = new Integer(1);
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ome);
                            }
                            ** if (token == null) goto lbl-1000
lbl-1000:
                            // 1 sources

                            {
                                iAMS.release(token);
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                            catch (Exception ex) {
                                try {
                                    block29: {
                                        if (TraceLogger.enableTrace) {
                                            TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
                                        }
                                        try {
                                            zoneError = new Integer(1);
                                            iAMS.rollbackTransaction(sanWWN);
                                        }
                                        catch (Exception e) {
                                            if (!TraceLogger.enableTrace) break block29;
                                            TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)e);
                                        }
                                    }
                                    ** if (token == null) goto lbl-1000
                                }
                                catch (Throwable var11_17) {
                                    if (token != null) {
                                        iAMS.release(token);
                                    }
                                    throw var11_17;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    iAMS.release(token);
                                }
lbl-1000:
                                // 2 sources

                                {
                                }
                            }
                        }
                    }
                }
            }
lbl-1000:
            // 1 sources

            {
                iAMS.release(token);
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, (Object)zoneError);
        }
        return zoneError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveZoneDescriptions(Zone[] zones, String sanWWN) {
        String methodName = "saveZoneDescriptions";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)"zones");
        }
        if (zones != null) {
            DBConnection con = null;
            try {
                DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
                con = (DBConnection)ds.getPooledConnection();
                for (int i = 0; i < zones.length; ++i) {
                    String zoneName = zones[i].getName();
                    if (zoneName == null || !FabricDbAccess.verifyZone((String)sanWWN, (String)zoneName)) continue;
                    FabricDbAccess.saveZoneDescription((DBConnection)con, (String)zones[i].getDescription(), (String)zoneName);
                }
            }
            catch (Exception ex) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
                }
            }
            finally {
                block18: {
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block18;
                        TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)e);
                    }
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, (Object)"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveZoneSetDescriptions(ZoneSet[] zoneSets, String sanWWN) {
        String methodName = "saveZoneSetDescriptions";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)"zoneSets");
        }
        if (zoneSets != null) {
            DBConnection con = null;
            try {
                DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
                con = (DBConnection)ds.getPooledConnection();
                for (int i = 0; i < zoneSets.length; ++i) {
                    String zsName = zoneSets[i].getName();
                    if (zsName == null || !FabricDbAccess.verifyZoneSet((String)sanWWN, (String)zsName)) continue;
                    FabricDbAccess.saveZoneSetDescription((DBConnection)con, (String)zoneSets[i].getDescription(), (String)zsName);
                }
            }
            catch (Exception ex) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
                }
            }
            finally {
                block18: {
                    try {
                        if (con != null) {
                            con.close();
                        }
                    }
                    catch (SQLException e) {
                        if (!TraceLogger.enableTrace) break block18;
                        TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)e);
                    }
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, (Object)"");
        }
    }

    private ZoneDefinition getZoneDefinition(String sanWWN, boolean active) {
        ZoneDefinition zoneDef;
        String methodName;
        block5: {
            methodName = "getZoneDefinition";
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)sanWWN);
            }
            zoneDef = new ZoneDefinition();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("FABRIC_WWN", sanWWN);
            try {
                String[] fabricIds = FabricDbAccess.getFabrics(params);
                if (fabricIds != null && fabricIds.length > 0) {
                    zoneDef = FabricDbAccess.getZoneDefinition((String)fabricIds[0], (boolean)active);
                }
            }
            catch (Exception ex) {
                if (!TraceLogger.enableTrace) break block5;
                TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, (Object)zoneDef);
        }
        return zoneDef;
    }

    private String[] getNonStdZones(String fabricId, ZoneDefinition zDef) {
        String[] zoneList;
        String methodName;
        block4: {
            methodName = "populateZones";
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)fabricId);
            }
            zoneList = null;
            try {
                zoneList = FabricDbAccess.getNonStandardZones((String)fabricId, (boolean)false);
            }
            catch (Exception ex) {
                if (!TraceLogger.enableTrace) break block4;
                TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, (Object)zDef);
        }
        return zoneList;
    }

    private HashMap[] getSans() {
        HashMap[] fabricAttr;
        String methodName;
        block4: {
            methodName = "getSans";
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)"");
            }
            fabricAttr = null;
            try {
                fabricAttr = FabricDbAccess.getFabricsForZoning();
            }
            catch (Exception ex) {
                if (!TraceLogger.enableTrace) break block4;
                TraceLogger.exception((String)ZoneRequestHandler.class.getName(), (String)methodName, (Throwable)ex);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, (Object)fabricAttr);
        }
        return fabricAttr;
    }

    private HashMap getDebugSANs() {
        String methodName = "getDebugSans";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ZoneRequestHandler.class.getName(), (String)methodName, (String)"");
        }
        HashMap<String, String> fabrics = new HashMap<String, String>();
        for (int i = 0; i < 10; ++i) {
            String fabricLabel = "SAN Label " + i;
            String fabricWWN = "SAN WWN " + i;
            fabrics.put(fabricWWN, fabricLabel);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ZoneRequestHandler.class.getName(), (String)methodName, fabrics);
        }
        return fabrics;
    }
}

