/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.nas;

import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.NasFilerAdmin;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TResPwd;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.xmsg.MessageLog;

public class NasGuiBoxHndlr
implements RequestHandler,
ThrowAway {
    private NameList head;
    private static Class requestDataClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)NasGuiBoxHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (RequestChecker.isDesiredType((Class)requestDataClass, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            NasFilerAdmin[] filerArray = (NasFilerAdmin[])request.requestData;
            Connection dbc = Server.getConnection();
            if (dbc == null) {
                Server.setResponseError(response, "GEN0050E");
            } else {
                boolean successes = false;
                boolean failures = false;
                NasFilerAdmin filer = filerArray[0];
                try {
                    int[] IDarray = null;
                    TResPwd accessor = new TResPwd(dbc);
                    if (filer.nfaFilerID < 0) {
                        IDarray = new int[]{filer.nfaFilerID};
                        successes = true;
                    } else {
                        NameList node;
                        this.head = new NameList();
                        this.head.nlName = filer.nfaDomainName;
                        this.head.nlID = filer.nfaDomainID;
                        this.head.nlID3 = 1;
                        this.head.nlState = 0;
                        filer.domainNode = this.head;
                        for (int i = 1; i < filerArray.length; ++i) {
                            filer = filerArray[i];
                            node = this.head;
                            while (node != null) {
                                if (node.nlID == filer.nfaDomainID) {
                                    filer.domainNode = node;
                                    ++node.nlID3;
                                    break;
                                }
                                node = node.nlNext;
                            }
                            if (node != null) continue;
                            node = new NameList();
                            node.nlName = filer.nfaDomainName;
                            node.nlID = filer.nfaDomainID;
                            node.nlID3 = 1;
                            node.nlState = 0;
                            node.nlNext = this.head;
                            this.head = node;
                            filer.domainNode = node;
                        }
                        NameList agentList = new TStatComputer(dbc).selectAgents();
                        node = this.head;
                        while (node != null) {
                            for (int k = 1; k < filerArray.length; ++k) {
                                filer = filerArray[k];
                                if (filer.nfaDomainID == node.nlID) break;
                            }
                            boolean searching = true;
                            NameList agent = agentList;
                            while (searching && agent != null) {
                                if (agent.nlID == node.nlID) {
                                    Request agentReq = new Request();
                                    agentReq.typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
                                    agentReq.subType = "org.eclipse.aperi.agent.handler.nas.NasLoginHandler";
                                    agentReq.serviceName = RequestTypeManager.getInternalName((String)agentReq.typeCode);
                                    agentReq.userName = request.userName;
                                    agentReq.flags = 0;
                                    agentReq.requestData = filer;
                                    AgentManager am = Server.getAgentManager();
                                    Response agentResp = am.transmitToAgent(agentReq, null, agent.nlID2, false);
                                    if (agentResp == null) {
                                        String name = Server.agentMgr.getAgentName(agent.nlID2);
                                        MessageLog.logMessage((String)"NAS0003E", (Object)name);
                                    } else if (agentResp.status <= 12) {
                                        searching = false;
                                        if (agentResp.status > 4) {
                                            response.status = agentResp.status;
                                            response.errorMessage = agentResp.errorMessage;
                                            failures = true;
                                        } else {
                                            successes = true;
                                            node.nlState = 1;
                                        }
                                    }
                                }
                                agent = agent.nlNext;
                            }
                            if (agent == null) {
                                failures = true;
                            }
                            node = node.nlNext;
                        }
                        if (successes) {
                            int total = 0;
                            node = this.head;
                            while (node != null) {
                                if (node.nlState == 1) {
                                    total += node.nlID3;
                                }
                                node = node.nlNext;
                            }
                            IDarray = new int[total];
                            int index = 0;
                            for (int i = 0; i < filerArray.length; ++i) {
                                filer = filerArray[i];
                                node = filer.domainNode;
                                if (node.nlState != 1) continue;
                                IDarray[index] = filer.nfaFilerID;
                                ++index;
                            }
                        }
                    }
                    if (successes) {
                        accessor.prepLoginUpdate();
                        boolean commit = false;
                        int last = IDarray.length - 1;
                        for (int i = 0; i < IDarray.length; ++i) {
                            if (i == last) {
                                commit = true;
                            }
                            accessor.updateLogin(IDarray[i], filer.nfaUserName, filer.nfaPassword, commit);
                        }
                        accessor.closeLoginUpdate();
                    }
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)NasGuiBoxHndlr.class.getName(), (String)"handle", (Throwable)e);
                    }
                    Server.setResponseError(response, (Exception)((Object)e));
                }
                finally {
                    ScheduleQueue.routine.rebuild();
                    Server.returnConnection(dbc);
                }
                Object[] dummyArray = new Object[]{NameList.packList((NameList)this.head)};
                response.responseData = dummyArray;
                if (!successes && !failures) {
                    Server.setResponseError(response, "NAS0002E");
                }
            }
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)NasGuiBoxHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    static {
        NasFilerAdmin[] array = new NasFilerAdmin[]{};
        requestDataClass = array.getClass();
    }
}

