/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.infrastructure.database.CurrentTime;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleSubmit;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.VMTransceiver;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobComplete;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;
import org.eclipse.aperi.xmsg.MessageLog;

public class DeviceJobHndlrThread
implements Runnable {
    private DeviceRequest dr = null;
    private Transceiver transceiver = null;
    private DeviceJobHndlr devJobHndlr = null;

    public DeviceJobHndlrThread(Request request, Transceiver transceiver, DeviceJobHndlr hndlr) {
        this.dr = (DeviceRequest)request;
        this.transceiver = transceiver;
        this.devJobHndlr = hndlr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceJobHndlrThread.class.getName(), (String)"run", (String)"void");
        }
        Response response = new Response(0, null);
        try {
            this.dr.deviceRunNbr = this.devJobHndlr.deviceAPI(this.dr, response);
        }
        catch (Exception e) {
            MessageLog.logException((String)"SRV0451E", (Exception)e, (Object)"run");
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)DeviceJobHndlrThread.class.getName(), (String)"run", (Throwable)e);
            }
            e.printStackTrace();
        }
        catch (Throwable e) {
            MessageLog.logException((String)"SRV0451E", (Exception)new Exception(e), (Object)"run");
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)DeviceJobHndlrThread.class.getName(), (String)"run", (Throwable)e);
            }
            e.printStackTrace();
        }
        if (this.dr.deviceRunNbr < 1) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage((int)1, (String)DeviceJobHndlrThread.class.getName(), (String)"run", (String)(this.devJobHndlr.getClass().getName() + ".deviceAPI() failed"));
            }
            DeviceJobComplete djc = new DeviceJobComplete();
            djc.deviceJobID = this.dr.deviceRunNbr;
            djc.deviceServerID = this.dr.deviceServerID;
            djc.dataScheduleID = this.dr.dataScheduleID;
            djc.dataScheduleRunID = this.dr.dataScheduleRunNbr;
            djc.status = 0;
            try {
                djc.finish_time = CurrentTime.getTimestamp().getTime();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            DeviceJobHndlrThread.updateComplete(djc);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DeviceJobHndlrThread.class.getName(), (String)"run", (boolean)false);
            }
            response.status = (short)12;
            this.ReturnResponse(response);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DeviceJobHndlrThread.class.getName(), (String)"run", (boolean)false);
            }
            return;
        }
        response.responseData = new Integer(this.dr.deviceRunNbr);
        DeviceJobHndlr.setDeviceJobID(this.dr);
        try {
            if (this.dr.waitForJobComplete) {
                IJobMgmtService iJob = (IJobMgmtService)ConnectorClient.getService((String)this.dr.deviceServerHost, (int)this.dr.deviceServerPort, IJobMgmtService.class, (String)"FabricManagerService");
                DeviceJobHndlr.waitForDeviceJob(response, this.dr.deviceRunNbr, iJob);
            }
        }
        finally {
            this.ReturnResponse(response);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DeviceJobHndlrThread.class.getName(), (String)"run", (boolean)true);
            }
        }
    }

    private void ReturnResponse(Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceJobHndlrThread.class.getName(), (String)"ReturnResponse", (String)"Response");
        }
        if (response != null) {
            this.transceiver.transmitResponse((Request)this.dr, response);
            if (!(this.transceiver instanceof VMTransceiver)) {
                response.returnResponse();
            }
        }
        this.transceiver.close();
        this.transceiver.returnTransceiver();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DeviceJobHndlrThread.class.getName(), (String)"ReturnResponse", (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateComplete(DeviceJobComplete djc) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceJobHndlrThread.class.getName(), (String)"updateComplete", (String)"djc");
        }
        Connection dbc = Server.getConnection();
        try {
            String UPDATE_RUNS = "update t_runs set device_server_id = ?, finish_time = ?, status = ?  where schedule_id = ? and run_number = ?";
            PreparedStatement insertStmt = dbc.prepareStatement(UPDATE_RUNS);
            insertStmt.setInt(1, djc.deviceServerID);
            insertStmt.setLong(2, djc.finish_time);
            SQLUtil.setByte(insertStmt, 3, (byte)djc.status);
            insertStmt.setInt(4, djc.dataScheduleID);
            insertStmt.setInt(5, djc.dataScheduleRunID);
            insertStmt.executeUpdate();
            insertStmt.close();
            dbc.commit();
        }
        catch (SQLException e) {
            Object[] args = new Object[]{"update", "t_runs", "DeviceJobHndlrThread.processComplete"};
            String msg = SQLUtil.getSQLExceptionMsg("JSS0008E", e, args);
            ScheduleSubmit.logWriter.println(msg);
        }
        finally {
            if (dbc != null) {
                Server.returnConnection(dbc);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)DeviceJobHndlrThread.class.getName(), (String)"updateComplete");
        }
    }
}

