/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.fabric.api.IFabricManagerService;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.gui.disk.common.model.DiskDataControllerConstants;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;

public class FabricActionHandler
extends DeviceJobHndlr {
    private IFabricManagerService fmService = null;
    private String userName = null;

    public int deviceAPI(DeviceRequest request, Response response) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FabricActionHandler.class.getName(), (String)"deviceAPI", (String)"request, response");
        }
        GUIRequestData reqData = (GUIRequestData)request.requestData;
        this.userName = request.userName;
        int jobID = DiskDataControllerConstants.INVALID_JOBID;
        try {
            DeviceRequestHndlr.initDeviceServerComm(request);
            this.fmService = (IFabricManagerService)ConnectorClient.getService((String)request.deviceServerHost, (int)request.deviceServerPort, IFabricManagerService.class, (String)"FabricManagerService");
            AsyncResult result = null;
            if (reqData.getActionId() == 30) {
                result = this.createZone(reqData, response);
            } else if (reqData.getActionId() == 31) {
                result = this.updateZone(reqData, response);
            }
            if (result != null) {
                if (result.getReturnException() != null) {
                    throw result.getReturnException();
                }
                jobID = Integer.parseInt(result.getJobId());
            }
        }
        catch (Exception ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)FabricActionHandler.class.getName(), (String)"deviceAPI", (Throwable)ex);
            }
            response.status = (short)12;
            if (ex instanceof SRMRuntimeException) {
                response.errorMessage = ((SRMRuntimeException)ex).getLocalizedMessage();
            } else {
                String[] inserts = new String[]{};
                String msg = ex.getMessage();
                if (msg != null) {
                    inserts = new String[]{msg};
                }
                response.errorMessage = new SRMMessage("HWN021503E", inserts).getLocalizedMessage();
            }
            response.responseData = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FabricActionHandler.class.getName(), (String)"deviceAPI", (int)jobID);
        }
        return jobID;
    }

    private AsyncResult createZone(GUIRequestData reqData, Response response) throws Exception {
        String fabricId = (String)((Object)reqData.getParameter("fabric.id"));
        TraceLogger.traceMessage((int)1, (String)FabricActionHandler.class.getName(), (String)"createZone", (String)("fabricId: " + fabricId));
        String zoneSetName = (String)((Object)reqData.getParameter("zoneset.name"));
        TraceLogger.traceMessage((int)1, (String)FabricActionHandler.class.getName(), (String)"createZone", (String)("zoneSetName: " + zoneSetName));
        String zoneName = (String)((Object)reqData.getParameter("zone.name"));
        TraceLogger.traceMessage((int)1, (String)FabricActionHandler.class.getName(), (String)"createZone", (String)("zoneName: " + zoneName));
        String[] portWwpns = (String[])reqData.getParameter("ports");
        TraceLogger.traceMessage((int)1, (String)FabricActionHandler.class.getName(), (String)"createZone", (String)("portWwpns: " + portWwpns));
        StringBuffer auditMsgBuffer = new StringBuffer("Username = " + this.userName);
        auditMsgBuffer.append("\n Create Zone ");
        auditMsgBuffer.append("\n fabric ID = ");
        auditMsgBuffer.append(fabricId);
        auditMsgBuffer.append("\n zone name = ");
        auditMsgBuffer.append(zoneName);
        auditMsgBuffer.append("\n port wwpns = ");
        auditMsgBuffer.append(portWwpns);
        short[] zoneTypes = new short[portWwpns.length];
        for (int i = 0; i < portWwpns.length; ++i) {
            zoneTypes[i] = 11;
        }
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)FabricActionHandler.class.getName(), (String)"createZone()", (String)String.valueOf(auditMsgBuffer));
        }
        this.fmService.startTransaction(fabricId);
        this.fmService.createZone(fabricId, zoneName, (short)0, (short)0);
        this.fmService.addZoneToZoneSet(fabricId, zoneSetName, zoneName);
        this.fmService.addZoneMembersToZone(fabricId, zoneName, portWwpns, zoneTypes);
        this.fmService.activateZoneSet(fabricId, zoneSetName);
        return this.fmService.commitTransaction(fabricId);
    }

    private AsyncResult updateZone(GUIRequestData reqData, Response response) throws Exception {
        String fabricId = (String)((Object)reqData.getParameter("fabric.id"));
        TraceLogger.traceMessage((int)1, (String)FabricActionHandler.class.getName(), (String)"updateZone", (String)("fabricId: " + fabricId));
        String zoneSetName = (String)((Object)reqData.getParameter("zoneset.name"));
        TraceLogger.traceMessage((int)1, (String)FabricActionHandler.class.getName(), (String)"updateZone", (String)("zoneSetName: " + zoneSetName));
        String zoneName = (String)((Object)reqData.getParameter("zone.name"));
        TraceLogger.traceMessage((int)1, (String)FabricActionHandler.class.getName(), (String)"updateZone", (String)("zoneName: " + zoneName));
        String[] portWwpns = (String[])reqData.getParameter("ports");
        TraceLogger.traceMessage((int)1, (String)FabricActionHandler.class.getName(), (String)"updateZone", (String)("portWwpns: " + portWwpns.toString()));
        StringBuffer auditMsgBuffer = new StringBuffer("Username = " + this.userName);
        auditMsgBuffer.append("\n Update Zone ");
        auditMsgBuffer.append("\n fabric ID = ");
        auditMsgBuffer.append(fabricId);
        auditMsgBuffer.append("\n zone set name= ");
        auditMsgBuffer.append(zoneSetName);
        auditMsgBuffer.append("\n zone name = ");
        auditMsgBuffer.append(zoneName);
        auditMsgBuffer.append("\n port wwpns = ");
        auditMsgBuffer.append(portWwpns);
        short[] zoneTypes = new short[portWwpns.length];
        for (int i = 0; i < portWwpns.length; ++i) {
            zoneTypes[i] = 11;
        }
        if (TraceLogger.enableAudit) {
            TraceLogger.auditMessage((String)FabricActionHandler.class.getName(), (String)"updateZone()", (String)String.valueOf(auditMsgBuffer));
        }
        this.fmService.startTransaction(fabricId);
        this.fmService.addZoneMembersToZone(fabricId, zoneName, portWwpns, zoneTypes);
        this.fmService.activateZoneSet(fabricId, zoneSetName);
        return this.fmService.commitTransaction(fabricId);
    }
}

