/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.scheduler;

import java.io.File;
import org.eclipse.aperi.backend.SectionedConfigParser;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScheduleConfig {
    private File file;
    private int number;
    SectionedConfigParser parser;
    private String[][] concurrencyKeys = new String[][]{{"maxSubmitThreads", "4"}, {"maxCompleteThreads", "4"}};
    private String[][] jobsKeys = new String[][]{{"minutesAdvanced", "1"}, {"delayLimitMinutes", "120"}};
    private String[][][] sectionKeyWords = new String[][][]{this.concurrencyKeys, this.jobsKeys};
    private static final int MAX_SUBMIT_THREADS_KEY = 0;
    private static final int MAX_COMPLETE_THREADS_KEY = 1;
    private static final int MINUTES_ADVANCED_KEY = 0;
    private static final int DELAY_LIMIT_KEY = 1;
    private static final int CONCURRENCY_SECTION = 0;
    private static final int JOBS_SECTION = 1;
    private static final String[] sectionNames = new String[]{"concurrency", "jobs"};
    private static final String configFile = "configuration" + File.separator + "Scheduler.config";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduleConfig() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleConfig.class.getName(), (String)"ScheduleConfig", (String)"");
        }
        this.file = new File(configFile);
        if (this.file.exists()) {
            try {
                int sectionIndex;
                this.parser = new SectionedConfigParser(configFile, sectionNames, this.sectionKeyWords);
                while ((sectionIndex = this.parser.nextSection()) >= 0) {
                    if (sectionIndex == 0) {
                        SchCommon.submitThreads = this.getNumber(this.concurrencyKeys[0][1], "maxSubmitThreads", SchCommon.submitThreads, 2, 8);
                        SchCommon.completeThreads = this.getNumber(this.concurrencyKeys[1][1], "maxCompleteThreads", SchCommon.completeThreads, 2, 8);
                        continue;
                    }
                    SchCommon.minutesAdvanced = this.getNumber(this.jobsKeys[0][1], "minutesAdvanced", SchCommon.minutesAdvanced, 1, 9);
                    SchCommon.millisAdvanced = SchCommon.minutesAdvanced * 60000;
                    SchCommon.delayLimitMinutes = this.getNumber(this.jobsKeys[1][1], "delayLimitMinutes", SchCommon.delayLimitMinutes, 1, 2880);
                    SchCommon.delayLimit = SchCommon.delayLimitMinutes * 60000;
                }
            }
            catch (LocalizableException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ScheduleConfig.class.getName(), (String)"ScheduleConfig", (Throwable)e);
                }
                e.print();
            }
            finally {
                if (this.parser != null) {
                    this.parser.close();
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleConfig.class.getName(), (String)"ScheduleConfig");
        }
    }

    private int getNumber(String input, String keyword, int defaultValue, int min, int max) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleConfig.class.getName(), (String)"getNumber", (String)"input, keyword, defaultValue, min, max");
        }
        int returnNumber = defaultValue;
        boolean bad = false;
        try {
            returnNumber = Integer.parseInt(input);
            if (returnNumber < min || returnNumber > max) {
                bad = true;
            }
        }
        catch (NumberFormatException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleConfig.class.getName(), (String)"getNumber", (Throwable)e);
            }
            bad = true;
        }
        if (bad) {
            Object[] args = new Object[]{keyword, Integer.toString(min), Integer.toString(max), Integer.toString(defaultValue)};
            MessageLog.logMessage((String)"JSS0062W", (Object[])args);
            returnNumber = defaultValue;
        }
        int traceResult = returnNumber;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleConfig.class.getName(), (String)"getNumber", (int)traceResult);
        }
        return traceResult;
    }
}

