/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.handler.server.AgentStateHndlr;
import org.eclipse.aperi.server.handler.server.GuiToAgentHndlr;
import org.eclipse.aperi.server.req.AgentCommandReq;
import org.eclipse.aperi.server.req.AgentStateReq;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.server.req.GuiToAgentReq;

public class AgentCommandHndlr
implements RequestHandler,
ThreadSafe {
    public Response handle(Request request, Transceiver comm) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentCommandHndlr.class.getName(), (String)"handle", (String)"request, comm");
        }
        if (!RequestChecker.isDesiredType(AgentCommandReq.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AgentCommandHndlr.class.getName(), (String)"handle", (Object)response);
            }
            return response;
        }
        AgentCommandReq agentCommandReq = (AgentCommandReq)request.requestData;
        Request agentRequest = agentCommandReq.acrRequest;
        int[] agentIDs = agentCommandReq.acrAgentIDs;
        Response agentResponse = null;
        String[] messages = new String[agentIDs.length];
        if (agentRequest.requestData instanceof AgentStateReq) {
            ComputerID computerID;
            AgentStateReq agentStateReq = (AgentStateReq)agentRequest.requestData;
            AgentStateHndlr agentStateHndlr = new AgentStateHndlr();
            agentStateReq.computerID = computerID = new ComputerID(0);
            for (int i = 0; i < agentIDs.length; ++i) {
                computerID.computerID = agentIDs[i];
                agentResponse = agentStateHndlr.handle(agentRequest, null);
                if (agentResponse.status == 0) continue;
                messages[i] = agentResponse.errorMessage;
            }
        } else {
            GuiToAgentReq guiToAgentReq = (GuiToAgentReq)agentRequest.requestData;
            GuiToAgentHndlr guiToAgentHndlr = new GuiToAgentHndlr();
            for (int i = 0; i < agentIDs.length; ++i) {
                guiToAgentReq.computerID = agentIDs[i];
                agentResponse = guiToAgentHndlr.handle(agentRequest, null);
                if (agentResponse.status == 0) continue;
                messages[i] = agentResponse.errorMessage;
            }
        }
        byte[] states = new byte[agentIDs.length];
        for (int i = 0; i < agentIDs.length; ++i) {
            AgentManager.AgentAddress agentNode = Server.agentMgr.getAgent(agentIDs[i]);
            if (agentNode == null) {
                states[i] = 77;
                continue;
            }
            states[i] = agentNode.state;
            if (agentNode.state != 1) continue;
            if (agentNode.consecutiveErrors > 0) {
                states[i] = 4;
                continue;
            }
            if (agentNode.upgradeRequired <= 0) continue;
            states[i] = 5;
        }
        Object[] status = new Object[]{states, messages};
        agentResponse.status = 0;
        agentResponse.responseData = status;
        agentResponse.errorMessage = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AgentCommandHndlr.class.getName(), (String)"handle", (Object)agentResponse);
        }
        return agentResponse;
    }
}

