/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.net.InetAddress;
import java.util.Date;
import org.eclipse.aperi.agent.req.AgentRequestData;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.SoftwareVersion;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TAgent;
import org.eclipse.aperi.request.CheckedRequest;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.req.AgentRegReq;

public class AgentRegHndlr
implements RequestHandler,
ThreadSafe {
    private static SoftwareVersion nextProduct(SoftwareVersion[] agentProducts, MutableInteger i) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentRegHndlr.class.getName(), (String)"nextProduct", (String)"agentProducts, i");
        }
        SoftwareVersion result = null;
        while (i.value < agentProducts.length && result == null) {
            result = agentProducts[i.value];
            ++i.value;
        }
        SoftwareVersion traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AgentRegHndlr.class.getName(), (String)"nextProduct", (Object)traceResult);
        }
        return traceResult;
    }

    private static void checkVendorChange(SoftwareVersion[] agentProducts) {
        MutableInteger i;
        SoftwareVersion product;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentRegHndlr.class.getName(), (String)"checkVendorChange", (String)"agentProducts");
        }
        if ((product = AgentRegHndlr.nextProduct(agentProducts, i = new MutableInteger())) != null && product.svVendor < SoftwareVersion.getVendor()) {
            do {
                product.svVersion = 1;
                product.svRelease = 0;
                product.svModification = 0;
            } while ((product = AgentRegHndlr.nextProduct(agentProducts, i)) != null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AgentRegHndlr.class.getName(), (String)"checkVendorChange");
        }
    }

    public Response handle(Request request, Transceiver comm) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)AgentRegHndlr.class.getName(), (String)"handle", (String)"request, comm");
        }
        if (!RequestChecker.isDesiredType(AgentRegReq.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AgentRegHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        CheckedRequest checkedRequest = (CheckedRequest)request;
        AgentRegReq regData = (AgentRegReq)checkedRequest.requestData;
        InetAddress inet = ((SocketTransceiver)comm).getInetAddress();
        String ipAddress = inet.getHostAddress();
        String networkName = regData.networkName;
        if (networkName == null) {
            networkName = inet.getHostName();
        }
        AgentRegHndlr.checkVendorChange(regData.installedProducts);
        String guid = regData.guidO != null ? regData.guidO.toNoDotString() : null;
        TAgent agent = new TAgent(checkedRequest.machineName, regData.port, new Date().getTime(), regData.hwID, networkName, ipAddress, regData.timezone, null, regData.installedProducts, regData.featureSet, guid);
        Server.agentMgr.register(agent, response, regData.installedProducts, regData.newLogDir);
        if (response.status == 0) {
            AgentRequestData responseData = new AgentRequestData();
            responseData.setServerToken(Server.getServerToken());
            responseData.setServerPort(Server.getListenerPort());
            responseData.setComputerID(agent.computer.computerID);
            response.responseData = responseData;
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)AgentRegHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }
}

