/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.io.Serializable;
import java.sql.Connection;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TConfigSettings;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.ConfigSettings;

public class ConfigSettingsHndlr
implements RequestHandler,
ThrowAway {
    private String subType;
    private ConfigSettings settings;

    private void save(TConfigSettings accessor) throws GeneralException {
        int rowsChanged;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConfigSettingsHndlr.class.getName(), (String)"save", (String)"accessor");
        }
        if ((rowsChanged = this.subType.equals("org.eclipse.aperi.server.handler.server.ConfigSettingsHndlr.Retention") ? accessor.updateRetention(this.settings) : accessor.updateNetwork(this.settings)) > 0) {
            this.settings = accessor.getConfigSettings(true);
        } else {
            accessor.insert(this.settings);
        }
        accessor.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConfigSettingsHndlr.class.getName(), (String)"save");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConfigSettingsHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        Response response = Response.getResponse((short)0, null);
        Serializable requestData = request.requestData;
        if (requestData != null) {
            this.subType = request.subType;
            if (!RequestChecker.isDesiredType(ConfigSettings.class, (Request)request, (Response)response)) {
                Response traceResult = response;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ConfigSettingsHndlr.class.getName(), (String)"handle", (Object)traceResult);
                }
                return traceResult;
            }
            this.settings = (ConfigSettings)requestData;
        }
        Connection dbc = Server.getConnection();
        TConfigSettings accessor = new TConfigSettings(dbc);
        try {
            if (this.settings == null) {
                response.responseData = accessor.getConfigSettings(false);
            } else {
                this.save(accessor);
                Server.updateSettings(this.settings);
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ConfigSettingsHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
        }
        finally {
            Server.returnConnection(dbc);
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConfigSettingsHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }
}

