/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.DeviceServerManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.SRMServerInfo;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.xmsg.MessageLog;

public class DeviceServerRegHndlr
implements RequestHandler,
ThrowAway {
    public Response handle(Request request, Transceiver transceiver) {
        String methodName = "handle()";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)DeviceServerRegHndlr.class.getName(), (String)methodName, (String)"request, transceiver");
        }
        Response response = Response.getResponse((short)0, null);
        try {
            if (request.requestData instanceof SRMServerInfo) {
                SRMServerInfo devServerInfo = (SRMServerInfo)request.requestData;
                DeviceServerManager devServMgr = Server.getDeviceServerManager();
                response.status = 0;
                if (devServerInfo.getType() == SRMServerInfo.REGISTER) {
                    devServMgr.registerDeviceServer(devServerInfo);
                } else if (devServerInfo.getType() == SRMServerInfo.UNREGISTER) {
                    devServMgr.unRegisterDeviceServer(devServerInfo);
                } else if (devServerInfo.getType() == SRMServerInfo.REFRESH) {
                    devServMgr.refresh();
                } else {
                    response.status = (short)12;
                    Object[] args = new Object[]{new Integer(request.subType)};
                    response.errorMessage = MessageLog.getMessage((String)"STS0093E", (Object[])args);
                    response.responseData = null;
                    String msg = "Invalid sub-type " + request.subType + " passed from" + "the installer.";
                    if (TraceLogger.enableTrace) {
                        TraceLogger.traceMessage((int)1, (String)DeviceServerRegHndlr.class.getName(), (String)methodName, (String)msg);
                    }
                }
            } else {
                response.status = (short)12;
                response.errorMessage = MessageLog.getMessage((String)"GEN0316E");
                response.responseData = null;
                if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage((int)1, (String)DeviceServerRegHndlr.class.getName(), (String)methodName, (String)"Invalide data object.");
                }
            }
        }
        catch (Exception e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)DeviceServerRegHndlr.class.getName(), (String)methodName, (Throwable)e);
            }
            Server.setResponseError(response, e);
            response.status = (short)12;
            response.responseData = null;
        }
        TraceLogger.exit((String)DeviceServerRegHndlr.class.getName(), (String)methodName, (Object)"request, transceiver");
        return response;
    }
}

