/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.server;

import java.sql.Connection;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.xmsg.MessageLog;

public class GenerateAlertHndlr
implements ThreadSafe,
RequestHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response respose;
        String className = this.getClass().getName();
        String methodName = "handle";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)className, (String)"handle", (String)"request, transceiver");
        }
        if (RequestChecker.isDesiredType(Alert.class, (Request)request, (Response)(respose = Response.getResponse((short)0, null)))) {
            Alert alert = (Alert)request.requestData;
            AlertDefinition reqAlertDef = alert.getAlertDefinition();
            if (reqAlertDef != null && reqAlertDef.aldAlertID > 0) {
                Connection dbc = Server.getConnection();
                TAlertDefinition tAlert = new TAlertDefinition(dbc);
                try {
                    tAlert.prepSelectByID(false, false);
                    AlertDefinition alertDefFromDB = tAlert.getByID(reqAlertDef.aldAlertID);
                    if (reqAlertDef.aldAlertID == 111) {
                        alertDefFromDB.aldCondition = reqAlertDef.aldCondition;
                        if (alertDefFromDB.aldCondition == 103) {
                            alertDefFromDB.aldType = (short)30;
                        } else if (alertDefFromDB.aldCondition == 106) {
                            alertDefFromDB.aldType = (short)32;
                        } else if (alertDefFromDB.aldCondition == 107) {
                            alertDefFromDB.aldType = (short)31;
                        }
                    }
                    if (alertDefFromDB != null) {
                        alert.setAlertDefinition(alertDefFromDB);
                    }
                    tAlert.closeSelect();
                }
                catch (GeneralException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)className, (String)"handle", (Throwable)e);
                    }
                }
                finally {
                    Server.returnConnection(dbc);
                }
                Alerter.queueAlert(alert);
            } else if (TraceLogger.enableTrace) {
                String msg = "Alert Definition is null and therefore alert was not queued.";
                msg = msg + " Alert message: " + MessageLog.getMessage((String)alert.getMessageID());
                TraceLogger.traceMessage((int)3, (String)className, (String)"handle", (String)msg);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)className, (String)"handle", (Object)respose);
        }
        return respose;
    }
}

