/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.discovery.RemoveMissingProcessor;
import org.eclipse.aperi.fabric.api.IFabricManagerService;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TResFabric;
import org.eclipse.aperi.server.ServerJob;
import org.eclipse.aperi.server.VMJobResults;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.server.handler.scheduler.DeviceJobHndlr;
import org.eclipse.aperi.xmsg.MessageLog;

public class ExecProbeFabric
implements ServerJob {
    private JobRun jobRun;
    private Connection dbc;

    public ExecProbeFabric(Connection dbc) {
        this.initialize(dbc);
    }

    public ExecProbeFabric() {
    }

    public void initialize(Connection dbc) {
        this.dbc = dbc;
    }

    public int run(VMJobResults job, String[] parms) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecProbeFabric.class.getName(), (String)"run", (String)"job, parms");
        }
        this.jobRun = job.getJobRun();
        String[] fabricIDs = this.getAllFabricBySchedID(this.jobRun.getSchedID());
        int rc = this.probeFabric(fabricIDs);
        if (rc == 0) {
            MessageLog.logMessage((String)"GEN0401I");
        } else if (rc == 4) {
            MessageLog.logMessage((String)"GEN0402W");
        } else {
            MessageLog.logMessage((String)"GEN0400E");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ExecProbeFabric.class.getName(), (String)"run", (int)rc);
        }
        return rc;
    }

    private int probeFabric(String[] fabricIDS) {
        AsyncResult tar;
        DeviceRequest dr = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(dr);
        IJobMgmtService iJob = (IJobMgmtService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IJobMgmtService.class, (String)"FabricManagerService");
        if (iJob == null) {
            MessageLog.logMessage((String)"SRV0450E", (Object)IJobMgmtService.class.getName());
            return 8;
        }
        IDiscover iDis = (IDiscover)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiscover.class, (String)"DiscoverService");
        if (iDis == null) {
            MessageLog.logMessage((String)"SRV0450E", (Object)IDiscover.class.getName());
            return 8;
        }
        String method = "probeFabric";
        try {
            String user = this.jobRun.getSchedCreator();
            String schedName = this.jobRun.getSchedName();
            String runNumber = this.jobRun.getFormattedRunNumberSchedID();
            String jobName = this.jobRun.getJobName();
            tar = (AsyncResult)iDis.invoke(user, schedName, runNumber, jobName, "FabricManagerService", IFabricManagerService.class.getName(), "probeFabrics", new Object[]{fabricIDS});
        }
        catch (Exception e) {
            MessageLog.logException((String)"SRV0451E", (Exception)e, (Object)method);
            e.printStackTrace();
            return 8;
        }
        catch (Throwable e) {
            MessageLog.logException((String)"SRV0451E", (Exception)new Exception(e), (Object)method);
            e.printStackTrace();
            return 8;
        }
        int rc = DeviceJobHndlr.completeDeviceJob(iJob, tar, method, this.jobRun.getSchedID(), this.jobRun.getSchedRunNumber(), dr.deviceServerID);
        RemoveMissingProcessor removeMissingProcessor = new RemoveMissingProcessor();
        removeMissingProcessor.performScheduledFabricDeletion();
        return rc;
    }

    private String[] getAllFabricBySchedID(int scheduleID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecProbeFabric.class.getName(), (String)"probeFabric", (String)"scheduleID");
        }
        TResFabric fabricAccessor = new TResFabric();
        String[] fabricIDS = null;
        try {
            GuiListReq glr = new GuiListReq();
            NameList fabricNL = fabricAccessor.getFabricTiedTo(scheduleID);
            Hashtable<String, String> fabricIDHT = new Hashtable<String, String>();
            int count = 0;
            while (fabricNL != null) {
                if (fabricNL.nlInfo == 114) {
                    if (fabricIDHT.put(fabricNL.nlName, "FABRICID") == null) {
                        ++count;
                    }
                } else {
                    glr.groupID = fabricNL.nlID;
                    NameList memberList = fabricAccessor.selectNames(glr);
                    while (memberList != null) {
                        if (fabricIDHT.put(memberList.nlName, "FABRICID") == null) {
                            ++count;
                        }
                        memberList = memberList.nlNext;
                    }
                }
                fabricNL = fabricNL.nlNext;
            }
            fabricIDS = new String[count];
            Enumeration e = fabricIDHT.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                fabricIDS[i++] = (String)e.nextElement();
            }
        }
        catch (GeneralException e) {
            MessageLog.logException((String)"SRV0451E", (Exception)((Object)e), (Object)"probeFabric");
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ExecProbeFabric.class.getName(), (String)"probeFabric", (Object)"scheduleID");
            }
            return null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ExecProbeFabric.class.getName(), (String)"probeFabric", (String)"scheduleID");
        }
        return fabricIDS;
    }
}

