/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.jobs;

import java.sql.Connection;
import java.util.HashMap;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.server.jobs.Aggregation;
import org.eclipse.aperi.server.jobs.AggregationMap;

public class OSAggregationMap
extends AggregationMap {
    private HashMap fsToParent = new HashMap();
    private HashMap dirToDirGroup = new HashMap();
    private HashMap dirParents = new HashMap();

    OSAggregationMap(Connection dbc) {
        super(dbc);
    }

    protected void initMaps(Aggregation aggregationFactory) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)OSAggregationMap.class.getName(), (String)"initMaps", (String)"aggregationFactory");
        }
        this.factory = aggregationFactory;
        this.networkAggregation = this.factory.newAggregation(-3);
        int lastID = Integer.MIN_VALUE;
        Aggregation list = null;
        int listSize = 0;
        TResFS fsAccessor = new TResFS(this.dbc);
        fsAccessor.prepSelectParentIDs("select distinct f.filesystem_id, gr.group_id from t_res_filesystem f, t_view_group2res gr where gr.res_type = 3 and f.filesystem_id = gr.resource_id union  select f.filesystem_id, f.computer_id from t_res_filesystem f union  select f.filesystem_id, c.domain_id from t_res_filesystem f, t_stat_computer c where f.computer_id = c.computer_id union select distinct f.filesystem_id, gr.group_id from t_res_filesystem f, t_view_group2res gr where f.computer_id = gr.resource_id order by 1");
        int[] idArray = new int[2];
        while (fsAccessor.selectParentIDs(idArray)) {
            Aggregation aggregation = this.getAggregation(this.parents, idArray[1]);
            int id = idArray[0];
            if (lastID == id) {
                aggregation.agNext = list;
                list = aggregation;
                ++listSize;
                continue;
            }
            this.addAggregationToMap(this.fsToParent, list, listSize, lastID);
            list = aggregation;
            listSize = 1;
            lastID = id;
        }
        this.addAggregationToMap(this.fsToParent, list, listSize, lastID);
        fsAccessor.closeSelect();
        fsAccessor = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)OSAggregationMap.class.getName(), (String)"initMaps");
        }
    }

    protected void aggregate(Aggregation additive) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)OSAggregationMap.class.getName(), (String)"aggregate", (String)"additive");
        }
        this.hashKey.value = additive.agResourceID;
        Object tempObj = this.fsToParent.get(this.hashKey);
        if (tempObj == null) {
            this.aggregateArrayMap(additive, this.hashKey, this.dirToDirGroup);
        } else {
            this.addTo(this.networkAggregation, additive);
            this.aggregateArrayMap(additive, this.hashKey, this.fsToParent);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)OSAggregationMap.class.getName(), (String)"aggregate");
        }
    }

    protected void replaceAggregationBuckets(Aggregation a) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)OSAggregationMap.class.getName(), (String)"replaceAggregationBuckets", (String)"a");
        }
        this.factory = a;
        this.networkAggregation = a.newAggregation(-3);
        this.parents.clear();
        this.dirParents.clear();
        this.replaceMapValues(this.fsToParent, this.parents);
        this.replaceMapValues(this.dirToDirGroup, this.dirParents);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)OSAggregationMap.class.getName(), (String)"replaceAggregationBuckets");
        }
    }
}

