/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.svp;

import java.io.PrintWriter;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.logging.TraceLoggerFactory;
import org.eclipse.aperi.server.RequestManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServiceProvider;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.server.SvpThreadGroup;
import org.eclipse.aperi.server.svp.CimomConfig;
import org.eclipse.aperi.xmsg.MessageLog;

public class CimomSvp
extends ServiceProvider {
    private static final String CLASSNAME = CimomSvp.class.getName();
    public static final String EXTENSION_POINT_ID = "org.eclipse.aperi.server.data.cimomHandler";
    private RequestManager rm;
    private PrintWriter logWriter;
    private ThreadGroup threadGroup;

    public String getTypeCode() {
        return "org.eclipse.aperi.server.svp.CimomSvp";
    }

    public void startup(ServiceQueue queue) throws Exception {
        String methodName = "startup";
        TraceLoggerFactory.startLogger((String)"ITSRM.logger.trace.TivoliSRM-CIMOM", (String)this.getTypeCode());
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"startup", (String)"queue");
        }
        try {
            this.logWriter = Server.initMessageLog("org.eclipse.aperi.server.svp.CimomSvp");
        }
        catch (Exception e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)CLASSNAME, (String)"startup", (Throwable)e);
            }
            String logFile = Server.getLogFileName("org.eclipse.aperi.server.svp.CimomSvp");
            MessageLog.logException((String)"GEN0049E", (Exception)e, (Object)logFile);
            throw e;
        }
        this.threadGroup = new SvpThreadGroup("CIMOM", new String[]{"org.eclipse.aperi.server.svp.CimomSvp"});
        CimomConfig config = new CimomConfig();
        config.loadConfigSettings();
        this.rm = new RequestManager(EXTENSION_POINT_ID, queue, this.threadGroup, "CimomRequestHandler", 5, config.threadPoolSize, config.maxThreads, config.spawnThreadTrigger);
        if (!this.rm.initialize()) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)CLASSNAME, (String)"startup");
            }
            throw new Exception();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"startup");
        }
    }

    public void shutdown(byte shutdownOption) {
        String methodName = "shutdown";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"shutdown", (String)"shutdownOption");
        }
        TraceLoggerFactory.stopLogger((String)this.getTypeCode());
        MessageLog.logMessage((String)"STS0002I");
        if (this.rm != null) {
            this.rm.dispose();
            this.rm = null;
        }
        if (this.logWriter != null) {
            try {
                this.logWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logWriter = null;
        }
    }
}

