/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.util.snmp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.aperi.xmsg.LocalizableException;

public class Asn1Value {
    public static final int UNIVERSAL_CLASS = 0;
    public static final int APPLICATION_CLASS = 1;
    public static final int CONTEXT_CLASS = 2;
    public static final int PRIVATE_CLASS = 3;
    public static final int INTEGER_ID = Asn1Value.universalId(2);
    public static final int OCTET_STRING_ID = Asn1Value.universalId(4);
    public static final int NULL_ID = Asn1Value.universalId(5);
    public static final int OBJECT_IDENTIFIER_ID = Asn1Value.universalId(6);
    public static final int SEQUENCE_ID = Asn1Value.universalId(16);
    public static final int NUMERIC_STRING_ID = Asn1Value.universalId(18);
    public static final int PRINTABLE_STRING_ID = Asn1Value.universalId(19);
    public static final int TRAP_ID = Asn1Value.contextId(4);
    public static final int IP_ADDRESS_ID = Asn1Value.applicationId(0);
    public static final int COUNTER_ID = Asn1Value.applicationId(1);
    public static final int GAUGE_ID = Asn1Value.applicationId(2);
    public static final int TIME_TICKS_ID = Asn1Value.applicationId(3);
    public static final int OPAQUE_ID = Asn1Value.applicationId(4);
    public static final int[] TRELLISOFT_ENTERPRISE_OID = new int[]{1, 3, 6, 1, 4, 1, 6076};
    public static final Asn1Value Null = new Asn1Value(NULL_ID, null);
    public static final Asn1Value EmptySequence = new Asn1Value(new Asn1Value[0]);
    public static final Asn1Value EmptyString = new Asn1Value("");
    static final int TAG_MASK = 0xFFFFFFF;
    static final int constructedShift = 28;
    static final int classShift = 29;
    static final int CONSTRUCTED_MASK = 0x10000000;
    static final int CLASS_MASK = 0x60000000;
    public int identifier;
    public Object content = null;

    public static int identifier(int c, int t) {
        return c << 29 | t & 0xFFFFFFF;
    }

    public static int identifierClass(int i) {
        return i >> 29;
    }

    public static int identifierTag(int i) {
        return i & 0xFFFFFFF;
    }

    public static boolean identifierConstructed(int i) {
        return (i & 0x10000000) != 0;
    }

    public static final int universalId(int i) {
        return Asn1Value.identifier(0, i);
    }

    public static final int applicationId(int i) {
        return Asn1Value.identifier(1, i);
    }

    public static final int contextId(int i) {
        return Asn1Value.identifier(2, i);
    }

    public static final int privateId(int i) {
        return Asn1Value.identifier(3, i);
    }

    public static Asn1Value counter(int i) {
        return new Asn1Value(COUNTER_ID, new Integer(i));
    }

    public static Asn1Value gauge(int i) {
        return new Asn1Value(GAUGE_ID, new Integer(i));
    }

    public static Asn1Value timeTicks(long i) {
        return new Asn1Value(TIME_TICKS_ID, new Long(i));
    }

    public static Asn1Value Opaque(String i) {
        return new Asn1Value(OPAQUE_ID, i);
    }

    public static Asn1Value ipAddress(InetAddress i) {
        return new Asn1Value(IP_ADDRESS_ID, i.getAddress());
    }

    public static Asn1Value trellisoftOID(int[] v) {
        int[] oid = new int[TRELLISOFT_ENTERPRISE_OID.length + v.length];
        System.arraycopy(TRELLISOFT_ENTERPRISE_OID, 0, oid, 0, TRELLISOFT_ENTERPRISE_OID.length);
        System.arraycopy(v, 0, oid, TRELLISOFT_ENTERPRISE_OID.length, v.length);
        return new Asn1Value(oid);
    }

    public Asn1Value(int t, Object v) {
        this.identifier = t;
        this.content = v;
    }

    public Asn1Value(int v) {
        this.identifier = INTEGER_ID;
        this.content = new Integer(v);
    }

    public Asn1Value(long v) {
        this.identifier = INTEGER_ID;
        this.content = new Long(v);
    }

    public Asn1Value(String v) {
        this.identifier = OCTET_STRING_ID;
        this.content = v;
    }

    public Asn1Value(int[] v) {
        this.identifier = OBJECT_IDENTIFIER_ID;
        this.content = v;
    }

    public Asn1Value(Vector v) {
        this.identifier = SEQUENCE_ID;
        this.content = v;
    }

    public Asn1Value(Asn1Value[] v) {
        this.identifier = SEQUENCE_ID;
        this.content = v;
    }

    public Asn1Value explicit(int identifier, Asn1Value v) {
        Asn1Value[] constructed = new Asn1Value[]{v};
        return new Asn1Value(identifier, constructed);
    }

    public Asn1Value implicit(int identifier, Asn1Value v) {
        return new Asn1Value(identifier, v.content);
    }

    public int getInt() {
        return (int)this.getLong();
    }

    public long getLong() {
        if (this.content instanceof Long) {
            return (Long)this.content;
        }
        return ((Integer)this.content).intValue();
    }

    public String getString() {
        return (String)this.content;
    }

    public Vector getVector() {
        return (Vector)this.content;
    }

    public Asn1Value[] getArray() {
        return (Asn1Value[])this.content;
    }

    public void print(PrintWriter out) throws IOException {
        int ans1class = Asn1Value.identifierClass(this.identifier);
        String[] className = new String[]{"[UNIVERSAL ", "[APPLICATION ", "[CONTEXT ", "[PRIVATE "};
        out.print(className[ans1class]);
        out.print(Asn1Value.identifierTag(this.identifier));
        out.print("] ");
        if (this.content == null) {
            out.print("NULL");
        } else if (this.content instanceof Integer) {
            out.print((Integer)this.content);
        } else if (this.content instanceof Long) {
            out.print((Long)this.content);
        } else if (this.content instanceof String) {
            out.print("\"" + (String)this.content + "\"");
        } else if (this.content instanceof byte[]) {
            out.print("OCTET STRING:");
            Asn1Value.printHex(out, (byte[])this.content);
        } else if (this.content instanceof int[]) {
            int[] numbers = (int[])this.content;
            StringBuffer b = new StringBuffer();
            if (numbers.length > 0) {
                b.append(String.valueOf(numbers[0]));
                for (int i = 1; i < numbers.length; ++i) {
                    b.append(".");
                    b.append(String.valueOf(numbers[i]));
                }
            } else {
                b.append(".");
            }
            out.print(b.toString());
        } else if (this.content instanceof Vector) {
            out.print("{ ");
            Enumeration e = ((Vector)this.content).elements();
            while (e.hasMoreElements()) {
                ((Asn1Value)e.nextElement()).print(out);
                out.print(", ");
            }
            out.print("}");
        } else if (this.content instanceof Asn1Value[]) {
            Asn1Value[] e = (Asn1Value[])this.content;
            out.print("{ ");
            for (int i = 0; i < e.length; ++i) {
                e[i].print(out);
                out.print(", ");
            }
            out.print("}");
        } else {
            out.print("<UNKNOWN>");
        }
    }

    private static void printHex(PrintWriter out, byte[] coded, int max) {
        String hexDigits = "0123456789ABCDEF";
        for (int i = 0; i < coded.length && i < max; ++i) {
            int c = coded[i];
            if (c < 0) {
                c += 256;
            }
            int hex1 = c & 0xF;
            int hex2 = c >> 4;
            out.print(hexDigits.substring(hex2, hex2 + 1));
            out.print(hexDigits.substring(hex1, hex1 + 1));
        }
    }

    private static void printHex(PrintWriter out, byte[] coded) {
        Asn1Value.printHex(out, coded, coded.length);
    }

    private static void encodeTagInteger(OutputStream out, int value) throws IOException {
        byte[] octets = new byte[5];
        int n = 0;
        while (value != 0) {
            octets[n] = (byte)(value & 0x7F);
            value >>= 7;
            ++n;
        }
        for (int i = n - 1; i > 0; --i) {
            out.write(octets[i] | 0x80);
        }
        out.write(octets[0]);
    }

    private static void encodeLength(OutputStream out, int length) throws IOException {
        if (length < 128) {
            out.write((byte)length);
        } else {
            byte[] octets = new byte[4];
            int n = 0;
            while (length != 0) {
                octets[n] = (byte)(length & 0xFF);
                length >>= 8;
                n = (byte)(n + 1);
            }
            out.write(0x80 | n);
            for (int i = n - 1; i >= 0; --i) {
                out.write(octets[i]);
            }
        }
    }

    private void encodeIdentifier(OutputStream out, boolean constructed) throws IOException {
        int c = Asn1Value.identifierClass(this.identifier);
        int t = Asn1Value.identifierTag(this.identifier);
        byte mask = (byte)(c << 6 | (constructed ? 32 : 0));
        if (t <= 30) {
            out.write(mask | t);
        } else {
            out.write(mask | 0x1F);
            Asn1Value.encodeTagInteger(out, t);
        }
    }

    private void encode(OutputStream out) throws IOException {
        boolean constructed = this.content instanceof Vector || this.content instanceof Asn1Value[];
        this.encodeIdentifier(out, constructed);
        if (this.content instanceof Integer) {
            Asn1Value.encodeContent(out, this.getInt());
        } else if (this.content instanceof Long) {
            Asn1Value.encodeContent(out, this.getLong());
        } else if (this.content instanceof String) {
            Asn1Value.encodeContent(out, this.getString());
        } else if (this.content instanceof byte[]) {
            Asn1Value.encodeContent(out, (byte[])this.content);
        } else if (this.content instanceof int[]) {
            Asn1Value.encodeContent(out, (int[])this.content);
        } else if (this.content instanceof Vector) {
            Asn1Value.encodeContent(out, this.getVector());
        } else if (this.content instanceof Asn1Value[]) {
            Asn1Value.encodeContent(out, this.getArray());
        } else if (this.content == null) {
            out.write(0);
        } else {
            throw new ClassCastException("invalid content class");
        }
    }

    private static void encodeContent(OutputStream out, long value) throws IOException {
        int n;
        byte[] octets = new byte[8];
        long endValue = value < 0L ? -1L : 0L;
        long endSign = endValue & 0x80L;
        for (n = 0; n == 0 || value != endValue || (long)(octets[n - 1] & 0x80) != endSign; value >>= 8, n = (int)((byte)(n + 1))) {
            octets[n] = (byte)(value & 0xFFL);
        }
        out.write(n);
        for (int i = n - 1; i >= 0; --i) {
            out.write(octets[i]);
        }
    }

    private static void encodeContent(OutputStream out, String value) throws IOException {
        Asn1Value.encodeLength(out, value.length());
        OutputStreamWriter w = new OutputStreamWriter(out);
        w.write(value);
        w.close();
    }

    private static void encodeContent(OutputStream out, byte[] value) throws IOException {
        Asn1Value.encodeLength(out, value.length);
        out.write(value);
    }

    private static void encodeContent(OutputStream out, int[] value) throws IOException {
        if (value.length < 2) {
            throw new IllegalArgumentException("OID has less than 2 numbers");
        }
        int num1 = 40 * value[0] + value[1];
        ByteArrayOutputStream numOut = new ByteArrayOutputStream();
        Asn1Value.encodeTagInteger(numOut, num1);
        for (int i = 2; i < value.length; ++i) {
            Asn1Value.encodeTagInteger(numOut, value[i]);
        }
        byte[] numbersEncoded = numOut.toByteArray();
        Asn1Value.encodeLength(out, numbersEncoded.length);
        out.write(numbersEncoded);
    }

    private static void encodeContent(OutputStream out, Vector value) throws IOException {
        ByteArrayOutputStream code;
        Vector<ByteArrayOutputStream> codes = new Vector<ByteArrayOutputStream>();
        int length = 0;
        Enumeration e = value.elements();
        while (e.hasMoreElements()) {
            code = new ByteArrayOutputStream();
            ((Asn1Value)e.nextElement()).encode(code);
            codes.addElement(code);
            length += code.size();
        }
        Asn1Value.encodeLength(out, length);
        e = codes.elements();
        while (e.hasMoreElements()) {
            code = (ByteArrayOutputStream)e.nextElement();
            out.write(code.toByteArray());
        }
    }

    private static void encodeContent(OutputStream out, Asn1Value[] value) throws IOException {
        int i;
        ByteArrayOutputStream[] codes = new ByteArrayOutputStream[value.length];
        int length = 0;
        for (i = 0; i < value.length; ++i) {
            ByteArrayOutputStream code = new ByteArrayOutputStream();
            value[i].encode(code);
            codes[i] = code;
            length += code.size();
        }
        Asn1Value.encodeLength(out, length);
        for (i = 0; i < value.length; ++i) {
            out.write(codes[i].toByteArray());
        }
    }

    public byte[] encode() throws LocalizableException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.encode(out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }
}

