/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control;

import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.aperi.control.ControlEngine;
import org.eclipse.aperi.control.data.ControlConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;

public class ControlService
implements IService {
    static ILogger msgLogger = null;
    static ILogger traceLogger = null;
    static final String className = ControlService.class.getName();
    private Status status = null;
    public static final String SERVICE_NAME = "ControlService";
    private ControlEngine ce = null;

    public ControlService() {
        msgLogger = ControlConstants.msgLogger;
        traceLogger = ControlConstants.traceLogger;
        String methodName = SERVICE_NAME;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        this.status = new Status(5, 3);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public boolean startup() {
        String methodName = "startup";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        boolean started = false;
        this.status.setRunStatus(9);
        this.ce = ControlEngine.getInstance();
        if (this.ce != null) {
            started = true;
            this.status.setRunStatus(8);
        } else if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Failed to obtain reference to the zone controller.  Fabric Access Service failed to start properly");
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return started;
    }

    public boolean shutdown() {
        String methodName = "shutdown";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        boolean stopped = false;
        if (this.ce != null) {
            this.ce.shutdown();
        }
        this.ce = null;
        stopped = true;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return stopped;
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("ControlService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("ControlService_Description");
    }

    public Status getStatus() {
        return new Status(5, 8);
    }

    public String getVersion() {
        return "5.0.0";
    }

    public String getDescription() {
        String methodName = "getDescription";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getDescription");
        }
        String defaultDescription = "Provides access to control functions such as zone control, and storage configuration.";
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "getDescription");
        }
        return defaultDescription;
    }

    public Hashtable getRoleMap() {
        Hashtable roleMap = new Hashtable();
        return roleMap;
    }
}

