/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control;

import java.lang.reflect.Method;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.control.ControlEngine;
import org.eclipse.aperi.control.ThreadPool;
import org.eclipse.aperi.control.data.ControlConstants;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.InvalidTokenException;
import org.eclipse.aperi.control.interfaces.JobInProgressException;
import org.eclipse.aperi.interfaces.IController;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;

public abstract class Controller
implements IController {
    protected ThreadPool controllerThreadPool = null;
    protected static final int MAXTHREADS = 5;
    protected ControlEngine ce = null;
    protected Token token = null;
    protected boolean threadIsRunning = false;
    protected boolean shutdown = false;
    protected Method m = null;
    protected Object[] args = null;
    ILogger msgLogger = ControlConstants.msgLogger;
    ILogger traceLogger = ControlConstants.traceLogger;
    static final String className = Controller.class.getName();

    public abstract Controller createController(ControlEngine var1, Token var2, Method var3, Object[] var4);

    public abstract String[] getAsyncMethodNames();

    public abstract String[] getNonPersistedTopLevelJobAPIMethodNames();

    protected abstract Class getProxyInterfaceClass();

    protected Token getToken() {
        String methodName = "getToken";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        if (this.threadIsRunning) {
            return this.token;
        }
        return this.ce.getTokenForProxyThread(Thread.currentThread());
    }

    public ThreadPool getThreadPool() {
        String methodName = "getThreadPool";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return this.controllerThreadPool;
    }

    public void shutdown() {
        String methodName;
        block6: {
            methodName = "shutdown";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            }
            if (!this.threadIsRunning && this.controllerThreadPool != null) {
                this.controllerThreadPool.shutdown();
            } else {
                try {
                    this.shutdown = true;
                    Thread t = new Thread((Runnable)((Object)this));
                    t.interrupt();
                    t.join(30000L);
                }
                catch (Exception e) {
                    this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                    if (this.traceLogger == null || !this.traceLogger.isLogging()) break block6;
                    this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    public int startSubJob(String jobName, boolean persistedJob) {
        int subJobNum;
        String methodName;
        block4: {
            methodName = "startSubJob";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            }
            subJobNum = -1;
            try {
                subJobNum = this.ce.startSubJob(this.getToken(), jobName, persistedJob);
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return subJobNum;
    }

    public boolean endSubJob(int subJobNum, int rc, int status, SRMMessage msg, Exception returnException, Object[] returnObjs) {
        boolean bResult;
        String methodName;
        block4: {
            methodName = "endSubJob";
            if (this.traceLogger != null && this.traceLogger.isLogging()) {
                this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
            }
            bResult = false;
            try {
                bResult = this.ce.endSubJob(this.getToken(), subJobNum, rc, status, msg, returnException, returnObjs);
            }
            catch (Exception e) {
                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block4;
                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return bResult;
    }

    protected ILogger getJobLogger() {
        String methodName = "getJobLogger";
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return this.ce.getJobLogger(this.getToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        String methodName;
        block15: {
            Object returnObj;
            block14: {
                methodName = "run";
                if (this.traceLogger != null && this.traceLogger.isLogging()) {
                    this.traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
                }
                this.threadIsRunning = true;
                returnObj = null;
                try {
                    returnObj = this.m.invoke((Object)this, this.args);
                    Object var5_3 = null;
                }
                catch (Throwable throwable) {
                    block17: {
                        Object var5_5 = null;
                        AsyncResult result = this.ce.processReturnObj(this.getToken(), returnObj);
                        if (!this.shutdown) {
                            try {
                                this.ce.endJob(this.getToken(), result.getRc(), result.getStatus(), result.getSRMMessage(), result.getReturnException(), result.getResults());
                            }
                            catch (Exception e2) {
                                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e2);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block17;
                                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                            }
                        }
                    }
                    this.threadIsRunning = false;
                    throw throwable;
                }
                AsyncResult result = this.ce.processReturnObj(this.getToken(), returnObj);
                if (!this.shutdown) {
                    try {
                        this.ce.endJob(this.getToken(), result.getRc(), result.getStatus(), result.getSRMMessage(), result.getReturnException(), result.getResults());
                    }
                    catch (Exception e2) {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e2);
                        if (this.traceLogger == null || !this.traceLogger.isLogging()) break block14;
                        this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                    }
                }
            }
            this.threadIsRunning = false;
            {
                break block15;
                catch (Exception e) {
                    block16: {
                        this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                        if (this.traceLogger != null && this.traceLogger.isLogging()) {
                            this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                        }
                        returnObj = new AsyncResult(-14, 0);
                        ((AsyncResult)returnObj).setReturnException(new Exception(e));
                        Object var5_4 = null;
                        AsyncResult result = this.ce.processReturnObj(this.getToken(), returnObj);
                        if (!this.shutdown) {
                            try {
                                this.ce.endJob(this.getToken(), result.getRc(), result.getStatus(), result.getSRMMessage(), result.getReturnException(), result.getResults());
                            }
                            catch (Exception e2) {
                                this.msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e2);
                                if (this.traceLogger == null || !this.traceLogger.isLogging()) break block16;
                                this.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e2);
                            }
                        }
                    }
                    this.threadIsRunning = false;
                }
            }
        }
        if (this.traceLogger != null && this.traceLogger.isLogging()) {
            this.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    protected void checkToken(Token token) throws InvalidTokenException, JobInProgressException {
        this.ce.checkToken(token);
    }

    protected Token createToken(String resource, String resourceType, String clientId, int accessType) {
        return this.ce.createToken(resource, resourceType, clientId, accessType);
    }

    protected Token getDBToken(String resource, String resourceType, String client, int accessType) {
        return this.ce.getDBToken(resource, resourceType, client, accessType);
    }

    protected void removeToken(String resource, String resourceType) {
        this.ce.removeToken(resource, resourceType);
    }

    protected void removeTokenFromJobs(Token token) {
        this.ce.removeTokenFromJobs(token);
    }

    protected void removeTokenFromValidTokens(Token token) {
        this.ce.removeTokenFromValidTokens(token);
    }

    public void setControlEngine(ControlEngine ce) {
        this.ce = ce;
    }
}

