/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.util.LogUtil;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Level
implements Serializable {
    static final long serialVersionUID = -6321437674805466582L;
    private static final String DESC_FILE = "com.ibm.log.util.Msgs";
    public static final int OFF_INDEX = Integer.MAX_VALUE;
    public static final int FATAL_INDEX = 7000;
    public static final int ERROR_INDEX = 6000;
    public static final int WARNING_INDEX = 5000;
    public static final int INFO_INDEX = 4000;
    public static final int DEBUG_MIN_INDEX = 3000;
    public static final int DEBUG_MID_INDEX = 2000;
    public static final int DEBUG_MAX_INDEX = 1000;
    public static final int ALL_INDEX = Integer.MIN_VALUE;
    private static Hashtable knownLevels = new Hashtable();
    public static final Level OFF = new Level("OFF", Integer.MAX_VALUE, "LEVEL_OFF", "com.ibm.log.util.Msgs");
    public static final Level FATAL = new Level("FATAL", 7000, "LEVEL_FATAL", "com.ibm.log.util.Msgs");
    public static final Level ERROR = new Level("ERROR", 6000, "LEVEL_ERROR", "com.ibm.log.util.Msgs");
    public static final Level WARN = new Level("WARN", 5000, "LEVEL_WARNING", "com.ibm.log.util.Msgs");
    public static final Level INFO = new Level("INFO", 4000, "LEVEL_INFO", "com.ibm.log.util.Msgs");
    public static final Level DEBUG_MIN = new Level("DEBUG_MIN", 3000, "LEVEL_DEBUG_MIN", "com.ibm.log.util.Msgs");
    public static final Level DEBUG_MID = new Level("DEBUG_MID", 2000, "LEVEL_DEBUG_MID", "com.ibm.log.util.Msgs");
    public static final Level DEBUG_MAX = new Level("DEBUG_MAX", 1000, "LEVEL_DEBUG_MAX", "com.ibm.log.util.Msgs");
    public static final Level ALL = new Level("ALL", Integer.MIN_VALUE, "LEVEL_ALL", "com.ibm.log.util.Msgs");
    protected int value = Integer.MAX_VALUE;
    protected String description = "";
    protected String descriptionFile = "";
    protected String descriptionKey = "";
    protected String name = "";

    public static Level getLevel(String name) {
        name = name.toUpperCase();
        return (Level)knownLevels.get(name);
    }

    public static Enumeration getAllLevels() {
        return knownLevels.elements();
    }

    protected Level(String name, int value) {
        this.setName(name);
        this.value = value;
        knownLevels.put(this.getName(), this);
    }

    protected Level(String name, int value, String description) {
        this(name, value);
        this.setDescription(description);
    }

    protected Level(String name, int value, String descKey, String descFile) {
        this(name, value);
        this.setDescription(descKey, descFile);
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        if (name != null) {
            this.name = name = name.toUpperCase();
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setName");
            LogUtil.errorMsg(msg);
        }
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(Locale locale) {
        String desc = this.description;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.descriptionFile != null && this.descriptionKey != null) {
            try {
                ResourceBundle msgBundle = ResourceBundle.getBundle(this.descriptionFile, locale);
                desc = msgBundle.getString(this.descriptionKey);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return desc;
    }

    protected void setDescription(String desc) {
        if (desc != null) {
            this.description = desc;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setDescription");
            LogUtil.errorMsg(msg);
        }
    }

    protected void setDescription(String key, String file) {
        if (key != null && file != null) {
            this.descriptionKey = key;
            this.descriptionFile = file;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setDescription");
            LogUtil.errorMsg(msg);
        }
    }

    public final int getValue() {
        return this.value;
    }

    public boolean equals(Level level) {
        boolean result = false;
        if (this.getValue() == level.getValue()) {
            result = true;
        }
        return result;
    }

    public int hashcode() {
        return this.getValue();
    }

    public String toString() {
        return "levelName=" + this.getName() + ", levelValue=" + this.getValue();
    }
}

