/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.util.CircularEventQueue;
import com.ibm.log.util.LogUtil;
import java.util.Properties;

public class MemoryHandler
extends Handler {
    static final long serialVersionUID = 8568566190684608305L;
    protected transient CircularEventQueue queue = new CircularEventQueue();
    protected boolean convertExceptions = false;

    public MemoryHandler() {
        this.open = true;
    }

    public MemoryHandler(String name) {
        super(name);
        this.open = true;
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("queueCapacity", new Integer(this.queue.getCapacity()).toString());
        props.put("convertExceptions", new Boolean(this.convertExceptions));
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("queueCapacity");
        if (prop != null) {
            this.queue.setCapacity(new Integer(prop));
        }
        if ((prop = props.getProperty("dumpEvents")) != null) {
            this.setDumpEvents(new Boolean(prop));
        }
        if ((prop = props.getProperty("convertExceptions")) != null) {
            this.convertExceptions = new Boolean(prop);
        }
    }

    public int getQueueCount() {
        return this.queue.getQueueCount();
    }

    public int getQueueCapacity() {
        return this.queue.getCapacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueueCapacity(int capacity) {
        if (capacity >= 1) {
            Object object = this.deviceLock;
            synchronized (object) {
                this.close();
                this.queue.setCapacity(capacity);
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_BAD_PARM", new Integer(capacity), this.getClass().getName() + ".setQueueCapacity");
            LogUtil.errorMsg(msg);
        }
    }

    public void setDumpEvents(boolean flag) {
        if (flag) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.deviceLock;
        synchronized (object) {
            while (this.queue.getQueueCount() > 0) {
                this.log(this.queue.dequeue());
            }
        }
    }

    public synchronized void process(LogEvent event) {
        if (event != null) {
            if (this.convertExceptions) {
                event.convertException();
            }
            this.queue.enqueue(event);
        }
    }

    public void write(LogEvent event) throws Exception {
    }

    public String toString() {
        String result = super.toString();
        return result + ", capacity=" + this.getQueueCapacity();
    }
}

