/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.LogEvent;
import com.ibm.log.TypeLogger;

public class SimpleTypeLogger
extends TypeLogger {
    static final long serialVersionUID = 4735605126703831855L;

    public SimpleTypeLogger() {
    }

    public SimpleTypeLogger(String name) {
        super(name);
    }

    public void fatal(String text) {
        if (this.isLoggable(8L)) {
            this.logText(8L, text, null);
        }
    }

    public void fatal(String text, Object insert1) {
        if (this.isLoggable(8L)) {
            Object[] inserts = new Object[]{insert1};
            this.logText(8L, text, inserts);
        }
    }

    public void fatal(String text, Object insert1, Object insert2) {
        if (this.isLoggable(8L)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logText(8L, text, inserts);
        }
    }

    public void fatal(String text, Object[] inserts) {
        if (this.isLoggable(8L)) {
            this.logText(8L, text, inserts);
        }
    }

    public void error(String text) {
        if (this.isLoggable(4L)) {
            this.logText(4L, text, null);
        }
    }

    public void error(String text, Object insert1) {
        if (this.isLoggable(4L)) {
            Object[] inserts = new Object[]{insert1};
            this.logText(4L, text, inserts);
        }
    }

    public void error(String text, Object insert1, Object insert2) {
        if (this.isLoggable(4L)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logText(4L, text, inserts);
        }
    }

    public void error(String text, Object[] inserts) {
        if (this.isLoggable(4L)) {
            this.logText(4L, text, inserts);
        }
    }

    public void warn(String text) {
        if (this.isLoggable(2L)) {
            this.logText(2L, text, null);
        }
    }

    public void warn(String text, Object insert1) {
        if (this.isLoggable(2L)) {
            Object[] inserts = new Object[]{insert1};
            this.logText(2L, text, inserts);
        }
    }

    public void warn(String text, Object insert1, Object insert2) {
        if (this.isLoggable(2L)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logText(2L, text, inserts);
        }
    }

    public void warn(String text, Object[] inserts) {
        if (this.isLoggable(2L)) {
            this.logText(2L, text, inserts);
        }
    }

    public void info(String text) {
        if (this.isLoggable(1L)) {
            this.logText(1L, text, null);
        }
    }

    public void info(String text, Object insert1) {
        if (this.isLoggable(1L)) {
            Object[] inserts = new Object[]{insert1};
            this.logText(1L, text, inserts);
        }
    }

    public void info(String text, Object insert1, Object insert2) {
        if (this.isLoggable(1L)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logText(1L, text, inserts);
        }
    }

    public void info(String text, Object[] inserts) {
        if (this.isLoggable(1L)) {
            this.logText(1L, text, inserts);
        }
    }

    public void entry() {
        if (this.isLoggable(64L)) {
            this.logText(64L, "Entry", null);
        }
    }

    public void entry(Object parm1) {
        if (this.isLoggable(64L)) {
            Object[] parms = new Object[]{SimpleTypeLogger.objToStr(parm1)};
            this.logText(64L, "Entry, parm 1 = {0}", parms);
        }
    }

    public void entry(Object parm1, Object parm2) {
        if (this.isLoggable(64L)) {
            Object[] parms = new Object[]{SimpleTypeLogger.objToStr(parm1), SimpleTypeLogger.objToStr(parm2)};
            this.logText(64L, "Entry, parm 1 = {0}, parm 2 = {1}", parms);
        }
    }

    public void entry(Object[] parms) {
        if (this.isLoggable(64L)) {
            StringBuffer bfr = new StringBuffer("Entry");
            Object[] strs = null;
            if (parms != null) {
                strs = new String[parms.length];
                for (int j = 0; j < parms.length; ++j) {
                    bfr.append(", parm " + (j + 1) + " = {" + j + "}");
                    strs[j] = SimpleTypeLogger.objToStr(parms[j]);
                }
            }
            this.logText(64L, bfr.toString(), strs);
        }
    }

    public void exit() {
        if (this.isLoggable(128L)) {
            this.logText(128L, "Exit", null);
        }
    }

    public void exit(byte retValue) {
        if (this.isLoggable(128L)) {
            Object[] parms = new Object[]{new Byte(retValue)};
            this.logText(128L, "Exit, return value = {0}", parms);
        }
    }

    public void exit(short retValue) {
        if (this.isLoggable(128L)) {
            Object[] parms = new Object[]{new Short(retValue)};
            this.logText(128L, "Exit, return value = {0}", parms);
        }
    }

    public void exit(int retValue) {
        if (this.isLoggable(128L)) {
            Object[] parms = new Object[]{new Integer(retValue)};
            this.logText(128L, "Exit, return value = {0}", parms);
        }
    }

    public void exit(long retValue) {
        if (this.isLoggable(128L)) {
            Object[] parms = new Object[]{new Long(retValue)};
            this.logText(128L, "Exit, return value = {0}", parms);
        }
    }

    public void exit(float retValue) {
        if (this.isLoggable(128L)) {
            Object[] parms = new Object[]{new Float(retValue)};
            this.logText(128L, "Exit, return value = {0}", parms);
        }
    }

    public void exit(double retValue) {
        if (this.isLoggable(128L)) {
            Object[] parms = new Object[]{new Double(retValue)};
            this.logText(128L, "Exit, return value = {0}", parms);
        }
    }

    public void exit(char retValue) {
        if (this.isLoggable(128L)) {
            Object[] parms = new Object[]{new Character(retValue)};
            this.logText(128L, "Exit, return value = {0}", parms);
        }
    }

    public void exit(boolean retValue) {
        if (this.isLoggable(128L)) {
            Object[] parms = new Object[]{new Boolean(retValue)};
            this.logText(128L, "Exit, return value = {0}", parms);
        }
    }

    public void exit(Object retValue) {
        if (this.isLoggable(128L)) {
            Object[] parms = new Object[]{SimpleTypeLogger.objToStr(retValue)};
            this.logText(128L, "Exit, return value = {0}", parms);
        }
    }

    public void exception(Throwable throwable) {
        if (this.isLoggable(4L)) {
            LogEvent event = new LogEvent(4L, throwable);
            this.logAndWarn(event);
        }
    }

    public void exception(Throwable throwable, String text) {
        if (this.isLoggable(4L)) {
            LogEvent event = new LogEvent(4L, throwable, text);
            this.logAndWarn(event);
        }
    }

    public void misc(String text) {
        if (this.isLoggable(256L)) {
            this.logText(256L, text, null);
        }
    }

    public void misc(String text, Object insert1) {
        if (this.isLoggable(256L)) {
            Object[] inserts = new Object[]{insert1};
            this.logText(256L, text, inserts);
        }
    }

    public void misc(String text, Object insert1, Object insert2) {
        if (this.isLoggable(256L)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logText(256L, text, inserts);
        }
    }

    public void misc(String text, Object[] inserts) {
        if (this.isLoggable(256L)) {
            this.logText(256L, text, inserts);
        }
    }

    public void perf(String text) {
        if (this.isLoggable(32768L)) {
            this.logText(32768L, text, null);
        }
    }

    public void perf(String text, Object insert1) {
        if (this.isLoggable(32768L)) {
            Object[] inserts = new Object[]{insert1};
            this.logText(32768L, text, inserts);
        }
    }

    public void perf(String text, Object insert1, Object insert2) {
        if (this.isLoggable(32768L)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logText(32768L, text, inserts);
        }
    }

    public void perf(String text, Object[] inserts) {
        if (this.isLoggable(32768L)) {
            this.logText(32768L, text, inserts);
        }
    }

    public void svc(String text) {
        if (this.isLoggable(16384L)) {
            this.logText(16384L, text, null);
        }
    }

    public void svc(String text, Object insert1) {
        if (this.isLoggable(16384L)) {
            Object[] inserts = new Object[]{insert1};
            this.logText(16384L, text, inserts);
        }
    }

    public void svc(String text, Object insert1, Object insert2) {
        if (this.isLoggable(16384L)) {
            Object[] inserts = new Object[]{insert1, insert2};
            this.logText(16384L, text, inserts);
        }
    }

    public void svc(String text, Object[] inserts) {
        if (this.isLoggable(16384L)) {
            this.logText(16384L, text, inserts);
        }
    }
}

