/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;

public class StreamHandler
extends Handler {
    static final long serialVersionUID = -6390988184944454386L;
    protected static boolean addLineSep = true;
    protected static String lineSeparator = System.getProperty("line.separator");
    protected static int lineSeparatorLength = lineSeparator.length();
    protected transient BufferedWriter bWriter = null;
    private transient OutputStream outputStream = null;

    public StreamHandler() {
    }

    public StreamHandler(String name) {
        super(name);
    }

    public StreamHandler(String name, OutputStream os) {
        super(name);
        this.setOutputStream(os);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("addLineSeparator", new Boolean(addLineSep).toString());
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("addLineSeparator");
        if (prop != null) {
            this.setAddLineSeparator(new Boolean(prop));
        }
    }

    public boolean getAddLineSeparator() {
        return addLineSep;
    }

    public void setAddLineSeparator(boolean add) {
        addLineSep = add;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream os) {
        if (os != null) {
            this.outputStream = os;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setOutputStream");
            LogUtil.errorMsg(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                OutputStreamWriter osw = new OutputStreamWriter(this.getOutputStream());
                this.bWriter = new BufferedWriter(osw);
                this.open = true;
                this.writeHeader();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.deviceLock;
        synchronized (object) {
            if (this.open) {
                try {
                    this.writeTrailer();
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.bWriter.flush();
                    this.bWriter.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.bWriter = null;
            this.open = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LogEvent event) throws Exception {
        Object object = this.deviceLock;
        synchronized (object) {
            if (!this.open) {
                this.open();
            }
            String msg = this.getFormatter().format(event);
            this.bWriter.write(msg, 0, msg.length());
            if (addLineSep) {
                this.bWriter.write(lineSeparator, 0, lineSeparatorLength);
            }
            this.bWriter.flush();
        }
    }

    protected void writeHeader() throws Exception {
        String header = this.getFormatter().getHeader();
        if (header != null) {
            this.bWriter.write(header, 0, header.length());
            this.bWriter.flush();
        }
    }

    protected void writeTrailer() throws Exception {
        String trailer = this.getFormatter().getTrailer();
        if (trailer != null) {
            this.bWriter.write(trailer, 0, trailer.length());
            this.bWriter.flush();
        }
    }
}

