/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.mgr;

import com.ibm.log.mgr.ConfigChangeEvent;
import com.ibm.log.mgr.ConfigChangeListener;
import com.ibm.log.mgr.DataStore;
import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.util.LogUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class DataStoreSupport
implements DataStore {
    private static final String ROOT_NAME = "/";
    protected boolean initialized = false;
    private final DataStoreConfig root;
    private Hashtable fullConfig = new Hashtable();
    private Object configLock = new Object();
    private Object listenerLock = new Object();
    private Vector listeners = new Vector();

    public DataStoreSupport() {
        this.root = new DataStoreConfig();
        this.root.setProperty("name", ROOT_NAME);
        this.root.setLoadedFromDataStore(false);
        this.fullConfig.put(ROOT_NAME, this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfig(DataStoreConfig config) {
        DataStoreConfig parent = null;
        if (config != null) {
            String name = config.getProperty("name");
            if (name != null && !name.trim().equals("")) {
                Object object = this.configLock;
                synchronized (object) {
                    if (!this.fullConfig.containsKey(name)) {
                        this.fullConfig.put(name, config);
                        parent = this.getParentConfig(config);
                        config.setParent(parent);
                        Iterator it = parent.getChildren();
                        while (it.hasNext()) {
                            DataStoreConfig child = (DataStoreConfig)it.next();
                            if (this.getParentConfig(child) == parent) continue;
                            it.remove();
                            config.addChild(child);
                            child.setParent(config);
                        }
                        parent.addChild(config);
                        this.notifyConfigChangeListeners(config);
                    }
                }
            } else {
                String msg = LogUtil.getLogMsg("ERR_BAD_PARM", name, this.getClass().getName() + ".addConfig");
                LogUtil.errorMsg(msg);
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".addConfig");
            LogUtil.errorMsg(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfig(DataStoreConfig config) {
        if (config != null) {
            String name = config.getProperty("name");
            if (name != null && !name.trim().equals("")) {
                Object object = this.configLock;
                synchronized (object) {
                    if (this.fullConfig.containsKey(name)) {
                        this.fullConfig.remove(name);
                        DataStoreConfig parent = config.getParent();
                        parent.removeChild(config);
                        Iterator it = config.getChildren();
                        while (it.hasNext()) {
                            DataStoreConfig child = (DataStoreConfig)it.next();
                            it.remove();
                            parent.addChild(child);
                            child.setParent(parent);
                        }
                        config.setParent(null);
                    }
                }
            } else {
                String msg = LogUtil.getLogMsg("ERR_BAD_PARM", name, this.getClass().getName() + ".removeConfig");
                LogUtil.errorMsg(msg);
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".removeConfig");
            LogUtil.errorMsg(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfig(DataStoreConfig config) {
        Object it = null;
        if (config != null) {
            String name = config.getProperty("name");
            if (name != null && !name.trim().equals("")) {
                Object object = this.configLock;
                synchronized (object) {
                    if (this.fullConfig.containsKey(name)) {
                        this.removeConfig(config);
                        this.addConfig(config);
                    }
                }
            } else {
                String msg = LogUtil.getLogMsg("ERR_BAD_PARM", name, this.getClass().getName() + ".updateConfig");
                LogUtil.errorMsg(msg);
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".updateConfig");
            LogUtil.errorMsg(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getConfig() {
        Object object = this.configLock;
        synchronized (object) {
            return this.fullConfig.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStoreConfig getConfig(String name) {
        DataStoreConfig config = null;
        if (name != null) {
            if (!name.trim().equals("")) {
                Object object = this.configLock;
                synchronized (object) {
                    config = (DataStoreConfig)this.fullConfig.get(name);
                    if (config == null) {
                        config = new DataStoreConfig();
                        config.setProperty("name", name);
                        this.addConfig(config);
                    }
                }
            } else {
                String msg = LogUtil.getLogMsg("ERR_BAD_PARM", name, this.getClass().getName() + ".getConfig(String)");
                LogUtil.errorMsg(msg);
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".getConfig(String)");
            LogUtil.errorMsg(msg);
        }
        return config;
    }

    public boolean containsConfig(String name) {
        boolean result = false;
        if (name != null && !name.trim().equals("")) {
            result = this.fullConfig.containsKey(name);
        }
        return result;
    }

    public abstract void saveConfig(boolean var1) throws Exception;

    public boolean isWriteable() {
        return false;
    }

    public DataStoreConfig getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataStoreConfig getParentConfig(DataStoreConfig config) {
        boolean found = false;
        DataStoreConfig parent = null;
        String name = config.getProperty("name");
        Object object = this.configLock;
        synchronized (object) {
            while (!found) {
                int dot = name.lastIndexOf(46);
                if (dot == -1) {
                    found = true;
                    parent = this.getRoot();
                    continue;
                }
                parent = (DataStoreConfig)this.fullConfig.get(name = name.substring(0, dot));
                if (parent == null) continue;
                found = true;
            }
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigChangeListener(ConfigChangeListener listener) {
        if (listener != null) {
            Object object = this.listenerLock;
            synchronized (object) {
                if (!this.listeners.contains(listener)) {
                    this.listeners.add(listener);
                }
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".addConfigChangeListener");
            LogUtil.errorMsg(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigChangeListener(ConfigChangeListener listener) {
        if (listener != null) {
            Object object = this.listenerLock;
            synchronized (object) {
                if (this.listeners.contains(listener)) {
                    this.listeners.remove(listener);
                }
            }
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".removeConfigChangeListener");
            LogUtil.errorMsg(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getConfigChangeListeners() {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.listeners.iterator();
        }
    }

    protected void notifyConfigChangeListeners(DataStoreConfig config) {
        if (this.initialized) {
            Iterator it = this.getConfigChangeListeners();
            while (it.hasNext()) {
                ConfigChangeListener l = (ConfigChangeListener)it.next();
                this.notifyAll(l, config);
            }
        }
    }

    private void notifyAll(ConfigChangeListener l, DataStoreConfig config) {
        ConfigChangeEvent event = new ConfigChangeEvent(this, config);
        l.configChange(event);
        Iterator it = config.getChildren();
        while (it.hasNext()) {
            config = (DataStoreConfig)it.next();
            this.notifyAll(l, config);
        }
    }
}

