/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import java.net.InetAddress;

public class CBEGlobalInstanceID {
    private static final String ALPHA_PREFIX = "JL";
    private static final String HOST_IP = CBEGlobalInstanceID.getHostIP();
    private static final String START_TIME = CBEGlobalInstanceID.getStartTime();
    private static final int START_TIME_FIELD_LEN = 14;
    private static final long START_TIME_MASK = 0xFFFFFFFFFFFFL;
    private static int seqCounter = 0;
    private static final int SEQUENCE_FIELD_LEN = 8;
    private static final int BYTE_FF = 255;
    private static final int HEX_DIGIT_F = 15;

    private CBEGlobalInstanceID() {
    }

    public static void appendCBE101GUID(StringBuffer buff) {
        if (null != buff) {
            String sequence = Integer.toHexString(CBEGlobalInstanceID.getNextSequence());
            buff.append(ALPHA_PREFIX);
            buff.append(HOST_IP);
            buff.append(START_TIME);
            for (int i = sequence.length(); i < 8; ++i) {
                buff.append('0');
            }
            buff.append(sequence);
        }
    }

    private static String getHostIP() {
        String hostIP;
        String HEX_LOCALHOST = "7f000001";
        try {
            StringBuffer buff = new StringBuffer();
            byte[] address = InetAddress.getLocalHost().getAddress();
            for (int i = 0; i < address.length; ++i) {
                int nextByte = address[i] & 0xFF;
                if (nextByte <= 15) {
                    buff.append('0');
                }
                buff.append(Integer.toHexString(nextByte));
            }
            hostIP = buff.toString();
        }
        catch (Exception ex) {
            hostIP = "7f000001";
        }
        return hostIP;
    }

    private static String getStartTime() {
        StringBuffer buff = new StringBuffer();
        long now = System.currentTimeMillis() & 0xFFFFFFFFFFFFL;
        String s = Long.toHexString(now);
        for (int i = s.length(); i < 14; ++i) {
            buff.append('0');
        }
        buff.append(s);
        return buff.toString();
    }

    private static synchronized int getNextSequence() {
        int nextSeq = seqCounter++;
        return nextSeq;
    }
}

