/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;

public class CircularEventQueue {
    public static final int DEFAULT_QUEUE_CAPACITY = 10000;
    protected int queueCount = 0;
    protected int capacity;
    private int head = 0;
    private int tail = 0;
    private LogEvent[] queue = null;

    public CircularEventQueue() {
        this(10000);
    }

    public CircularEventQueue(int capacity) throws IllegalArgumentException {
        if (capacity < 1) {
            throw new IllegalArgumentException(LogUtil.getLogMsg("ERR_QUEUE_SIZE", new Integer(capacity)));
        }
        this.setCapacity(capacity);
        this.queue = new LogEvent[capacity];
    }

    public synchronized int getQueueCount() {
        return this.queueCount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        if (capacity >= 1) {
            this.capacity = capacity;
        } else {
            String msg = LogUtil.getLogMsg("ERR_NULL_PARM", this.getClass().getName() + ".setCapacity");
            LogUtil.errorMsg(msg);
        }
    }

    public synchronized void enqueue(LogEvent event) {
        if (event != null) {
            this.queue[this.tail] = event;
            if (this.queueCount < this.capacity) {
                ++this.queueCount;
            }
            if (this.tail == this.head && this.queueCount == this.capacity) {
                this.head = (this.head + 1) % this.capacity;
            }
            this.tail = (this.tail + 1) % this.capacity;
        }
    }

    public synchronized LogEvent dequeue() {
        LogEvent event = this.first();
        if (event != null) {
            this.queue[this.head] = null;
            this.head = (this.head + 1) % this.capacity;
            --this.queueCount;
        }
        return event;
    }

    public synchronized LogEvent first() {
        LogEvent event = null;
        if (this.queueCount != 0) {
            event = this.queue[this.head];
        }
        return event;
    }
}

