/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import com.ibm.log.Handler;
import com.ibm.log.LogEvent;
import com.ibm.log.util.LogUtil;
import com.ibm.log.util.MessageErrorProtocol;
import java.util.Properties;

public class RetryErrorProtocol
extends MessageErrorProtocol {
    static final long serialVersionUID = 2730056913313477501L;
    public static final int DEFAULT_RETRY_COUNT = 5;
    public static final int DEFAULT_RETRY_INTERVAL = 1000;
    private int maxRetries = 5;
    private int retryInterval = 1000;
    private transient Object retryTimer = new Object();

    public RetryErrorProtocol() {
    }

    public RetryErrorProtocol(String name) {
        super(name);
    }

    public Properties getConfig() {
        Properties props = super.getConfig();
        props.put("maxRetries", new Integer(this.getMaxRetries()).toString());
        props.put("retryInterval", new Integer(this.getRetryInterval()).toString());
        return props;
    }

    public void setConfig(Properties props) {
        super.setConfig(props);
        String prop = props.getProperty("maxRetries");
        if (prop != null) {
            this.setMaxRetries(new Integer(prop));
        }
        if ((prop = props.getProperty("retryInterval")) != null) {
            this.setRetryInterval(new Integer(prop));
        }
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int count) {
        if (count >= 0) {
            this.maxRetries = count;
        } else {
            String msg = LogUtil.getLogMsg("ERR_BAD_PARM", new Integer(count), this.getClass().getName() + ".setMaxRetries");
            LogUtil.errorMsg(msg);
        }
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int interval) {
        if (interval >= 0) {
            this.retryInterval = interval;
        } else {
            String msg = LogUtil.getLogMsg("ERR_BAD_PARM", new Integer(interval), this.getClass().getName() + ".setRetryInterval");
            LogUtil.errorMsg(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Handler handler, LogEvent event, Throwable t) {
        boolean done = false;
        int retries = 0;
        int maxRetries = this.getMaxRetries();
        String msg = LogUtil.getLogMsg("RETRY_ATTEMPT", handler.getName());
        if (t != null) {
            String throwableMsg = t.getMessage();
            msg = throwableMsg != null ? msg + System.getProperty("line.separator") + throwableMsg : msg + System.getProperty("line.separator") + t.getClass().getName();
        }
        LogUtil.errorMsg(msg);
        while (!done && retries < maxRetries) {
            block9: {
                int interval = this.getRetryInterval();
                try {
                    if (interval == 0) break block9;
                    Object object = this.retryTimer;
                    synchronized (object) {
                        this.retryTimer.wait(interval);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            try {
                handler.write(event);
                done = true;
            }
            catch (Exception e) {
                ++retries;
            }
        }
        msg = done ? LogUtil.getLogMsg("RETRY_SUCCEEDED") : LogUtil.getLogMsg("RETRY_FAILED");
        LogUtil.errorMsg(msg);
    }

    public void cleanup(Handler handler) {
    }

    public boolean isCleanupRequired() {
        return false;
    }
}

