/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.download.ConfigurationException;
import org.eclipse.aperi.download.EclipseMirrorList;
import org.eclipse.aperi.download.Util;
import org.eclipse.aperi.download.interfaces.IDownload;
import org.eclipse.aperi.download.interfaces.IDownloadTarget;
import org.eclipse.aperi.download.interfaces.IMirror;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Download
implements IDownload {
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_FILE_URL = "url";
    public static final String ATTR_MIRROR_URL = "mirrorxml";
    private String _description = null;
    private String _fileUrl = null;
    private String _mirrorUrl = null;
    private boolean _mirrored = false;

    public Download(Node node) throws ConfigurationException {
        NamedNodeMap downloadAttr = node.getAttributes();
        this._description = Util.getNamedAttribute(downloadAttr, ATTR_DESCRIPTION, true);
        this._fileUrl = Util.getNamedAttribute(downloadAttr, ATTR_FILE_URL, false);
        this._mirrorUrl = Util.getNamedAttribute(downloadAttr, ATTR_MIRROR_URL, false);
        if (this._mirrorUrl != null) {
            this._mirrored = true;
        }
        if (this._fileUrl == null && this._mirrorUrl == null) {
            throw new ConfigurationException("A download must have either a url or a mirrorxml\ndefined in the download configuration.");
        }
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public String getFileUrl() {
        return this._fileUrl;
    }

    @Override
    public boolean isMirrored() {
        return this._mirrored;
    }

    @Override
    public Vector<IMirror> getMirrors() throws IOException, SAXException {
        EclipseMirrorList mirrorList = new EclipseMirrorList(this._mirrorUrl);
        return mirrorList.getMirrors();
    }

    @Override
    public void setFileUrl(String url) {
        this._fileUrl = url;
    }

    @Override
    public abstract void downloadFile(String var1, String var2) throws Exception;

    public void fileCopy(File origFile, File newFile) throws IOException {
        FileChannel in = new FileInputStream(origFile).getChannel();
        FileChannel out = new FileOutputStream(newFile).getChannel();
        out.transferFrom(in, 0L, in.size());
        in.close();
        out.close();
    }

    public void streamCopy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buff = new byte[1024];
        while ((bytesRead = in.read(buff)) != -1) {
            out.write(buff, 0, bytesRead);
        }
    }

    public void createPlaceholders(Vector<IDownloadTarget> downloadTargets, String baseDir) throws IOException {
        Iterator<IDownloadTarget> targetItr = downloadTargets.iterator();
        File targetFile = null;
        try {
            while (targetItr.hasNext()) {
                IDownloadTarget target = targetItr.next();
                targetFile = new File(baseDir + File.separator + target.getTargetPath());
                targetFile.createNewFile();
                targetFile.setLastModified(0L);
            }
        }
        catch (IOException e) {
            System.out.println("File creation failed: " + targetFile.getAbsolutePath());
            for (IDownloadTarget target : downloadTargets) {
                targetFile = new File(target.getTargetPath());
                if (!targetFile.exists() || targetFile.lastModified() != 0L) continue;
                targetFile.delete();
            }
            throw e;
        }
    }

    public boolean prepTargets(long modifiedDate, Vector<IDownloadTarget> downloadTargets, String baseDir) throws IOException {
        File targetFile;
        boolean exactMatch = false;
        int totalTargets = downloadTargets.size();
        int nMatch = 0;
        int nNoMatch = 0;
        for (IDownloadTarget target : downloadTargets) {
            targetFile = new File(baseDir + File.separator + target.getTargetPath());
            if (!targetFile.exists()) continue;
            if (targetFile.lastModified() == modifiedDate) {
                ++nMatch;
                continue;
            }
            ++nNoMatch;
        }
        if (nMatch == totalTargets) {
            exactMatch = true;
        } else if (nNoMatch > 0) {
            for (IDownloadTarget target : downloadTargets) {
                targetFile = new File(baseDir + File.separator + target.getTargetPath());
                if (!targetFile.exists() || targetFile.delete()) continue;
                throw new IOException("Failed to delete file: " + targetFile.getAbsolutePath());
            }
        }
        return exactMatch;
    }

    public void copyToTargets(File sourceFile, Vector<IDownloadTarget> downloadTargets, String baseDir, long lastModified) throws IOException {
        try {
            for (IDownloadTarget target : downloadTargets) {
                File targetFile = new File(baseDir + File.separator + target.getTargetPath());
                if (targetFile.lastModified() != 0L) {
                    throw new IOException("Concurrent modification detected: " + targetFile.getAbsolutePath());
                }
                this.fileCopy(sourceFile, targetFile);
                targetFile.setLastModified(lastModified);
            }
            sourceFile.delete();
        }
        catch (IOException e) {
            for (IDownloadTarget target : downloadTargets) {
                File targetFile = new File(target.getTargetPath());
                if (!targetFile.exists()) continue;
                targetFile.delete();
            }
            sourceFile.delete();
            throw e;
        }
    }
}

