/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.download;

import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.eclipse.aperi.download.Mirror;
import org.eclipse.aperi.download.interfaces.IMirror;
import org.eclipse.aperi.download.interfaces.IMirrorList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseMirrorList
implements IMirrorList {
    public static final String ATTR_MIRROR = "mirror";
    public static final String ATTR_URL = "url";
    public static final String ATTR_LABEL = "label";
    private URL _mirrorUrl = null;
    private Vector<IMirror> _mirrors = new Vector();

    public EclipseMirrorList(String mirrorUrl) throws IOException, SAXException {
        this._mirrorUrl = new URL(mirrorUrl);
        URLConnection urlConn = this._mirrorUrl.openConnection();
        InputStream in = urlConn.getInputStream();
        DOMParser parser = new DOMParser();
        InputSource inputSource = new InputSource(in);
        parser.parse(inputSource);
        Document mirrorDoc = parser.getDocument();
        NodeList mirrors = mirrorDoc.getElementsByTagName(ATTR_MIRROR);
        for (int i = 0; i < mirrors.getLength(); ++i) {
            Node mirror = mirrors.item(i);
            String fileUrl = mirror.getAttributes().getNamedItem(ATTR_URL).getNodeValue();
            String description = mirror.getAttributes().getNamedItem(ATTR_LABEL).getNodeValue();
            this._mirrors.add(new Mirror(description, fileUrl));
        }
    }

    @Override
    public Vector<IMirror> getMirrors() {
        return this._mirrors;
    }
}

