/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;

public class ConnectionPool {
    private Driver repositoryDriver;
    private Connection[] pool;
    private String repositoryURL;
    private Properties connectProperties;
    private int openConnections = 0;
    private int poolIndex = 0;
    private int poolSize;
    public String udbSqlid;

    public ConnectionPool(String driverName, String repositoryURL, Properties connectProperties, int poolSize) throws ClassNotFoundException, SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConnectionPool.class.getName(), (String)"ConnectionPool", (String)"driverName, repositoryURL, connectProperties, poolSize");
        }
        this.repositoryURL = repositoryURL;
        this.connectProperties = connectProperties;
        this.poolSize = poolSize;
        this.pool = new Connection[poolSize > 0 ? poolSize : 1];
        Class.forName(driverName);
        this.repositoryDriver = DriverManager.getDriver(repositoryURL);
        if (SQLUtil.isUDB()) {
            this.udbSqlid = this.connectProperties.getProperty("schema");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConnectionPool.class.getName(), (String)"ConnectionPool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freePool() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConnectionPool.class.getName(), (String)"freePool", (String)"");
        }
        Connection[] connectionArray = this.pool;
        synchronized (this.pool) {
            block10: {
                for (int i = 0; i < this.poolSize; ++i) {
                    if (this.pool[i] == null) continue;
                    this.closeConnection(this.pool[i]);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (SQLUtil.isCloudscape()) {
                    try {
                        this.repositoryDriver.connect("jdbc:db2j:;shutdown=true", this.connectProperties);
                    }
                    catch (SQLException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)ConnectionPool.class.getName(), (String)"freePool", (Throwable)e);
                        }
                        if (e.getSQLState().equals("XJ015")) break block10;
                        SQLUtil.logSQLException("SRV0045E", e, null);
                    }
                }
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ConnectionPool.class.getName(), (String)"freePool");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(boolean messageWanted) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConnectionPool.class.getName(), (String)"getConnection", (String)"messageWanted");
        }
        Connection dbConnection = null;
        Connection[] connectionArray = this.pool;
        synchronized (this.pool) {
            Connection traceResult;
            if (this.poolIndex > 0) {
                --this.poolIndex;
                dbConnection = this.pool[this.poolIndex];
                this.pool[this.poolIndex] = null;
            } else {
                ++this.openConnections;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (dbConnection != null) {
                try {
                    dbConnection.rollback();
                }
                catch (SQLException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ConnectionPool.class.getName(), (String)"getConnection", (Throwable)e);
                    }
                    if (messageWanted) {
                        SQLUtil.logSQLException("SRV0046E", e, null);
                    }
                    this.closeConnection(dbConnection);
                    this.decrementOpenConnections();
                    Connection traceResult2 = this.getConnection(messageWanted);
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ConnectionPool.class.getName(), (String)"getConnection", (Object)traceResult2);
                    }
                    return traceResult2;
                }
                SQLUtil.setHoldability(dbConnection, true);
                traceResult = dbConnection;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ConnectionPool.class.getName(), (String)"getConnection", (Object)traceResult);
                }
                return traceResult;
            }
            try {
                dbConnection = this.repositoryDriver.connect(this.repositoryURL, this.connectProperties);
                dbConnection.setAutoCommit(false);
                if (!SQLUtil.isOracle()) {
                    dbConnection.setTransactionIsolation(2);
                }
                if (SQLUtil.isUDB()) {
                    Statement stmt = dbConnection.createStatement();
                    stmt.executeUpdate("set current schema = " + this.udbSqlid);
                    stmt.close();
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ConnectionPool.class.getName(), (String)"getConnection", (Throwable)e);
                }
                if (messageWanted) {
                    SQLUtil.logSQLException("SRV0044E", e, new Object[]{this.repositoryDriver, this.repositoryURL});
                }
                this.decrementOpenConnections();
            }
            SQLUtil.setHoldability(dbConnection, true);
            traceResult = dbConnection;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ConnectionPool.class.getName(), (String)"getConnection", (Object)traceResult);
            }
            return traceResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementOpenConnections() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConnectionPool.class.getName(), (String)"decrementOpenConnections", (String)"");
        }
        Connection[] connectionArray = this.pool;
        synchronized (this.pool) {
            --this.openConnections;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ConnectionPool.class.getName(), (String)"decrementOpenConnections");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnConnection(Connection dbConnection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConnectionPool.class.getName(), (String)"returnConnection", (String)"dbConnection");
        }
        if (dbConnection == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ConnectionPool.class.getName(), (String)"returnConnection");
            }
            return;
        }
        Connection[] connectionArray = this.pool;
        synchronized (this.pool) {
            if (this.openConnections <= this.poolSize && this.poolIndex < this.poolSize) {
                this.pool[this.poolIndex] = dbConnection;
                ++this.poolIndex;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ConnectionPool.class.getName(), (String)"returnConnection");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            --this.openConnections;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.closeConnection(dbConnection);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ConnectionPool.class.getName(), (String)"returnConnection");
            }
            return;
        }
    }

    public int getConnectionCount() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConnectionPool.class.getName(), (String)"getConnectionCount", (String)"");
        }
        int traceResult = this.openConnections;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConnectionPool.class.getName(), (String)"getConnectionCount", (int)traceResult);
        }
        return traceResult;
    }

    public int getPoolElementCount() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConnectionPool.class.getName(), (String)"getPoolElementCount", (String)"");
        }
        int traceResult = this.poolIndex;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConnectionPool.class.getName(), (String)"getPoolElementCount", (int)traceResult);
        }
        return traceResult;
    }

    private void closeConnection(Connection dbConnection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ConnectionPool.class.getName(), (String)"closeConnection", (String)"dbConnection");
        }
        try {
            if (!dbConnection.isClosed()) {
                if (!dbConnection.getAutoCommit()) {
                    dbConnection.commit();
                }
                dbConnection.close();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ConnectionPool.class.getName(), (String)"closeConnection", (Throwable)e);
            }
            SQLUtil.logSQLException("SRV0045E", e, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ConnectionPool.class.getName(), (String)"closeConnection");
        }
    }
}

