/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.SQLException;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.CreatorNameQueryable;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class EditableObjectProxy {
    public static final String DUPLICATE_MSG_ID = "SRV0096E";
    private RepositoryAccessor accessor;
    private CreateHeader createHeader;
    private String objectType;

    public EditableObjectProxy(RepositoryAccessor pAccessor, CreateHeader pCreateHeader, String pObjectType) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)EditableObjectProxy.class.getName(), (String)"EditableObjectProxy", (String)"pAccessor, pCreateHeader, pObjectType");
        }
        this.accessor = pAccessor;
        this.createHeader = pCreateHeader;
        this.objectType = pObjectType;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)EditableObjectProxy.class.getName(), (String)"EditableObjectProxy");
        }
    }

    public void initSelect(String additionalColumns) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)EditableObjectProxy.class.getName(), (String)"initSelect", (String)"additionalColumns");
        }
        StringBuffer buf = new StringBuffer(120);
        buf.append("SELECT creator, name, description, last_modified");
        if (additionalColumns != null) {
            buf.append(", ");
            buf.append(additionalColumns);
        }
        buf.append(" FROM ");
        buf.append(this.accessor.tableName);
        buf.append(" WHERE ");
        buf.append(((CreatorNameQueryable)((Object)this.accessor)).getIDColumnName());
        buf.append(" = ");
        buf.append(Integer.toString(this.createHeader.ID));
        this.accessor.selectStmt = this.accessor.prepareStmt(buf.toString());
        this.accessor.stmtPhase = 3;
        try {
            this.accessor.resultSet = this.accessor.selectStmt.executeQuery();
            this.accessor.stmtPhase = 2;
            if (this.accessor.resultSet.next()) {
                this.accessor.stmtPhase = 1;
                this.accessor.colIndex = 1;
                this.createHeader.creator = this.accessor.getString(this.accessor.resultSet);
                this.createHeader.setName(this.accessor.getString(this.accessor.resultSet));
                this.createHeader.setDescription(this.accessor.getString(this.accessor.resultSet));
                this.createHeader.lastModified = this.accessor.getLong(this.accessor.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)EditableObjectProxy.class.getName(), (String)"initSelect", (Throwable)e);
            }
            this.accessor.stmtType = 0;
            this.accessor.sqlError(e);
        }
        if (this.accessor.stmtPhase == 2) {
            String s;
            this.accessor.closeSelect();
            if (this.createHeader.creator == null) {
                s = Integer.toString(this.createHeader.ID);
            } else {
                buf.setLength(0);
                buf.append(this.createHeader.creator);
                buf.append('.');
                buf.append(this.createHeader.getName());
                s = buf.toString();
            }
            Object[] args = new Object[]{this.objectType, s};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)EditableObjectProxy.class.getName(), (String)"initSelect");
            }
            throw new GeneralException(MessageLog.getMessage((String)"SRV0199E", (Object[])args));
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)EditableObjectProxy.class.getName(), (String)"initSelect");
        }
    }

    public void initInsert(String additionalColumns) throws GeneralException {
        int extraCount;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)EditableObjectProxy.class.getName(), (String)"initInsert", (String)"additionalColumns");
        }
        if (additionalColumns == null) {
            extraCount = 0;
        } else {
            extraCount = 1;
            int pos = 0;
            while ((pos = additionalColumns.indexOf(44, pos)) > 0) {
                ++extraCount;
                ++pos;
            }
        }
        StringBuffer buf = new StringBuffer(140);
        buf.append("INSERT INTO ");
        buf.append(this.accessor.tableName);
        buf.append(" (creator, name, description, last_modified, last_mod_user, ");
        buf.append(((CreatorNameQueryable)((Object)this.accessor)).getIDColumnName());
        if (additionalColumns != null) {
            buf.append(", ");
            buf.append(additionalColumns);
        }
        buf.append(") VALUES (?,?,?,?,?,?");
        while (extraCount > 0) {
            buf.append(",?");
            --extraCount;
        }
        buf.append(')');
        try {
            this.createHeader.lastModified = SQLUtil.getTimestamp(this.accessor.dbc).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)EditableObjectProxy.class.getName(), (String)"initInsert", (Throwable)e);
            }
            return;
        }
        this.accessor.insertStmt = this.accessor.prepareStmt(buf.toString());
        this.accessor.stmtPhase = 0;
        this.accessor.colIndex = 1;
        this.accessor.stmtType = 1;
        try {
            this.accessor.setString(this.accessor.insertStmt, this.createHeader.creator);
            this.accessor.setString(this.accessor.insertStmt, this.createHeader.getTrueName());
            this.accessor.setString(this.accessor.insertStmt, this.createHeader.getTrueDescription());
            this.accessor.setLong(this.accessor.insertStmt, this.createHeader.lastModified);
            this.accessor.setString(this.accessor.insertStmt, this.createHeader.lastModUser);
            this.accessor.setInt(this.accessor.insertStmt, this.createHeader.ID);
            this.accessor.stmtPhase = 3;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)EditableObjectProxy.class.getName(), (String)"initInsert", (Throwable)e);
            }
            this.accessor.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)EditableObjectProxy.class.getName(), (String)"initInsert");
        }
    }

    public void finishInsert() throws GeneralException {
        this.finishInsert(false);
    }

    public void finishInsert(boolean ignoreDuplicateKeyError) throws GeneralException {
        block7: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)EditableObjectProxy.class.getName(), (String)"finishInsert", (String)"ignoreDuplicateKeyError");
            }
            this.accessor.stmtPhase = 3;
            try {
                this.accessor.insertStmt.executeUpdate();
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)EditableObjectProxy.class.getName(), (String)"finishInsert", (Throwable)e);
                }
                if (!SQLUtil.isDuplicateKeyViolation(e)) {
                    this.accessor.sqlError(e);
                }
                if (ignoreDuplicateKeyError) break block7;
                String s = this.createHeader.creator + "." + this.createHeader.getName();
                Object[] args = new Object[]{this.objectType, s};
                s = MessageLog.getMessage((String)DUPLICATE_MSG_ID, (Object[])args);
                this.accessor.cleanup();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)EditableObjectProxy.class.getName(), (String)"finishInsert");
                }
                throw new GeneralException(s);
            }
        }
        this.accessor.closeInsert();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)EditableObjectProxy.class.getName(), (String)"finishInsert");
        }
    }

    public void deleteByID(int id, String idColumnName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)EditableObjectProxy.class.getName(), (String)"deleteByID", (String)"id, idColumnName");
        }
        StringBuffer buf = new StringBuffer(120);
        buf.append("DELETE FROM ");
        buf.append(this.accessor.tableName);
        buf.append(" WHERE ");
        buf.append(idColumnName);
        buf.append(" = ");
        buf.append(Integer.toString(id));
        this.accessor.deleteStmt = this.accessor.prepareStmt(buf.toString());
        try {
            this.accessor.executeUpdate(this.accessor.deleteStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)EditableObjectProxy.class.getName(), (String)"deleteByID", (Throwable)e);
            }
            this.accessor.stmtType = 3;
            this.accessor.sqlError(e);
        }
        this.accessor.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)EditableObjectProxy.class.getName(), (String)"deleteByID");
        }
    }
}

