/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.MissingAlertAccessible;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TFoundFilesystem;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResDomain;
import org.eclipse.aperi.repository.table.TResFS;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.repository.table.TStormSettings;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Alert;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.UninstallAgentDriver;
import org.eclipse.aperi.server.alert.BaseAlerter;
import org.eclipse.aperi.server.alert.DiscoveryAlerter;
import org.eclipse.aperi.server.alert.ProbeAlerter;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.server.handler.agent.ProbeResultsHndlr;
import org.eclipse.aperi.xmsg.MessageLog;

public class FilerSaver {
    private Connection dbc;
    private boolean updateScheduler;
    private int[] lockedTrees;
    private long discoveryTime;
    private TResShare shareAccessor;
    private TFoundFilesystem foundFsAccessor;
    private Share shareBuffer = new Share();
    private boolean nasInstalled;
    private LdapTree dummyNasTree;
    private int nasShareID;
    private short nasShareOwnerType;
    private boolean triggerAlerts;
    private short resourceType;
    private short alertType;
    private byte subProduct;
    public Settings settings;
    private static final int[][] varBindOIDs = new int[4][];
    private static final String[] tecSlotNames;
    private static final long MILLIS_PER_DAY = 86400000L;

    public void handleMissingVSs(int clusterID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"handleMissingVSs", (String)"clusterID");
        }
        this.getSettings();
        this.resourceType = (short)99;
        this.dummyNasTree.ltTreeID = clusterID;
        Share removedList = this.handleMissingFilers(null);
        if (removedList != null) {
            TResCluster clAccessor = new TResCluster(this.dbc);
            clAccessor.cleanupCluster(clusterID);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"handleMissingVSs");
        }
    }

    public FilerSaver(Connection dbc, int nasShareID) {
        this(dbc, nasShareID, 1, false, null, null);
    }

    public FilerSaver(Connection dbc, int nasShareID, short pNasShareOwnerType, boolean triggerAlerts, Settings pSettings, String nasShareOwnerName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"FilerSaver", (String)"dbc, nasShareID, pNasShareOwnerType, triggerAlerts, pSettings, nasShareOwnerName");
        }
        try {
            this.discoveryTime = SQLUtil.getTimestamp(dbc).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)FilerSaver.class.getName(), (String)"FilerSaver", (Throwable)e);
            }
            return;
        }
        this.dbc = dbc;
        this.nasShareID = nasShareID;
        this.nasShareOwnerType = pNasShareOwnerType;
        this.triggerAlerts = triggerAlerts;
        this.settings = pSettings;
        this.dummyNasTree = new LdapTree();
        this.dummyNasTree.ltTreeID = nasShareID;
        this.dummyNasTree.setLtName(nasShareOwnerName);
        this.shareAccessor = new TResShare(dbc);
        this.foundFsAccessor = new TFoundFilesystem(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"FilerSaver");
        }
    }

    private void getSettings() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"getSettings", (String)"");
        }
        if (this.settings == null) {
            TStormSettings accessor = new TStormSettings(this.dbc);
            this.settings = accessor.getSettings();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"getSettings");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDiscoveryData(NasFiler filerList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"saveDiscoveryData", (String)"filerList");
        }
        this.nasInstalled = true;
        this.getSettings();
        LdapTree treeList = this.getTreeList(filerList);
        this.lockTrees(treeList, true);
        this.resourceType = this.nasShareOwnerType == 103 ? this.nasShareOwnerType : (short)1;
        this.alertType = (short)80;
        this.subProduct = 0;
        try {
            if (!this.nasInstalled) {
                filerList = this.pruneFilers(filerList);
            }
            filerList = this.saveFilers(filerList, true);
            this.saveDomains(filerList);
            this.saveFilesystems(filerList);
            this.handleMissingFilers(treeList);
            this.checkNewStorageAlerts(filerList);
        }
        finally {
            this.unlockTrees();
            if (this.updateScheduler) {
                ScheduleQueue.routine.rebuild();
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"saveDiscoveryData");
        }
    }

    public void saveDiskArrays(NasFiler diskArrayList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"saveDiskArrays", (String)"diskArrayList");
        }
        this.getSettings();
        this.resourceType = (short)78;
        this.alertType = (short)82;
        this.subProduct = 1;
        this.saveFilers(diskArrayList, false);
        this.handleMissingFilers(null);
        this.checkNewStorageAlerts(diskArrayList);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"saveDiskArrays");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProbeData(Computer computer) throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"saveProbeData", (String)"computer");
        }
        NasFiler filerList = computer.cmpNasFiler;
        LdapTree treeList = this.getTreeList(filerList);
        this.lockTrees(treeList, false);
        try {
            if (!Constants.isDiskArray((short)filerList.nfOSType)) {
                this.saveVirtualServers(filerList, computer.cmpID);
                this.updateVSProbeTime(computer.cmpCluster);
            }
            this.saveProbeResults(computer.cmpID, filerList);
        }
        finally {
            this.unlockTrees();
            if (this.updateScheduler) {
                ScheduleQueue.routine.rebuild();
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"saveProbeData");
        }
    }

    private LdapTree getTreeList(NasFiler filerList) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"getTreeList", (String)"filerList");
        }
        LdapTree treeList = null;
        NasFiler filer = filerList;
        while (filer != null) {
            LdapTree tree = filer.nfLdapTree;
            if (tree != null && tree.ltComputerID != -1) {
                tree.ltComputerID = -1;
                tree.ltNext = treeList;
                treeList = tree;
            }
            filer = filer.nfNext;
        }
        LdapTree traceResult = treeList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"getTreeList", traceResult);
        }
        return traceResult;
    }

    private void lockTrees(LdapTree treeList, boolean isDiscoveryData) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"lockTrees", (String)"treeList, isDiscoveryData");
        }
        int treeCount = 0;
        LdapTree tree = treeList;
        while (tree != null) {
            ++treeCount;
            tree = tree.ltNext;
        }
        this.lockedTrees = new int[treeCount];
        tree = treeList;
        while (tree != null) {
            this.lockedTrees[--treeCount] = tree.ltTreeID;
            tree = tree.ltNext;
        }
        Arrays.sort(this.lockedTrees);
        for (int i = 0; i < this.lockedTrees.length; ++i) {
            LockManager.lock((short)0, (String)"LdapTree", (String)String.valueOf(this.lockedTrees[i]), (byte)(isDiscoveryData ? (byte)1 : 2), (boolean)true);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"lockTrees");
        }
    }

    private void unlockTrees() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"unlockTrees", (String)"");
        }
        if (this.lockedTrees != null) {
            for (int i = 0; i < this.lockedTrees.length; ++i) {
                if (this.lockedTrees[i] <= 0) continue;
                LockManager.unLock((short)0, (String)"LdapTree", (String)String.valueOf(this.lockedTrees[i]));
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"unlockTrees");
        }
    }

    private NasFiler pruneFilers(NasFiler filerList) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"pruneFilers", (String)"filerList");
        }
        NasFiler prunedList = null;
        while (filerList != null) {
            NasFiler filer = filerList;
            filerList = filer.nfNext;
            if (filer.nfComputer.cmpOSType != 8) continue;
            filer.nfNext = prunedList;
            prunedList = filer;
        }
        NasFiler traceResult = prunedList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"pruneFilers", traceResult);
        }
        return traceResult;
    }

    private NasFiler saveFilers(NasFiler filerList, boolean mightBeAgents) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"saveFilers", (String)"filerList, mightBeAgents");
        }
        TResComputer compAccessor = new TResComputer(this.dbc);
        compAccessor.getIDs(filerList);
        if (mightBeAgents) {
            filerList = this.pruneAgents(filerList);
        }
        Share shareBuffer = new Share();
        shareBuffer.shScanTime = this.discoveryTime;
        shareBuffer.shResourceType = this.resourceType;
        this.shareAccessor = new TResShare(this.dbc);
        this.shareAccessor.prepSave();
        NasFiler filer = filerList;
        while (filer != null) {
            boolean bNewShare = filer.nfNewFiler;
            filer.nfComputer.cmpID = filer.nfComputerID;
            if (filer.nfLdapTree == null) {
                filer.nfLdapTree = this.dummyNasTree;
            }
            LdapTree tree = filer.nfLdapTree;
            if (!filer.nfNewFiler) {
                tree.ltHasComputers = true;
            }
            if (Constants.isCimomManaged((short)filer.nfComputer.cmpOSType)) {
                shareBuffer.shPath = filer.nfnameSpace;
            }
            shareBuffer.shComputerID = tree.ltTreeID;
            shareBuffer.shResourceID = filer.nfComputerID;
            if (this.nasShareOwnerType == 103 && !filer.nfNewFiler && !this.shareAccessor.getShareExists(shareBuffer.shComputerID, shareBuffer.shResourceID, shareBuffer.shResourceType)) {
                bNewShare = true;
            }
            this.shareAccessor.saveShare(shareBuffer, bNewShare);
            this.shareAccessor.commit();
            filer = filer.nfNext;
        }
        this.shareAccessor.closeSave();
        NasFiler traceResult = filerList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"saveFilers", (Object)traceResult);
        }
        return traceResult;
    }

    private NasFiler pruneAgents(NasFiler filerList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"pruneAgents", (String)"filerList");
        }
        NasFiler prev = null;
        AgentManager am = Server.getAgentManager();
        NasFiler curr = filerList;
        while (curr != null) {
            if (am.get(curr.nfComputerID) != null) {
                if (this.nasShareOwnerType == 103) {
                    throw new GeneralException(MessageLog.getMessage((String)"NAS0025E", (Object)curr.nfNetworkName));
                }
                if (prev == null) {
                    filerList = curr.nfNext;
                } else {
                    prev.nfNext = curr.nfNext;
                }
            } else {
                prev = curr;
            }
            curr = curr.nfNext;
        }
        NasFiler traceResult = filerList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"pruneAgents", (Object)traceResult);
        }
        return traceResult;
    }

    private void saveDomains(NasFiler filerList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"saveDomains", (String)"filerList");
        }
        Domain domList = null;
        NasFiler filer = filerList;
        while (filer != null) {
            Computer computer = filer.nfComputer;
            Domain domain = computer.cmpDomain;
            if (domain != null && domain.domID != -1) {
                domain.domID = -1;
                domain.domNext = domList;
                domList = domain;
            }
            filer = filer.nfNext;
        }
        if (domList != null) {
            TResDomain domAccessor = new TResDomain(this.dbc);
            domAccessor.getIDs(domList);
            domAccessor = null;
        }
        TStatComputer compAccessor = new TStatComputer(this.dbc);
        compAccessor.prepUpdateDomain();
        NasFiler filer2 = filerList;
        while (filer2 != null) {
            Computer computer = filer2.nfComputer;
            if (computer.cmpDomain != null && computer.cmpOSType != 8) {
                computer.cmpDomainID = computer.cmpDomain.domID;
                compAccessor.updateDomain(computer);
            } else {
                computer.cmpDomainID = -1;
            }
            filer2 = filer2.nfNext;
        }
        compAccessor.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"saveDomains");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFilesystems(NasFiler filerList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"saveFilesystems", (String)"filerList");
        }
        NasFiler filer = filerList;
        while (filer != null) {
            this.nasShareID = filer.nfLdapTree.ltTreeID;
            try {
                ProbeResultsHndlr.lockComputer(filer.nfComputer, null);
                Computer computer = filer.nfComputer;
                boolean newFilesystems = this.foundFsAccessor.getIDs(computer);
                this.saveFilesystems(computer, newFilesystems);
                this.handleMissingFilesystems(filer);
            }
            finally {
                ProbeResultsHndlr.unLockComputer(filer.nfComputer);
            }
            filer = filer.nfNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"saveFilesystems");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFilesystems(Computer computer, boolean newFilesystems) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"saveFilesystems", (String)"computer, newFilesystems");
        }
        this.shareBuffer.shScanTime = this.discoveryTime;
        this.shareBuffer.shRemovedTime = 0L;
        this.shareBuffer.shPath = " ";
        this.shareBuffer.shResourceType = (short)68;
        this.shareBuffer.shComputerID = this.nasShareID;
        try {
            this.shareAccessor.prepSave();
            if (newFilesystems) {
                this.foundFsAccessor.prepInsert();
            }
            LogicalDisk lDisk = computer.cmpLogicalDisk;
            while (lDisk != null) {
                Filesystem fs = lDisk.ldFilesystem;
                this.shareBuffer.shResourceID = fs.fsID;
                if (fs.fsNewFilesystem) {
                    this.foundFsAccessor.insert(computer, fs);
                }
                this.shareAccessor.saveShare(this.shareBuffer, fs.fsNewFilesystem);
                this.shareAccessor.commit();
                lDisk = lDisk.ldNext;
            }
        }
        finally {
            if (newFilesystems) {
                this.foundFsAccessor.cleanup();
            }
            this.shareAccessor.cleanup();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"saveFilesystems");
        }
    }

    private void handleMissingFilesystems(NasFiler filer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"handleMissingFilesystems", (String)"filer");
        }
        Share missingList = this.foundFsAccessor.getMissingFilesystems(this.nasShareID, filer.nfComputerID, this.discoveryTime);
        Share removeList = null;
        if (missingList != null) {
            removeList = this.shareAccessor.setRemovedTime(missingList, this.discoveryTime, this.settings.seKeepRemovedFS);
        }
        if (removeList != null) {
            this.removeFilesystems(filer, removeList);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"handleMissingFilesystems");
        }
    }

    private void removeFilesystems(NasFiler filer, Share removeList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"removeFilesystems", (String)"filer, removeList");
        }
        Filesystem fsList = null;
        boolean deleteTResFS = !Constants.supportsFullProbe((short)filer.nfOSType);
        this.shareAccessor.prepGetShareCount();
        Share sh = removeList;
        while (sh != null) {
            sh.shShareCount = this.shareAccessor.getShareCount(sh.shResourceID, (short)68);
            if (sh.shShareCount <= 1 && deleteTResFS) {
                Filesystem fs = new Filesystem();
                fs.fsID = sh.shResourceID;
                fs.fsNext = fsList;
                fsList = fs;
            }
            sh = sh.shNext;
        }
        this.shareAccessor.closeSelect();
        if (fsList != null) {
            TResFS fsAccessor = new TResFS(this.dbc);
            fsAccessor.deleteFS(fsList, true);
            this.updateScheduler = true;
        }
        this.removeFoundFilesystems(removeList, filer.nfComputerID, deleteTResFS);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"removeFilesystems");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFoundFilesystems(Share removeList, int filerCompID, boolean deleteFsShares) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"removeFoundFilesystems", (String)"removeList, filerCompID, deleteFsShares");
        }
        if (removeList == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)FilerSaver.class.getName(), (String)"removeFoundFilesystems");
            }
            return;
        }
        try {
            int shareID = removeList.shComputerID;
            this.foundFsAccessor.prepDeleteByID("t_found_filesystem", "filesystem_id");
            this.shareAccessor.prepDelete();
            Share sh = removeList;
            while (sh != null) {
                if (sh.shShareCount <= 1) {
                    if (deleteFsShares) {
                        sh.shComputerID = filerCompID;
                        this.shareAccessor.deleteShare(sh);
                        sh.shComputerID = shareID;
                    }
                    this.foundFsAccessor.deleteByID(sh.shResourceID, false);
                }
                this.shareAccessor.deleteShare(sh);
                sh = sh.shNext;
            }
        }
        finally {
            this.shareAccessor.cleanup();
            this.foundFsAccessor.closeDelete();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"removeFoundFilesystems");
        }
    }

    Share handleMissingFilers(LdapTree treeList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"handleMissingFilers", (String)"treeList");
        }
        Share missingFilers = null;
        Share removeList = null;
        this.dummyNasTree.ltNext = treeList;
        LdapTree tree = treeList = this.dummyNasTree;
        while (tree != null) {
            Share tmpList = this.shareAccessor.getRemovedResources(tree.ltTreeID, this.resourceType, this.discoveryTime, missingFilers);
            if (tmpList != missingFilers) {
                tree.ltHasComputers = true;
                missingFilers = tmpList;
                while (tmpList != null && tmpList.shResource == null) {
                    tmpList.shResource = tree;
                    tmpList = tmpList.shNext;
                }
            }
            tree = tree.ltNext;
        }
        short alertResourceType = this.resourceType == 1 ? (short)79 : (short)this.resourceType;
        if (missingFilers != null) {
            removeList = this.shareAccessor.setRemovedTime(missingFilers, this.discoveryTime, this.settings.seKeepRemovedFS);
            missingFilers = this.shareAccessor.getUpdateList();
            RepositoryAccessor accessor = this.resourceType == 78 ? new TResDiskArray(this.dbc) : new TStatComputer(this.dbc);
            MissingAlertAccessible castAccessor = (MissingAlertAccessible)((Object)accessor);
            castAccessor.prepFetchByID();
            Share headShare2 = null;
            LdapTree tree2 = null;
            LinkedList<Share> byTree = new LinkedList<Share>();
            while (missingFilers != null) {
                Share nextShare = missingFilers.shNext;
                missingFilers.shNext = null;
                if (castAccessor.fetchByID(missingFilers)) {
                    if (missingFilers.shResource != tree2) {
                        tree2 = (LdapTree)missingFilers.shResource;
                        headShare2 = null;
                    }
                    if (headShare2 == null) {
                        headShare2 = missingFilers;
                        byTree.add(headShare2);
                    } else {
                        missingFilers.shNext = headShare2.shNext;
                        headShare2.shNext = missingFilers;
                    }
                    missingFilers.shResourceType = alertResourceType;
                }
                missingFilers = nextShare;
            }
            accessor.closeSelect();
            ProbeAlerter pAlert = new ProbeAlerter(this.dbc, 0);
            for (Share headShare2 : byTree) {
                tree2 = (LdapTree)headShare2.shResource;
                alertResourceType = tree2 == this.dummyNasTree ? (short)this.nasShareOwnerType : (short)66;
                DiscoveryAlerter alerter = new DiscoveryAlerter(this.dbc, castAccessor, this.alertType, alertResourceType, tree2.ltTreeID, tree2.getLtName());
                if (headShare2.shResourceType != 99) {
                    alerter.alert(headShare2);
                    Server.agentMgr.updateExpirationOfAgentLessManagedNode(headShare2.shResourceID, true);
                    continue;
                }
                pAlert.alertVSRemoved(tree2.ltTreeID, headShare2);
            }
        }
        if (removeList != null) {
            this.removeFilers(removeList, false);
        }
        Share traceResult = removeList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"handleMissingFilers", (Object)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFilers(Share removeList, boolean force) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"removeFilers", (String)"removeList, force");
        }
        NasFiler filer = null;
        RepositoryAccessor cmpAccessor = null;
        TResShare shAccessor = new TResShare(this.dbc);
        shAccessor.prepDeleteIncludingType();
        shAccessor.prepGetShareCount();
        try {
            long removeMillis = 0L;
            if (this.settings != null) {
                removeMillis = (long)this.settings.seKeepRemovedFilers * 86400000L;
            } else {
                this.getSettings();
                removeMillis = (long)this.settings.seKeepRemovedFilers * 86400000L;
            }
            long removeTime = this.getProbeTime() - removeMillis;
            Share shList = removeList;
            Share shTempList = null;
            Share removeFilerList = null;
            while (shList != null) {
                shTempList = shList;
                shList = shTempList.shNext;
                if (shTempList.shResource != null && shTempList.shRemovedTime >= removeTime) continue;
                shTempList.shNext = removeFilerList;
                removeFilerList = shTempList;
            }
            Share sh = removeFilerList;
            while (sh != null) {
                filer = null;
                try {
                    short type;
                    int manShrCnt;
                    int oldShrCnt;
                    LockManager.lock((short)2, (String)"Computer", (String)Integer.toString(sh.shResourceID), (byte)1, (boolean)true);
                    Share fsList = this.foundFsAccessor.getMissingFilesystems(sh.shComputerID, sh.shResourceID, 0L);
                    if (sh.shResourceType == 103) {
                        oldShrCnt = shAccessor.getShareCount(sh.shResourceID, (short)1);
                        manShrCnt = shAccessor.getShareCount(sh.shResourceID, sh.shResourceType);
                        type = 1;
                    } else {
                        oldShrCnt = shAccessor.getShareCount(sh.shResourceID, sh.shResourceType);
                        manShrCnt = shAccessor.getShareCount(sh.shResourceID, (short)103);
                        type = 103;
                    }
                    int shareCount = oldShrCnt + manShrCnt;
                    if (shareCount <= 1 || force) {
                        byte productCode = sh.shResourceType == 78 ? (byte)9 : 1;
                        if (!UninstallAgentDriver.remove(sh.shResourceID, true, productCode, this.dbc, true)) {
                            String msg = MessageLog.getMessage((String)"STS0165E", (Object)String.valueOf(sh.shResourceID));
                            throw new GeneralException(msg);
                        }
                        this.removeFoundFilesystems(fsList, sh.shResourceID, false);
                    } else {
                        if (cmpAccessor == null) {
                            cmpAccessor = new TResComputer(this.dbc);
                            ((TResComputer)cmpAccessor).prepGetNasFiler();
                        }
                        filer = ((TResComputer)cmpAccessor).getNasFiler(sh.shResourceID);
                        TResShare shAccessor2 = new TResShare(this.dbc);
                        if (!shAccessor2.getShareExists(sh.shComputerID, sh.shResourceID, type) && filer != null && !Constants.isDiskArray((short)filer.nfOSType)) {
                            this.removeFilesystems(filer, fsList);
                        }
                    }
                    shAccessor.deleteIncludingType(sh);
                }
                finally {
                    LockManager.unLock((short)2, (String)"Computer", (String)Integer.toString(sh.shResourceID));
                }
                sh = sh.shNext;
            }
        }
        finally {
            if (cmpAccessor != null) {
                cmpAccessor.cleanup();
            }
            shAccessor.cleanup();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"removeFilers");
        }
    }

    private void checkNewStorageAlerts(NasFiler filerList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"checkNewStorageAlerts", (String)"filerList");
        }
        AlertDefinition alertDef = null;
        NasFiler filer = filerList;
        while (filer != null) {
            boolean issueAlert;
            if (filer.nfNewFiler && (issueAlert = filer.nfOSType == 8 ? filer.nfLdapTree.ltHasComputers : this.triggerAlerts)) {
                if (alertDef == null) {
                    alertDef = this.getAlertDefinition(Constants.isDiskArray((short)filer.nfOSType));
                }
                this.genNewStorageAlert(filer, alertDef);
            }
            filer = filer.nfNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"checkNewStorageAlerts");
        }
    }

    private AlertDefinition getAlertDefinition(boolean isDiskArray) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"getAlertDefinition", (String)"isDiskArray");
        }
        TAlertDefinition alertAccessor = new TAlertDefinition(this.dbc);
        alertAccessor.prepSelectByID(false, false);
        AlertDefinition alertDef = alertAccessor.getByID(100);
        if (alertDef == null) {
            Object[] args = new Object[]{new Integer(100)};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)FilerSaver.class.getName(), (String)"getAlertDefinition");
            }
            throw new GeneralException(MessageLog.getMessage((String)"SRV0105E", (Object[])args));
        }
        alertAccessor.closeSelect();
        if (isDiskArray) {
            alertDef.aldProductID = (short)3;
            alertDef.aldCondition = (short)64;
        } else {
            alertDef.aldProductID = 0;
            alertDef.aldCondition = (short)55;
        }
        AlertDefinition traceResult = alertDef;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"getAlertDefinition", (Object)traceResult);
        }
        return traceResult;
    }

    private void genNewStorageAlert(NasFiler filer, AlertDefinition alertDef) {
        int trapNumber;
        String computerName;
        short resourceType;
        int computerID;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"genNewStorageAlert", (String)"filer, alertDef");
        }
        if (alertDef.aldCondition == 64) {
            computerID = this.nasShareID;
            resourceType = 78;
            computerName = this.dummyNasTree.getLtName();
            trapNumber = 23;
        } else {
            computerID = filer.nfComputerID;
            resourceType = 79;
            computerName = filer.nfName;
            trapNumber = 18;
        }
        String s = computerName;
        if (Constants.isCimomManaged((short)filer.nfOSType)) {
            s = filer.nfCIMOM;
        }
        String[] parms = new String[]{s, ResourceTypeManager.getName((short)resourceType), filer.nfName, alertDef.getEmailSubjectID()};
        Alert alert = new Alert(computerID, filer.nfComputerID, resourceType, alertDef, parms, trapNumber, varBindOIDs, tecSlotNames, -1, -1, this.subProduct, -1);
        Alerter.queueAlert(alert);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"genNewStorageAlert");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveVirtualServers(NasFiler filerList, int cid) throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"saveVirtualServers", (String)"filerList, cid");
        }
        NasFiler firstVS = null;
        NasFiler lastVS = filerList;
        int vsCnt = 0;
        TResCluster clusterAccessor = new TResCluster(this.dbc);
        Cluster cluster = null;
        NasFiler sortFiler = filerList;
        while (sortFiler != null) {
            if (Constants.isVirtualServer((int)sortFiler.nfOSType)) {
                ++vsCnt;
                if (cluster == null) {
                    cluster = clusterAccessor.getClusterByName(sortFiler.nfComputer.cmpCluster.clusterName, sortFiler.nfComputer.cmpCluster.domain_name);
                }
                sortFiler.nfLdapTree = new LdapTree();
                sortFiler.nfLdapTree.ltTreeID = cluster.clusterID;
                if (firstVS == null) {
                    firstVS = sortFiler;
                } else if (sortFiler.nfNext == null || !Constants.isVirtualServer((int)sortFiler.nfNext.nfOSType)) {
                    lastVS = sortFiler;
                }
            }
            sortFiler = sortFiler.nfNext;
        }
        if (firstVS != null) {
            NasFiler mark = null;
            try {
                mark = lastVS.nfNext;
                lastVS.nfNext = null;
                this.resourceType = (short)99;
                firstVS = this.saveFilers(firstVS, false);
                this.updateCIDForClusterResources(cid, firstVS);
            }
            finally {
                lastVS.nfNext = mark;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"saveVirtualServers");
        }
    }

    private void updateCIDForClusterResources(int computerID, NasFiler filerList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"updateCIDForClusterResources", (String)"computerID, filerList");
        }
        NasFiler currFiler = filerList;
        while (currFiler != null) {
            LogicalDisk ld = currFiler.nfComputer.cmpLogicalDisk;
            while (ld != null && ld.ldFilesystem != null) {
                ld.ldFilesystem.fsComputerID = currFiler.nfComputer.cmpID;
                ld.ldFilesystem.fsScanningCompID = computerID;
                ld = ld.ldNext;
            }
            Controller controller = currFiler.nfComputer.cmpController;
            while (controller != null) {
                controller.ctlrComputerID = currFiler.nfComputer.cmpID;
                controller = controller.ctlrNext;
            }
            currFiler.nfComputer.cmpNodeHostedID = computerID;
            currFiler = currFiler.nfNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"updateCIDForClusterResources");
        }
    }

    private void saveProbeResults(int computerID, NasFiler filerList) throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"saveProbeResults", (String)"computerID, filerList");
        }
        ProbeResultsHndlr saver = new ProbeResultsHndlr(this.dbc);
        NasFiler filer = filerList;
        while (filer != null) {
            if (Constants.supportsFullProbe((short)filer.nfOSType) || Constants.isDiskArray((short)filer.nfOSType)) {
                filer.nfComputer.cmpNasFiler = filer;
                filer.nfComputer.cmpProbingCompID = computerID;
                this.updateScheduler = saver.saveResults(filer.nfComputer);
            } else {
                saver.saveNasProbeResults(filer.nfComputer);
            }
            filer = filer.nfNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"saveProbeResults");
        }
    }

    public long getProbeTime() {
        return this.discoveryTime;
    }

    public void setProbeTime(long time) {
        this.discoveryTime = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVSProbeTime(Cluster cluster) throws StorageException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FilerSaver.class.getName(), (String)"updateVSProbeTime", (String)"cluster");
        }
        if (cluster != null) {
            TResShare shAccessor = new TResShare(this.dbc);
            TResComputer cmpAccessor = new TResComputer(this.dbc);
            Share shareBuffer = new Share();
            shareBuffer.shScanTime = this.discoveryTime;
            shareBuffer.shComputerID = cluster.clusterID;
            shareBuffer.shResourceType = (short)99;
            try {
                shAccessor.prepUpdate();
                Iterator itr = cluster.virtualServers.iterator();
                while (itr.hasNext()) {
                    shareBuffer.shResourceID = cmpAccessor.selectCID((String)itr.next());
                    shAccessor.updateVSProbeTime(shareBuffer);
                }
            }
            finally {
                shAccessor.closeUpdate();
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FilerSaver.class.getName(), (String)"updateVSProbeTime");
        }
    }

    static {
        FilerSaver.varBindOIDs[0] = BaseAlerter.COMPUTER_OID;
        FilerSaver.varBindOIDs[1] = BaseAlerter.RESOURCE_TYPE_OID;
        FilerSaver.varBindOIDs[2] = BaseAlerter.RESOURCE_NAME_OID;
        FilerSaver.varBindOIDs[3] = Alerter.ALERT_TYPE_OID;
        tecSlotNames = new String[4];
        FilerSaver.tecSlotNames[0] = "hostname";
        FilerSaver.tecSlotNames[1] = "resourceType";
        FilerSaver.tecSlotNames[2] = "resourceName";
        FilerSaver.tecSlotNames[3] = "alertType";
    }
}

