/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;

public class StatDeleter
extends RepositoryAccessor {
    public static final String DELETE_CLAUSE = "DELETE FROM ";
    public static final int N_PLACES = 10;

    public StatDeleter(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"StatDeleter", (String)"dbc");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"StatDeleter");
        }
    }

    public void deleteByStatID(String pTableName, int statisticID, short statisticType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"deleteByStatID", (String)"pTableName, statisticID, statisticType");
        }
        this.deleteByStatID(pTableName, statisticID, statisticType, false, -1, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"deleteByStatID");
        }
    }

    public void deleteByStatID(String pTableName, int statisticID, short statisticType, boolean reportTypeCol, int historyType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"deleteByStatID", (String)"pTableName, statisticID, statisticType, reportTypeCol, historyType");
        }
        this.deleteByStatID(pTableName, statisticID, statisticType, reportTypeCol, historyType, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"deleteByStatID");
        }
    }

    public void deleteByStatID(String pTableName, int statisticID, short statisticType, boolean reportTypeCol, int historyType, boolean deleteUnixOnly) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"deleteByStatID", (String)"pTableName, statisticID, statisticType, reportTypeCol, historyType, deleteUnixOnly");
        }
        this.tableName = pTableName;
        StringBuffer buf = new StringBuffer(120);
        buf.append(DELETE_CLAUSE);
        buf.append(this.tableName);
        buf.append(" WHERE statistic_id = ");
        buf.append(Integer.toString(statisticID));
        if (statisticType >= 0) {
            if (reportTypeCol) {
                buf.append(" AND report_type = ");
            } else {
                buf.append(" AND statistic_type = ");
            }
            this.appendCharLiteral(buf, statisticType);
        }
        if (historyType >= 0) {
            buf.append(" AND statistic_type in (");
            this.appendCharLiteral(buf, historyType);
            if (historyType != 0) {
                buf.append(',');
                this.appendCharLiteral(buf, historyType + 2);
            }
            buf.append(')');
        }
        if (deleteUnixOnly) {
            buf.append(" AND filesystem_id in");
            buf.append(" (SELECT filesystem_id");
            buf.append(" FROM t_res_filesystem f, t_stat_computer c");
            buf.append(" WHERE f.scanning_comp_id = c.computer_id");
            buf.append(" AND c.os_type not in (");
            for (short i = 0; i < 28; i = (short)(i + 1)) {
                if (!Constants.isWindows((short)i)) continue;
                buf.append(i);
                buf.append(',');
            }
            buf.setLength(buf.length() - 1);
            buf.append("))");
        }
        this.deleteStmt = this.prepareStmt(buf.toString());
        try {
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)StatDeleter.class.getName(), (String)"deleteByStatID", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        this.commit();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"deleteByStatID");
        }
    }

    private void appendCharLiteral(StringBuffer buf, int c) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"appendCharLiteral", (String)"buf, c");
        }
        buf.append('\'');
        buf.append(c);
        buf.append('\'');
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"appendCharLiteral");
        }
    }

    public void deleteStatByDirID(String pTableName, String whereClause) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"deleteStatByDirID", (String)"pTableName, whereClause");
        }
        this.tableName = pTableName;
        StringBuffer buf = new StringBuffer(300);
        buf.append(DELETE_CLAUSE);
        buf.append(this.tableName);
        buf.append(" WHERE filesystem_id IN (SELECT directory_id");
        buf.append(" FROM t_stat_directory");
        buf.append(whereClause);
        buf.append(')');
        this.deleteStmt = this.prepareStmt(buf.toString());
        try {
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)StatDeleter.class.getName(), (String)"deleteStatByDirID", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        this.commit();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"deleteStatByDirID");
        }
    }

    public void prepDeleteByFSnStat(String pTableName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"prepDeleteByFSnStat", (String)"pTableName");
        }
        this.prepDeleteByIDnStat(pTableName, "filesystem_id");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"prepDeleteByFSnStat");
        }
    }

    public void prepDeleteByIDnStat(String pTableName, String idColumnName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"prepDeleteByIDnStat", (String)"pTableName, idColumnName");
        }
        this.tableName = pTableName;
        StringBuffer buf = new StringBuffer(100);
        buf.append(DELETE_CLAUSE);
        buf.append(this.tableName);
        buf.append(" WHERE ");
        buf.append(idColumnName);
        buf.append(" = ? AND statistic_id = ?");
        this.deleteStmt = this.prepareStmt(buf.toString());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"prepDeleteByIDnStat");
        }
    }

    public void execDeleteByFSnStat(int filesystemID, int statisticID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"execDeleteByFSnStat", (String)"filesystemID, statisticID");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.deleteStmt, filesystemID);
            this.setInt(this.deleteStmt, statisticID);
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)StatDeleter.class.getName(), (String)"execDeleteByFSnStat", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"execDeleteByFSnStat");
        }
    }

    private void prepDeleteBySomeKindOfID(String pTableName, String what, boolean byStatisticID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"prepDeleteBySomeKindOfID", (String)"pTableName, what, byStatisticID");
        }
        this.tableName = pTableName;
        StringBuffer buf = new StringBuffer(120);
        buf.append(DELETE_CLAUSE);
        buf.append(this.tableName);
        buf.append(" WHERE ");
        if (byStatisticID) {
            buf.append("statistic_id = ? AND ");
        }
        buf.append(what);
        buf.append(" in (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.deleteStmt = this.prepareStmt(buf.toString());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"prepDeleteBySomeKindOfID");
        }
    }

    public void prepDeleteByText(String text) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"prepDeleteByText", (String)"text");
        }
        StringBuffer buf = new StringBuffer(120);
        buf.append(text);
        buf.append(" in (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        this.deleteStmt = this.prepareStmt(buf.toString());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"prepDeleteByText");
        }
    }

    public void prepDeleteByID(String pTableName, String pColumnName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"prepDeleteByID", (String)"pTableName, pColumnName");
        }
        this.prepDeleteBySomeKindOfID(pTableName, pColumnName, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"prepDeleteByID");
        }
    }

    public void prepDeleteByFilesystemID(String pTableName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"prepDeleteByFilesystemID", (String)"pTableName");
        }
        this.prepDeleteBySomeKindOfID(pTableName, "filesystem_id", false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"prepDeleteByFilesystemID");
        }
    }

    public void prepDeleteByDirectoryID(String pTableName) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"prepDeleteByDirectoryID", (String)"pTableName");
        }
        this.prepDeleteBySomeKindOfID(pTableName, "directory_id", false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"prepDeleteByDirectoryID");
        }
    }

    public LinkedInteger deleteByID(LinkedInteger list) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"deleteByID", (String)"list");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            int counter;
            for (counter = 0; counter < 10 && list != null; ++counter) {
                this.setInt(this.deleteStmt, list.value);
                list = list.next;
            }
            while (counter < 10) {
                this.setInt(this.deleteStmt, -2147483647);
                ++counter;
            }
            this.executeUpdate(this.deleteStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)StatDeleter.class.getName(), (String)"deleteByID", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        this.commit();
        if (list == null) {
            this.closeDelete();
        }
        LinkedInteger traceResult = list;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"deleteByID", (Object)traceResult);
        }
        return traceResult;
    }

    public void prepDeleteByUserNStat(String pTableName, boolean isUser) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"prepDeleteByUserNStat", (String)"pTableName, isUser");
        }
        this.prepDeleteBySomeKindOfID(pTableName, isUser ? "user_id" : "group_id", true);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"prepDeleteByUserNStat");
        }
    }

    public void deleteByIDnStat(int[] pIDArray, int pStatisticID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StatDeleter.class.getName(), (String)"deleteByIDnStat", (String)"pIDArray, pStatisticID");
        }
        int i = pIDArray.length - 1;
        while (i >= 0) {
            this.stmtPhase = 0;
            this.colIndex = 1;
            try {
                this.setInt(this.deleteStmt, pStatisticID);
                for (int counter = 0; counter < 10; ++counter) {
                    if (i >= 0) {
                        this.setInt(this.deleteStmt, pIDArray[i--]);
                        continue;
                    }
                    this.setInt(this.deleteStmt, -2147483647);
                }
                this.executeUpdate(this.deleteStmt);
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)StatDeleter.class.getName(), (String)"deleteByIDnStat", (Throwable)e);
                }
                this.stmtType = 3;
                this.sqlError(e);
            }
            this.commit();
        }
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StatDeleter.class.getName(), (String)"deleteByIDnStat");
        }
    }
}

