/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.CuStatDef;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.infrastructure.database.AutoIdentifier;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TGroup2Res;

public class StorageRepositoryAccessor
extends RepositoryAccessor {
    public StorageRepositoryAccessor(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StorageRepositoryAccessor.class.getName(), (String)"RepositoryAccess", (String)"dbc");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StorageRepositoryAccessor.class.getName(), (String)"RepositoryAccess");
        }
    }

    public static int getIdentifier(int identifierType, int identifierCount, Connection dbc) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StorageRepositoryAccessor.class.getName(), (String)"getIdentifier", (String)"identifierType, identifierCount, dbc");
        }
        int identifier = 0;
        try {
            identifier = AutoIdentifier.getIdentifier((int)identifierType, (int)identifierCount);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)StorageRepositoryAccessor.class.getName(), (String)"getIdentifier", (int)identifier);
            }
            return identifier;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)StorageRepositoryAccessor.class.getName(), (String)"getIdentifier", (Throwable)e);
            }
            String errorMsg = SQLUtil.getSQLExceptionMsg("STS0033E", e, null);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)StorageRepositoryAccessor.class.getName(), (String)"getIdentifier");
            }
            throw new GeneralException(errorMsg);
        }
    }

    protected void deleteStats(String sqlText, Filesystem fsList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StorageRepositoryAccessor.class.getName(), (String)"deleteStats", (String)"sqlText, fsList");
        }
        try {
            this.deleteStmt = this.prepareStmt(sqlText);
            Filesystem fs = fsList;
            while (fs != null) {
                this.stmtPhase = 0;
                this.deleteStmt.setInt(1, fs.fsID);
                this.executeUpdate(this.deleteStmt);
                this.dbc.commit();
                fs = fs.fsNext;
            }
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)StorageRepositoryAccessor.class.getName(), (String)"deleteStats", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StorageRepositoryAccessor.class.getName(), (String)"deleteStats");
        }
    }

    protected void deleteStats(String sqlText, CuStatDef statList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StorageRepositoryAccessor.class.getName(), (String)"deleteStats", (String)"sqlText, statList");
        }
        int deleteCount = 0;
        try {
            this.deleteStmt = this.prepareStmt(sqlText);
            CuStatDef statDef = statList;
            while (statDef != null) {
                this.stmtPhase = 0;
                this.deleteStmt.setInt(1, statDef.sdID);
                if ((deleteCount += this.executeUpdate(this.deleteStmt)) > 10) {
                    deleteCount = 0;
                    this.dbc.commit();
                }
                statDef = statDef.sdNext;
            }
            if (deleteCount > 0) {
                this.dbc.commit();
            }
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)StorageRepositoryAccessor.class.getName(), (String)"deleteStats", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StorageRepositoryAccessor.class.getName(), (String)"deleteStats");
        }
    }

    public void delete(String pTableName, String whereClause, boolean doCommit) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StorageRepositoryAccessor.class.getName(), (String)"delete", (String)"pTableName, whereClause, doCommit");
        }
        this.tableName = pTableName;
        StringBuffer buf = new StringBuffer();
        buf.append("DELETE FROM ");
        buf.append(this.tableName);
        buf.append(whereClause);
        this.deleteStmt = this.prepareStmt(buf.toString());
        try {
            this.executeUpdate(this.deleteStmt);
            if (doCommit) {
                this.commit();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)StorageRepositoryAccessor.class.getName(), (String)"delete", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StorageRepositoryAccessor.class.getName(), (String)"delete");
        }
    }

    public void delete(String pTableName, String whereClause) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StorageRepositoryAccessor.class.getName(), (String)"delete", (String)"pTableName, whereClause");
        }
        this.delete(pTableName, whereClause, true);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StorageRepositoryAccessor.class.getName(), (String)"delete");
        }
    }

    public void deleteByLogicalDisk(LogicalDisk lDisk) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StorageRepositoryAccessor.class.getName(), (String)"deleteByLogicalDisk", (String)"lDisk");
        }
        try {
            this.stmtPhase = 0;
            this.deleteStmt.setInt(1, lDisk.ldID);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)StorageRepositoryAccessor.class.getName(), (String)"deleteByLogicalDisk", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StorageRepositoryAccessor.class.getName(), (String)"deleteByLogicalDisk");
        }
    }

    public void deleteByComputer(String table, int computerID) throws GeneralException {
        if (table.compareToIgnoreCase("t_res_entity_wwpn") == 0) {
            this.deleteByIdColumn(table, "entity_id", computerID);
        } else {
            this.deleteByIdColumn(table, "computer_id", computerID);
        }
    }

    public void deleteByFilesystem(String table, int filesystemID) throws GeneralException {
        this.deleteByIdColumn(table, "filesystem_id", filesystemID);
    }

    public void deleteByDisk(String table, int diskID) throws GeneralException {
        this.deleteByIdColumn(table, "disk_id", diskID);
    }

    public void deleteByIdColumn(String table, String column, int ID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StorageRepositoryAccessor.class.getName(), (String)"deleteByIdColumn", (String)"table, column, ID");
        }
        this.tableName = table;
        try {
            this.deleteStmt = this.prepareStmt("delete from " + table + " where " + column + " = ?");
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, ID);
            this.executeUpdate(this.deleteStmt);
            if (table.indexOf("t_stat_computer") != -1) {
                TGroup2Res grp2ResAccessor = new TGroup2Res(this.dbc);
                grp2ResAccessor.deleteResource(ID, false);
                grp2ResAccessor = null;
            }
            this.dbc.commit();
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)StorageRepositoryAccessor.class.getName(), (String)"deleteByIdColumn", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StorageRepositoryAccessor.class.getName(), (String)"deleteByIdColumn");
        }
    }

    public void prepDeleteByID(String table, String column) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StorageRepositoryAccessor.class.getName(), (String)"prepDeleteByID", (String)"table, column");
        }
        this.tableName = table;
        this.deleteStmt = this.prepareStmt("delete from " + table + " where " + column + " = ?");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StorageRepositoryAccessor.class.getName(), (String)"prepDeleteByID");
        }
    }

    public void deleteByID(int ID, boolean commit) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StorageRepositoryAccessor.class.getName(), (String)"deleteByID", (String)"ID, commit");
        }
        try {
            this.setPhase();
            this.setInt(this.deleteStmt, ID);
            this.executeUpdate(this.deleteStmt);
            if (commit) {
                this.commit();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)StorageRepositoryAccessor.class.getName(), (String)"deleteByID", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StorageRepositoryAccessor.class.getName(), (String)"deleteByID");
        }
    }
}

