/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.UnmanagedCompHndlr;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.repository.table.TResExport;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.handler.agent.BatchReportHndlr;

public class RptCompExport
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private GuiReportReq grr;
    private AgentManager agentManager = Server.getAgentManager();

    public RptCompExport(Connection dbc) {
        super(dbc);
    }

    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        Object accessor;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptCompExport.class.getName(), (String)"getReportData", (String)"grr");
        }
        this.grr = grr;
        Object array = null;
        Export list = null;
        if (grr.reportType == 29) {
            accessor = new TStatComputer(this.dbc);
            Computer computer = new Computer();
            computer.cmpID = -2;
            if (((TStatComputer)accessor).getGuiComputerStats(computer)) {
                list = computer;
            }
        } else if (grr.reportType == 3) {
            accessor = new TResExport(this.dbc);
            list = ((TResExport)accessor).selectByComputer(-2);
        } else if (grr.reportType == 71) {
            accessor = new UnmanagedCompHndlr(this.dbc);
            FoundComputer[] unmanagedArray = ((UnmanagedCompHndlr)accessor).getUnmanaged();
            list = FoundComputer.unpack((FoundComputer[])unmanagedArray);
        }
        ReportFilter filter = null;
        if (grr.columnFilters != null && list != null) {
            filter = new ReportFilter(grr, list);
            Export curr = list;
            Export prev = null;
            list = null;
            while (curr != null) {
                Object reportData;
                Packable next = curr.getNext();
                if (grr.reportType == 29) {
                    reportData = ((Computer)curr).clone();
                } else {
                    reportData = curr;
                    if (grr.reportType == 3) {
                        this.getComputerName((Export)reportData);
                    }
                }
                if (filter.isSelected(reportData)) {
                    curr.setNext(null);
                    if (prev == null) {
                        list = curr;
                    } else {
                        prev.setNext((Packable)curr);
                    }
                    prev = curr;
                }
                curr = next;
            }
        }
        array = grr.reportType == 29 ? (FoundComputer[])BatchReportHndlr.packComps((Computer)list) : (grr.reportType == 3 ? this.packExports(list) : FoundComputer.pack((FoundComputer)((FoundComputer)list)));
        FoundComputer[] traceResult = array;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptCompExport.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }

    private void getComputerName(Export export) {
        export.xpComputerName = this.agentManager.getAgentName(export.xpComputerID);
    }

    private Serializable packExports(Export export) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptCompExport.class.getName(), (String)"packExports", (String)"export");
        }
        Export[] exports = null;
        int count = 0;
        Export node = export;
        while (node != null) {
            ++count;
            node = node.xpNext;
        }
        if (count > 0) {
            exports = new Export[count];
            for (int i = 0; i < count; ++i) {
                node = export.xpNext;
                export.xpNext = null;
                exports[i] = export;
                if (!this.grr.isBatchReport) {
                    export.xpComputerName = null;
                } else if (export.xpComputerName == null) {
                    this.getComputerName(export);
                }
                export = node;
            }
        }
        Export[] traceResult = exports;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptCompExport.class.getName(), (String)"packExports", (Object)traceResult);
        }
        return traceResult;
    }
}

