/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.Group2ResSqlUtil;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptDiskHist;
import org.eclipse.aperi.repository.report.RptFilesystemSpc;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResVendorModel;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.xmsg.MessageLog;

public class RptDiskCapacity
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private StringBuffer buf = new StringBuffer(2000);
    private GuiReportReq grr;
    private PreparedStatement subsysUseable;
    private PreparedStatement subsysSRM;
    private PreparedStatement getServer;
    private PreparedStatement numDisks;
    private static final String NETWORK = MessageLog.getMessageNoID((String)"STG5048L");
    private TResVendorModel vmAccessor = null;
    private static final String MOST_RECENT = "'" + Integer.toString(3) + "'";
    private static final String LOGICAL_DISK = Integer.toString(11);
    private static final String DISK_SELECT = " c.computer_id, d.disk_id, a.path, d.capacity, h.free_space, h.primary_defects, h.grown_defects, dev.vendor_id, dev.model_id, dev.serial_number, dev.flags, r.os_type from t_stat_disk d, t_res_dev_access a, t_res_controller c, t_stat_disk_hist h, t_res_physical_volume dev, t_res_host r where d.disk_id = a.device_id and d.disk_id = h.disk_id and d.disk_id = dev.physical_volume_id and h.statistic_type = " + MOST_RECENT + " and a.controller_id = c.controller_id" + " and r.computer_id = c.computer_id" + " and dev.device_type = " + 0;
    private static final String SS_DISK_SELECT = " dev.subsystem_id, d.disk_id, dev.device_id, d.capacity, h.free_space, h.primary_defects, h.grown_defects, dev.vendor_id, dev.model_id, dev.serial_number, dev.flags, r.os_type from t_stat_disk d,  t_stat_disk_hist h,  t_res_physical_volume dev, t_res_storage_subsystem r where d.disk_id = h.disk_id and d.disk_id = dev.physical_volume_id and h.statistic_type = " + MOST_RECENT;
    private static final String SVC_DISK_SELECT = " dev.subsystem_id, d.disk_id, dev.element_name, d.capacity, h.free_space, h.primary_defects, h.grown_defects, -1, -1, '', -1, r.os_type from t_stat_disk d,  t_stat_disk_hist h,  t_res_storage_extent dev, t_res_storage_subsystem r where d.disk_id = h.disk_id and d.disk_id = dev.storage_extent_id and h.statistic_type = " + MOST_RECENT;
    private static final String SUBSYSTEM_PROBED_SELECT = " d.subsystem_id,  case when d.user_provided_name is not null  and d.user_provided_name <> ''  then d.user_provided_name else d.display_name end display_name, d.os_type,  v.n_disks, v.disk_capacity, v.disk_freespace, v.n_luns, v.lun_capacity, v.overhead, d.vg_capacity, d.vg_freespace, d.dg_freespace, d.cache, vendor.vendor_name, model.model_name, d.name, d.code_level, v.lgldisk_assigned_capacity, v.lun_capacity_zos from t_res_storage_subsystem d, t_view_ss_aggrinfo v,  t_res_vendor vendor, t_res_model model  where d.subsystem_id = v.subsystem_id and d.last_probe_time is not null and d.vendor_id = vendor.vendor_id and d.model_id = model.model_id ";
    private static final String TPCSERVER_WHERE = " where tpc_server_id = ?";
    private static final String GET_SERVER = "select server_name from t_res_server where server_id = ?";
    private static final String SUBSYS_USABLE = " select sum(l.capacity) from t_res_storage_volume l where l.snap_source_id < 0  and l.is_vcmdb = '0' and l.replication_mode <> '" + Integer.toString(2) + "'" + " and l.subsystem_id = ?";
    private static final String SUBSYS_SRM = " select sum(l.capacity) from t_res_storage_volume l, t_res_view_ssluncmp corr where l.svid = corr.svid and l.subsystem_id = ?";
    private static final String COMPUTER_LIST = " s.computer_id, ' ', '2'";
    private static final String COMPUTER_GROUP_LIST = " g.group_id, g.creator, g.name";
    private static final String DOMAIN_LIST = " o.domain_id, ' ', o.name";
    private static final String NETWORK_LIST = " -3, ' ', 'network wide'";
    private static final String SELECT_COMPSUM_FROM = " , c.disk_capacity, c.disk_free_space, c.owned_disk_cap, c.owned_disk_free_sp,  scsi.capacity, scsi.freespace, fc.capacity, fc.freespace  from  t_stat_disk d,  (t_stat_computer c left outer join t_view_comp_SCSI_disksum scsi on c.computer_id = scsi.computer_id )  left outer join t_view_comp_FC_disksum fc on c.computer_id = fc.computer_id ";
    private static final String SELECT_COMPGROUPSUM_FROM = ", sum(c.disk_capacity), sum(c.disk_free_space), sum(c.owned_disk_cap), sum(c.owned_disk_free_sp),   sum(scsi.capacity), sum(scsi.freespace), sum(fc.capacity), sum(fc.freespace )  from t_group g,  (t_stat_computer c left outer join t_view_comp_SCSI_disksum scsi on c.computer_id = scsi.computer_id )  left outer join t_view_comp_FC_disksum fc on c.computer_id = fc.computer_id ";
    private static final String SELECT_SUM_FROM = ",sum(d.capacity), sum(h.free_space)  from t_stat_disk d, t_stat_disk_hist h ";
    private static final String COMPUTER_WHERE = ", t_res_share s where d.disk_id = s.resource_id and s.computer_id = c.computer_id ";
    private static final String COMPUTER_GROUP_WHERE = " where c.computer_id = gr.resource_id and gr.group_id = g.group_id ";
    private static final String DOMAIN_WHERE = ", t_res_domain o where  d.disk_id = h.disk_id and h.statistic_type = " + MOST_RECENT + " and h.disk_id in" + " (select distinct(resource_id) from t_res_share s, t_stat_computer c" + " where s.resource_type = " + 10 + " and s.computer_id = c.computer_id and c.domain_id = o.domain_id)";
    private static final String NETWORK_WHERE = " where d.disk_id = h.disk_id and h.statistic_type = " + MOST_RECENT;
    private static final String NET_SPACE_SELECT = "select sum(f.capacity), sum(f.used_space) from  t_res_filesystem f, t_res_logical_disk l where f.logical_disk_id = l.logical_disk_id and   l.logical_disk_type not in ('4', '7')";
    private static final String NET_KNOWN_SELECT = "select sum(f.capacity), sum(f.used_space) from  t_res_filesystem f, t_res_logical_disk l, t_stat_computer c where f.logical_disk_id   = l.logical_disk_id and   l.logical_disk_type = '7' and   c.computer_id       = f.computer_id and   c.os_type <> 9";
    private static final String NET_CAPACITY_SELECT = "select sum(capacity) from t_res_logical_disk where logical_disk_type not in ('4', '7') and   logical_disk_id in (select s.resource_id from  t_res_share s, t_stat_computer c where s.resource_type = " + LOGICAL_DISK + " and   s.computer_id = c.computer_id)";
    private static final String NET_SS_CAPACITY_SELECT = "select sum(capacity) from t_res_storage_volume";
    private static final String NET_OVERHEAD_SELECT = "select sum(overhead) from t_res_logical_disk union  select sum(overhead) from t_res_storage_volume";
    private static final String NET_REPLICATION_SELECT = "select sum(capacity) from  t_res_storage_volume where replication_mode = '2' and   is_assigned = 0";
    private static final String NET_SURFACED_SELECT_OLD = "select sum(l.capacity) from  t_res_storage_volume l, t_res_share s, t_res_storage_subsystem a where l.is_assigned = 0  and   l.replication_mode <> '2' and   l.svid = s.resource_id and   s.computer_id     = a.subsystem_id and   l.svid not in (select logical_disk_id from t_stat_disk)";
    private static final String NET_SURFACED_SELECT = "select sum(l.capacity) from  t_res_storage_volume l  where l.is_assigned = 0  and   l.replication_mode <> '2'";
    private static final String NET_DISK_SELECT = "select sum(d.capacity) from  t_stat_disk d, t_res_physical_volume v where v.physical_volume_id        = d.disk_id and   d.logical_disk_id <= 0 and   v.device_type      = 0 and   d.disk_id in (select device_id from t_res_dev_access)";
    private static final String NET_SS_DISK_SELECT = "select  sum(capacity) from t_res_physical_volume where subsystem_id <> -1 and physical_volume_id not in (select device_id from t_res_dev_access)";

    public RptDiskCapacity(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDiskCapacity.class.getName(), (String)"RptDiskCapacity", (String)"dbc");
        }
        this.tableName = "t_stat_disk+";
        this.vmAccessor = new TResVendorModel(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDiskCapacity.class.getName(), (String)"RptDiskCapacity");
        }
    }

    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDiskCapacity.class.getName(), (String)"getReportData", (String)"grr");
        }
        this.grr = grr;
        if (grr.reportSubtype == 28) {
            RptDiskHist histRtn = new RptDiskHist(this.dbc);
            Serializable traceResult = histRtn.getReportData(grr);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptDiskCapacity.class.getName(), (String)"getReportData", (Object)traceResult);
            }
            return traceResult;
        }
        RespFSspace head = new RespFSspace();
        RespFSspace curr = null;
        RespFSspace last = head;
        int totalRows = 0;
        boolean rowSelected = true;
        ReportFilter filter = null;
        if (grr.columnFilters != null && grr.reportSubtype != 15) {
            filter = new ReportFilter(grr, head);
        }
        try {
            if (grr.reportType == 72) {
                this.buf.append("select");
                this.buf.append(SUBSYSTEM_PROBED_SELECT);
                SQLUtil.appendInClause(this.buf, "d.subsystem_id", grr.selectedResources, grr.isResourceInList, true);
                this.subsysUseable = this.prepareStmt(SUBSYS_USABLE);
                this.subsysSRM = this.prepareStmt(SUBSYS_SRM);
            } else {
                switch (grr.reportSubtype) {
                    case 27: {
                        this.buf.append("select");
                        if (grr.idSubtype <= 0) {
                            this.buf.append(DISK_SELECT);
                            this.buf.append(" and d.logical_disk_id <= 0");
                            SQLUtil.appendInClause(this.buf, "d.disk_id", grr.selectedResources, grr.isResourceInList, true);
                            this.buf.append(" union select ");
                            this.buf.append(SS_DISK_SELECT);
                            this.buf.append(" and dev.subsystem_id = r.subsystem_id");
                            SQLUtil.appendInClause(this.buf, "d.disk_id", grr.selectedResources, grr.isResourceInList, true);
                            this.buf.append(" union select ");
                            this.buf.append(SVC_DISK_SELECT);
                            this.buf.append(" and dev.subsystem_id = r.subsystem_id");
                            this.buf.append(" and d.logical_disk_id <= 0");
                            SQLUtil.appendInClause(this.buf, "d.disk_id", grr.selectedResources, grr.isResourceInList, true);
                            break;
                        }
                        TResComputer cmpAccessor = new TResComputer(this.dbc);
                        short ssType = cmpAccessor.getStorageSubsystemType(grr.grrID1);
                        if (ssType > 0) {
                            if (ssType != 21) {
                                this.buf.append(SS_DISK_SELECT);
                            } else {
                                this.buf.append(SVC_DISK_SELECT);
                            }
                            this.buf.append(" and dev.subsystem_id = ");
                        } else {
                            this.buf.append(DISK_SELECT);
                            this.buf.append(" and c.computer_id = ");
                        }
                        this.buf.append(grr.grrID1);
                        break;
                    }
                    case 77: {
                        this.buf.append("select");
                        this.buf.append(SUBSYSTEM_PROBED_SELECT);
                        SQLUtil.appendInClause(this.buf, "d.subsystem_id", grr.selectedResources, grr.isResourceInList, true);
                        this.subsysUseable = this.prepareStmt(SUBSYS_USABLE);
                        this.subsysSRM = this.prepareStmt(SUBSYS_SRM);
                        break;
                    }
                    case 12: {
                        this.buf.append("select distinct");
                        this.buf.append(COMPUTER_LIST);
                        this.buf.append(SELECT_COMPSUM_FROM);
                        this.buf.append(COMPUTER_WHERE);
                        SQLUtil.appendInClause(this.buf, "s.computer_id", grr.selectedResources, grr.isResourceInList, true);
                        this.buf.append(" order by s.computer_id");
                        break;
                    }
                    case 13: 
                    case 82: {
                        this.buf.append("select distinct");
                        this.buf.append(COMPUTER_GROUP_LIST);
                        this.buf.append(SELECT_COMPGROUPSUM_FROM);
                        this.buf.append(", t_view_group2res gr ");
                        this.buf.append(COMPUTER_GROUP_WHERE);
                        if (grr.reportSubtype == 13) {
                            this.buf.append(" and g.group_type <> 99");
                        } else {
                            this.buf.append(" and g.group_type = 99");
                        }
                        Group2ResSqlUtil.appendG2RWhere(this.buf, grr.selectedResources, grr.isResourceInList, true, grr.reportSubtype, "gr");
                        this.buf.append(" group by ");
                        this.buf.append(" g.name, g.creator, g.group_id ");
                        break;
                    }
                    case 14: {
                        this.buf.append("select");
                        this.buf.append(DOMAIN_LIST);
                        this.buf.append(SELECT_SUM_FROM);
                        this.buf.append(DOMAIN_WHERE);
                        SQLUtil.appendInClause(this.buf, "o.domain_id", grr.selectedResources, grr.isResourceInList, true);
                        this.buf.append(" group by o.domain_id, o.name");
                        break;
                    }
                    case 15: {
                        this.buf.append("select");
                        this.buf.append(NETWORK_LIST);
                        this.buf.append(SELECT_SUM_FROM);
                        this.buf.append(NETWORK_WHERE);
                        break;
                    }
                    default: {
                        Object[] args = new Object[]{new Integer(grr.reportType), new Integer(grr.reportSubtype)};
                        String errmsg = MessageLog.getMessage((String)"GEN0125E", (Object[])args);
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)RptDiskCapacity.class.getName(), (String)"getReportData");
                        }
                        throw new GeneralException(errmsg);
                    }
                }
            }
            String sqlText = this.buf.toString();
            this.selectStmt = this.prepareStmt(sqlText);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                if (curr == null) {
                    curr = new RespFSspace();
                }
                this.colIndex = 1;
                if (grr.reportSubtype == 77 || grr.reportType == 72) {
                    curr.id = this.getInt(this.resultSet);
                    curr.setName(this.getString(this.resultSet));
                    curr.osType = this.getShort(this.resultSet);
                    curr.disks = this.getInt(this.resultSet);
                    curr.capacity = this.getLong(this.resultSet);
                    curr.freeSpace = this.getLong(this.resultSet);
                    curr.luns = this.getInt(this.resultSet);
                    curr.lun_capacity = this.getLong(this.resultSet);
                    curr.overhead = this.getLong(this.resultSet);
                    curr.vs_capacity = this.getLong(this.resultSet);
                    curr.vs_freespace = this.getLong(this.resultSet);
                    curr.dg_freecap = this.getLong(this.resultSet);
                    long tempCache = this.getLong(this.resultSet);
                    curr.cache = tempCache > 0L ? (tempCache /= 0x100000L) : -1L;
                    curr.manufacturer = this.getString(this.resultSet);
                    curr.model = this.getString(this.resultSet);
                    curr.serialNumber = this.getString(this.resultSet);
                    curr.firmware = this.getString(this.resultSet);
                    curr.disk_assigned_capacity = this.getLong(this.resultSet);
                    curr.disk_unassigned_capacity = curr.lun_capacity - curr.disk_assigned_capacity;
                    curr.disk_total_formatted_free_space = curr.disk_unassigned_capacity + curr.vs_freespace;
                    curr.zos_lun_capacity = this.getLong(this.resultSet);
                    if (curr.zos_lun_capacity == -1L && (curr.osType == 12 || curr.osType == 25 || curr.osType == 27)) {
                        curr.zos_lun_capacity = 0L;
                    }
                    curr.open_sys_lun_capacity = curr.lun_capacity - curr.zos_lun_capacity;
                    this.getUseable(curr);
                    this.getSRMKnown(curr);
                } else {
                    curr.id = this.getInt(this.resultSet);
                    if (grr.reportSubtype == 27) {
                        curr.fs_id = this.getInt(this.resultSet);
                    } else {
                        curr.creator = this.getString(this.resultSet);
                    }
                    if (grr.reportSubtype == 27) {
                        RespFSspace finder = head;
                        while (finder != null && curr.fs_id != finder.fs_id) {
                            finder = finder.next;
                        }
                        if (finder != null && curr.fs_id == finder.fs_id) continue;
                    }
                    curr.setName(this.getString(this.resultSet));
                    curr.capacity = this.getLong(this.resultSet);
                    curr.freeSpace = this.getLong(this.resultSet);
                    if (grr.reportSubtype == 12 || grr.reportSubtype == 82 || grr.reportSubtype == 13) {
                        curr.owned_capacity = this.getLong(this.resultSet);
                        curr.owned_freeSp = this.getLong(this.resultSet);
                        curr.SCSI_capacity = this.getLong(this.resultSet);
                        curr.SCSI_freespace = this.getLong(this.resultSet);
                        curr.FC_capacity = this.getLong(this.resultSet);
                        curr.FC_freespace = this.getLong(this.resultSet);
                    }
                    if (grr.reportSubtype == 27) {
                        String model;
                        String vendor;
                        curr.primaryDefects = this.getInt(this.resultSet);
                        curr.grownDefects = this.getInt(this.resultSet);
                        short vendor_id = this.getShort(this.resultSet);
                        curr.manufacturer = vendor = this.vmAccessor.getVendorName(vendor_id);
                        curr.model = model = this.vmAccessor.getModelName(this.getShort(this.resultSet));
                        curr.serialNumber = this.getString(this.resultSet);
                        curr.flags = this.getShort(this.resultSet);
                        short osType = this.getShort(this.resultSet);
                        curr.directoryCount = Constants.isDiskArray((short)osType) ? 1L : 0L;
                        if ((curr.flags & 1) != 0) {
                            curr.manufacturer = MessageLog.getMessageNoID((String)"GUI0129T");
                        }
                        if ((curr.flags & 2) != 0) {
                            curr.serialNumber = MessageLog.getMessageNoID((String)"GUI0129T");
                        }
                    }
                }
                if (filter != null) {
                    RespFSspace clone = (RespFSspace)curr.clone();
                    if (grr.reportSubtype != 77 && grr.reportType != 72) {
                        this.getComputerNames(clone);
                    }
                    rowSelected = filter.isSelected(clone);
                }
                if (!rowSelected) continue;
                last.next = curr;
                last = curr;
                curr = null;
                ++totalRows;
            }
            this.closeSelect();
            if (grr.reportSubtype == 77 || grr.reportType == 72) {
                if (this.subsysUseable != null) {
                    this.subsysUseable.close();
                }
                if (this.subsysSRM != null) {
                    this.subsysSRM.close();
                }
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptDiskCapacity.class.getName(), (String)"getReportData", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (grr.reportSubtype == 15 && head.next != null) {
            this.getNetworkValues(head.next);
            if (grr.columnFilters != null) {
                filter = new ReportFilter(grr, head);
                RespFSspace clone = (RespFSspace)head.next.clone();
                this.getComputerNames(clone);
                if (!filter.isSelected(clone)) {
                    head.next = null;
                    totalRows = 0;
                }
            }
        }
        if (grr.reportSubtype != 77 && grr.reportType != 72 && grr.isBatchReport) {
            this.getComputerNames(head.next);
        }
        RespFSspace[] traceResult = RptFilesystemSpc.packItUp(head.next, totalRows);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDiskCapacity.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }

    private void getUseable(RespFSspace curr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDiskCapacity.class.getName(), (String)"getUseable", (String)"curr");
        }
        ResultSet rs = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.subsysUseable, curr.id);
            this.stmtPhase = 3;
            rs = this.subsysUseable.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptDiskCapacity.class.getName(), (String)"getUseable", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptDiskCapacity.class.getName(), (String)"getUseable");
            }
            return;
        }
        try {
            if (rs.next()) {
                this.getPhase();
                curr.fs_capacity = this.getLong(rs);
                rs.close();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptDiskCapacity.class.getName(), (String)"getUseable", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDiskCapacity.class.getName(), (String)"getUseable");
        }
    }

    private String getServerName(int id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDiskCapacity.class.getName(), (String)"getServerName", (String)"curr");
        }
        ResultSet rs = null;
        String server = null;
        if (id == -1) {
            return "Local Server";
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.getServer, id);
            this.stmtPhase = 3;
            rs = this.getServer.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptDiskCapacity.class.getName(), (String)"getServerName", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptDiskCapacity.class.getName(), (String)"getUseable");
            }
            return null;
        }
        try {
            if (rs.next()) {
                this.getPhase();
                server = this.getString(rs);
                rs.close();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptDiskCapacity.class.getName(), (String)"getServerName", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDiskCapacity.class.getName(), (String)"getUseable");
        }
        return server;
    }

    private void getSRMKnown(RespFSspace curr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDiskCapacity.class.getName(), (String)"getSRMKnown", (String)"curr");
        }
        ResultSet rs = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.subsysSRM, curr.id);
            this.stmtPhase = 3;
            rs = this.subsysSRM.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptDiskCapacity.class.getName(), (String)"getSRMKnown", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptDiskCapacity.class.getName(), (String)"getSRMKnown");
            }
            return;
        }
        try {
            if (rs.next()) {
                this.getPhase();
                curr.fsFreeSpace = this.getLong(rs);
                rs.close();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptDiskCapacity.class.getName(), (String)"getSRMKnown", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDiskCapacity.class.getName(), (String)"getSRMKnown");
        }
    }

    public void getNetworkValues(RespFSspace node) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDiskCapacity.class.getName(), (String)"getNetworkValues", (String)"node");
        }
        long tiedCapacity = 0L;
        long tiedUsedSpace = 0L;
        long untiedCapacity = 0L;
        long untiedUsedSpace = 0L;
        long logicalCapacity = 0L;
        long overhead = 0L;
        long replicationCapacity = 0L;
        long lunCapacity = 0L;
        long diskCapacity = 0L;
        try {
            this.staticStmt = this.createStatement();
            this.resultSet = this.staticStmt.executeQuery(NET_SPACE_SELECT);
            if (this.nextResult()) {
                this.getPhase();
                tiedCapacity = this.getLong(this.resultSet);
                tiedUsedSpace = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            this.resultSet = this.staticStmt.executeQuery(NET_KNOWN_SELECT);
            if (this.nextResult()) {
                this.getPhase();
                untiedCapacity = this.getLong(this.resultSet);
                untiedUsedSpace = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            this.resultSet = this.staticStmt.executeQuery(NET_CAPACITY_SELECT);
            long tempLogCapacity = 0L;
            if (this.nextResult()) {
                this.getPhase();
                tempLogCapacity = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            this.resultSet = this.staticStmt.executeQuery(NET_SS_CAPACITY_SELECT);
            if (this.nextResult()) {
                this.getPhase();
                tempLogCapacity = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            logicalCapacity = tempLogCapacity;
            this.resultSet = this.staticStmt.executeQuery(NET_OVERHEAD_SELECT);
            if (this.nextResult()) {
                this.getPhase();
                overhead = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            this.resultSet = this.staticStmt.executeQuery(NET_REPLICATION_SELECT);
            if (this.nextResult()) {
                this.getPhase();
                replicationCapacity = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            this.resultSet = this.staticStmt.executeQuery(NET_SURFACED_SELECT);
            if (this.nextResult()) {
                this.getPhase();
                lunCapacity = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            this.resultSet = this.staticStmt.executeQuery(NET_DISK_SELECT);
            long tempDiskCap = 0L;
            if (this.nextResult()) {
                this.getPhase();
                tempDiskCap = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            this.resultSet = this.staticStmt.executeQuery(NET_SS_DISK_SELECT);
            long tempDiskCap1 = 0L;
            if (this.nextResult()) {
                this.getPhase();
                tempDiskCap1 = this.getLong(this.resultSet);
            }
            this.closeResultSet();
            diskCapacity = tempDiskCap + tempDiskCap1;
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptDiskCapacity.class.getName(), (String)"getNetworkValues", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        node.capacity = diskCapacity;
        node.usedSpace = tiedUsedSpace + untiedUsedSpace;
        node.fsFreeSpace = tiedCapacity + untiedCapacity - node.usedSpace;
        node.fs_capacity = logicalCapacity - (tiedCapacity + untiedCapacity);
        node.overhead = overhead + replicationCapacity;
        node.unknown = lunCapacity;
        node.unallocated = diskCapacity - (logicalCapacity + node.overhead + lunCapacity);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDiskCapacity.class.getName(), (String)"getNetworkValues");
        }
    }

    private void getComputerNames(RespFSspace node) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDiskCapacity.class.getName(), (String)"getComputerNames", (String)"node");
        }
        AgentManager agentManager = Server.getAgentManager();
        while (node != null) {
            switch (this.grr.reportSubtype) {
                case 27: {
                    node.creator = agentManager.getAgentName(node.id);
                    break;
                }
                case 12: {
                    node.setName(agentManager.getAgentName(node.id));
                }
                case 14: {
                    node.creator = " ";
                    break;
                }
                case 15: {
                    node.creator = " ";
                    node.setName(NETWORK);
                }
            }
            node = node.next;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDiskCapacity.class.getName(), (String)"getComputerNames");
        }
    }
}

