/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.SpaceHistory;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptUserSpace;

public class RptFsHist
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private Timestamp tsStart = new Timestamp(0L);
    private Timestamp tsEnd = new Timestamp(0L);
    private static final String SELECT = "select filesystem_id, statistic_time, statistic_type, accum_count, file_count, capacity, free_space, used_space from t_stat_fs_hist ";
    private static final String FILESYSTEM_COL = "filesystem_id";

    public RptFsHist(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptFsHist.class.getName(), (String)"RptFsHist", (String)"dbc");
        }
        this.tableName = "t_stat_fs_hist";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptFsHist.class.getName(), (String)"RptFsHist");
        }
    }

    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptFsHist.class.getName(), (String)"getReportData", (String)"grr");
        }
        SpaceHistory resultList = null;
        int totalRows = 0;
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(SELECT);
        buffer.append(" where statistic_type in ('");
        buffer.append(grr.histType);
        buffer.append('\'');
        if (grr.histType != 0) {
            buffer.append(",'");
            buffer.append(grr.histType + 2);
            buffer.append('\'');
        }
        buffer.append(") and product_id = ");
        buffer.append(grr.productCode);
        buffer.append(" and");
        if (grr.startTime > 0L) {
            buffer.append(" statistic_time between ? and ? and");
        }
        SQLUtil.appendInClause(buffer, FILESYSTEM_COL, grr.selectedResources);
        try {
            this.selectStmt = this.prepareStmt(buffer.toString());
            if (grr.startTime > 0L) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setTimestamp(this.selectStmt, grr.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, grr.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            SpaceHistory sh = new SpaceHistory();
            while (this.resultSet.next()) {
                this.colIndex = 1;
                sh.shLegendID1 = this.getInt(this.resultSet);
                sh.shLegendID2 = Integer.MIN_VALUE;
                sh.shStatisticTime = this.getTimestamp(this.resultSet);
                byte statType = this.getByte(this.resultSet);
                short accumCount = this.getShort(this.resultSet);
                sh.shFileCount = this.getLong(this.resultSet);
                if (grr.histSubtype == 0 && sh.shFileCount < 0L) continue;
                long capacity = this.getLong(this.resultSet);
                sh.shTotalSize = this.getLong(this.resultSet);
                sh.shUsedSize = this.getLong(this.resultSet);
                if (statType == 3 || statType == 4) {
                    if (accumCount <= 0) continue;
                    sh.shFileCount /= (long)accumCount;
                    capacity /= (long)accumCount;
                    sh.shTotalSize /= (long)accumCount;
                    sh.shUsedSize /= (long)accumCount;
                    try {
                        sh.shStatisticTime = SQLUtil.getTimestamp(this.dbc).getTime();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)RptFsHist.class.getName(), (String)"getReportData", (Throwable)e);
                        }
                        return null;
                    }
                }
                if (grr.histSubtype == 2) {
                    if (sh.shTotalSize > 0L) {
                        sh.shFileCount = sh.shTotalSize * 100L / capacity;
                    }
                } else if (grr.histSubtype == 3) {
                    sh.shTotalSize = capacity - sh.shTotalSize;
                } else if (grr.histSubtype == 4) {
                    sh.shTotalSize = sh.shUsedSize;
                    if (sh.shTotalSize > 0L) {
                        sh.shFileCount = sh.shTotalSize * 100L / capacity;
                    }
                } else if (grr.histSubtype == 5) {
                    sh.shTotalSize = capacity;
                }
                sh.shNext = resultList;
                resultList = sh;
                sh = new SpaceHistory();
                ++totalRows;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptFsHist.class.getName(), (String)"getReportData", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        SpaceHistory[] traceResult = RptUserSpace.packUpHistory(resultList, totalRows);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptFsHist.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }
}

