/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.repository.table.TResLogicalDisk;
import org.eclipse.aperi.xmsg.MessageLog;

public class RptLunWWN
extends RepositoryAccessor
implements GuiDataProvider {
    private static final String SELECT_ONE = "  (select distinct sv.svid as svid, sv.logical_disk_type as logical_disk_type, sv.capacity as capacity             , sv.use_count as use_count, sv.mirror_count as mirror_count, sv.is_swap as is_swap             , sv.snap_source_id as snap_source_id, sv.is_vcmdb as is_vcmdb, sv.replication_mode as replication_mode             , sv.not_exposed as not_exposed, sv.overhead as overhead, sv.lun_identity as lun_identity             , sv.format as format , ss.subsystem_id as subsystem_id, ss.last_probe_time as last_probe_time             , cimkey.device_id as device_id, sv.display_name as sv_display_name, vendor.vendor_name as vendor_name             , model.model_name as model_name             , case when ss.user_provided_name is not null                    and ss.user_provided_name not in ('')                    then ss.user_provided_name else ss.display_name end as                    ss_display_name             , ss.os_type as os_type, port.name as port_name , mask.host_element_name host_element_name             , sv.name as sv_name, sv.unique_id   from \tt_res_masking_info mask        \t, t_res_data_path dp        \t, t_res_port port        \t, t_res_storage_volume sv        \t, t_res_storage_subsystem ss        \t, t_res_cimkey_volume cimkey        \t, t_res_vendor vendor        \t, t_res_model model    where port.subsystem_id is null        \tand dp.initiator_port_id = port.port_id        \tand sv.svid = dp.volume_id        \tand sv.subsystem_id = ss.subsystem_id        \tand cimkey.volume_id = sv.svid         \tand mask.masking_info_id = dp.masking_info_id        \tand vendor.vendor_id = ss.vendor_id        \tand model.model_id = ss.model_id ";
    private static final String SELECT_TWO_FIRST_PART = " select lun2hba.svid, lun2hba.logical_disk_type, lun2hba.capacity       \t, lun2hba.use_count, lun2hba.mirror_count, lun2hba.is_swap       \t, lun2hba.snap_source_id, lun2hba.is_vcmdb, lun2hba.replication_mode       \t, lun2hba.not_exposed, lun2hba.overhead, lun2hba.lun_identity       \t, lun2hba.format , lun2hba.subsystem_id, lun2hba.last_probe_time       \t, lun2hba.device_id, lun2hba.sv_display_name, lun2hba.vendor_name       \t, lun2hba.model_name, lun2hba.ss_display_name       \t, lun2hba.os_type, lun2hba.port_name , lun2hba.host_element_name       \t, lun2hba.sv_name, sv2host.computer_id, sv2host.os_type         , sv2host.disk_id, sv2host.capacity disk_capacity  \t\t, sv2host.free_space, sv2host.path    from ";
    private static final String SELECT_TWO_SECOND_PART = "      \tas lun2hba left outer join \t\t(select distinct c.computer_id, c.os_type, ctl.wwn_str  \t\tfrom t_res_host c, t_res_controller ctl, t_res_port\t\twhere t_res_port.subsystem_id is null             and ctl.wwn_str = t_res_port.name  \t\t\tand ctl.computer_id = c.computer_id) as host \ton lun2hba.port_name = host.wwn_str left outer join         \t(select  distinct c.computer_id, c.os_type, sd_disk_id as disk_id         \t\t, sd_capacity as capacity, sdh_free_space as free_space, da_path as path, sv_unique_id         \tfrom \tt_res_comp2lun comp2lun        \t\t,  t_res_host c        \twhere \t         \t\tcomp2lun.computer_id = c.computer_id ";
    private static final String SELECT_TWO_THIRD_PART = "         ) as sv2host         \t\ton (sv2host.sv_unique_id = lun2hba.unique_id     \t    and host.computer_id = sv2host.computer_id) ";
    private static final String BY_SUBSYSTEM = " order by lun2hba.ss_display_name asc , lun2hba.device_id,  lun2hba.sv_display_name asc";
    private static final String BY_CAPACITY = " order by lun2hba.capacity desc";
    private static final String BY_PROBE_TIME = " order by s.scan_time ";
    private static final String GET_SRM_DISK = " select distinct c.computer_id, c.os_type,  sd.disk_id, sd.capacity, dh.free_space, da.path  from t_res_share sh, t_res_dev_access da,  t_stat_disk sd, t_stat_disk_hist dh, t_res_host c,  t_res_view_ssluncmp ssluncmp  where ssluncmp.svid = ?  and  ssluncmp.computer_id = c.computer_id  and  ssluncmp.physical_volume_id = sd.disk_id  and  sd.disk_id = da.device_id  and  sd.disk_id = dh.disk_id  and  dh.statistic_type = '3'";

    public RptLunWWN(Connection dbc) {
        super(dbc);
        this.tableName = "t_res_lun_wwn";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        Lun lunList = null;
        Lun lun = new Lun();
        LogicalDisk lDisk = new LogicalDisk();
        boolean rowSelected = true;
        ReportFilter filter = null;
        if (grr.columnFilters != null) {
            filter = new ReportFilter(grr, lun);
        }
        int counter = 0;
        try {
            this.selectStmt = this.prepareStmt(this.getSQLText(grr));
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                ++counter;
                rowSelected = true;
                this.getPhase();
                this.colIndex = this.fetchLogicalDiskInfo(lDisk, this.resultSet);
                lun.lunLogicalDisk = lDisk;
                lun.lunID = lDisk.ldID;
                lun.lunDaID = this.getInt(this.resultSet);
                lun.lunProbeTime = this.getTimestamp(this.resultSet);
                lun.lunDeviceId = this.getString(this.resultSet);
                lun.lunName = this.getString(this.resultSet);
                lun.lunDaManufacturer = this.getString(this.resultSet);
                lun.lunDaModel = this.getString(this.resultSet);
                lun.lunDaAlias = this.getString(this.resultSet);
                lun.lunOSType = this.getShort(this.resultSet);
                lun.lunHBAWWN = this.getString(this.resultSet);
                try {
                    lun.lunWorkWWN = Long.parseLong(lun.lunHBAWWN, 16);
                }
                catch (NumberFormatException e) {
                    lun.lunWorkWWN = -2L;
                }
                lun.lunSSHost = this.getString(this.resultSet);
                lun.lunWWN = this.getString(this.resultSet);
                if (!Constants.hasLunWWN((short)lun.lunOSType)) {
                    if (SQLUtil.isNullString(lun.lunName)) {
                        lun.lunName = lun.lunWWN;
                    }
                    lun.lunWWN = null;
                } else if (lun.lunOSType == 25 || lun.lunOSType == 27) {
                    if (!SQLUtil.isNullString(lun.lunName)) {
                        lun.lunWWN = lun.lunDeviceId;
                    } else {
                        lun.lunName = lun.lunDeviceId;
                        lun.lunWWN = null;
                    }
                }
                int computer_id = this.getInt(this.resultSet);
                if (computer_id > 0) {
                    lun.lunLogicalDisk.ldIsSwap = true;
                    lun.lunAgentID = computer_id;
                    lun.lunAgentOSType = this.getShort(this.resultSet);
                    int disk_ID = this.getInt(this.resultSet);
                    if (disk_ID > 0) {
                        lun.lunDiskID = disk_ID;
                        lun.lunDiskCapacity = this.getLong(this.resultSet);
                        lun.lunDiskFreespace = this.getLong(this.resultSet);
                        lun.lunDiskPath = this.getString(this.resultSet);
                    }
                }
                if (grr.reportSubtype == 89) {
                    if (lun.lunAgentID > 0) {
                        rowSelected = false;
                    }
                } else if (grr.reportSubtype == 90) {
                    if (lun.lunAgentID < 1) {
                        rowSelected = false;
                    } else if (lun.lunDiskID > 0) {
                        rowSelected = false;
                    }
                }
                if (rowSelected && filter != null) {
                    rowSelected = filter.isSelected(lun);
                }
                if (rowSelected) {
                    lun.lunNext = lunList;
                    lunList = lun;
                }
                lun = new Lun();
                lDisk = new LogicalDisk();
            }
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.close(this);
        }
        return (Serializable)Packer.pack(lunList);
    }

    private String getSQLText(GuiReportReq grr) throws GeneralException {
        StringBuffer buffer = new StringBuffer(256);
        StringBuffer subselect = new StringBuffer(256);
        StringBuffer subselect2 = new StringBuffer(256);
        subselect.append(SELECT_ONE);
        subselect2.append(SELECT_TWO_SECOND_PART);
        if (grr.selectedResources != null) {
            SQLUtil.appendInClause(subselect, "ss.subsystem_id", grr.selectedResources, grr.isResourceInList, true);
            SQLUtil.appendInClause(subselect2, "comp2lun.subsystem_id", grr.selectedResources, grr.isResourceInList, true);
        }
        subselect.append(") ");
        buffer.append(SELECT_TWO_FIRST_PART + subselect + subselect2 + SELECT_TWO_THIRD_PART);
        switch (grr.reportSubtype) {
            case 77: 
            case 89: 
            case 90: {
                buffer.append(BY_SUBSYSTEM);
                break;
            }
            case 78: {
                buffer.append(BY_CAPACITY);
                break;
            }
            case 18: {
                buffer.append(BY_PROBE_TIME);
                break;
            }
            default: {
                Object[] args = new Object[]{new Integer(grr.reportType), new Integer(grr.reportSubtype)};
                String errmsg = MessageLog.getMessage((String)"GEN0125E", (Object[])args);
                throw new GeneralException(errmsg);
            }
        }
        return buffer.toString();
    }

    private void close(RepositoryAccessor accessor) {
        try {
            accessor.closeSelect();
        }
        catch (GeneralException generalException) {
            // empty catch block
        }
    }

    private int fetchLogicalDiskInfo(LogicalDisk ld, ResultSet rs) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"fetchLogicalDiskInfo", (String)"ld, rs");
        }
        this.colIndex = 1;
        ld.ldID = this.getInt(rs);
        ld.ldType = this.getByte(rs);
        ld.ldCapacity = this.getLong(rs);
        ld.ldUseCount = this.getShort(rs);
        ld.ldMirrorCount = this.getByte(rs);
        ld.ldIsSwap = this.getBoolean(rs);
        ld.ldSnapSourceID = this.getInt(rs);
        boolean isVCMDB = this.getBoolean(rs);
        byte replicationMode = this.getByte(rs);
        boolean notExposed = this.getBoolean(rs);
        ld.setFlags((short)replicationMode, isVCMDB, notExposed);
        ld.ldOverhead = this.getLong(rs);
        ld.lun_identity = this.getByte(rs);
        ld.ldStorageType = this.getShort(rs);
        int traceResult = this.colIndex;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"fetchLogicalDiskInfo", (int)traceResult);
        }
        return traceResult;
    }
}

