/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.TStorm.common.SpaceHistory;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptUserSpace;

public class RptSpaceHist
extends StorageRepositoryAccessor
implements GuiDataProvider {
    private Timestamp tsStart = new Timestamp(0L);
    private Timestamp tsEnd = new Timestamp(0L);
    private static final String SELECT = "select filesystem_id, statistic_time, statistic_type, accum_count, file_count, total_size from t_stat_space_hist where statistic_id = ";
    private static final String FILESYSTEM_COL = "filesystem_id";

    public RptSpaceHist(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptSpaceHist.class.getName(), (String)"RptSpaceHist", (String)"dbc");
        }
        this.tableName = "t_stat_space_hist";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptSpaceHist.class.getName(), (String)"RptSpaceHist");
        }
    }

    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptSpaceHist.class.getName(), (String)"getReportData", (String)"grr");
        }
        SpaceHistory resultList = null;
        int totalRows = 0;
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(SELECT);
        buffer.append(grr.profile);
        buffer.append(" and statistic_type in ('");
        buffer.append(grr.histType);
        buffer.append('\'');
        if (grr.histType != 0) {
            buffer.append(",'");
            buffer.append(grr.histType + 2);
            buffer.append('\'');
        }
        buffer.append(") and");
        if (grr.startTime > 0L) {
            buffer.append(" statistic_time between ? and ? and");
        }
        SQLUtil.appendInClause(buffer, FILESYSTEM_COL, grr.selectedResources);
        try {
            this.selectStmt = this.prepareStmt(buffer.toString());
            if (grr.startTime > 0L) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setTimestamp(this.selectStmt, grr.startTime, this.tsStart);
                this.setTimestamp(this.selectStmt, grr.endTime, this.tsEnd);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            SpaceHistory sh = new SpaceHistory();
            while (this.resultSet.next()) {
                this.colIndex = 1;
                sh.shLegendID1 = this.getInt(this.resultSet);
                sh.shLegendID2 = Integer.MIN_VALUE;
                sh.shStatisticTime = this.getTimestamp(this.resultSet);
                byte statType = this.getByte(this.resultSet);
                short accumCount = this.getShort(this.resultSet);
                sh.shFileCount = this.getLong(this.resultSet);
                sh.shTotalSize = this.getLong(this.resultSet);
                if (statType == 3 || statType == 4) {
                    if (accumCount == 0) continue;
                    sh.shFileCount /= (long)accumCount;
                    sh.shTotalSize /= (long)accumCount;
                    try {
                        sh.shStatisticTime = SQLUtil.getTimestamp(this.dbc).getTime();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)RptSpaceHist.class.getName(), (String)"getReportData", (Throwable)e);
                        }
                        return null;
                    }
                }
                if (grr.historyPercentLimit > 0L) {
                    sh.shFileCount = sh.shTotalSize * 51200L / grr.historyPercentLimit;
                }
                sh.shNext = resultList;
                resultList = sh;
                sh = new SpaceHistory();
                ++totalRows;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptSpaceHist.class.getName(), (String)"getReportData", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        SpaceHistory[] traceResult = RptUserSpace.packUpHistory(resultList, totalRows);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptSpaceHist.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }
}

