/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespVolGroup;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptFsHist;
import org.eclipse.aperi.repository.report.filter.ReportFilter;

public class RptVolGroup
extends StorageRepositoryAccessor
implements GuiDataProvider {
    int rowCount;
    RespVolGroup listHdr = null;
    private static final String SELECT = " select v.volgroup_id, v.name, v.freespace, v.capacity,  v.volgroup_type, v.config, v.status, v.format,    v.nbrvolumes, v.nbrdisks, v.last_probe_time, v.discovered_time,   v.computer_id, v.disk_group, v.lss, v.surf_lun_cap, v.unsurf_lun_cap,  c.host_name, c.os_type  from t_res_volgroup v, t_res_host c where v.computer_id = c.computer_id and  v.volgroup_type in (0,1)";
    private static final String BY_NAME = " order by v.name desc";
    private static final String BY_CAPACITY = " order by v.capacity";
    private static final String BY_FREESPACE = " order by v.freespace";
    private static final String BY_COMPUTER = " order by c.host_name desc";
    private static final String BY_PROBE_TIME = " order by v.last_probe_time";
    private static final String BY_DISCOVERED_TIME = " order by v.discovered_time";

    public RptVolGroup(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptVolGroup.class.getName(), (String)"RptVolGroup", (String)"dbc");
        }
        this.tableName = "t_res_volgroup";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptVolGroup.class.getName(), (String)"RptVolGroup");
        }
    }

    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptVolGroup.class.getName(), (String)"getReportData", (String)"grr");
        }
        if (grr.reportSubtype == 28) {
            RptFsHist histRtn = new RptFsHist(this.dbc);
            Serializable traceResult = histRtn.getReportData(grr);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptVolGroup.class.getName(), (String)"getReportData", (Object)traceResult);
            }
            return traceResult;
        }
        this.rowCount = 0;
        StringBuffer buf = new StringBuffer(200);
        buf.append(SELECT);
        switch (grr.reportSubtype) {
            case 80: {
                buf.append(BY_NAME);
                break;
            }
            case 12: {
                buf.append(BY_COMPUTER);
                break;
            }
            case 78: {
                buf.append(BY_CAPACITY);
                break;
            }
            case 17: {
                buf.append(BY_FREESPACE);
                break;
            }
            case 18: {
                buf.append(BY_PROBE_TIME);
                break;
            }
            case 37: {
                buf.append(BY_DISCOVERED_TIME);
            }
        }
        int totalRows = 0;
        boolean rowSelected = true;
        RespVolGroup head = new RespVolGroup();
        RespVolGroup curr = new RespVolGroup();
        ReportFilter filter = null;
        if (grr.columnFilters != null) {
            filter = new ReportFilter(grr, curr);
        }
        try {
            this.selectStmt = this.prepareStmt(buf.toString());
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            RespVolGroup last = head;
            while (this.nextResult()) {
                ++this.rowCount;
                if (curr == null) {
                    curr = new RespVolGroup();
                }
                this.colIndex = 1;
                curr.vgID = this.getInt(this.resultSet);
                curr.vgName = this.getString(this.resultSet);
                curr.vgFreeSpace = this.getLong(this.resultSet);
                curr.vgTotalSpace = this.getLong(this.resultSet);
                curr.vgType = this.getShort(this.resultSet);
                curr.vgConfig = this.getShort(this.resultSet);
                curr.vgOperationalStatus = this.getInt(this.resultSet);
                curr.vgStatus = (short)curr.vgOperationalStatus;
                curr.vgFormat = this.getShort(this.resultSet);
                curr.vgVolumes = this.getInt(this.resultSet);
                curr.vgDisks = this.getInt(this.resultSet);
                curr.vgProbeTime = this.getTimestamp(this.resultSet);
                if (this.resultSet.wasNull()) {
                    curr.vgProbeTime = 86400000L;
                }
                curr.vgDiscoveredTime = this.getTimestamp(this.resultSet);
                if (this.resultSet.wasNull()) {
                    curr.vgDiscoveredTime = 86400000L;
                }
                curr.vgComputerID = this.getInt(this.resultSet);
                curr.vgDiskGroup = this.getString(this.resultSet);
                curr.vgLSS = this.getString(this.resultSet);
                curr.vgSurfacedLunCap = this.getLong(this.resultSet);
                curr.vgUnSurfacedLunCap = this.getLong(this.resultSet);
                curr.rvgComputerName = this.getString(this.resultSet);
                curr.rvgComputerOsType = this.getShort(this.resultSet);
                if (filter != null) {
                    RespVolGroup clone = (RespVolGroup)curr.clone();
                    rowSelected = filter.isSelected(clone);
                }
                if (!rowSelected) continue;
                last.next = curr;
                last = curr;
                curr = null;
                ++totalRows;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptVolGroup.class.getName(), (String)"getReportData", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        RespVolGroup[] traceResult = RptVolGroup.packItUp(head.next, totalRows);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptVolGroup.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }

    public static RespVolGroup[] packItUp(RespVolGroup head, int totalRows) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptVolGroup.class.getName(), (String)"packItUp", (String)"head, totalRows");
        }
        RespVolGroup[] result = new RespVolGroup[totalRows];
        totalRows = 0;
        while (head != null) {
            RespVolGroup next = head.next;
            head.next = null;
            result[totalRows] = head;
            ++totalRows;
            head = next;
        }
        RespVolGroup[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptVolGroup.class.getName(), (String)"packItUp", (Object)traceResult);
        }
        return traceResult;
    }
}

