/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;

public class TFoundComputer
extends RepositoryAccessor {
    private static final String SELECT_ALL = "SELECT found_computer_id, name, domain_name, ip_address, os_type, discovery_method, name_is_local, when_discovered, times_missing FROM t_found_computer";
    private static final String JOIN_NETWORK = "SELECT c.computer_id FROM t_found_computer f, t_res_host c WHERE f.found_computer_id = ? AND UPPER(c.network_name) = UPPER(f.name) AND (UPPER(c.domain_name) = UPPER(f.domain_name) OR c.ip_address = f.ip_address)";
    private static final String JOIN_WINDOWS = "SELECT c.computer_id FROM t_found_computer f, t_res_host c, t_stat_computer s, t_res_domain d WHERE f.found_computer_id = ? and UPPER(c.host_url) = UPPER(f.name) AND UPPER(d.name) = UPPER(f.domain_name) AND s.domain_id = d.domain_id AND s.computer_id = c.computer_id";
    private static final String INSERT = "INSERT INTO t_found_computer (found_computer_id, name, domain_name, ip_address, os_type, discovery_method, name_is_local, when_discovered, times_missing) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE = "UPDATE t_found_computer SET ip_address = ?, os_type = ?, name_is_local = ?, times_missing = ? WHERE found_computer_id = ?";

    public TFoundComputer(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundComputer.class.getName(), (String)"TFoundComputer", (String)"dbc");
        }
        this.tableName = "T_FOUND_COMPUTER";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundComputer.class.getName(), (String)"TFoundComputer");
        }
    }

    private void fetch(FoundComputer fc) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundComputer.class.getName(), (String)"fetch", (String)"fc");
        }
        fc.fcID = this.getInt(this.resultSet);
        fc.fcName = this.getString(this.resultSet);
        fc.fcDomain = this.getString(this.resultSet);
        fc.fcIPAddress = this.getString(this.resultSet);
        fc.fcOSType = this.getShort(this.resultSet);
        fc.fcDiscoveryMethod = this.getShort(this.resultSet);
        fc.fcNameIsLocal = this.getBoolean(this.resultSet);
        fc.fcWhenDiscovered = this.getTimestamp(this.resultSet);
        fc.fcTimesMissing = this.getShort(this.resultSet);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundComputer.class.getName(), (String)"fetch");
        }
    }

    private FoundComputer select(String sqlText) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundComputer.class.getName(), (String)"select", (String)"sqlText");
        }
        FoundComputer head = null;
        this.selectStmt = this.prepareStmt(sqlText);
        this.stmtPhase = 3;
        try {
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                FoundComputer fc = new FoundComputer();
                this.colIndex = 1;
                this.fetch(fc);
                fc.fcNext = head;
                head = fc;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TFoundComputer.class.getName(), (String)"select", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        FoundComputer traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundComputer.class.getName(), (String)"select", traceResult);
        }
        return traceResult;
    }

    public FoundComputer selectAll() throws GeneralException {
        return this.select(SELECT_ALL);
    }

    public FoundComputer selectByDomain(String domain) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundComputer.class.getName(), (String)"selectByDomain", (String)"domain");
        }
        StringBuffer buf = new StringBuffer(SELECT_ALL);
        buf.append(" WHERE domain_name = '");
        buf.append(domain);
        buf.append('\'');
        String sqlText = buf.toString();
        buf = null;
        FoundComputer traceResult = this.select(sqlText);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundComputer.class.getName(), (String)"selectByDomain", (Object)traceResult);
        }
        return traceResult;
    }

    public void prepWindowsMatch() throws GeneralException {
        this.selectStmt = this.prepareStmt(JOIN_WINDOWS);
    }

    public void prepNetworkMatch() throws GeneralException {
        this.selectStmt = this.prepareStmt(JOIN_NETWORK);
    }

    public boolean selectMatch(int fcID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundComputer.class.getName(), (String)"selectMatch", (String)"fcID");
        }
        boolean result = false;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, fcID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            result = this.nextResult();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TFoundComputer.class.getName(), (String)"selectMatch", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundComputer.class.getName(), (String)"selectMatch", (boolean)traceResult);
        }
        return traceResult;
    }

    public void prepSelectByID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundComputer.class.getName(), (String)"prepSelectByID", (String)"");
        }
        StringBuffer buf = new StringBuffer(200);
        buf.append(SELECT_ALL);
        buf.append(" WHERE found_computer_id = ?");
        this.selectStmt = this.prepareStmt(buf.toString());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundComputer.class.getName(), (String)"prepSelectByID");
        }
    }

    public void fetchByID(FoundComputer fc) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundComputer.class.getName(), (String)"fetchByID", (String)"fc");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, fc.fcID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                this.fetch(fc);
            } else {
                fc.fcName = null;
                fc.fcDomain = null;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TFoundComputer.class.getName(), (String)"fetchByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundComputer.class.getName(), (String)"fetchByID");
        }
    }

    public void insert(FoundComputer computers) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundComputer.class.getName(), (String)"insert", (String)"computers");
        }
        int commitCounter = 0;
        this.insertStmt = this.prepareStmt(INSERT);
        try {
            while (computers != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.insertStmt, computers.fcID);
                this.setString(this.insertStmt, computers.fcName);
                this.setString(this.insertStmt, computers.fcDomain);
                this.setString(this.insertStmt, computers.fcIPAddress);
                this.setShort(this.insertStmt, computers.fcOSType);
                this.setShort(this.insertStmt, computers.fcDiscoveryMethod);
                this.setBoolean(this.insertStmt, computers.fcNameIsLocal);
                this.setTimestamp(this.insertStmt, computers.fcWhenDiscovered);
                this.setShort(this.insertStmt, computers.fcTimesMissing);
                this.executeUpdate(this.insertStmt);
                if (++commitCounter >= 10) {
                    this.commit();
                    commitCounter = 0;
                }
                computers = computers.fcNext;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TFoundComputer.class.getName(), (String)"insert", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        this.closeInsert();
        if (commitCounter > 0) {
            this.stmtType = 1;
            this.commit();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundComputer.class.getName(), (String)"insert");
        }
    }

    public void update(FoundComputer computers) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundComputer.class.getName(), (String)"update", (String)"computers");
        }
        int commitCounter = 0;
        this.updateStmt = this.prepareStmt(UPDATE);
        try {
            while (computers != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setString(this.updateStmt, computers.fcIPAddress);
                this.setShort(this.updateStmt, computers.fcOSType);
                this.setBoolean(this.updateStmt, computers.fcNameIsLocal);
                this.setShort(this.updateStmt, computers.fcTimesMissing);
                this.setInt(this.updateStmt, computers.fcID);
                this.executeUpdate(this.updateStmt);
                if (++commitCounter >= 10) {
                    this.commit();
                    commitCounter = 0;
                }
                computers = computers.fcNext;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TFoundComputer.class.getName(), (String)"update", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        this.closeUpdate();
        if (commitCounter > 0) {
            this.stmtType = 2;
            this.commit();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundComputer.class.getName(), (String)"update");
        }
    }

    public static String canonicalName(FoundComputer fc) {
        String result;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TFoundComputer.class.getName(), (String)"canonicalName", (String)"fc");
        }
        if (Util.isEmpty((String)fc.fcDomain)) {
            result = fc.fcName;
        } else {
            StringBuffer buf = new StringBuffer(100);
            if (fc.fcNameIsLocal) {
                buf.append(fc.fcDomain);
                buf.append('\\');
                buf.append(fc.fcName);
            } else {
                buf.append(fc.fcName);
                buf.append('.');
                buf.append(fc.fcDomain);
            }
            result = buf.toString();
        }
        String traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TFoundComputer.class.getName(), (String)"canonicalName", (Object)traceResult);
        }
        return traceResult;
    }
}

