/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Group2Res;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.table.TGroup2Mask;
import org.eclipse.aperi.repository.table.TResCluster;
import org.eclipse.aperi.server.handler.gui.GroupDefHndlr;
import org.eclipse.aperi.xmsg.MessageLog;

public class TGroup2Res
extends RepositoryAccessor {
    Connection save_dbc;
    private static final short DIRECT_RESOURCE = 1;
    private static final short INDIRECT_RESOURCE = 2;
    private static final short DIRECT_GROUP = 3;
    private static final short INDIRECT_GROUP = 4;
    private static final short MASKED_RESOURCE = 5;
    private static final short PARENT_LEVELS = 5;
    private static final String INSERT = "insert into t_group2res ( resource_id, group_id, parent_id, res_type, res_indicator, ancestors ) values (?, ?, ?, ?, ?, ?)";
    private static final String DELETE = "delete from t_group2res where resource_id = ? and group_id = ? and  parent_id = ?  and res_indicator = ? and ancestors = ? ";
    private static final String DELETE_GROUP = "delete from t_group2res where resource_id = ? or group_id = ? ";
    private static final String DELETE_RESOURCE = "delete from t_group2res where resource_id = ? ";
    private static final String SELECT_CHILDREN = "select resource_id, group_id, parent_id, res_type, res_indicator, ancestors from t_group2res where group_id = ? ";
    private static final String SELECT_COMPUTER_NAMES = "select r.host_name as name, r.computer_id as ID, 1 as type, '' as creator, s.cluster_id as cl_id from t_res_host r, t_stat_computer s  where r.computer_id = s.computer_id and r.computer_id in (select resource_id from t_group2res where  group_id = ? and res_indicator = 1) union select g.name as name, g.group_id as ID, g.group_type as type,  g.creator as creator, 0 as cl_id from  t_group g where g.group_id in (select resource_id from t_group2res  where group_id = ? and res_indicator = 3) order by name";
    private static final String SELECT_FILESYSTEM_COMPUTERS = "select c.host_name as name, r.computer_id as ID, 1 as type, '' as creator  from t_res_filesystem r, t_res_host c  where r.computer_id = c.computer_id and r.filesystem_id in (select resource_id from t_group2res where  group_id = ? and res_indicator = 1) union select g.name as name, g.group_id as ID, g.group_type as type,  g.creator as creator  from t_group g where g.group_id in (select resource_id from t_group2res  where group_id = ? and res_indicator = 3) order by name";
    private static final String SELECT_FILESYSTEM_NAMES = "select r.mount_point as name, r.filesystem_id as ID, 3 as type, '' as creator, r.computer_id as comp_id  from t_res_filesystem r  where r.filesystem_id in (select resource_id from t_group2res where  group_id = ? and res_indicator = 1) union select g.name as name, g.group_id as ID, g.group_type as type,  g.creator as creator, -1 as comp_id from t_group g where g.group_id in (select resource_id from t_group2res  where group_id = ? and res_indicator = 3) order by comp_id, name";
    private static final String SELECT_FS = "select r.mount_point as name, r.filesystem_id as ID, 3 as type, r.computer_id as comp_id  from t_res_filesystem r  where r.computer_id  = ? and r.filesystem_id in (select resource_id from t_group2res where  group_id = ? and res_indicator = 1) order by comp_id, name";
    private static final String SELECT_ANCESTOR = "select resource_id, group_id, parent_id, res_type, res_indicator, ancestors from t_group2res where resource_id = ? and ( res_indicator = ? or res_indicator = ? )";
    private static final String SELECT_COMPUTER_BY_GID = "select c.host_name as name, c.computer_id as ID, 1 as type, c.computer_id as comp_id  from t_res_host c  where c.computer_id in (select distinct(resource_id) from t_group2res where  group_id = ? and ((res_indicator = 1) OR (res_indicator = 2) OR (res_indicator = 5)))";
    private static final String SELECT_FS_BY_GID = "select r.mount_point as name, r.filesystem_id as ID, 3 as type, r.computer_id as comp_id  from t_res_filesystem r  where r.filesystem_id in (select distinct(resource_id) from t_group2res where  group_id = ? and ((res_indicator = 1) OR (res_indicator = 2) OR (res_indicator = 5))) order by comp_id, name";
    private static final String SELECT_MON_GROUP_BY_COMP_ID = "select t.group_id from t_group2res t, t_group r where r.group_type = 0 and t.group_id = r.group_id and t.res_indicator = 1 and t.resource_id = ? ";
    private static final String SELECT_MON_GROUP_BY_FS_ID = "select t.group_id from t_group2res t, t_group r where r.group_type = 2 and t.group_id = r.group_id and t.res_indicator = 1 and t.resource_id = ? ";
    boolean locked = false;
    String resName = null;

    public TGroup2Res(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"TGroup2Res", (String)"dbc");
        }
        this.save_dbc = dbc;
        this.tableName = "t_group2res";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"TGroup2Res");
        }
    }

    private ArrayList findAncestors(int group_id, boolean isDelete) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"findAncestors", (String)"group_id, isDelete");
        }
        boolean exceeded_flag = false;
        ArrayList<Group2Res> tempList = new ArrayList<Group2Res>(30);
        if (group_id > 0) {
            try {
                this.selectStmt = this.prepareStmt(SELECT_ANCESTOR);
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, group_id);
                this.setShort(this.selectStmt, (short)3);
                this.setShort(this.selectStmt, (short)4);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                while (this.resultSet.next()) {
                    this.colIndex = 1;
                    Group2Res g2rList = new Group2Res();
                    g2rList.g2resResourceID = this.getInt(this.resultSet);
                    g2rList.g2resGroupID = this.getInt(this.resultSet);
                    g2rList.g2resParentID = this.getInt(this.resultSet);
                    g2rList.g2resResourceType = this.getShort(this.resultSet);
                    g2rList.g2resIndicator = this.getShort(this.resultSet);
                    g2rList.g2resAncestors = this.getString(this.resultSet);
                    StringTokenizer st = new StringTokenizer(g2rList.g2resAncestors, ":");
                    int count = st.countTokens();
                    if (isDelete) {
                        if (count > 5) {
                            exceeded_flag = true;
                            break;
                        }
                    } else if (count >= 5) {
                        exceeded_flag = true;
                        break;
                    }
                    tempList.add(g2rList);
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TGroup2Res.class.getName(), (String)"findAncestors", (Throwable)e);
                }
                if (this.locked) {
                    this.unlockTGroup();
                }
                this.stmtType = 0;
                this.sqlError(e);
            }
            this.closeResultSet();
            this.closeSelect();
            if (exceeded_flag) {
                this.cleanup();
                if (this.locked) {
                    this.unlockTGroup();
                }
                String s = MessageLog.getMessage((String)"SRV0166E");
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"findAncestors");
                }
                throw new GeneralException(s);
            }
        }
        ArrayList<Group2Res> traceResult = tempList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"findAncestors", traceResult);
        }
        return traceResult;
    }

    private int getParentLevels(int group_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"getParentLevels", (String)"group_id");
        }
        int groupLevel = 0;
        if (group_id > 0) {
            try {
                this.selectStmt = this.prepareStmt(SELECT_ANCESTOR);
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, group_id);
                this.setShort(this.selectStmt, (short)3);
                this.setShort(this.selectStmt, (short)4);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                while (this.resultSet.next()) {
                    this.colIndex = 1;
                    Group2Res g2rList = new Group2Res();
                    g2rList.g2resResourceID = this.getInt(this.resultSet);
                    g2rList.g2resGroupID = this.getInt(this.resultSet);
                    g2rList.g2resParentID = this.getInt(this.resultSet);
                    g2rList.g2resResourceType = this.getShort(this.resultSet);
                    g2rList.g2resIndicator = this.getShort(this.resultSet);
                    g2rList.g2resAncestors = this.getString(this.resultSet);
                    StringTokenizer st = new StringTokenizer(g2rList.g2resAncestors, ":");
                    int count = st.countTokens();
                    if (count <= groupLevel) continue;
                    groupLevel = count;
                }
                this.closeResultSet();
                this.closeSelect();
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TGroup2Res.class.getName(), (String)"getParentLevels", (Throwable)e);
                }
                if (this.locked) {
                    this.unlockTGroup();
                }
                this.stmtType = 0;
                this.sqlError(e);
            }
            int traceResult = groupLevel + 1;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"getParentLevels", (int)traceResult);
            }
            return traceResult;
        }
        int traceResult = 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"getParentLevels", (int)traceResult);
        }
        return traceResult;
    }

    private int getChildrenLevels(int grp_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"getChildrenLevels", (String)"grp_id");
        }
        int childrenLevel = 0;
        if (grp_id < 0) {
            int traceResult = childrenLevel;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"getChildrenLevels", (int)traceResult);
            }
            return traceResult;
        }
        try {
            this.selectStmt = this.prepareStmt(SELECT_CHILDREN);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, grp_id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.resultSet.next()) {
                this.colIndex = 1;
                Group2Res g2rList = new Group2Res();
                g2rList.g2resResourceID = this.getInt(this.resultSet);
                g2rList.g2resGroupID = this.getInt(this.resultSet);
                g2rList.g2resParentID = this.getInt(this.resultSet);
                g2rList.g2resResourceType = this.getShort(this.resultSet);
                g2rList.g2resIndicator = this.getShort(this.resultSet);
                g2rList.g2resAncestors = this.getString(this.resultSet);
                StringTokenizer st = new StringTokenizer(g2rList.g2resAncestors, ":");
                int count = st.countTokens();
                if (count <= childrenLevel) continue;
                childrenLevel = count;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Res.class.getName(), (String)"getChildrenLevels", (Throwable)e);
            }
            if (this.locked) {
                this.unlockTGroup();
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        this.closeSelect();
        int traceResult = childrenLevel;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"getChildrenLevels", (int)traceResult);
        }
        return traceResult;
    }

    public NameList getFSforComputer(NameList nlComp, int group_id, short group_type) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"getFSforComputer", (String)"nlComp, group_id, group_type");
        }
        NameList tail = null;
        NameList grMembers = null;
        String sqltxt = null;
        switch (group_type) {
            case 90: {
                sqltxt = SELECT_FS;
                break;
            }
            default: {
                sqltxt = null;
            }
        }
        int compid = nlComp.nlID;
        try {
            this.selectStmt = this.prepareStmt(sqltxt);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, compid);
            this.setInt(this.selectStmt, group_id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.resultSet.next()) {
                this.colIndex = 1;
                grMembers = new NameList();
                grMembers.nlName = this.getString(this.resultSet);
                grMembers.nlID = this.getInt(this.resultSet);
                grMembers.nlInfo = this.getShort(this.resultSet);
                grMembers.nlID2 = this.getInt(this.resultSet);
                grMembers.nlNext = tail;
                tail = grMembers;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Res.class.getName(), (String)"getFSforComputer", (Throwable)e);
            }
            if (this.locked) {
                this.unlockTGroup();
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        this.closeSelect();
        NameList traceResult = grMembers;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"getFSforComputer", traceResult);
        }
        return traceResult;
    }

    public NameList getMemberList(int group_id, short group_type) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"getMemberList", (String)"group_id, group_type");
        }
        NameList tail = null;
        NameList grMembers = null;
        String sqltxt = null;
        switch (group_type) {
            case 0: 
            case 89: {
                sqltxt = SELECT_COMPUTER_BY_GID;
                break;
            }
            case 2: 
            case 90: {
                sqltxt = SELECT_FS_BY_GID;
                break;
            }
            default: {
                sqltxt = null;
            }
        }
        if (sqltxt != null) {
            try {
                this.selectStmt = this.prepareStmt(sqltxt);
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.selectStmt, group_id);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.stmtPhase = 1;
                while (this.resultSet.next()) {
                    this.colIndex = 1;
                    grMembers = new NameList();
                    grMembers.nlName = this.getString(this.resultSet);
                    grMembers.nlID = this.getInt(this.resultSet);
                    grMembers.nlInfo = this.getShort(this.resultSet);
                    if (group_type == 90 || group_type == 2) {
                        grMembers.nlID2 = this.getInt(this.resultSet);
                    }
                    grMembers.nlNext = tail;
                    tail = grMembers;
                }
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TGroup2Res.class.getName(), (String)"getMemberList", (Throwable)e);
                }
                if (this.locked) {
                    this.unlockTGroup();
                }
                this.stmtType = 0;
                this.sqlError(e);
            }
            this.closeResultSet();
            this.closeSelect();
        }
        NameList traceResult = grMembers;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"getMemberList", traceResult);
        }
        return traceResult;
    }

    public NameList getMembers(int group_id, short group_type) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"getMembers", (String)"group_id, group_type");
        }
        NameList tail = null;
        NameList grMembers = null;
        String sqltxt = null;
        switch (group_type) {
            case 89: {
                sqltxt = SELECT_COMPUTER_NAMES;
                break;
            }
            case 90: {
                sqltxt = SELECT_FILESYSTEM_NAMES;
                break;
            }
            case 98: {
                sqltxt = SELECT_FILESYSTEM_COMPUTERS;
                break;
            }
            case 99: {
                sqltxt = SELECT_COMPUTER_NAMES;
                break;
            }
            default: {
                sqltxt = null;
            }
        }
        try {
            this.selectStmt = this.prepareStmt(sqltxt);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, group_id);
            this.setInt(this.selectStmt, group_id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.resultSet.next()) {
                this.colIndex = 1;
                grMembers = new NameList();
                grMembers.nlName = this.getString(this.resultSet);
                grMembers.nlID = this.getInt(this.resultSet);
                grMembers.nlInfo = this.getShort(this.resultSet);
                String cr = this.getString(this.resultSet);
                if (this.isGroup(grMembers.nlInfo)) {
                    grMembers.nlName = cr + "." + grMembers.nlName;
                }
                if (group_type == 90 && !this.isGroup(grMembers.nlInfo)) {
                    grMembers.nlID2 = this.getInt(this.resultSet);
                }
                if (grMembers.nlInfo == 1 && group_type != 98) {
                    grMembers.nlClusterID = this.getInt(this.resultSet);
                    if (grMembers.nlClusterID > 0) {
                        TResCluster tr = new TResCluster(this.dbc);
                        tr.fillInClusterDetails(grMembers);
                    }
                }
                grMembers.nlNext = tail;
                tail = grMembers;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Res.class.getName(), (String)"getMembers", (Throwable)e);
            }
            if (this.locked) {
                this.unlockTGroup();
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        this.closeSelect();
        NameList traceResult = grMembers;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"getMembers", traceResult);
        }
        return traceResult;
    }

    private ArrayList findChildResources(int grp_id, boolean isDelete) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"findChildResources", (String)"grp_id, isDelete");
        }
        boolean exceeded_flag = false;
        ArrayList<Group2Res> resList = new ArrayList<Group2Res>(512);
        try {
            this.selectStmt = this.prepareStmt(SELECT_CHILDREN);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, grp_id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.resultSet.next()) {
                this.colIndex = 1;
                Group2Res g2rList = new Group2Res();
                g2rList.g2resResourceID = this.getInt(this.resultSet);
                g2rList.g2resGroupID = this.getInt(this.resultSet);
                g2rList.g2resParentID = this.getInt(this.resultSet);
                g2rList.g2resResourceType = this.getShort(this.resultSet);
                g2rList.g2resIndicator = this.getShort(this.resultSet);
                g2rList.g2resAncestors = this.getString(this.resultSet);
                StringTokenizer st = new StringTokenizer(g2rList.g2resAncestors, ":");
                int count = st.countTokens();
                if (isDelete) {
                    if (count > 5) {
                        exceeded_flag = true;
                        break;
                    }
                } else if (count >= 5) {
                    exceeded_flag = true;
                    break;
                }
                resList.add(g2rList);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Res.class.getName(), (String)"findChildResources", (Throwable)e);
            }
            if (this.locked) {
                this.unlockTGroup();
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        this.closeSelect();
        if (exceeded_flag) {
            this.cleanup();
            if (this.locked) {
                this.unlockTGroup();
            }
            String s = MessageLog.getMessage((String)"SRV0166E");
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"findChildResources");
            }
            throw new GeneralException(s);
        }
        ArrayList<Group2Res> traceResult = resList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"findChildResources", traceResult);
        }
        return traceResult;
    }

    private void removeResources(int group_id, short MonOrRepGroup, ArrayList removeList, ArrayList parentList) throws GeneralException {
        int i;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"removeResources", (String)"group_id, MonOrRepGroup, removeList, parentList");
        }
        this.deleteStmt = this.prepareStmt(DELETE);
        for (i = 0; i < removeList.size(); ++i) {
            this.stmtType = 3;
            this.stmtPhase = 0;
            this.colIndex = 1;
            Group2Res g2r = new Group2Res();
            g2r = (Group2Res)removeList.get(i);
            try {
                if (MonOrRepGroup == GroupDefHndlr.REPORTING_GROUP) {
                    this.setInt(this.deleteStmt, g2r.g2resResourceID);
                    this.setInt(this.deleteStmt, g2r.g2resGroupID);
                    this.setInt(this.deleteStmt, g2r.g2resParentID);
                    this.setShort(this.deleteStmt, g2r.g2resIndicator);
                    this.setString(this.deleteStmt, g2r.g2resAncestors);
                } else {
                    this.setInt(this.deleteStmt, g2r.g2resResourceID);
                    this.setInt(this.deleteStmt, group_id);
                    this.setInt(this.deleteStmt, group_id);
                    this.setShort(this.deleteStmt, (short)1);
                    this.setString(this.deleteStmt, String.valueOf(group_id));
                }
                this.stmtPhase = 3;
                this.deleteStmt.executeUpdate();
                continue;
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TGroup2Res.class.getName(), (String)"removeResources", (Throwable)e);
                }
                if (this.locked) {
                    this.unlockTGroup();
                }
                this.sqlError(e);
            }
        }
        for (i = 0; i < parentList.size(); ++i) {
            Group2Res parGr = (Group2Res)parentList.get(i);
            int parent_id = parGr.g2resGroupID;
            String parent_path = parGr.g2resAncestors;
            for (int j = 0; j < removeList.size(); ++j) {
                this.stmtType = 3;
                this.stmtPhase = 0;
                this.colIndex = 1;
                Group2Res g2r = (Group2Res)((Group2Res)removeList.get(j)).clone();
                g2r.g2resGroupID = parent_id;
                g2r.g2resIndicator = g2r.g2resIndicator == 1 ? (short)2 : (g2r.g2resIndicator == 3 ? (short)4 : g2r.g2resIndicator);
                g2r.g2resAncestors = MonOrRepGroup == GroupDefHndlr.REPORTING_GROUP ? parent_path + ":" + g2r.g2resAncestors : parent_path + ":" + group_id;
                try {
                    this.setInt(this.deleteStmt, g2r.g2resResourceID);
                    this.setInt(this.deleteStmt, g2r.g2resGroupID);
                    this.setInt(this.deleteStmt, g2r.g2resParentID);
                    this.setShort(this.deleteStmt, g2r.g2resIndicator);
                    this.setString(this.deleteStmt, g2r.g2resAncestors);
                    this.stmtPhase = 3;
                    this.deleteStmt.executeUpdate();
                    continue;
                }
                catch (SQLException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)TGroup2Res.class.getName(), (String)"removeResources", (Throwable)e);
                    }
                    if (this.locked) {
                        this.unlockTGroup();
                    }
                    this.sqlError(e);
                }
            }
        }
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"removeResources");
        }
    }

    private void insertResources(int group_id, short MonOrRepGroup, ArrayList addList, ArrayList parentList) throws GeneralException {
        int i;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"insertResources", (String)"group_id, MonOrRepGroup, addList, parentList");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        for (i = 0; i < addList.size(); ++i) {
            this.stmtType = 1;
            this.stmtPhase = 0;
            this.colIndex = 1;
            Group2Res g2r = new Group2Res();
            g2r = (Group2Res)addList.get(i);
            try {
                if (MonOrRepGroup == GroupDefHndlr.REPORTING_GROUP) {
                    this.setInt(this.insertStmt, g2r.g2resResourceID);
                    this.setInt(this.insertStmt, g2r.g2resGroupID);
                    this.setInt(this.insertStmt, g2r.g2resParentID);
                    this.setShort(this.insertStmt, g2r.g2resResourceType);
                    this.setShort(this.insertStmt, g2r.g2resIndicator);
                    this.setString(this.insertStmt, g2r.g2resAncestors);
                } else {
                    this.setInt(this.insertStmt, g2r.g2resResourceID);
                    this.setInt(this.insertStmt, group_id);
                    this.setInt(this.insertStmt, group_id);
                    this.setShort(this.insertStmt, g2r.g2resResourceType);
                    this.setShort(this.insertStmt, (short)1);
                    this.setString(this.insertStmt, String.valueOf(group_id));
                }
                this.stmtPhase = 3;
                this.insertStmt.executeUpdate();
                continue;
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TGroup2Res.class.getName(), (String)"insertResources", (Throwable)e);
                }
                if (this.locked) {
                    this.unlockTGroup();
                }
                this.sqlError(e);
            }
        }
        for (i = 0; i < parentList.size(); ++i) {
            Group2Res parGr = (Group2Res)parentList.get(i);
            int parent_id = parGr.g2resGroupID;
            String parent_path = parGr.g2resAncestors;
            for (int j = 0; j < addList.size(); ++j) {
                this.stmtType = 1;
                this.stmtPhase = 0;
                this.colIndex = 1;
                Group2Res g2r = (Group2Res)((Group2Res)addList.get(j)).clone();
                g2r.g2resGroupID = parent_id;
                g2r.g2resIndicator = g2r.g2resIndicator == 1 ? (short)2 : (g2r.g2resIndicator == 3 ? (short)4 : g2r.g2resIndicator);
                if (MonOrRepGroup == GroupDefHndlr.REPORTING_GROUP) {
                    g2r.g2resAncestors = parent_path + ":" + g2r.g2resAncestors;
                } else {
                    g2r.g2resParentID = group_id;
                    g2r.g2resAncestors = parent_path + ":" + group_id;
                }
                try {
                    this.setInt(this.insertStmt, g2r.g2resResourceID);
                    this.setInt(this.insertStmt, g2r.g2resGroupID);
                    this.setInt(this.insertStmt, g2r.g2resParentID);
                    this.setShort(this.insertStmt, g2r.g2resResourceType);
                    this.setShort(this.insertStmt, g2r.g2resIndicator);
                    this.setString(this.insertStmt, g2r.g2resAncestors);
                    this.stmtPhase = 3;
                    this.insertStmt.executeUpdate();
                    continue;
                }
                catch (SQLException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)TGroup2Res.class.getName(), (String)"insertResources", (Throwable)e);
                    }
                    if (this.locked) {
                        this.unlockTGroup();
                    }
                    this.sqlError(e);
                }
            }
        }
        this.closeInsert();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"insertResources");
        }
    }

    private void deleteGroup(int group_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"deleteGroup", (String)"group_id");
        }
        this.deleteStmt = this.prepareStmt(DELETE_GROUP);
        this.stmtType = 3;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.deleteStmt, group_id);
            this.setInt(this.deleteStmt, group_id);
            this.stmtPhase = 3;
            this.deleteStmt.executeUpdate();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Res.class.getName(), (String)"deleteGroup", (Throwable)e);
            }
            if (this.locked) {
                this.unlockTGroup();
            }
            this.sqlError(e);
        }
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"deleteGroup");
        }
    }

    public void deleteResource(int resource_id, boolean isTGroupLocked) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"deleteResource", (String)"resource_id, isTGroupLocked");
        }
        this.locked = false;
        this.resName = Integer.toString(resource_id);
        if (!isTGroupLocked) {
            this.locked = this.lockTGroup((byte)1);
        }
        this.deleteStmt = this.prepareStmt(DELETE_RESOURCE);
        this.stmtType = 3;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.deleteStmt, resource_id);
            this.stmtPhase = 3;
            this.deleteStmt.executeUpdate();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Res.class.getName(), (String)"deleteResource", (Throwable)e);
            }
            if (this.locked) {
                this.unlockTGroup();
            }
            this.sqlError(e);
        }
        this.closeDelete();
        if (this.locked) {
            this.unlockTGroup();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"deleteResource");
        }
    }

    private ArrayList getResources(int group_id, NameList resource_list, ArrayList parentList, boolean isDelete) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"getResources", (String)"group_id, resource_list, parentList, isDelete");
        }
        ArrayList<Group2Res> resourceList = new ArrayList<Group2Res>(512);
        NameList resource = resource_list;
        while (resource != null) {
            Group2Res resItem = new Group2Res();
            if (this.isGroup(resource.nlInfo)) {
                Group2Res g2r;
                int i;
                if (parentList != null) {
                    for (i = 0; i < parentList.size(); ++i) {
                        g2r = (Group2Res)parentList.get(i);
                        if (g2r.g2resGroupID != resource.nlID) continue;
                        this.cleanup();
                        if (this.locked) {
                            this.unlockTGroup();
                        }
                        String s = MessageLog.getMessage((String)"SRV0161E");
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"getResources");
                        }
                        throw new GeneralException(s);
                    }
                }
                resItem.g2resResourceID = resource.nlID;
                resItem.g2resGroupID = group_id;
                resItem.g2resParentID = group_id;
                resItem.g2resIndicator = (short)3;
                resItem.g2resResourceType = resource.nlInfo;
                resItem.g2resAncestors = String.valueOf(group_id);
                resourceList.add(resItem);
                ArrayList childResources = this.findChildResources(resource.nlID, isDelete);
                for (i = 0; i < childResources.size(); ++i) {
                    g2r = (Group2Res)childResources.get(i);
                    g2r.g2resGroupID = group_id;
                    g2r.g2resIndicator = g2r.g2resIndicator == 1 ? (short)2 : (g2r.g2resIndicator == 3 ? (short)4 : g2r.g2resIndicator);
                    g2r.g2resAncestors = String.valueOf(group_id) + ":" + g2r.g2resAncestors;
                    resourceList.add(g2r);
                }
            } else if (this.isMask(resource.nlInfo)) {
                resItem.g2resResourceID = resource.nlID;
                resItem.g2resGroupID = group_id;
                resItem.g2resParentID = group_id;
                resItem.g2resIndicator = (short)5;
                if (resource.nlInfo == 95) {
                    resItem.g2resResourceType = 1;
                } else if (resource.nlInfo == 96) {
                    resItem.g2resResourceType = (short)3;
                }
                resItem.g2resAncestors = String.valueOf(group_id);
                resourceList.add(resItem);
            } else {
                resItem.g2resResourceID = resource.nlID;
                resItem.g2resGroupID = group_id;
                resItem.g2resParentID = group_id;
                resItem.g2resIndicator = 1;
                resItem.g2resResourceType = resource.nlInfo;
                resItem.g2resAncestors = String.valueOf(group_id);
                resourceList.add(resItem);
            }
            resource = resource.nlNext;
        }
        ArrayList<Group2Res> traceResult = resourceList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"getResources", traceResult);
        }
        return traceResult;
    }

    private Group2Res getMGroupByMember(NameList nm) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"getMGroupByMember", (String)"nm");
        }
        int res_id = nm.nlID;
        int group_id = 0;
        Group2Res g2r = new Group2Res();
        String sqltxt = null;
        switch (nm.nlInfo) {
            case 1: {
                sqltxt = SELECT_MON_GROUP_BY_COMP_ID;
                break;
            }
            case 3: {
                sqltxt = SELECT_MON_GROUP_BY_FS_ID;
            }
        }
        try {
            this.selectStmt = this.prepareStmt(sqltxt);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, res_id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.colIndex = 1;
            this.stmtPhase = 1;
            if (this.resultSet.next()) {
                group_id = this.getInt(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup2Res.class.getName(), (String)"getMGroupByMember", (Throwable)e);
            }
            if (this.locked) {
                this.unlockTGroup();
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        this.closeSelect();
        if (group_id > 0) {
            g2r.g2resGroupID = group_id;
            g2r.g2resResourceID = res_id;
            g2r.g2resParentID = group_id;
            g2r.g2resIndicator = 1;
            g2r.g2resResourceType = nm.nlInfo;
            g2r.g2resAncestors = String.valueOf(group_id);
        } else {
            g2r = null;
        }
        Group2Res traceResult = g2r;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"getMGroupByMember", (Object)traceResult);
        }
        return traceResult;
    }

    private boolean isGroup(short grpType) {
        return grpType == 2 || grpType == 0 || grpType == 77 || grpType == 89 || grpType == 90;
    }

    private boolean isMask(short grpType) {
        return grpType == 95 || grpType == 96;
    }

    public void deleteResources(int group_id, short group_type, boolean isTGroupLocked) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"deleteResources", (String)"group_id, group_type, isTGroupLocked");
        }
        int default_group_id = -1;
        this.locked = false;
        this.resName = Integer.toString(group_id);
        if (!isTGroupLocked) {
            this.locked = this.lockTGroup((byte)1);
        }
        ArrayList parentGroups = this.findAncestors(group_id, true);
        ArrayList childResources = this.findChildResources(group_id, true);
        if (GroupDefHndlr.whichGroup(group_type) == GroupDefHndlr.REPORTING_GROUP) {
            this.removeResources(group_id, GroupDefHndlr.REPORTING_GROUP, childResources, parentGroups);
            this.deleteGroup(group_id);
        }
        if (GroupDefHndlr.whichGroup(group_type) == GroupDefHndlr.MONITORING_GROUP) {
            switch (group_type) {
                case 0: {
                    default_group_id = 4;
                    break;
                }
                case 2: {
                    default_group_id = 3;
                }
            }
            this.removeResources(group_id, GroupDefHndlr.MONITORING_GROUP, childResources, parentGroups);
            parentGroups = this.findAncestors(default_group_id, false);
            this.insertResources(default_group_id, GroupDefHndlr.MONITORING_GROUP, childResources, parentGroups);
            this.deleteGroup(group_id);
        }
        if (this.locked) {
            this.unlockTGroup();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"deleteResources");
        }
    }

    public void insertNewResources(int resourceID, int grpID, String resourceName, boolean isTGroupLocked) throws GeneralException {
        short grpType;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"insertNewResources", (String)"resourceID, grpID, resourceName, isTGroupLocked");
        }
        TGroup2Mask grp2MaskAccessor = new TGroup2Mask(this.dbc);
        NameList resource_data = new NameList();
        resource_data.nlID = resourceID;
        switch (grpID) {
            case 8: {
                grpType = 77;
                resource_data.nlInfo = (short)78;
                resource_data.nlName = resourceName;
                this.addRemoveResources(grpID, grpType, resource_data, null, isTGroupLocked);
                break;
            }
            case 4: {
                grpType = 0;
                resource_data.nlInfo = 1;
                resource_data.nlName = resourceName;
                this.addRemoveResources(grpID, grpType, resource_data, null, isTGroupLocked);
                break;
            }
            case 3: {
                grpType = 2;
                resource_data.nlInfo = (short)3;
                resource_data.nlName = resourceName;
                this.addRemoveResources(grpID, grpType, resource_data, null, isTGroupLocked);
                break;
            }
            default: {
                Object[] args = new Object[]{new Integer(grpID)};
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"insertNewResources");
                }
                throw new GeneralException(MessageLog.getMessage((String)"SRV0109E", (Object[])args));
            }
        }
        switch (grpType) {
            case 0: {
                grpType = 89;
                resource_data.nlInfo = (short)95;
                break;
            }
            case 2: {
                grpType = 90;
                resource_data.nlInfo = (short)96;
                break;
            }
            default: {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"insertNewResources");
                }
                return;
            }
        }
        if (resource_data.nlName != null) {
            NameList maskList = grp2MaskAccessor.retrieveMasksByGroupType(grpType, resource_data.nlName);
            while (maskList != null) {
                this.addRemoveResources(maskList.nlID, grpType, resource_data, null, false);
                maskList = maskList.nlNext;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"insertNewResources");
        }
    }

    public void addRemoveResources(int group_id, short group_type, NameList resource_list, NameList remove_list, boolean isTGroupLocked) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"addRemoveResources", (String)"group_id, group_type, resource_list, remove_list, isTGroupLocked");
        }
        ArrayList resourceList = null;
        int default_group_id = -1;
        this.locked = false;
        this.resName = Integer.toString(group_id);
        if (!isTGroupLocked) {
            this.locked = this.lockTGroup((byte)1);
        }
        int parentLevels = this.getParentLevels(group_id);
        NameList nl = resource_list;
        while (nl != null) {
            int childrenLevels;
            if ((nl.nlInfo == 0 || nl.nlInfo == 2 || nl.nlInfo == 89 || nl.nlInfo == 90) && (childrenLevels = this.getChildrenLevels(nl.nlID)) + parentLevels > 5) {
                String s = MessageLog.getMessage((String)"SRV0166E");
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"addRemoveResources");
                }
                throw new GeneralException(s);
            }
            nl = nl.nlNext;
        }
        ArrayList parentGroups = this.findAncestors(group_id, false);
        if (GroupDefHndlr.whichGroup(group_type) == GroupDefHndlr.MONITORING_GROUP) {
            switch (group_type) {
                case 0: {
                    default_group_id = 4;
                    break;
                }
                case 2: {
                    default_group_id = 3;
                }
            }
            ArrayList defaultGroupParents = this.findAncestors(default_group_id, false);
            if (remove_list != null) {
                resourceList = null;
                resourceList = this.getResources(group_id, remove_list, null, false);
                this.removeResources(group_id, GroupDefHndlr.MONITORING_GROUP, resourceList, parentGroups);
                this.insertResources(default_group_id, GroupDefHndlr.MONITORING_GROUP, resourceList, defaultGroupParents);
            }
            if (resource_list != null) {
                NameList nm = resource_list;
                while (nm != null) {
                    Group2Res g2r = this.getMGroupByMember(nm);
                    if (g2r != null) {
                        ArrayList parentGrp = this.findAncestors(g2r.g2resGroupID, false);
                        ArrayList<Group2Res> resList = new ArrayList<Group2Res>(1);
                        resList.add(g2r);
                        this.removeResources(g2r.g2resGroupID, GroupDefHndlr.MONITORING_GROUP, resList, parentGrp);
                    }
                    nm = nm.nlNext;
                }
                resourceList = null;
                resourceList = this.getResources(group_id, resource_list, parentGroups, false);
                this.insertResources(group_id, GroupDefHndlr.MONITORING_GROUP, resourceList, parentGroups);
            }
        }
        if (GroupDefHndlr.whichGroup(group_type) == GroupDefHndlr.REPORTING_GROUP) {
            if (remove_list != null) {
                resourceList = null;
                resourceList = this.getResources(group_id, remove_list, null, false);
                this.removeResources(group_id, GroupDefHndlr.REPORTING_GROUP, resourceList, parentGroups);
            }
            if (resource_list != null) {
                resourceList = null;
                resourceList = this.getResources(group_id, resource_list, parentGroups, false);
                this.insertResources(group_id, GroupDefHndlr.REPORTING_GROUP, resourceList, parentGroups);
            }
        }
        if (this.locked) {
            this.unlockTGroup();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"addRemoveResources");
        }
    }

    private boolean lockTGroup(byte lockType) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"lockTGroup", (String)"lockType");
        }
        boolean traceResult = LockManager.lock((short)0, (String)"GROUP", (String)this.resName, (byte)lockType, (boolean)true);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"lockTGroup", (boolean)traceResult);
        }
        return traceResult;
    }

    private void unlockTGroup() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup2Res.class.getName(), (String)"unlockTGroup", (String)"");
        }
        if (this.resName != null) {
            LockManager.unLock((short)0, (String)"GROUP", (String)this.resName);
        }
        this.locked = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup2Res.class.getName(), (String)"unlockTGroup");
        }
    }
}

